package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementPartnerAssignment;
import odata.msgraph.client.beta.enums.DeviceManagementPartnerAppType;
import odata.msgraph.client.beta.enums.DeviceManagementPartnerTenantState;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Entity which represents a connection to device management partner.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "lastHeartbeatDateTime", 
    "partnerState", 
    "partnerAppType", 
    "singleTenantAppId", 
    "displayName", 
    "isConfigured", 
    "whenPartnerDevicesWillBeRemoved", 
    "whenPartnerDevicesWillBeMarkedAsNonCompliant", 
    "whenPartnerDevicesWillBeRemovedDateTime", 
    "whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime", 
    "groupsRequiringPartnerEnrollment"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementPartner extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementPartner";
    }

    @JsonProperty("lastHeartbeatDateTime")
    protected OffsetDateTime lastHeartbeatDateTime;

    @JsonProperty("partnerState")
    protected DeviceManagementPartnerTenantState partnerState;

    @JsonProperty("partnerAppType")
    protected DeviceManagementPartnerAppType partnerAppType;

    @JsonProperty("singleTenantAppId")
    protected String singleTenantAppId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isConfigured")
    protected Boolean isConfigured;

    @JsonProperty("whenPartnerDevicesWillBeRemoved")
    protected OffsetDateTime whenPartnerDevicesWillBeRemoved;

    @JsonProperty("whenPartnerDevicesWillBeMarkedAsNonCompliant")
    protected OffsetDateTime whenPartnerDevicesWillBeMarkedAsNonCompliant;

    @JsonProperty("whenPartnerDevicesWillBeRemovedDateTime")
    protected OffsetDateTime whenPartnerDevicesWillBeRemovedDateTime;

    @JsonProperty("whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime")
    protected OffsetDateTime whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime;

    @JsonProperty("groupsRequiringPartnerEnrollment")
    protected List<DeviceManagementPartnerAssignment> groupsRequiringPartnerEnrollment;

    @JsonProperty("groupsRequiringPartnerEnrollment@nextLink")
    protected String groupsRequiringPartnerEnrollmentNextLink;

    protected DeviceManagementPartner() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementPartner() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastHeartbeatDateTime;
        private DeviceManagementPartnerTenantState partnerState;
        private DeviceManagementPartnerAppType partnerAppType;
        private String singleTenantAppId;
        private String displayName;
        private Boolean isConfigured;
        private OffsetDateTime whenPartnerDevicesWillBeRemoved;
        private OffsetDateTime whenPartnerDevicesWillBeMarkedAsNonCompliant;
        private OffsetDateTime whenPartnerDevicesWillBeRemovedDateTime;
        private OffsetDateTime whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime;
        private List<DeviceManagementPartnerAssignment> groupsRequiringPartnerEnrollment;
        private String groupsRequiringPartnerEnrollmentNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Timestamp of last heartbeat after admin enabled option Connect to Device
         * management Partner”</i>
         * 
         * @param lastHeartbeatDateTime
         *            value of {@code lastHeartbeatDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastHeartbeatDateTime(OffsetDateTime lastHeartbeatDateTime) {
            this.lastHeartbeatDateTime = lastHeartbeatDateTime;
            this.changedFields = changedFields.add("lastHeartbeatDateTime");
            return this;
        }

        /**
         * <i>“Partner state of this tenant”</i>
         * 
         * @param partnerState
         *            value of {@code partnerState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder partnerState(DeviceManagementPartnerTenantState partnerState) {
            this.partnerState = partnerState;
            this.changedFields = changedFields.add("partnerState");
            return this;
        }

        /**
         * <i>“Partner App type”</i>
         * 
         * @param partnerAppType
         *            value of {@code partnerAppType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder partnerAppType(DeviceManagementPartnerAppType partnerAppType) {
            this.partnerAppType = partnerAppType;
            this.changedFields = changedFields.add("partnerAppType");
            return this;
        }

        /**
         * <i>“Partner Single tenant App id”</i>
         * 
         * @param singleTenantAppId
         *            value of {@code singleTenantAppId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder singleTenantAppId(String singleTenantAppId) {
            this.singleTenantAppId = singleTenantAppId;
            this.changedFields = changedFields.add("singleTenantAppId");
            return this;
        }

        /**
         * <i>“Partner display name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Whether device management partner is configured or not”</i>
         * 
         * @param isConfigured
         *            value of {@code isConfigured} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isConfigured(Boolean isConfigured) {
            this.isConfigured = isConfigured;
            this.changedFields = changedFields.add("isConfigured");
            return this;
        }

        /**
         * <i>“DateTime in UTC when PartnerDevices will be removed. This will become obselete
         * soon.”</i>
         * 
         * @param whenPartnerDevicesWillBeRemoved
         *            value of {@code whenPartnerDevicesWillBeRemoved} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder whenPartnerDevicesWillBeRemoved(OffsetDateTime whenPartnerDevicesWillBeRemoved) {
            this.whenPartnerDevicesWillBeRemoved = whenPartnerDevicesWillBeRemoved;
            this.changedFields = changedFields.add("whenPartnerDevicesWillBeRemoved");
            return this;
        }

        /**
         * <i>“DateTime in UTC when PartnerDevices will be marked as NonCompliant. This will
         * become obselete soon.”</i>
         * 
         * @param whenPartnerDevicesWillBeMarkedAsNonCompliant
         *            value of {@code whenPartnerDevicesWillBeMarkedAsNonCompliant} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder whenPartnerDevicesWillBeMarkedAsNonCompliant(OffsetDateTime whenPartnerDevicesWillBeMarkedAsNonCompliant) {
            this.whenPartnerDevicesWillBeMarkedAsNonCompliant = whenPartnerDevicesWillBeMarkedAsNonCompliant;
            this.changedFields = changedFields.add("whenPartnerDevicesWillBeMarkedAsNonCompliant");
            return this;
        }

        /**
         * <i>“DateTime in UTC when PartnerDevices will be removed”</i>
         * 
         * @param whenPartnerDevicesWillBeRemovedDateTime
         *            value of {@code whenPartnerDevicesWillBeRemovedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder whenPartnerDevicesWillBeRemovedDateTime(OffsetDateTime whenPartnerDevicesWillBeRemovedDateTime) {
            this.whenPartnerDevicesWillBeRemovedDateTime = whenPartnerDevicesWillBeRemovedDateTime;
            this.changedFields = changedFields.add("whenPartnerDevicesWillBeRemovedDateTime");
            return this;
        }

        /**
         * <i>“DateTime in UTC when PartnerDevices will be marked as NonCompliant”</i>
         * 
         * @param whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime
         *            value of {@code whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime(OffsetDateTime whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime) {
            this.whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime = whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime;
            this.changedFields = changedFields.add("whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime");
            return this;
        }

        /**
         * <i>“User groups that specifies whether enrollment is through partner.”</i>
         * 
         * @param groupsRequiringPartnerEnrollment
         *            value of {@code groupsRequiringPartnerEnrollment} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupsRequiringPartnerEnrollment(List<DeviceManagementPartnerAssignment> groupsRequiringPartnerEnrollment) {
            this.groupsRequiringPartnerEnrollment = groupsRequiringPartnerEnrollment;
            this.changedFields = changedFields.add("groupsRequiringPartnerEnrollment");
            return this;
        }

        /**
         * <i>“User groups that specifies whether enrollment is through partner.”</i>
         * 
         * @param groupsRequiringPartnerEnrollment
         *            value of {@code groupsRequiringPartnerEnrollment} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupsRequiringPartnerEnrollment(DeviceManagementPartnerAssignment... groupsRequiringPartnerEnrollment) {
            return groupsRequiringPartnerEnrollment(Arrays.asList(groupsRequiringPartnerEnrollment));
        }

        /**
         * <i>“User groups that specifies whether enrollment is through partner.”</i>
         * 
         * @param groupsRequiringPartnerEnrollmentNextLink
         *            value of {@code groupsRequiringPartnerEnrollment@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupsRequiringPartnerEnrollmentNextLink(String groupsRequiringPartnerEnrollmentNextLink) {
            this.groupsRequiringPartnerEnrollmentNextLink = groupsRequiringPartnerEnrollmentNextLink;
            this.changedFields = changedFields.add("groupsRequiringPartnerEnrollment");
            return this;
        }

        public DeviceManagementPartner build() {
            DeviceManagementPartner _x = new DeviceManagementPartner();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementPartner";
            _x.id = id;
            _x.lastHeartbeatDateTime = lastHeartbeatDateTime;
            _x.partnerState = partnerState;
            _x.partnerAppType = partnerAppType;
            _x.singleTenantAppId = singleTenantAppId;
            _x.displayName = displayName;
            _x.isConfigured = isConfigured;
            _x.whenPartnerDevicesWillBeRemoved = whenPartnerDevicesWillBeRemoved;
            _x.whenPartnerDevicesWillBeMarkedAsNonCompliant = whenPartnerDevicesWillBeMarkedAsNonCompliant;
            _x.whenPartnerDevicesWillBeRemovedDateTime = whenPartnerDevicesWillBeRemovedDateTime;
            _x.whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime = whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime;
            _x.groupsRequiringPartnerEnrollment = groupsRequiringPartnerEnrollment;
            _x.groupsRequiringPartnerEnrollmentNextLink = groupsRequiringPartnerEnrollmentNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Timestamp of last heartbeat after admin enabled option Connect to Device
     * management Partner”</i>
     * 
     * @return property lastHeartbeatDateTime
     */
    @Property(name="lastHeartbeatDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastHeartbeatDateTime() {
        return Optional.ofNullable(lastHeartbeatDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastHeartbeatDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Timestamp of last heartbeat after admin enabled option Connect to Device
     * management Partner”</i>
     * 
     * @param lastHeartbeatDateTime
     *            new value of {@code lastHeartbeatDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastHeartbeatDateTime} field changed
     */
    public DeviceManagementPartner withLastHeartbeatDateTime(OffsetDateTime lastHeartbeatDateTime) {
        DeviceManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("lastHeartbeatDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementPartner");
        _x.lastHeartbeatDateTime = lastHeartbeatDateTime;
        return _x;
    }

    /**
     * <i>“Partner state of this tenant”</i>
     * 
     * @return property partnerState
     */
    @Property(name="partnerState")
    @JsonIgnore
    public Optional<DeviceManagementPartnerTenantState> getPartnerState() {
        return Optional.ofNullable(partnerState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code partnerState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Partner state of this tenant”</i>
     * 
     * @param partnerState
     *            new value of {@code partnerState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code partnerState} field changed
     */
    public DeviceManagementPartner withPartnerState(DeviceManagementPartnerTenantState partnerState) {
        DeviceManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("partnerState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementPartner");
        _x.partnerState = partnerState;
        return _x;
    }

    /**
     * <i>“Partner App type”</i>
     * 
     * @return property partnerAppType
     */
    @Property(name="partnerAppType")
    @JsonIgnore
    public Optional<DeviceManagementPartnerAppType> getPartnerAppType() {
        return Optional.ofNullable(partnerAppType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code partnerAppType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Partner App type”</i>
     * 
     * @param partnerAppType
     *            new value of {@code partnerAppType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code partnerAppType} field changed
     */
    public DeviceManagementPartner withPartnerAppType(DeviceManagementPartnerAppType partnerAppType) {
        DeviceManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("partnerAppType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementPartner");
        _x.partnerAppType = partnerAppType;
        return _x;
    }

    /**
     * <i>“Partner Single tenant App id”</i>
     * 
     * @return property singleTenantAppId
     */
    @Property(name="singleTenantAppId")
    @JsonIgnore
    public Optional<String> getSingleTenantAppId() {
        return Optional.ofNullable(singleTenantAppId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code singleTenantAppId
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Partner Single tenant App id”</i>
     * 
     * @param singleTenantAppId
     *            new value of {@code singleTenantAppId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code singleTenantAppId} field changed
     */
    public DeviceManagementPartner withSingleTenantAppId(String singleTenantAppId) {
        DeviceManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("singleTenantAppId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementPartner");
        _x.singleTenantAppId = singleTenantAppId;
        return _x;
    }

    /**
     * <i>“Partner display name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Partner display name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceManagementPartner withDisplayName(String displayName) {
        DeviceManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementPartner");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Whether device management partner is configured or not”</i>
     * 
     * @return property isConfigured
     */
    @Property(name="isConfigured")
    @JsonIgnore
    public Optional<Boolean> getIsConfigured() {
        return Optional.ofNullable(isConfigured);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isConfigured}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether device management partner is configured or not”</i>
     * 
     * @param isConfigured
     *            new value of {@code isConfigured} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isConfigured} field changed
     */
    public DeviceManagementPartner withIsConfigured(Boolean isConfigured) {
        DeviceManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("isConfigured");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementPartner");
        _x.isConfigured = isConfigured;
        return _x;
    }

    /**
     * <i>“DateTime in UTC when PartnerDevices will be removed. This will become obselete
     * soon.”</i>
     * 
     * @return property whenPartnerDevicesWillBeRemoved
     */
    @Property(name="whenPartnerDevicesWillBeRemoved")
    @JsonIgnore
    public Optional<OffsetDateTime> getWhenPartnerDevicesWillBeRemoved() {
        return Optional.ofNullable(whenPartnerDevicesWillBeRemoved);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * whenPartnerDevicesWillBeRemoved} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“DateTime in UTC when PartnerDevices will be removed. This will become obselete
     * soon.”</i>
     * 
     * @param whenPartnerDevicesWillBeRemoved
     *            new value of {@code whenPartnerDevicesWillBeRemoved} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code whenPartnerDevicesWillBeRemoved} field changed
     */
    public DeviceManagementPartner withWhenPartnerDevicesWillBeRemoved(OffsetDateTime whenPartnerDevicesWillBeRemoved) {
        DeviceManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("whenPartnerDevicesWillBeRemoved");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementPartner");
        _x.whenPartnerDevicesWillBeRemoved = whenPartnerDevicesWillBeRemoved;
        return _x;
    }

    /**
     * <i>“DateTime in UTC when PartnerDevices will be marked as NonCompliant. This will
     * become obselete soon.”</i>
     * 
     * @return property whenPartnerDevicesWillBeMarkedAsNonCompliant
     */
    @Property(name="whenPartnerDevicesWillBeMarkedAsNonCompliant")
    @JsonIgnore
    public Optional<OffsetDateTime> getWhenPartnerDevicesWillBeMarkedAsNonCompliant() {
        return Optional.ofNullable(whenPartnerDevicesWillBeMarkedAsNonCompliant);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * whenPartnerDevicesWillBeMarkedAsNonCompliant} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“DateTime in UTC when PartnerDevices will be marked as NonCompliant. This will
     * become obselete soon.”</i>
     * 
     * @param whenPartnerDevicesWillBeMarkedAsNonCompliant
     *            new value of {@code whenPartnerDevicesWillBeMarkedAsNonCompliant} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code whenPartnerDevicesWillBeMarkedAsNonCompliant} field changed
     */
    public DeviceManagementPartner withWhenPartnerDevicesWillBeMarkedAsNonCompliant(OffsetDateTime whenPartnerDevicesWillBeMarkedAsNonCompliant) {
        DeviceManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("whenPartnerDevicesWillBeMarkedAsNonCompliant");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementPartner");
        _x.whenPartnerDevicesWillBeMarkedAsNonCompliant = whenPartnerDevicesWillBeMarkedAsNonCompliant;
        return _x;
    }

    /**
     * <i>“DateTime in UTC when PartnerDevices will be removed”</i>
     * 
     * @return property whenPartnerDevicesWillBeRemovedDateTime
     */
    @Property(name="whenPartnerDevicesWillBeRemovedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getWhenPartnerDevicesWillBeRemovedDateTime() {
        return Optional.ofNullable(whenPartnerDevicesWillBeRemovedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * whenPartnerDevicesWillBeRemovedDateTime} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“DateTime in UTC when PartnerDevices will be removed”</i>
     * 
     * @param whenPartnerDevicesWillBeRemovedDateTime
     *            new value of {@code whenPartnerDevicesWillBeRemovedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code whenPartnerDevicesWillBeRemovedDateTime} field changed
     */
    public DeviceManagementPartner withWhenPartnerDevicesWillBeRemovedDateTime(OffsetDateTime whenPartnerDevicesWillBeRemovedDateTime) {
        DeviceManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("whenPartnerDevicesWillBeRemovedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementPartner");
        _x.whenPartnerDevicesWillBeRemovedDateTime = whenPartnerDevicesWillBeRemovedDateTime;
        return _x;
    }

    /**
     * <i>“DateTime in UTC when PartnerDevices will be marked as NonCompliant”</i>
     * 
     * @return property whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime
     */
    @Property(name="whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getWhenPartnerDevicesWillBeMarkedAsNonCompliantDateTime() {
        return Optional.ofNullable(whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“DateTime in UTC when PartnerDevices will be marked as NonCompliant”</i>
     * 
     * @param whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime
     *            new value of {@code whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime} field changed
     */
    public DeviceManagementPartner withWhenPartnerDevicesWillBeMarkedAsNonCompliantDateTime(OffsetDateTime whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime) {
        DeviceManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementPartner");
        _x.whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime = whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime;
        return _x;
    }

    /**
     * <i>“User groups that specifies whether enrollment is through partner.”</i>
     * 
     * @return property groupsRequiringPartnerEnrollment
     */
    @Property(name="groupsRequiringPartnerEnrollment")
    @JsonIgnore
    public CollectionPage<DeviceManagementPartnerAssignment> getGroupsRequiringPartnerEnrollment() {
        return new CollectionPage<DeviceManagementPartnerAssignment>(contextPath, DeviceManagementPartnerAssignment.class, groupsRequiringPartnerEnrollment, Optional.ofNullable(groupsRequiringPartnerEnrollmentNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“User groups that specifies whether enrollment is through partner.”</i>
     * 
     * @return property groupsRequiringPartnerEnrollment
     */
    @Property(name="groupsRequiringPartnerEnrollment")
    @JsonIgnore
    public CollectionPage<DeviceManagementPartnerAssignment> getGroupsRequiringPartnerEnrollment(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementPartnerAssignment>(contextPath, DeviceManagementPartnerAssignment.class, groupsRequiringPartnerEnrollment, Optional.ofNullable(groupsRequiringPartnerEnrollmentNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementPartner patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementPartner _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementPartner put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementPartner _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementPartner _copy() {
        DeviceManagementPartner _x = new DeviceManagementPartner();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastHeartbeatDateTime = lastHeartbeatDateTime;
        _x.partnerState = partnerState;
        _x.partnerAppType = partnerAppType;
        _x.singleTenantAppId = singleTenantAppId;
        _x.displayName = displayName;
        _x.isConfigured = isConfigured;
        _x.whenPartnerDevicesWillBeRemoved = whenPartnerDevicesWillBeRemoved;
        _x.whenPartnerDevicesWillBeMarkedAsNonCompliant = whenPartnerDevicesWillBeMarkedAsNonCompliant;
        _x.whenPartnerDevicesWillBeRemovedDateTime = whenPartnerDevicesWillBeRemovedDateTime;
        _x.whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime = whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime;
        _x.groupsRequiringPartnerEnrollment = groupsRequiringPartnerEnrollment;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementPartner[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastHeartbeatDateTime=");
        b.append(this.lastHeartbeatDateTime);
        b.append(", ");
        b.append("partnerState=");
        b.append(this.partnerState);
        b.append(", ");
        b.append("partnerAppType=");
        b.append(this.partnerAppType);
        b.append(", ");
        b.append("singleTenantAppId=");
        b.append(this.singleTenantAppId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isConfigured=");
        b.append(this.isConfigured);
        b.append(", ");
        b.append("whenPartnerDevicesWillBeRemoved=");
        b.append(this.whenPartnerDevicesWillBeRemoved);
        b.append(", ");
        b.append("whenPartnerDevicesWillBeMarkedAsNonCompliant=");
        b.append(this.whenPartnerDevicesWillBeMarkedAsNonCompliant);
        b.append(", ");
        b.append("whenPartnerDevicesWillBeRemovedDateTime=");
        b.append(this.whenPartnerDevicesWillBeRemovedDateTime);
        b.append(", ");
        b.append("whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime=");
        b.append(this.whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime);
        b.append(", ");
        b.append("groupsRequiringPartnerEnrollment=");
        b.append(this.groupsRequiringPartnerEnrollment);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
