package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Entity that represents user state summary for an intent”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "conflictCount", 
    "errorCount", 
    "failedCount", 
    "notApplicableCount", 
    "successCount"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementIntentUserStateSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementIntentUserStateSummary";
    }

    @JsonProperty("conflictCount")
    protected Integer conflictCount;

    @JsonProperty("errorCount")
    protected Integer errorCount;

    @JsonProperty("failedCount")
    protected Integer failedCount;

    @JsonProperty("notApplicableCount")
    protected Integer notApplicableCount;

    @JsonProperty("successCount")
    protected Integer successCount;

    protected DeviceManagementIntentUserStateSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementIntentUserStateSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer conflictCount;
        private Integer errorCount;
        private Integer failedCount;
        private Integer notApplicableCount;
        private Integer successCount;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Number of users in conflict”</i>
         * 
         * @param conflictCount
         *            value of {@code conflictCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder conflictCount(Integer conflictCount) {
            this.conflictCount = conflictCount;
            this.changedFields = changedFields.add("conflictCount");
            return this;
        }

        /**
         * <i>“Number of error users”</i>
         * 
         * @param errorCount
         *            value of {@code errorCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorCount(Integer errorCount) {
            this.errorCount = errorCount;
            this.changedFields = changedFields.add("errorCount");
            return this;
        }

        /**
         * <i>“Number of failed users”</i>
         * 
         * @param failedCount
         *            value of {@code failedCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedCount(Integer failedCount) {
            this.failedCount = failedCount;
            this.changedFields = changedFields.add("failedCount");
            return this;
        }

        /**
         * <i>“Number of not applicable users”</i>
         * 
         * @param notApplicableCount
         *            value of {@code notApplicableCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notApplicableCount(Integer notApplicableCount) {
            this.notApplicableCount = notApplicableCount;
            this.changedFields = changedFields.add("notApplicableCount");
            return this;
        }

        /**
         * <i>“Number of succeeded users”</i>
         * 
         * @param successCount
         *            value of {@code successCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder successCount(Integer successCount) {
            this.successCount = successCount;
            this.changedFields = changedFields.add("successCount");
            return this;
        }

        public DeviceManagementIntentUserStateSummary build() {
            DeviceManagementIntentUserStateSummary _x = new DeviceManagementIntentUserStateSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementIntentUserStateSummary";
            _x.id = id;
            _x.conflictCount = conflictCount;
            _x.errorCount = errorCount;
            _x.failedCount = failedCount;
            _x.notApplicableCount = notApplicableCount;
            _x.successCount = successCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Number of users in conflict”</i>
     * 
     * @return property conflictCount
     */
    @Property(name="conflictCount")
    @JsonIgnore
    public Optional<Integer> getConflictCount() {
        return Optional.ofNullable(conflictCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code conflictCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of users in conflict”</i>
     * 
     * @param conflictCount
     *            new value of {@code conflictCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code conflictCount} field changed
     */
    public DeviceManagementIntentUserStateSummary withConflictCount(Integer conflictCount) {
        DeviceManagementIntentUserStateSummary _x = _copy();
        _x.changedFields = changedFields.add("conflictCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntentUserStateSummary");
        _x.conflictCount = conflictCount;
        return _x;
    }

    /**
     * <i>“Number of error users”</i>
     * 
     * @return property errorCount
     */
    @Property(name="errorCount")
    @JsonIgnore
    public Optional<Integer> getErrorCount() {
        return Optional.ofNullable(errorCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorCount} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Number of error users”</i>
     * 
     * @param errorCount
     *            new value of {@code errorCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorCount} field changed
     */
    public DeviceManagementIntentUserStateSummary withErrorCount(Integer errorCount) {
        DeviceManagementIntentUserStateSummary _x = _copy();
        _x.changedFields = changedFields.add("errorCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntentUserStateSummary");
        _x.errorCount = errorCount;
        return _x;
    }

    /**
     * <i>“Number of failed users”</i>
     * 
     * @return property failedCount
     */
    @Property(name="failedCount")
    @JsonIgnore
    public Optional<Integer> getFailedCount() {
        return Optional.ofNullable(failedCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code failedCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of failed users”</i>
     * 
     * @param failedCount
     *            new value of {@code failedCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code failedCount} field changed
     */
    public DeviceManagementIntentUserStateSummary withFailedCount(Integer failedCount) {
        DeviceManagementIntentUserStateSummary _x = _copy();
        _x.changedFields = changedFields.add("failedCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntentUserStateSummary");
        _x.failedCount = failedCount;
        return _x;
    }

    /**
     * <i>“Number of not applicable users”</i>
     * 
     * @return property notApplicableCount
     */
    @Property(name="notApplicableCount")
    @JsonIgnore
    public Optional<Integer> getNotApplicableCount() {
        return Optional.ofNullable(notApplicableCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notApplicableCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of not applicable users”</i>
     * 
     * @param notApplicableCount
     *            new value of {@code notApplicableCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notApplicableCount} field changed
     */
    public DeviceManagementIntentUserStateSummary withNotApplicableCount(Integer notApplicableCount) {
        DeviceManagementIntentUserStateSummary _x = _copy();
        _x.changedFields = changedFields.add("notApplicableCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntentUserStateSummary");
        _x.notApplicableCount = notApplicableCount;
        return _x;
    }

    /**
     * <i>“Number of succeeded users”</i>
     * 
     * @return property successCount
     */
    @Property(name="successCount")
    @JsonIgnore
    public Optional<Integer> getSuccessCount() {
        return Optional.ofNullable(successCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code successCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of succeeded users”</i>
     * 
     * @param successCount
     *            new value of {@code successCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code successCount} field changed
     */
    public DeviceManagementIntentUserStateSummary withSuccessCount(Integer successCount) {
        DeviceManagementIntentUserStateSummary _x = _copy();
        _x.changedFields = changedFields.add("successCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntentUserStateSummary");
        _x.successCount = successCount;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementIntentUserStateSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementIntentUserStateSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementIntentUserStateSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementIntentUserStateSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementIntentUserStateSummary _copy() {
        DeviceManagementIntentUserStateSummary _x = new DeviceManagementIntentUserStateSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.conflictCount = conflictCount;
        _x.errorCount = errorCount;
        _x.failedCount = failedCount;
        _x.notApplicableCount = notApplicableCount;
        _x.successCount = successCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementIntentUserStateSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("conflictCount=");
        b.append(this.conflictCount);
        b.append(", ");
        b.append("errorCount=");
        b.append(this.errorCount);
        b.append(", ");
        b.append("failedCount=");
        b.append(this.failedCount);
        b.append(", ");
        b.append("notApplicableCount=");
        b.append(this.notApplicableCount);
        b.append(", ");
        b.append("successCount=");
        b.append(this.successCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
