package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Entity that represents device state summary for an intent”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "conflictCount", 
    "errorCount", 
    "failedCount", 
    "notApplicableCount", 
    "notApplicablePlatformCount", 
    "successCount"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementIntentDeviceStateSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementIntentDeviceStateSummary";
    }

    @JsonProperty("conflictCount")
    protected Integer conflictCount;

    @JsonProperty("errorCount")
    protected Integer errorCount;

    @JsonProperty("failedCount")
    protected Integer failedCount;

    @JsonProperty("notApplicableCount")
    protected Integer notApplicableCount;

    @JsonProperty("notApplicablePlatformCount")
    protected Integer notApplicablePlatformCount;

    @JsonProperty("successCount")
    protected Integer successCount;

    protected DeviceManagementIntentDeviceStateSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementIntentDeviceStateSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer conflictCount;
        private Integer errorCount;
        private Integer failedCount;
        private Integer notApplicableCount;
        private Integer notApplicablePlatformCount;
        private Integer successCount;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Number of devices in conflict”</i>
         * 
         * @param conflictCount
         *            value of {@code conflictCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder conflictCount(Integer conflictCount) {
            this.conflictCount = conflictCount;
            this.changedFields = changedFields.add("conflictCount");
            return this;
        }

        /**
         * <i>“Number of error devices”</i>
         * 
         * @param errorCount
         *            value of {@code errorCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorCount(Integer errorCount) {
            this.errorCount = errorCount;
            this.changedFields = changedFields.add("errorCount");
            return this;
        }

        /**
         * <i>“Number of failed devices”</i>
         * 
         * @param failedCount
         *            value of {@code failedCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedCount(Integer failedCount) {
            this.failedCount = failedCount;
            this.changedFields = changedFields.add("failedCount");
            return this;
        }

        /**
         * <i>“Number of not applicable devices”</i>
         * 
         * @param notApplicableCount
         *            value of {@code notApplicableCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notApplicableCount(Integer notApplicableCount) {
            this.notApplicableCount = notApplicableCount;
            this.changedFields = changedFields.add("notApplicableCount");
            return this;
        }

        /**
         * <i>“Number of not applicable devices due to mismatch platform and policy”</i>
         * 
         * @param notApplicablePlatformCount
         *            value of {@code notApplicablePlatformCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notApplicablePlatformCount(Integer notApplicablePlatformCount) {
            this.notApplicablePlatformCount = notApplicablePlatformCount;
            this.changedFields = changedFields.add("notApplicablePlatformCount");
            return this;
        }

        /**
         * <i>“Number of succeeded devices”</i>
         * 
         * @param successCount
         *            value of {@code successCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder successCount(Integer successCount) {
            this.successCount = successCount;
            this.changedFields = changedFields.add("successCount");
            return this;
        }

        public DeviceManagementIntentDeviceStateSummary build() {
            DeviceManagementIntentDeviceStateSummary _x = new DeviceManagementIntentDeviceStateSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementIntentDeviceStateSummary";
            _x.id = id;
            _x.conflictCount = conflictCount;
            _x.errorCount = errorCount;
            _x.failedCount = failedCount;
            _x.notApplicableCount = notApplicableCount;
            _x.notApplicablePlatformCount = notApplicablePlatformCount;
            _x.successCount = successCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Number of devices in conflict”</i>
     * 
     * @return property conflictCount
     */
    @Property(name="conflictCount")
    @JsonIgnore
    public Optional<Integer> getConflictCount() {
        return Optional.ofNullable(conflictCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code conflictCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of devices in conflict”</i>
     * 
     * @param conflictCount
     *            new value of {@code conflictCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code conflictCount} field changed
     */
    public DeviceManagementIntentDeviceStateSummary withConflictCount(Integer conflictCount) {
        DeviceManagementIntentDeviceStateSummary _x = _copy();
        _x.changedFields = changedFields.add("conflictCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntentDeviceStateSummary");
        _x.conflictCount = conflictCount;
        return _x;
    }

    /**
     * <i>“Number of error devices”</i>
     * 
     * @return property errorCount
     */
    @Property(name="errorCount")
    @JsonIgnore
    public Optional<Integer> getErrorCount() {
        return Optional.ofNullable(errorCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorCount} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Number of error devices”</i>
     * 
     * @param errorCount
     *            new value of {@code errorCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorCount} field changed
     */
    public DeviceManagementIntentDeviceStateSummary withErrorCount(Integer errorCount) {
        DeviceManagementIntentDeviceStateSummary _x = _copy();
        _x.changedFields = changedFields.add("errorCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntentDeviceStateSummary");
        _x.errorCount = errorCount;
        return _x;
    }

    /**
     * <i>“Number of failed devices”</i>
     * 
     * @return property failedCount
     */
    @Property(name="failedCount")
    @JsonIgnore
    public Optional<Integer> getFailedCount() {
        return Optional.ofNullable(failedCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code failedCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of failed devices”</i>
     * 
     * @param failedCount
     *            new value of {@code failedCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code failedCount} field changed
     */
    public DeviceManagementIntentDeviceStateSummary withFailedCount(Integer failedCount) {
        DeviceManagementIntentDeviceStateSummary _x = _copy();
        _x.changedFields = changedFields.add("failedCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntentDeviceStateSummary");
        _x.failedCount = failedCount;
        return _x;
    }

    /**
     * <i>“Number of not applicable devices”</i>
     * 
     * @return property notApplicableCount
     */
    @Property(name="notApplicableCount")
    @JsonIgnore
    public Optional<Integer> getNotApplicableCount() {
        return Optional.ofNullable(notApplicableCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notApplicableCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of not applicable devices”</i>
     * 
     * @param notApplicableCount
     *            new value of {@code notApplicableCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notApplicableCount} field changed
     */
    public DeviceManagementIntentDeviceStateSummary withNotApplicableCount(Integer notApplicableCount) {
        DeviceManagementIntentDeviceStateSummary _x = _copy();
        _x.changedFields = changedFields.add("notApplicableCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntentDeviceStateSummary");
        _x.notApplicableCount = notApplicableCount;
        return _x;
    }

    /**
     * <i>“Number of not applicable devices due to mismatch platform and policy”</i>
     * 
     * @return property notApplicablePlatformCount
     */
    @Property(name="notApplicablePlatformCount")
    @JsonIgnore
    public Optional<Integer> getNotApplicablePlatformCount() {
        return Optional.ofNullable(notApplicablePlatformCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notApplicablePlatformCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of not applicable devices due to mismatch platform and policy”</i>
     * 
     * @param notApplicablePlatformCount
     *            new value of {@code notApplicablePlatformCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notApplicablePlatformCount} field changed
     */
    public DeviceManagementIntentDeviceStateSummary withNotApplicablePlatformCount(Integer notApplicablePlatformCount) {
        DeviceManagementIntentDeviceStateSummary _x = _copy();
        _x.changedFields = changedFields.add("notApplicablePlatformCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntentDeviceStateSummary");
        _x.notApplicablePlatformCount = notApplicablePlatformCount;
        return _x;
    }

    /**
     * <i>“Number of succeeded devices”</i>
     * 
     * @return property successCount
     */
    @Property(name="successCount")
    @JsonIgnore
    public Optional<Integer> getSuccessCount() {
        return Optional.ofNullable(successCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code successCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of succeeded devices”</i>
     * 
     * @param successCount
     *            new value of {@code successCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code successCount} field changed
     */
    public DeviceManagementIntentDeviceStateSummary withSuccessCount(Integer successCount) {
        DeviceManagementIntentDeviceStateSummary _x = _copy();
        _x.changedFields = changedFields.add("successCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntentDeviceStateSummary");
        _x.successCount = successCount;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementIntentDeviceStateSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementIntentDeviceStateSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementIntentDeviceStateSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementIntentDeviceStateSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementIntentDeviceStateSummary _copy() {
        DeviceManagementIntentDeviceStateSummary _x = new DeviceManagementIntentDeviceStateSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.conflictCount = conflictCount;
        _x.errorCount = errorCount;
        _x.failedCount = failedCount;
        _x.notApplicableCount = notApplicableCount;
        _x.notApplicablePlatformCount = notApplicablePlatformCount;
        _x.successCount = successCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementIntentDeviceStateSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("conflictCount=");
        b.append(this.conflictCount);
        b.append(", ");
        b.append("errorCount=");
        b.append(this.errorCount);
        b.append(", ");
        b.append("failedCount=");
        b.append(this.failedCount);
        b.append(", ");
        b.append("notApplicableCount=");
        b.append(this.notApplicableCount);
        b.append(", ");
        b.append("notApplicablePlatformCount=");
        b.append(this.notApplicablePlatformCount);
        b.append(", ");
        b.append("successCount=");
        b.append(this.successCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
