package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceManagementReportFileFormat;
import odata.msgraph.client.beta.enums.DeviceManagementReportStatus;


/**
 * <i>“Entity representing a job to export a report”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "reportName", 
    "filter", 
    "select", 
    "format", 
    "snapshotId", 
    "status", 
    "url", 
    "requestDateTime", 
    "expirationDateTime"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementExportJob extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementExportJob";
    }

    @JsonProperty("reportName")
    protected String reportName;

    @JsonProperty("filter")
    protected String filter;

    @JsonProperty("select")
    protected List<String> select;

    @JsonProperty("select@nextLink")
    protected String selectNextLink;

    @JsonProperty("format")
    protected DeviceManagementReportFileFormat format;

    @JsonProperty("snapshotId")
    protected String snapshotId;

    @JsonProperty("status")
    protected DeviceManagementReportStatus status;

    @JsonProperty("url")
    protected String url;

    @JsonProperty("requestDateTime")
    protected OffsetDateTime requestDateTime;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    protected DeviceManagementExportJob() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementExportJob() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String reportName;
        private String filter;
        private List<String> select;
        private String selectNextLink;
        private DeviceManagementReportFileFormat format;
        private String snapshotId;
        private DeviceManagementReportStatus status;
        private String url;
        private OffsetDateTime requestDateTime;
        private OffsetDateTime expirationDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Name of the report”</i>
         * 
         * @param reportName
         *            value of {@code reportName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder reportName(String reportName) {
            this.reportName = reportName;
            this.changedFields = changedFields.add("reportName");
            return this;
        }

        /**
         * <i>“Filters applied on the report”</i>
         * 
         * @param filter
         *            value of {@code filter} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder filter(String filter) {
            this.filter = filter;
            this.changedFields = changedFields.add("filter");
            return this;
        }

        /**
         * <i>“Columns selected from the report”</i>
         * 
         * @param select
         *            value of {@code select} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder select(List<String> select) {
            this.select = select;
            this.changedFields = changedFields.add("select");
            return this;
        }

        /**
         * <i>“Columns selected from the report”</i>
         * 
         * @param select
         *            value of {@code select} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder select(String... select) {
            return select(Arrays.asList(select));
        }

        /**
         * <i>“Columns selected from the report”</i>
         * 
         * @param selectNextLink
         *            value of {@code select@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder selectNextLink(String selectNextLink) {
            this.selectNextLink = selectNextLink;
            this.changedFields = changedFields.add("select");
            return this;
        }

        /**
         * <i>“Format of the exported report”</i>
         * 
         * @param format
         *            value of {@code format} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder format(DeviceManagementReportFileFormat format) {
            this.format = format;
            this.changedFields = changedFields.add("format");
            return this;
        }

        /**
         * <i>“A snapshot is an identifiable subset of the dataset represented by the
         * ReportName. A sessionId or CachedReportConfiguration id can be used here. If a
         * sessionId is specified, Filter, Select, and OrderBy are applied to the data
         * represented by the sessionId. Filter, Select, and OrderBy cannot be specified
         * together with a CachedReportConfiguration id.”</i>
         * 
         * @param snapshotId
         *            value of {@code snapshotId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            this.changedFields = changedFields.add("snapshotId");
            return this;
        }

        /**
         * <i>“Status of the export job”</i>
         * 
         * @param status
         *            value of {@code status} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder status(DeviceManagementReportStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        /**
         * <i>“Temporary location of the exported report”</i>
         * 
         * @param url
         *            value of {@code url} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder url(String url) {
            this.url = url;
            this.changedFields = changedFields.add("url");
            return this;
        }

        /**
         * <i>“Time that the exported report was requested”</i>
         * 
         * @param requestDateTime
         *            value of {@code requestDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requestDateTime(OffsetDateTime requestDateTime) {
            this.requestDateTime = requestDateTime;
            this.changedFields = changedFields.add("requestDateTime");
            return this;
        }

        /**
         * <i>“Time that the exported report expires”</i>
         * 
         * @param expirationDateTime
         *            value of {@code expirationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public DeviceManagementExportJob build() {
            DeviceManagementExportJob _x = new DeviceManagementExportJob();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementExportJob";
            _x.id = id;
            _x.reportName = reportName;
            _x.filter = filter;
            _x.select = select;
            _x.selectNextLink = selectNextLink;
            _x.format = format;
            _x.snapshotId = snapshotId;
            _x.status = status;
            _x.url = url;
            _x.requestDateTime = requestDateTime;
            _x.expirationDateTime = expirationDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Name of the report”</i>
     * 
     * @return property reportName
     */
    @Property(name="reportName")
    @JsonIgnore
    public Optional<String> getReportName() {
        return Optional.ofNullable(reportName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code reportName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name of the report”</i>
     * 
     * @param reportName
     *            new value of {@code reportName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code reportName} field changed
     */
    public DeviceManagementExportJob withReportName(String reportName) {
        DeviceManagementExportJob _x = _copy();
        _x.changedFields = changedFields.add("reportName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExportJob");
        _x.reportName = reportName;
        return _x;
    }

    /**
     * <i>“Filters applied on the report”</i>
     * 
     * @return property filter
     */
    @Property(name="filter")
    @JsonIgnore
    public Optional<String> getFilter() {
        return Optional.ofNullable(filter);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code filter} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Filters applied on the report”</i>
     * 
     * @param filter
     *            new value of {@code filter} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code filter} field changed
     */
    public DeviceManagementExportJob withFilter(String filter) {
        DeviceManagementExportJob _x = _copy();
        _x.changedFields = changedFields.add("filter");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExportJob");
        _x.filter = filter;
        return _x;
    }

    /**
     * <i>“Columns selected from the report”</i>
     * 
     * @return property select
     */
    @Property(name="select")
    @JsonIgnore
    public CollectionPage<String> getSelect() {
        return new CollectionPage<String>(contextPath, String.class, select, Optional.ofNullable(selectNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Columns selected from the report”</i>
     * 
     * @return property select
     */
    @Property(name="select")
    @JsonIgnore
    public CollectionPage<String> getSelect(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, select, Optional.ofNullable(selectNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Format of the exported report”</i>
     * 
     * @return property format
     */
    @Property(name="format")
    @JsonIgnore
    public Optional<DeviceManagementReportFileFormat> getFormat() {
        return Optional.ofNullable(format);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code format} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Format of the exported report”</i>
     * 
     * @param format
     *            new value of {@code format} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code format} field changed
     */
    public DeviceManagementExportJob withFormat(DeviceManagementReportFileFormat format) {
        DeviceManagementExportJob _x = _copy();
        _x.changedFields = changedFields.add("format");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExportJob");
        _x.format = format;
        return _x;
    }

    /**
     * <i>“A snapshot is an identifiable subset of the dataset represented by the
     * ReportName. A sessionId or CachedReportConfiguration id can be used here. If a
     * sessionId is specified, Filter, Select, and OrderBy are applied to the data
     * represented by the sessionId. Filter, Select, and OrderBy cannot be specified
     * together with a CachedReportConfiguration id.”</i>
     * 
     * @return property snapshotId
     */
    @Property(name="snapshotId")
    @JsonIgnore
    public Optional<String> getSnapshotId() {
        return Optional.ofNullable(snapshotId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code snapshotId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“A snapshot is an identifiable subset of the dataset represented by the
     * ReportName. A sessionId or CachedReportConfiguration id can be used here. If a
     * sessionId is specified, Filter, Select, and OrderBy are applied to the data
     * represented by the sessionId. Filter, Select, and OrderBy cannot be specified
     * together with a CachedReportConfiguration id.”</i>
     * 
     * @param snapshotId
     *            new value of {@code snapshotId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code snapshotId} field changed
     */
    public DeviceManagementExportJob withSnapshotId(String snapshotId) {
        DeviceManagementExportJob _x = _copy();
        _x.changedFields = changedFields.add("snapshotId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExportJob");
        _x.snapshotId = snapshotId;
        return _x;
    }

    /**
     * <i>“Status of the export job”</i>
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<DeviceManagementReportStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Status of the export job”</i>
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public DeviceManagementExportJob withStatus(DeviceManagementReportStatus status) {
        DeviceManagementExportJob _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExportJob");
        _x.status = status;
        return _x;
    }

    /**
     * <i>“Temporary location of the exported report”</i>
     * 
     * @return property url
     */
    @Property(name="url")
    @JsonIgnore
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code url} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Temporary location of the exported report”</i>
     * 
     * @param url
     *            new value of {@code url} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code url} field changed
     */
    public DeviceManagementExportJob withUrl(String url) {
        DeviceManagementExportJob _x = _copy();
        _x.changedFields = changedFields.add("url");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExportJob");
        _x.url = url;
        return _x;
    }

    /**
     * <i>“Time that the exported report was requested”</i>
     * 
     * @return property requestDateTime
     */
    @Property(name="requestDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRequestDateTime() {
        return Optional.ofNullable(requestDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code requestDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Time that the exported report was requested”</i>
     * 
     * @param requestDateTime
     *            new value of {@code requestDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requestDateTime} field changed
     */
    public DeviceManagementExportJob withRequestDateTime(OffsetDateTime requestDateTime) {
        DeviceManagementExportJob _x = _copy();
        _x.changedFields = changedFields.add("requestDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExportJob");
        _x.requestDateTime = requestDateTime;
        return _x;
    }

    /**
     * <i>“Time that the exported report expires”</i>
     * 
     * @return property expirationDateTime
     */
    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * expirationDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Time that the exported report expires”</i>
     * 
     * @param expirationDateTime
     *            new value of {@code expirationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code expirationDateTime} field changed
     */
    public DeviceManagementExportJob withExpirationDateTime(OffsetDateTime expirationDateTime) {
        DeviceManagementExportJob _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExportJob");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementExportJob patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementExportJob _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementExportJob put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementExportJob _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementExportJob _copy() {
        DeviceManagementExportJob _x = new DeviceManagementExportJob();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportName = reportName;
        _x.filter = filter;
        _x.select = select;
        _x.format = format;
        _x.snapshotId = snapshotId;
        _x.status = status;
        _x.url = url;
        _x.requestDateTime = requestDateTime;
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementExportJob[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportName=");
        b.append(this.reportName);
        b.append(", ");
        b.append("filter=");
        b.append(this.filter);
        b.append(", ");
        b.append("select=");
        b.append(this.select);
        b.append(", ");
        b.append("format=");
        b.append(this.format);
        b.append(", ");
        b.append("snapshotId=");
        b.append(this.snapshotId);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("url=");
        b.append(this.url);
        b.append(", ");
        b.append("requestDateTime=");
        b.append(this.requestDateTime);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
