package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceManagementExchangeConnectorStatus;
import odata.msgraph.client.beta.enums.DeviceManagementExchangeConnectorSyncType;
import odata.msgraph.client.beta.enums.DeviceManagementExchangeConnectorType;


/**
 * <i>“Entity which represents a connection to an Exchange environment.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "lastSyncDateTime", 
    "status", 
    "primarySmtpAddress", 
    "serverName", 
    "connectorServerName", 
    "exchangeConnectorType", 
    "version", 
    "exchangeAlias", 
    "exchangeOrganization"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementExchangeConnector extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementExchangeConnector";
    }

    @JsonProperty("lastSyncDateTime")
    protected OffsetDateTime lastSyncDateTime;

    @JsonProperty("status")
    protected DeviceManagementExchangeConnectorStatus status;

    @JsonProperty("primarySmtpAddress")
    protected String primarySmtpAddress;

    @JsonProperty("serverName")
    protected String serverName;

    @JsonProperty("connectorServerName")
    protected String connectorServerName;

    @JsonProperty("exchangeConnectorType")
    protected DeviceManagementExchangeConnectorType exchangeConnectorType;

    @JsonProperty("version")
    protected String version;

    @JsonProperty("exchangeAlias")
    protected String exchangeAlias;

    @JsonProperty("exchangeOrganization")
    protected String exchangeOrganization;

    protected DeviceManagementExchangeConnector() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementExchangeConnector() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastSyncDateTime;
        private DeviceManagementExchangeConnectorStatus status;
        private String primarySmtpAddress;
        private String serverName;
        private String connectorServerName;
        private DeviceManagementExchangeConnectorType exchangeConnectorType;
        private String version;
        private String exchangeAlias;
        private String exchangeOrganization;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Last sync time for the Exchange Connector”</i>
         * 
         * @param lastSyncDateTime
         *            value of {@code lastSyncDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastSyncDateTime(OffsetDateTime lastSyncDateTime) {
            this.lastSyncDateTime = lastSyncDateTime;
            this.changedFields = changedFields.add("lastSyncDateTime");
            return this;
        }

        /**
         * <i>“Exchange Connector Status”</i>
         * 
         * @param status
         *            value of {@code status} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder status(DeviceManagementExchangeConnectorStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        /**
         * <i>“Email address used to configure the Service To Service Exchange Connector.”</i>
         * 
         * @param primarySmtpAddress
         *            value of {@code primarySmtpAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder primarySmtpAddress(String primarySmtpAddress) {
            this.primarySmtpAddress = primarySmtpAddress;
            this.changedFields = changedFields.add("primarySmtpAddress");
            return this;
        }

        /**
         * <i>“The name of the Exchange server.”</i>
         * 
         * @param serverName
         *            value of {@code serverName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serverName(String serverName) {
            this.serverName = serverName;
            this.changedFields = changedFields.add("serverName");
            return this;
        }

        /**
         * <i>“The name of the server hosting the Exchange Connector.”</i>
         * 
         * @param connectorServerName
         *            value of {@code connectorServerName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectorServerName(String connectorServerName) {
            this.connectorServerName = connectorServerName;
            this.changedFields = changedFields.add("connectorServerName");
            return this;
        }

        /**
         * <i>“The type of Exchange Connector Configured.”</i>
         * 
         * @param exchangeConnectorType
         *            value of {@code exchangeConnectorType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exchangeConnectorType(DeviceManagementExchangeConnectorType exchangeConnectorType) {
            this.exchangeConnectorType = exchangeConnectorType;
            this.changedFields = changedFields.add("exchangeConnectorType");
            return this;
        }

        /**
         * <i>“The version of the ExchangeConnectorAgent”</i>
         * 
         * @param version
         *            value of {@code version} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“An alias assigned to the Exchange server”</i>
         * 
         * @param exchangeAlias
         *            value of {@code exchangeAlias} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exchangeAlias(String exchangeAlias) {
            this.exchangeAlias = exchangeAlias;
            this.changedFields = changedFields.add("exchangeAlias");
            return this;
        }

        /**
         * <i>“Exchange Organization to the Exchange server”</i>
         * 
         * @param exchangeOrganization
         *            value of {@code exchangeOrganization} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exchangeOrganization(String exchangeOrganization) {
            this.exchangeOrganization = exchangeOrganization;
            this.changedFields = changedFields.add("exchangeOrganization");
            return this;
        }

        public DeviceManagementExchangeConnector build() {
            DeviceManagementExchangeConnector _x = new DeviceManagementExchangeConnector();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementExchangeConnector";
            _x.id = id;
            _x.lastSyncDateTime = lastSyncDateTime;
            _x.status = status;
            _x.primarySmtpAddress = primarySmtpAddress;
            _x.serverName = serverName;
            _x.connectorServerName = connectorServerName;
            _x.exchangeConnectorType = exchangeConnectorType;
            _x.version = version;
            _x.exchangeAlias = exchangeAlias;
            _x.exchangeOrganization = exchangeOrganization;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Last sync time for the Exchange Connector”</i>
     * 
     * @return property lastSyncDateTime
     */
    @Property(name="lastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSyncDateTime() {
        return Optional.ofNullable(lastSyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastSyncDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Last sync time for the Exchange Connector”</i>
     * 
     * @param lastSyncDateTime
     *            new value of {@code lastSyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastSyncDateTime} field changed
     */
    public DeviceManagementExchangeConnector withLastSyncDateTime(OffsetDateTime lastSyncDateTime) {
        DeviceManagementExchangeConnector _x = _copy();
        _x.changedFields = changedFields.add("lastSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExchangeConnector");
        _x.lastSyncDateTime = lastSyncDateTime;
        return _x;
    }

    /**
     * <i>“Exchange Connector Status”</i>
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<DeviceManagementExchangeConnectorStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Exchange Connector Status”</i>
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public DeviceManagementExchangeConnector withStatus(DeviceManagementExchangeConnectorStatus status) {
        DeviceManagementExchangeConnector _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExchangeConnector");
        _x.status = status;
        return _x;
    }

    /**
     * <i>“Email address used to configure the Service To Service Exchange Connector.”</i>
     * 
     * @return property primarySmtpAddress
     */
    @Property(name="primarySmtpAddress")
    @JsonIgnore
    public Optional<String> getPrimarySmtpAddress() {
        return Optional.ofNullable(primarySmtpAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * primarySmtpAddress} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Email address used to configure the Service To Service Exchange Connector.”</i>
     * 
     * @param primarySmtpAddress
     *            new value of {@code primarySmtpAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code primarySmtpAddress} field changed
     */
    public DeviceManagementExchangeConnector withPrimarySmtpAddress(String primarySmtpAddress) {
        DeviceManagementExchangeConnector _x = _copy();
        _x.changedFields = changedFields.add("primarySmtpAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExchangeConnector");
        _x.primarySmtpAddress = primarySmtpAddress;
        return _x;
    }

    /**
     * <i>“The name of the Exchange server.”</i>
     * 
     * @return property serverName
     */
    @Property(name="serverName")
    @JsonIgnore
    public Optional<String> getServerName() {
        return Optional.ofNullable(serverName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code serverName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The name of the Exchange server.”</i>
     * 
     * @param serverName
     *            new value of {@code serverName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serverName} field changed
     */
    public DeviceManagementExchangeConnector withServerName(String serverName) {
        DeviceManagementExchangeConnector _x = _copy();
        _x.changedFields = changedFields.add("serverName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExchangeConnector");
        _x.serverName = serverName;
        return _x;
    }

    /**
     * <i>“The name of the server hosting the Exchange Connector.”</i>
     * 
     * @return property connectorServerName
     */
    @Property(name="connectorServerName")
    @JsonIgnore
    public Optional<String> getConnectorServerName() {
        return Optional.ofNullable(connectorServerName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * connectorServerName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The name of the server hosting the Exchange Connector.”</i>
     * 
     * @param connectorServerName
     *            new value of {@code connectorServerName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectorServerName} field changed
     */
    public DeviceManagementExchangeConnector withConnectorServerName(String connectorServerName) {
        DeviceManagementExchangeConnector _x = _copy();
        _x.changedFields = changedFields.add("connectorServerName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExchangeConnector");
        _x.connectorServerName = connectorServerName;
        return _x;
    }

    /**
     * <i>“The type of Exchange Connector Configured.”</i>
     * 
     * @return property exchangeConnectorType
     */
    @Property(name="exchangeConnectorType")
    @JsonIgnore
    public Optional<DeviceManagementExchangeConnectorType> getExchangeConnectorType() {
        return Optional.ofNullable(exchangeConnectorType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * exchangeConnectorType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The type of Exchange Connector Configured.”</i>
     * 
     * @param exchangeConnectorType
     *            new value of {@code exchangeConnectorType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code exchangeConnectorType} field changed
     */
    public DeviceManagementExchangeConnector withExchangeConnectorType(DeviceManagementExchangeConnectorType exchangeConnectorType) {
        DeviceManagementExchangeConnector _x = _copy();
        _x.changedFields = changedFields.add("exchangeConnectorType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExchangeConnector");
        _x.exchangeConnectorType = exchangeConnectorType;
        return _x;
    }

    /**
     * <i>“The version of the ExchangeConnectorAgent”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The version of the ExchangeConnectorAgent”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public DeviceManagementExchangeConnector withVersion(String version) {
        DeviceManagementExchangeConnector _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExchangeConnector");
        _x.version = version;
        return _x;
    }

    /**
     * <i>“An alias assigned to the Exchange server”</i>
     * 
     * @return property exchangeAlias
     */
    @Property(name="exchangeAlias")
    @JsonIgnore
    public Optional<String> getExchangeAlias() {
        return Optional.ofNullable(exchangeAlias);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code exchangeAlias}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“An alias assigned to the Exchange server”</i>
     * 
     * @param exchangeAlias
     *            new value of {@code exchangeAlias} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code exchangeAlias} field changed
     */
    public DeviceManagementExchangeConnector withExchangeAlias(String exchangeAlias) {
        DeviceManagementExchangeConnector _x = _copy();
        _x.changedFields = changedFields.add("exchangeAlias");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExchangeConnector");
        _x.exchangeAlias = exchangeAlias;
        return _x;
    }

    /**
     * <i>“Exchange Organization to the Exchange server”</i>
     * 
     * @return property exchangeOrganization
     */
    @Property(name="exchangeOrganization")
    @JsonIgnore
    public Optional<String> getExchangeOrganization() {
        return Optional.ofNullable(exchangeOrganization);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * exchangeOrganization} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Exchange Organization to the Exchange server”</i>
     * 
     * @param exchangeOrganization
     *            new value of {@code exchangeOrganization} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code exchangeOrganization} field changed
     */
    public DeviceManagementExchangeConnector withExchangeOrganization(String exchangeOrganization) {
        DeviceManagementExchangeConnector _x = _copy();
        _x.changedFields = changedFields.add("exchangeOrganization");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExchangeConnector");
        _x.exchangeOrganization = exchangeOrganization;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementExchangeConnector patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementExchangeConnector _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementExchangeConnector put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementExchangeConnector _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementExchangeConnector _copy() {
        DeviceManagementExchangeConnector _x = new DeviceManagementExchangeConnector();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastSyncDateTime = lastSyncDateTime;
        _x.status = status;
        _x.primarySmtpAddress = primarySmtpAddress;
        _x.serverName = serverName;
        _x.connectorServerName = connectorServerName;
        _x.exchangeConnectorType = exchangeConnectorType;
        _x.version = version;
        _x.exchangeAlias = exchangeAlias;
        _x.exchangeOrganization = exchangeOrganization;
        return _x;
    }

    @Action(name = "sync")
    @JsonIgnore
    public ActionRequestNoReturn sync(DeviceManagementExchangeConnectorSyncType syncType) {
        Preconditions.checkNotNull(syncType, "syncType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("syncType", "microsoft.graph.deviceManagementExchangeConnectorSyncType", syncType)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sync"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementExchangeConnector[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastSyncDateTime=");
        b.append(this.lastSyncDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("primarySmtpAddress=");
        b.append(this.primarySmtpAddress);
        b.append(", ");
        b.append("serverName=");
        b.append(this.serverName);
        b.append(", ");
        b.append("connectorServerName=");
        b.append(this.connectorServerName);
        b.append(", ");
        b.append("exchangeConnectorType=");
        b.append(this.exchangeConnectorType);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("exchangeAlias=");
        b.append(this.exchangeAlias);
        b.append(", ");
        b.append("exchangeOrganization=");
        b.append(this.exchangeOrganization);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
