package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceManagementDomainJoinConnectorState;


/**
 * <i>“A Domain Join Connector is a connector that is responsible to allocate (and
 * delete) machine account blobs”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "lastConnectionDateTime", 
    "state", 
    "version"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementDomainJoinConnector extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementDomainJoinConnector";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastConnectionDateTime")
    protected OffsetDateTime lastConnectionDateTime;

    @JsonProperty("state")
    protected DeviceManagementDomainJoinConnectorState state;

    @JsonProperty("version")
    protected String version;

    protected DeviceManagementDomainJoinConnector() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementDomainJoinConnector() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private OffsetDateTime lastConnectionDateTime;
        private DeviceManagementDomainJoinConnectorState state;
        private String version;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The connector display name.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Last time connector contacted Intune.”</i>
         * 
         * @param lastConnectionDateTime
         *            value of {@code lastConnectionDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastConnectionDateTime(OffsetDateTime lastConnectionDateTime) {
            this.lastConnectionDateTime = lastConnectionDateTime;
            this.changedFields = changedFields.add("lastConnectionDateTime");
            return this;
        }

        /**
         * <i>“The connector state.”</i>
         * 
         * @param state
         *            value of {@code state} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder state(DeviceManagementDomainJoinConnectorState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        /**
         * <i>“The version of the connector.”</i>
         * 
         * @param version
         *            value of {@code version} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public DeviceManagementDomainJoinConnector build() {
            DeviceManagementDomainJoinConnector _x = new DeviceManagementDomainJoinConnector();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementDomainJoinConnector";
            _x.id = id;
            _x.displayName = displayName;
            _x.lastConnectionDateTime = lastConnectionDateTime;
            _x.state = state;
            _x.version = version;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The connector display name.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The connector display name.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceManagementDomainJoinConnector withDisplayName(String displayName) {
        DeviceManagementDomainJoinConnector _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementDomainJoinConnector");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Last time connector contacted Intune.”</i>
     * 
     * @return property lastConnectionDateTime
     */
    @Property(name="lastConnectionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastConnectionDateTime() {
        return Optional.ofNullable(lastConnectionDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastConnectionDateTime} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Last time connector contacted Intune.”</i>
     * 
     * @param lastConnectionDateTime
     *            new value of {@code lastConnectionDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastConnectionDateTime} field changed
     */
    public DeviceManagementDomainJoinConnector withLastConnectionDateTime(OffsetDateTime lastConnectionDateTime) {
        DeviceManagementDomainJoinConnector _x = _copy();
        _x.changedFields = changedFields.add("lastConnectionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementDomainJoinConnector");
        _x.lastConnectionDateTime = lastConnectionDateTime;
        return _x;
    }

    /**
     * <i>“The connector state.”</i>
     * 
     * @return property state
     */
    @Property(name="state")
    @JsonIgnore
    public Optional<DeviceManagementDomainJoinConnectorState> getState() {
        return Optional.ofNullable(state);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code state} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The connector state.”</i>
     * 
     * @param state
     *            new value of {@code state} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code state} field changed
     */
    public DeviceManagementDomainJoinConnector withState(DeviceManagementDomainJoinConnectorState state) {
        DeviceManagementDomainJoinConnector _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementDomainJoinConnector");
        _x.state = state;
        return _x;
    }

    /**
     * <i>“The version of the connector.”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The version of the connector.”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public DeviceManagementDomainJoinConnector withVersion(String version) {
        DeviceManagementDomainJoinConnector _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementDomainJoinConnector");
        _x.version = version;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementDomainJoinConnector patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementDomainJoinConnector _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementDomainJoinConnector put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementDomainJoinConnector _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementDomainJoinConnector _copy() {
        DeviceManagementDomainJoinConnector _x = new DeviceManagementDomainJoinConnector();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.lastConnectionDateTime = lastConnectionDateTime;
        _x.state = state;
        _x.version = version;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementDomainJoinConnector[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastConnectionDateTime=");
        b.append(this.lastConnectionDateTime);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
