package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceManagementReportStatus;


/**
 * <i>“Entity representing the configuration of a cached report”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "reportName", 
    "filter", 
    "select", 
    "orderBy", 
    "metadata", 
    "status", 
    "lastRefreshDateTime", 
    "expirationDateTime"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementCachedReportConfiguration extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementCachedReportConfiguration";
    }

    @JsonProperty("reportName")
    protected String reportName;

    @JsonProperty("filter")
    protected String filter;

    @JsonProperty("select")
    protected List<String> select;

    @JsonProperty("select@nextLink")
    protected String selectNextLink;

    @JsonProperty("orderBy")
    protected List<String> orderBy;

    @JsonProperty("orderBy@nextLink")
    protected String orderByNextLink;

    @JsonProperty("metadata")
    protected String metadata;

    @JsonProperty("status")
    protected DeviceManagementReportStatus status;

    @JsonProperty("lastRefreshDateTime")
    protected OffsetDateTime lastRefreshDateTime;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    protected DeviceManagementCachedReportConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementCachedReportConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String reportName;
        private String filter;
        private List<String> select;
        private String selectNextLink;
        private List<String> orderBy;
        private String orderByNextLink;
        private String metadata;
        private DeviceManagementReportStatus status;
        private OffsetDateTime lastRefreshDateTime;
        private OffsetDateTime expirationDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Name of the report”</i>
         * 
         * @param reportName
         *            value of {@code reportName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder reportName(String reportName) {
            this.reportName = reportName;
            this.changedFields = changedFields.add("reportName");
            return this;
        }

        /**
         * <i>“Filters applied on report creation.”</i>
         * 
         * @param filter
         *            value of {@code filter} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder filter(String filter) {
            this.filter = filter;
            this.changedFields = changedFields.add("filter");
            return this;
        }

        /**
         * <i>“Columns selected from the report”</i>
         * 
         * @param select
         *            value of {@code select} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder select(List<String> select) {
            this.select = select;
            this.changedFields = changedFields.add("select");
            return this;
        }

        /**
         * <i>“Columns selected from the report”</i>
         * 
         * @param select
         *            value of {@code select} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder select(String... select) {
            return select(Arrays.asList(select));
        }

        /**
         * <i>“Columns selected from the report”</i>
         * 
         * @param selectNextLink
         *            value of {@code select@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder selectNextLink(String selectNextLink) {
            this.selectNextLink = selectNextLink;
            this.changedFields = changedFields.add("select");
            return this;
        }

        /**
         * <i>“Ordering of columns in the report”</i>
         * 
         * @param orderBy
         *            value of {@code orderBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder orderBy(List<String> orderBy) {
            this.orderBy = orderBy;
            this.changedFields = changedFields.add("orderBy");
            return this;
        }

        /**
         * <i>“Ordering of columns in the report”</i>
         * 
         * @param orderBy
         *            value of {@code orderBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder orderBy(String... orderBy) {
            return orderBy(Arrays.asList(orderBy));
        }

        /**
         * <i>“Ordering of columns in the report”</i>
         * 
         * @param orderByNextLink
         *            value of {@code orderBy@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder orderByNextLink(String orderByNextLink) {
            this.orderByNextLink = orderByNextLink;
            this.changedFields = changedFields.add("orderBy");
            return this;
        }

        /**
         * <i>“Caller-managed metadata associated with the report”</i>
         * 
         * @param metadata
         *            value of {@code metadata} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder metadata(String metadata) {
            this.metadata = metadata;
            this.changedFields = changedFields.add("metadata");
            return this;
        }

        /**
         * <i>“Status of the cached report”</i>
         * 
         * @param status
         *            value of {@code status} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder status(DeviceManagementReportStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        /**
         * <i>“Time that the cached report was last refreshed”</i>
         * 
         * @param lastRefreshDateTime
         *            value of {@code lastRefreshDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastRefreshDateTime(OffsetDateTime lastRefreshDateTime) {
            this.lastRefreshDateTime = lastRefreshDateTime;
            this.changedFields = changedFields.add("lastRefreshDateTime");
            return this;
        }

        /**
         * <i>“Time that the cached report expires”</i>
         * 
         * @param expirationDateTime
         *            value of {@code expirationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public DeviceManagementCachedReportConfiguration build() {
            DeviceManagementCachedReportConfiguration _x = new DeviceManagementCachedReportConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementCachedReportConfiguration";
            _x.id = id;
            _x.reportName = reportName;
            _x.filter = filter;
            _x.select = select;
            _x.selectNextLink = selectNextLink;
            _x.orderBy = orderBy;
            _x.orderByNextLink = orderByNextLink;
            _x.metadata = metadata;
            _x.status = status;
            _x.lastRefreshDateTime = lastRefreshDateTime;
            _x.expirationDateTime = expirationDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Name of the report”</i>
     * 
     * @return property reportName
     */
    @Property(name="reportName")
    @JsonIgnore
    public Optional<String> getReportName() {
        return Optional.ofNullable(reportName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code reportName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name of the report”</i>
     * 
     * @param reportName
     *            new value of {@code reportName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code reportName} field changed
     */
    public DeviceManagementCachedReportConfiguration withReportName(String reportName) {
        DeviceManagementCachedReportConfiguration _x = _copy();
        _x.changedFields = changedFields.add("reportName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementCachedReportConfiguration");
        _x.reportName = reportName;
        return _x;
    }

    /**
     * <i>“Filters applied on report creation.”</i>
     * 
     * @return property filter
     */
    @Property(name="filter")
    @JsonIgnore
    public Optional<String> getFilter() {
        return Optional.ofNullable(filter);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code filter} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Filters applied on report creation.”</i>
     * 
     * @param filter
     *            new value of {@code filter} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code filter} field changed
     */
    public DeviceManagementCachedReportConfiguration withFilter(String filter) {
        DeviceManagementCachedReportConfiguration _x = _copy();
        _x.changedFields = changedFields.add("filter");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementCachedReportConfiguration");
        _x.filter = filter;
        return _x;
    }

    /**
     * <i>“Columns selected from the report”</i>
     * 
     * @return property select
     */
    @Property(name="select")
    @JsonIgnore
    public CollectionPage<String> getSelect() {
        return new CollectionPage<String>(contextPath, String.class, select, Optional.ofNullable(selectNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Columns selected from the report”</i>
     * 
     * @return property select
     */
    @Property(name="select")
    @JsonIgnore
    public CollectionPage<String> getSelect(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, select, Optional.ofNullable(selectNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Ordering of columns in the report”</i>
     * 
     * @return property orderBy
     */
    @Property(name="orderBy")
    @JsonIgnore
    public CollectionPage<String> getOrderBy() {
        return new CollectionPage<String>(contextPath, String.class, orderBy, Optional.ofNullable(orderByNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Ordering of columns in the report”</i>
     * 
     * @return property orderBy
     */
    @Property(name="orderBy")
    @JsonIgnore
    public CollectionPage<String> getOrderBy(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, orderBy, Optional.ofNullable(orderByNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Caller-managed metadata associated with the report”</i>
     * 
     * @return property metadata
     */
    @Property(name="metadata")
    @JsonIgnore
    public Optional<String> getMetadata() {
        return Optional.ofNullable(metadata);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code metadata} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Caller-managed metadata associated with the report”</i>
     * 
     * @param metadata
     *            new value of {@code metadata} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code metadata} field changed
     */
    public DeviceManagementCachedReportConfiguration withMetadata(String metadata) {
        DeviceManagementCachedReportConfiguration _x = _copy();
        _x.changedFields = changedFields.add("metadata");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementCachedReportConfiguration");
        _x.metadata = metadata;
        return _x;
    }

    /**
     * <i>“Status of the cached report”</i>
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<DeviceManagementReportStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Status of the cached report”</i>
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public DeviceManagementCachedReportConfiguration withStatus(DeviceManagementReportStatus status) {
        DeviceManagementCachedReportConfiguration _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementCachedReportConfiguration");
        _x.status = status;
        return _x;
    }

    /**
     * <i>“Time that the cached report was last refreshed”</i>
     * 
     * @return property lastRefreshDateTime
     */
    @Property(name="lastRefreshDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastRefreshDateTime() {
        return Optional.ofNullable(lastRefreshDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastRefreshDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Time that the cached report was last refreshed”</i>
     * 
     * @param lastRefreshDateTime
     *            new value of {@code lastRefreshDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastRefreshDateTime} field changed
     */
    public DeviceManagementCachedReportConfiguration withLastRefreshDateTime(OffsetDateTime lastRefreshDateTime) {
        DeviceManagementCachedReportConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lastRefreshDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementCachedReportConfiguration");
        _x.lastRefreshDateTime = lastRefreshDateTime;
        return _x;
    }

    /**
     * <i>“Time that the cached report expires”</i>
     * 
     * @return property expirationDateTime
     */
    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * expirationDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Time that the cached report expires”</i>
     * 
     * @param expirationDateTime
     *            new value of {@code expirationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code expirationDateTime} field changed
     */
    public DeviceManagementCachedReportConfiguration withExpirationDateTime(OffsetDateTime expirationDateTime) {
        DeviceManagementCachedReportConfiguration _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementCachedReportConfiguration");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementCachedReportConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementCachedReportConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementCachedReportConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementCachedReportConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementCachedReportConfiguration _copy() {
        DeviceManagementCachedReportConfiguration _x = new DeviceManagementCachedReportConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportName = reportName;
        _x.filter = filter;
        _x.select = select;
        _x.orderBy = orderBy;
        _x.metadata = metadata;
        _x.status = status;
        _x.lastRefreshDateTime = lastRefreshDateTime;
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementCachedReportConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportName=");
        b.append(this.reportName);
        b.append(", ");
        b.append("filter=");
        b.append(this.filter);
        b.append(", ");
        b.append("select=");
        b.append(this.select);
        b.append(", ");
        b.append("orderBy=");
        b.append(this.orderBy);
        b.append(", ");
        b.append("metadata=");
        b.append(this.metadata);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("lastRefreshDateTime=");
        b.append(this.lastRefreshDateTime);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
