package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementConstraint;
import odata.msgraph.client.beta.complex.DeviceManagementSettingDependency;
import odata.msgraph.client.beta.enums.DeviceManangementIntentValueType;


/**
 * <i>“Entity representing the defintion for an abstract complex setting”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "implementations"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementAbstractComplexSettingDefinition extends DeviceManagementSettingDefinition implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementAbstractComplexSettingDefinition";
    }

    @JsonProperty("implementations")
    protected List<String> implementations;

    @JsonProperty("implementations@nextLink")
    protected String implementationsNextLink;

    protected DeviceManagementAbstractComplexSettingDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementAbstractComplexSettingDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DeviceManangementIntentValueType valueType;
        private String displayName;
        private Boolean isTopLevel;
        private String description;
        private String placeholderText;
        private String documentationUrl;
        private List<String> keywords;
        private String keywordsNextLink;
        private List<DeviceManagementConstraint> constraints;
        private String constraintsNextLink;
        private List<DeviceManagementSettingDependency> dependencies;
        private String dependenciesNextLink;
        private List<String> implementations;
        private String implementationsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder valueType(DeviceManangementIntentValueType valueType) {
            this.valueType = valueType;
            this.changedFields = changedFields.add("valueType");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isTopLevel(Boolean isTopLevel) {
            this.isTopLevel = isTopLevel;
            this.changedFields = changedFields.add("isTopLevel");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder placeholderText(String placeholderText) {
            this.placeholderText = placeholderText;
            this.changedFields = changedFields.add("placeholderText");
            return this;
        }

        public Builder documentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
            this.changedFields = changedFields.add("documentationUrl");
            return this;
        }

        public Builder keywords(List<String> keywords) {
            this.keywords = keywords;
            this.changedFields = changedFields.add("keywords");
            return this;
        }

        public Builder keywords(String... keywords) {
            return keywords(Arrays.asList(keywords));
        }

        public Builder keywordsNextLink(String keywordsNextLink) {
            this.keywordsNextLink = keywordsNextLink;
            this.changedFields = changedFields.add("keywords");
            return this;
        }

        public Builder constraints(List<DeviceManagementConstraint> constraints) {
            this.constraints = constraints;
            this.changedFields = changedFields.add("constraints");
            return this;
        }

        public Builder constraints(DeviceManagementConstraint... constraints) {
            return constraints(Arrays.asList(constraints));
        }

        public Builder constraintsNextLink(String constraintsNextLink) {
            this.constraintsNextLink = constraintsNextLink;
            this.changedFields = changedFields.add("constraints");
            return this;
        }

        public Builder dependencies(List<DeviceManagementSettingDependency> dependencies) {
            this.dependencies = dependencies;
            this.changedFields = changedFields.add("dependencies");
            return this;
        }

        public Builder dependencies(DeviceManagementSettingDependency... dependencies) {
            return dependencies(Arrays.asList(dependencies));
        }

        public Builder dependenciesNextLink(String dependenciesNextLink) {
            this.dependenciesNextLink = dependenciesNextLink;
            this.changedFields = changedFields.add("dependencies");
            return this;
        }

        /**
         * <i>“List of definition IDs for all possible implementations of this abstract complex
         * setting”</i>
         * 
         * @param implementations
         *            value of {@code implementations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder implementations(List<String> implementations) {
            this.implementations = implementations;
            this.changedFields = changedFields.add("implementations");
            return this;
        }

        /**
         * <i>“List of definition IDs for all possible implementations of this abstract complex
         * setting”</i>
         * 
         * @param implementations
         *            value of {@code implementations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder implementations(String... implementations) {
            return implementations(Arrays.asList(implementations));
        }

        /**
         * <i>“List of definition IDs for all possible implementations of this abstract complex
         * setting”</i>
         * 
         * @param implementationsNextLink
         *            value of {@code implementations@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder implementationsNextLink(String implementationsNextLink) {
            this.implementationsNextLink = implementationsNextLink;
            this.changedFields = changedFields.add("implementations");
            return this;
        }

        public DeviceManagementAbstractComplexSettingDefinition build() {
            DeviceManagementAbstractComplexSettingDefinition _x = new DeviceManagementAbstractComplexSettingDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementAbstractComplexSettingDefinition";
            _x.id = id;
            _x.valueType = valueType;
            _x.displayName = displayName;
            _x.isTopLevel = isTopLevel;
            _x.description = description;
            _x.placeholderText = placeholderText;
            _x.documentationUrl = documentationUrl;
            _x.keywords = keywords;
            _x.keywordsNextLink = keywordsNextLink;
            _x.constraints = constraints;
            _x.constraintsNextLink = constraintsNextLink;
            _x.dependencies = dependencies;
            _x.dependenciesNextLink = dependenciesNextLink;
            _x.implementations = implementations;
            _x.implementationsNextLink = implementationsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“List of definition IDs for all possible implementations of this abstract complex
     * setting”</i>
     * 
     * @return property implementations
     */
    @Property(name="implementations")
    @JsonIgnore
    public CollectionPage<String> getImplementations() {
        return new CollectionPage<String>(contextPath, String.class, implementations, Optional.ofNullable(implementationsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of definition IDs for all possible implementations of this abstract complex
     * setting”</i>
     * 
     * @return property implementations
     */
    @Property(name="implementations")
    @JsonIgnore
    public CollectionPage<String> getImplementations(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, implementations, Optional.ofNullable(implementationsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementAbstractComplexSettingDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementAbstractComplexSettingDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementAbstractComplexSettingDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementAbstractComplexSettingDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementAbstractComplexSettingDefinition _copy() {
        DeviceManagementAbstractComplexSettingDefinition _x = new DeviceManagementAbstractComplexSettingDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.valueType = valueType;
        _x.displayName = displayName;
        _x.isTopLevel = isTopLevel;
        _x.description = description;
        _x.placeholderText = placeholderText;
        _x.documentationUrl = documentationUrl;
        _x.keywords = keywords;
        _x.constraints = constraints;
        _x.dependencies = dependencies;
        _x.implementations = implementations;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementAbstractComplexSettingDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("valueType=");
        b.append(this.valueType);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isTopLevel=");
        b.append(this.isTopLevel);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("placeholderText=");
        b.append(this.placeholderText);
        b.append(", ");
        b.append("documentationUrl=");
        b.append(this.documentationUrl);
        b.append(", ");
        b.append("keywords=");
        b.append(this.keywords);
        b.append(", ");
        b.append("constraints=");
        b.append(this.constraints);
        b.append(", ");
        b.append("dependencies=");
        b.append(this.dependencies);
        b.append(", ");
        b.append("implementations=");
        b.append(this.implementations);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
