package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AdminConsent;
import odata.msgraph.client.beta.complex.ComanagedDevicesSummary;
import odata.msgraph.client.beta.complex.ComanagementEligibleDevicesSummary;
import odata.msgraph.client.beta.complex.DeviceAndAppManagementAssignedRoleDetails;
import odata.msgraph.client.beta.complex.DeviceManagementSettings;
import odata.msgraph.client.beta.complex.DeviceProtectionOverview;
import odata.msgraph.client.beta.complex.IntuneBrand;
import odata.msgraph.client.beta.complex.ManagedDeviceCleanupSettings;
import odata.msgraph.client.beta.complex.RolePermission;
import odata.msgraph.client.beta.complex.UserExperienceAnalyticsSettings;
import odata.msgraph.client.beta.complex.WindowsMalwareOverview;
import odata.msgraph.client.beta.entity.collection.request.AndroidDeviceOwnerEnrollmentProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AndroidForWorkAppConfigurationSchemaCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AndroidForWorkEnrollmentProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AndroidManagedStoreAppConfigurationSchemaCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AppleUserInitiatedEnrollmentProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AuditEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CartToClassAssociationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ComanagementEligibleDeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ComplianceManagementPartnerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DataSharingConsentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DepOnboardingSettingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DetectedAppCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceAndAppManagementAssignmentFilterCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceAndAppManagementRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCompliancePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCompliancePolicySettingStateSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceComplianceScriptCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationConflictSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceEnrollmentConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceHealthScriptCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementAutopilotEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementDerivedCredentialSettingsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementDomainJoinConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementExchangeConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementExchangeOnPremisesPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementIntentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementPartnerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementScriptCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementTemplateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementTroubleshootingEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceShellScriptCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EmbeddedSIMActivationCodePoolCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyDefinitionFileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyMigrationReportCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyObjectFileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyUploadedDefinitionFileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ImportedDeviceIdentityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ImportedWindowsAutopilotDeviceIdentityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IntuneBrandingProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IosUpdateDeviceStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedAllDeviceCertificateStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceEncryptionStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagementConditionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagementConditionStatementCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppTroubleshootingEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileThreatDefenseConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.NdesConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.NotificationMessageTemplateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RemoteActionAuditCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RemoteAssistancePartnerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ResourceOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RestrictedAppsViolationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RoleDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RoleScopeTagCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TelecomExpenseManagementPartnerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TermsAndConditionsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsBaselineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDevicePerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDeviceStartupHistoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDeviceStartupProcessCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDeviceStartupProcessPerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsScoreHistoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserPFXCertificateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsAutopilotDeploymentProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsAutopilotDeviceIdentityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsFeatureUpdateProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionAppLearningSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionNetworkLearningSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsMalwareInformationCollectionRequest;
import odata.msgraph.client.beta.entity.request.AdvancedThreatProtectionOnboardingStateSummaryRequest;
import odata.msgraph.client.beta.entity.request.AndroidForWorkSettingsRequest;
import odata.msgraph.client.beta.entity.request.AndroidManagedStoreAccountEnterpriseSettingsRequest;
import odata.msgraph.client.beta.entity.request.ApplePushNotificationCertificateRequest;
import odata.msgraph.client.beta.entity.request.DeviceCompliancePolicyDeviceStateSummaryRequest;
import odata.msgraph.client.beta.entity.request.DeviceConfigurationDeviceStateSummaryRequest;
import odata.msgraph.client.beta.entity.request.DeviceConfigurationUserStateSummaryRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementExchangeOnPremisesPolicyRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementReportsRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceOverviewRequest;
import odata.msgraph.client.beta.entity.request.OnPremisesConditionalAccessSettingsRequest;
import odata.msgraph.client.beta.entity.request.SoftwareUpdateStatusSummaryRequest;
import odata.msgraph.client.beta.entity.request.UserExperienceAnalyticsOverviewRequest;
import odata.msgraph.client.beta.entity.request.UserExperienceAnalyticsRegressionSummaryRequest;
import odata.msgraph.client.beta.entity.request.WindowsAutopilotSettingsRequest;
import odata.msgraph.client.beta.enums.DeviceManagementSubscriptionState;
import odata.msgraph.client.beta.enums.DeviceManagementSubscriptions;


/**
 * <i>“Singleton entity that acts as a container for Android for Work settings
 * functionality under device management.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "settings", 
    "maximumDepTokens", 
    "intuneAccountId", 
    "lastReportAggregationDateTime", 
    "deviceComplianceReportSummarizationDateTime", 
    "legacyPcManangementEnabled", 
    "unlicensedAdminstratorsEnabled", 
    "intuneBrand", 
    "subscriptionState", 
    "subscriptions", 
    "managedDeviceCleanupSettings", 
    "adminConsent", 
    "deviceProtectionOverview", 
    "windowsMalwareOverview", 
    "accountMoveCompletionDateTime", 
    "userExperienceAnalyticsSettings"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagement extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagement";
    }

    @JsonProperty("settings")
    protected DeviceManagementSettings settings;

    @JsonProperty("maximumDepTokens")
    protected Integer maximumDepTokens;

    @JsonProperty("intuneAccountId")
    protected String intuneAccountId;

    @JsonProperty("lastReportAggregationDateTime")
    protected OffsetDateTime lastReportAggregationDateTime;

    @JsonProperty("deviceComplianceReportSummarizationDateTime")
    protected OffsetDateTime deviceComplianceReportSummarizationDateTime;

    @JsonProperty("legacyPcManangementEnabled")
    protected Boolean legacyPcManangementEnabled;

    @JsonProperty("unlicensedAdminstratorsEnabled")
    protected Boolean unlicensedAdminstratorsEnabled;

    @JsonProperty("intuneBrand")
    protected IntuneBrand intuneBrand;

    @JsonProperty("subscriptionState")
    protected DeviceManagementSubscriptionState subscriptionState;

    @JsonProperty("subscriptions")
    protected DeviceManagementSubscriptions subscriptions;

    @JsonProperty("managedDeviceCleanupSettings")
    protected ManagedDeviceCleanupSettings managedDeviceCleanupSettings;

    @JsonProperty("adminConsent")
    protected AdminConsent adminConsent;

    @JsonProperty("deviceProtectionOverview")
    protected DeviceProtectionOverview deviceProtectionOverview;

    @JsonProperty("windowsMalwareOverview")
    protected WindowsMalwareOverview windowsMalwareOverview;

    @JsonProperty("accountMoveCompletionDateTime")
    protected OffsetDateTime accountMoveCompletionDateTime;

    @JsonProperty("userExperienceAnalyticsSettings")
    protected UserExperienceAnalyticsSettings userExperienceAnalyticsSettings;

    protected DeviceManagement() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagement() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DeviceManagementSettings settings;
        private Integer maximumDepTokens;
        private String intuneAccountId;
        private OffsetDateTime lastReportAggregationDateTime;
        private OffsetDateTime deviceComplianceReportSummarizationDateTime;
        private Boolean legacyPcManangementEnabled;
        private Boolean unlicensedAdminstratorsEnabled;
        private IntuneBrand intuneBrand;
        private DeviceManagementSubscriptionState subscriptionState;
        private DeviceManagementSubscriptions subscriptions;
        private ManagedDeviceCleanupSettings managedDeviceCleanupSettings;
        private AdminConsent adminConsent;
        private DeviceProtectionOverview deviceProtectionOverview;
        private WindowsMalwareOverview windowsMalwareOverview;
        private OffsetDateTime accountMoveCompletionDateTime;
        private UserExperienceAnalyticsSettings userExperienceAnalyticsSettings;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Account level settings.”</i>
         * 
         * @param settings
         *            value of {@code settings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settings(DeviceManagementSettings settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        /**
         * <i>“Maximum number of dep tokens allowed per-tenant.”</i>
         * 
         * @param maximumDepTokens
         *            value of {@code maximumDepTokens} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumDepTokens(Integer maximumDepTokens) {
            this.maximumDepTokens = maximumDepTokens;
            this.changedFields = changedFields.add("maximumDepTokens");
            return this;
        }

        /**
         * <i>“Intune Account Id for given tenant”</i>
         * 
         * @param intuneAccountId
         *            value of {@code intuneAccountId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intuneAccountId(String intuneAccountId) {
            this.intuneAccountId = intuneAccountId;
            this.changedFields = changedFields.add("intuneAccountId");
            return this;
        }

        /**
         * <i>“The last modified time of reporting for this account. This property is read-only
         * .”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param lastReportAggregationDateTime
         *            value of {@code lastReportAggregationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastReportAggregationDateTime(OffsetDateTime lastReportAggregationDateTime) {
            this.lastReportAggregationDateTime = lastReportAggregationDateTime;
            this.changedFields = changedFields.add("lastReportAggregationDateTime");
            return this;
        }

        /**
         * <i>“The last requested time of device compliance reporting for this account. This
         * property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param deviceComplianceReportSummarizationDateTime
         *            value of {@code deviceComplianceReportSummarizationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceComplianceReportSummarizationDateTime(OffsetDateTime deviceComplianceReportSummarizationDateTime) {
            this.deviceComplianceReportSummarizationDateTime = deviceComplianceReportSummarizationDateTime;
            this.changedFields = changedFields.add("deviceComplianceReportSummarizationDateTime");
            return this;
        }

        /**
         * <i>“The property to enable Non-MDM managed legacy PC management for this account.
         * This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param legacyPcManangementEnabled
         *            value of {@code legacyPcManangementEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder legacyPcManangementEnabled(Boolean legacyPcManangementEnabled) {
            this.legacyPcManangementEnabled = legacyPcManangementEnabled;
            this.changedFields = changedFields.add("legacyPcManangementEnabled");
            return this;
        }

        /**
         * <i>“When enabled, users assigned as administrators via Role Assignment Memberships
         * do not require an assigned Intune license. Prior to this, only Intune licensed
         * users were granted permissions with an Intune role unless they were assigned a
         * role via Azure Active Directory. You are limited to 350 unlicensed direct
         * members for each AAD security group in a role assignment, but you can assign
         * multiple AAD security groups to a role if you need to support more than 350
         * unlicensed administrators. Licensed administrators are unaffected, do not have
         * to be direct members, nor does the 350 member limit apply. This property is read
         * -only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param unlicensedAdminstratorsEnabled
         *            value of {@code unlicensedAdminstratorsEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unlicensedAdminstratorsEnabled(Boolean unlicensedAdminstratorsEnabled) {
            this.unlicensedAdminstratorsEnabled = unlicensedAdminstratorsEnabled;
            this.changedFields = changedFields.add("unlicensedAdminstratorsEnabled");
            return this;
        }

        /**
         * <i>“intuneBrand contains data which is used in customizing the appearance of the
         * Company Portal applications as well as the end user web portal.”</i>
         * 
         * @param intuneBrand
         *            value of {@code intuneBrand} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intuneBrand(IntuneBrand intuneBrand) {
            this.intuneBrand = intuneBrand;
            this.changedFields = changedFields.add("intuneBrand");
            return this;
        }

        /**
         * <i>“Tenant mobile device management subscription state.”</i>
         * 
         * @param subscriptionState
         *            value of {@code subscriptionState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subscriptionState(DeviceManagementSubscriptionState subscriptionState) {
            this.subscriptionState = subscriptionState;
            this.changedFields = changedFields.add("subscriptionState");
            return this;
        }

        /**
         * <i>“Tenant's Subscription.”</i>
         * 
         * @param subscriptions
         *            value of {@code subscriptions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subscriptions(DeviceManagementSubscriptions subscriptions) {
            this.subscriptions = subscriptions;
            this.changedFields = changedFields.add("subscriptions");
            return this;
        }

        /**
         * <i>“Device cleanup rule”</i>
         * 
         * @param managedDeviceCleanupSettings
         *            value of {@code managedDeviceCleanupSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceCleanupSettings(ManagedDeviceCleanupSettings managedDeviceCleanupSettings) {
            this.managedDeviceCleanupSettings = managedDeviceCleanupSettings;
            this.changedFields = changedFields.add("managedDeviceCleanupSettings");
            return this;
        }

        /**
         * <i>“Admin consent information.”</i>
         * 
         * @param adminConsent
         *            value of {@code adminConsent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder adminConsent(AdminConsent adminConsent) {
            this.adminConsent = adminConsent;
            this.changedFields = changedFields.add("adminConsent");
            return this;
        }

        /**
         * <i>“Device protection overview.”</i>
         * 
         * @param deviceProtectionOverview
         *            value of {@code deviceProtectionOverview} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceProtectionOverview(DeviceProtectionOverview deviceProtectionOverview) {
            this.deviceProtectionOverview = deviceProtectionOverview;
            this.changedFields = changedFields.add("deviceProtectionOverview");
            return this;
        }

        /**
         * <i>“Malware overview for windows devices.”</i>
         * 
         * @param windowsMalwareOverview
         *            value of {@code windowsMalwareOverview} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsMalwareOverview(WindowsMalwareOverview windowsMalwareOverview) {
            this.windowsMalwareOverview = windowsMalwareOverview;
            this.changedFields = changedFields.add("windowsMalwareOverview");
            return this;
        }

        /**
         * <i>“The date &amp; time when tenant data moved between scaleunits.”</i>
         * 
         * @param accountMoveCompletionDateTime
         *            value of {@code accountMoveCompletionDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accountMoveCompletionDateTime(OffsetDateTime accountMoveCompletionDateTime) {
            this.accountMoveCompletionDateTime = accountMoveCompletionDateTime;
            this.changedFields = changedFields.add("accountMoveCompletionDateTime");
            return this;
        }

        /**
         * <i>“User experience analytics device settings”</i>
         * 
         * @param userExperienceAnalyticsSettings
         *            value of {@code userExperienceAnalyticsSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsSettings(UserExperienceAnalyticsSettings userExperienceAnalyticsSettings) {
            this.userExperienceAnalyticsSettings = userExperienceAnalyticsSettings;
            this.changedFields = changedFields.add("userExperienceAnalyticsSettings");
            return this;
        }

        public DeviceManagement build() {
            DeviceManagement _x = new DeviceManagement();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagement";
            _x.id = id;
            _x.settings = settings;
            _x.maximumDepTokens = maximumDepTokens;
            _x.intuneAccountId = intuneAccountId;
            _x.lastReportAggregationDateTime = lastReportAggregationDateTime;
            _x.deviceComplianceReportSummarizationDateTime = deviceComplianceReportSummarizationDateTime;
            _x.legacyPcManangementEnabled = legacyPcManangementEnabled;
            _x.unlicensedAdminstratorsEnabled = unlicensedAdminstratorsEnabled;
            _x.intuneBrand = intuneBrand;
            _x.subscriptionState = subscriptionState;
            _x.subscriptions = subscriptions;
            _x.managedDeviceCleanupSettings = managedDeviceCleanupSettings;
            _x.adminConsent = adminConsent;
            _x.deviceProtectionOverview = deviceProtectionOverview;
            _x.windowsMalwareOverview = windowsMalwareOverview;
            _x.accountMoveCompletionDateTime = accountMoveCompletionDateTime;
            _x.userExperienceAnalyticsSettings = userExperienceAnalyticsSettings;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Account level settings.”</i>
     * 
     * @return property settings
     */
    @Property(name="settings")
    @JsonIgnore
    public Optional<DeviceManagementSettings> getSettings() {
        return Optional.ofNullable(settings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settings} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Account level settings.”</i>
     * 
     * @param settings
     *            new value of {@code settings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settings} field changed
     */
    public DeviceManagement withSettings(DeviceManagementSettings settings) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.settings = settings;
        return _x;
    }

    /**
     * <i>“Maximum number of dep tokens allowed per-tenant.”</i>
     * 
     * @return property maximumDepTokens
     */
    @Property(name="maximumDepTokens")
    @JsonIgnore
    public Optional<Integer> getMaximumDepTokens() {
        return Optional.ofNullable(maximumDepTokens);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code maximumDepTokens}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Maximum number of dep tokens allowed per-tenant.”</i>
     * 
     * @param maximumDepTokens
     *            new value of {@code maximumDepTokens} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumDepTokens} field changed
     */
    public DeviceManagement withMaximumDepTokens(Integer maximumDepTokens) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("maximumDepTokens");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.maximumDepTokens = maximumDepTokens;
        return _x;
    }

    /**
     * <i>“Intune Account Id for given tenant”</i>
     * 
     * @return property intuneAccountId
     */
    @Property(name="intuneAccountId")
    @JsonIgnore
    public Optional<String> getIntuneAccountId() {
        return Optional.ofNullable(intuneAccountId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code intuneAccountId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Intune Account Id for given tenant”</i>
     * 
     * @param intuneAccountId
     *            new value of {@code intuneAccountId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code intuneAccountId} field changed
     */
    public DeviceManagement withIntuneAccountId(String intuneAccountId) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("intuneAccountId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.intuneAccountId = intuneAccountId;
        return _x;
    }

    /**
     * <i>“The last modified time of reporting for this account. This property is read-only
     * .”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property lastReportAggregationDateTime
     */
    @Property(name="lastReportAggregationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastReportAggregationDateTime() {
        return Optional.ofNullable(lastReportAggregationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastReportAggregationDateTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The last modified time of reporting for this account. This property is read-only
     * .”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param lastReportAggregationDateTime
     *            new value of {@code lastReportAggregationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastReportAggregationDateTime} field changed
     */
    public DeviceManagement withLastReportAggregationDateTime(OffsetDateTime lastReportAggregationDateTime) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("lastReportAggregationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.lastReportAggregationDateTime = lastReportAggregationDateTime;
        return _x;
    }

    /**
     * <i>“The last requested time of device compliance reporting for this account. This
     * property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property deviceComplianceReportSummarizationDateTime
     */
    @Property(name="deviceComplianceReportSummarizationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDeviceComplianceReportSummarizationDateTime() {
        return Optional.ofNullable(deviceComplianceReportSummarizationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceComplianceReportSummarizationDateTime} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The last requested time of device compliance reporting for this account. This
     * property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param deviceComplianceReportSummarizationDateTime
     *            new value of {@code deviceComplianceReportSummarizationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceComplianceReportSummarizationDateTime} field changed
     */
    public DeviceManagement withDeviceComplianceReportSummarizationDateTime(OffsetDateTime deviceComplianceReportSummarizationDateTime) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceComplianceReportSummarizationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceComplianceReportSummarizationDateTime = deviceComplianceReportSummarizationDateTime;
        return _x;
    }

    /**
     * <i>“The property to enable Non-MDM managed legacy PC management for this account.
     * This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property legacyPcManangementEnabled
     */
    @Property(name="legacyPcManangementEnabled")
    @JsonIgnore
    public Optional<Boolean> getLegacyPcManangementEnabled() {
        return Optional.ofNullable(legacyPcManangementEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * legacyPcManangementEnabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The property to enable Non-MDM managed legacy PC management for this account.
     * This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param legacyPcManangementEnabled
     *            new value of {@code legacyPcManangementEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code legacyPcManangementEnabled} field changed
     */
    public DeviceManagement withLegacyPcManangementEnabled(Boolean legacyPcManangementEnabled) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("legacyPcManangementEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.legacyPcManangementEnabled = legacyPcManangementEnabled;
        return _x;
    }

    /**
     * <i>“When enabled, users assigned as administrators via Role Assignment Memberships
     * do not require an assigned Intune license. Prior to this, only Intune licensed
     * users were granted permissions with an Intune role unless they were assigned a
     * role via Azure Active Directory. You are limited to 350 unlicensed direct
     * members for each AAD security group in a role assignment, but you can assign
     * multiple AAD security groups to a role if you need to support more than 350
     * unlicensed administrators. Licensed administrators are unaffected, do not have
     * to be direct members, nor does the 350 member limit apply. This property is read
     * -only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property unlicensedAdminstratorsEnabled
     */
    @Property(name="unlicensedAdminstratorsEnabled")
    @JsonIgnore
    public Optional<Boolean> getUnlicensedAdminstratorsEnabled() {
        return Optional.ofNullable(unlicensedAdminstratorsEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * unlicensedAdminstratorsEnabled} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“When enabled, users assigned as administrators via Role Assignment Memberships
     * do not require an assigned Intune license. Prior to this, only Intune licensed
     * users were granted permissions with an Intune role unless they were assigned a
     * role via Azure Active Directory. You are limited to 350 unlicensed direct
     * members for each AAD security group in a role assignment, but you can assign
     * multiple AAD security groups to a role if you need to support more than 350
     * unlicensed administrators. Licensed administrators are unaffected, do not have
     * to be direct members, nor does the 350 member limit apply. This property is read
     * -only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param unlicensedAdminstratorsEnabled
     *            new value of {@code unlicensedAdminstratorsEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unlicensedAdminstratorsEnabled} field changed
     */
    public DeviceManagement withUnlicensedAdminstratorsEnabled(Boolean unlicensedAdminstratorsEnabled) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("unlicensedAdminstratorsEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.unlicensedAdminstratorsEnabled = unlicensedAdminstratorsEnabled;
        return _x;
    }

    /**
     * <i>“intuneBrand contains data which is used in customizing the appearance of the
     * Company Portal applications as well as the end user web portal.”</i>
     * 
     * @return property intuneBrand
     */
    @Property(name="intuneBrand")
    @JsonIgnore
    public Optional<IntuneBrand> getIntuneBrand() {
        return Optional.ofNullable(intuneBrand);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code intuneBrand}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“intuneBrand contains data which is used in customizing the appearance of the
     * Company Portal applications as well as the end user web portal.”</i>
     * 
     * @param intuneBrand
     *            new value of {@code intuneBrand} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code intuneBrand} field changed
     */
    public DeviceManagement withIntuneBrand(IntuneBrand intuneBrand) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("intuneBrand");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.intuneBrand = intuneBrand;
        return _x;
    }

    /**
     * <i>“Tenant mobile device management subscription state.”</i>
     * 
     * @return property subscriptionState
     */
    @Property(name="subscriptionState")
    @JsonIgnore
    public Optional<DeviceManagementSubscriptionState> getSubscriptionState() {
        return Optional.ofNullable(subscriptionState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code subscriptionState
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Tenant mobile device management subscription state.”</i>
     * 
     * @param subscriptionState
     *            new value of {@code subscriptionState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subscriptionState} field changed
     */
    public DeviceManagement withSubscriptionState(DeviceManagementSubscriptionState subscriptionState) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("subscriptionState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.subscriptionState = subscriptionState;
        return _x;
    }

    /**
     * <i>“Tenant's Subscription.”</i>
     * 
     * @return property subscriptions
     */
    @Property(name="subscriptions")
    @JsonIgnore
    public Optional<DeviceManagementSubscriptions> getSubscriptions() {
        return Optional.ofNullable(subscriptions);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code subscriptions}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Tenant's Subscription.”</i>
     * 
     * @param subscriptions
     *            new value of {@code subscriptions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subscriptions} field changed
     */
    public DeviceManagement withSubscriptions(DeviceManagementSubscriptions subscriptions) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("subscriptions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.subscriptions = subscriptions;
        return _x;
    }

    /**
     * <i>“Device cleanup rule”</i>
     * 
     * @return property managedDeviceCleanupSettings
     */
    @Property(name="managedDeviceCleanupSettings")
    @JsonIgnore
    public Optional<ManagedDeviceCleanupSettings> getManagedDeviceCleanupSettings() {
        return Optional.ofNullable(managedDeviceCleanupSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managedDeviceCleanupSettings} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device cleanup rule”</i>
     * 
     * @param managedDeviceCleanupSettings
     *            new value of {@code managedDeviceCleanupSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceCleanupSettings} field changed
     */
    public DeviceManagement withManagedDeviceCleanupSettings(ManagedDeviceCleanupSettings managedDeviceCleanupSettings) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceCleanupSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.managedDeviceCleanupSettings = managedDeviceCleanupSettings;
        return _x;
    }

    /**
     * <i>“Admin consent information.”</i>
     * 
     * @return property adminConsent
     */
    @Property(name="adminConsent")
    @JsonIgnore
    public Optional<AdminConsent> getAdminConsent() {
        return Optional.ofNullable(adminConsent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code adminConsent}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Admin consent information.”</i>
     * 
     * @param adminConsent
     *            new value of {@code adminConsent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code adminConsent} field changed
     */
    public DeviceManagement withAdminConsent(AdminConsent adminConsent) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("adminConsent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.adminConsent = adminConsent;
        return _x;
    }

    /**
     * <i>“Device protection overview.”</i>
     * 
     * @return property deviceProtectionOverview
     */
    @Property(name="deviceProtectionOverview")
    @JsonIgnore
    public Optional<DeviceProtectionOverview> getDeviceProtectionOverview() {
        return Optional.ofNullable(deviceProtectionOverview);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceProtectionOverview} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device protection overview.”</i>
     * 
     * @param deviceProtectionOverview
     *            new value of {@code deviceProtectionOverview} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceProtectionOverview} field changed
     */
    public DeviceManagement withDeviceProtectionOverview(DeviceProtectionOverview deviceProtectionOverview) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceProtectionOverview");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceProtectionOverview = deviceProtectionOverview;
        return _x;
    }

    /**
     * <i>“Malware overview for windows devices.”</i>
     * 
     * @return property windowsMalwareOverview
     */
    @Property(name="windowsMalwareOverview")
    @JsonIgnore
    public Optional<WindowsMalwareOverview> getWindowsMalwareOverview() {
        return Optional.ofNullable(windowsMalwareOverview);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsMalwareOverview} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Malware overview for windows devices.”</i>
     * 
     * @param windowsMalwareOverview
     *            new value of {@code windowsMalwareOverview} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsMalwareOverview} field changed
     */
    public DeviceManagement withWindowsMalwareOverview(WindowsMalwareOverview windowsMalwareOverview) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("windowsMalwareOverview");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.windowsMalwareOverview = windowsMalwareOverview;
        return _x;
    }

    /**
     * <i>“The date &amp; time when tenant data moved between scaleunits.”</i>
     * 
     * @return property accountMoveCompletionDateTime
     */
    @Property(name="accountMoveCompletionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAccountMoveCompletionDateTime() {
        return Optional.ofNullable(accountMoveCompletionDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * accountMoveCompletionDateTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The date &amp; time when tenant data moved between scaleunits.”</i>
     * 
     * @param accountMoveCompletionDateTime
     *            new value of {@code accountMoveCompletionDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code accountMoveCompletionDateTime} field changed
     */
    public DeviceManagement withAccountMoveCompletionDateTime(OffsetDateTime accountMoveCompletionDateTime) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("accountMoveCompletionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.accountMoveCompletionDateTime = accountMoveCompletionDateTime;
        return _x;
    }

    /**
     * <i>“User experience analytics device settings”</i>
     * 
     * @return property userExperienceAnalyticsSettings
     */
    @Property(name="userExperienceAnalyticsSettings")
    @JsonIgnore
    public Optional<UserExperienceAnalyticsSettings> getUserExperienceAnalyticsSettings() {
        return Optional.ofNullable(userExperienceAnalyticsSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsSettings} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics device settings”</i>
     * 
     * @param userExperienceAnalyticsSettings
     *            new value of {@code userExperienceAnalyticsSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsSettings} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsSettings(UserExperienceAnalyticsSettings userExperienceAnalyticsSettings) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsSettings = userExperienceAnalyticsSettings;
        return _x;
    }

    /**
     * <i>“The Audit Events”</i>
     * 
     * @return navigational property auditEvents
     */
    @NavigationProperty(name="auditEvents")
    @JsonIgnore
    public AuditEventCollectionRequest getAuditEvents() {
        return new AuditEventCollectionRequest(
                        contextPath.addSegment("auditEvents"));
    }

    /**
     * <i>“The singleton Android for Work settings entity.”</i>
     * 
     * @return navigational property androidForWorkSettings
     */
    @NavigationProperty(name="androidForWorkSettings")
    @JsonIgnore
    public AndroidForWorkSettingsRequest getAndroidForWorkSettings() {
        return new AndroidForWorkSettingsRequest(contextPath.addSegment("androidForWorkSettings"));
    }

    /**
     * <i>“Android for Work app configuration schema entities.”</i>
     * 
     * @return navigational property androidForWorkAppConfigurationSchemas
     */
    @NavigationProperty(name="androidForWorkAppConfigurationSchemas")
    @JsonIgnore
    public AndroidForWorkAppConfigurationSchemaCollectionRequest getAndroidForWorkAppConfigurationSchemas() {
        return new AndroidForWorkAppConfigurationSchemaCollectionRequest(
                        contextPath.addSegment("androidForWorkAppConfigurationSchemas"));
    }

    /**
     * <i>“Android for Work enrollment profile entities.”</i>
     * 
     * @return navigational property androidForWorkEnrollmentProfiles
     */
    @NavigationProperty(name="androidForWorkEnrollmentProfiles")
    @JsonIgnore
    public AndroidForWorkEnrollmentProfileCollectionRequest getAndroidForWorkEnrollmentProfiles() {
        return new AndroidForWorkEnrollmentProfileCollectionRequest(
                        contextPath.addSegment("androidForWorkEnrollmentProfiles"));
    }

    /**
     * <i>“The singleton Android managed store account enterprise settings entity.”</i>
     * 
     * @return navigational property androidManagedStoreAccountEnterpriseSettings
     */
    @NavigationProperty(name="androidManagedStoreAccountEnterpriseSettings")
    @JsonIgnore
    public AndroidManagedStoreAccountEnterpriseSettingsRequest getAndroidManagedStoreAccountEnterpriseSettings() {
        return new AndroidManagedStoreAccountEnterpriseSettingsRequest(contextPath.addSegment("androidManagedStoreAccountEnterpriseSettings"));
    }

    /**
     * <i>“Android Enterprise app configuration schema entities.”</i>
     * 
     * @return navigational property androidManagedStoreAppConfigurationSchemas
     */
    @NavigationProperty(name="androidManagedStoreAppConfigurationSchemas")
    @JsonIgnore
    public AndroidManagedStoreAppConfigurationSchemaCollectionRequest getAndroidManagedStoreAppConfigurationSchemas() {
        return new AndroidManagedStoreAppConfigurationSchemaCollectionRequest(
                        contextPath.addSegment("androidManagedStoreAppConfigurationSchemas"));
    }

    /**
     * <i>“Android device owner enrollment profile entities.”</i>
     * 
     * @return navigational property androidDeviceOwnerEnrollmentProfiles
     */
    @NavigationProperty(name="androidDeviceOwnerEnrollmentProfiles")
    @JsonIgnore
    public AndroidDeviceOwnerEnrollmentProfileCollectionRequest getAndroidDeviceOwnerEnrollmentProfiles() {
        return new AndroidDeviceOwnerEnrollmentProfileCollectionRequest(
                        contextPath.addSegment("androidDeviceOwnerEnrollmentProfiles"));
    }

    /**
     * <i>“The list of assignment filters”</i>
     * 
     * @return navigational property assignmentFilters
     */
    @NavigationProperty(name="assignmentFilters")
    @JsonIgnore
    public DeviceAndAppManagementAssignmentFilterCollectionRequest getAssignmentFilters() {
        return new DeviceAndAppManagementAssignmentFilterCollectionRequest(
                        contextPath.addSegment("assignmentFilters"));
    }

    /**
     * <i>“The terms and conditions associated with device management of the company.”</i>
     * 
     * @return navigational property termsAndConditions
     */
    @NavigationProperty(name="termsAndConditions")
    @JsonIgnore
    public TermsAndConditionsCollectionRequest getTermsAndConditions() {
        return new TermsAndConditionsCollectionRequest(
                        contextPath.addSegment("termsAndConditions"));
    }

    /**
     * <i>“The device configurations.”</i>
     * 
     * @return navigational property deviceConfigurations
     */
    @NavigationProperty(name="deviceConfigurations")
    @JsonIgnore
    public DeviceConfigurationCollectionRequest getDeviceConfigurations() {
        return new DeviceConfigurationCollectionRequest(
                        contextPath.addSegment("deviceConfigurations"));
    }

    /**
     * <i>“The device compliance policies.”</i>
     * 
     * @return navigational property deviceCompliancePolicies
     */
    @NavigationProperty(name="deviceCompliancePolicies")
    @JsonIgnore
    public DeviceCompliancePolicyCollectionRequest getDeviceCompliancePolicies() {
        return new DeviceCompliancePolicyCollectionRequest(
                        contextPath.addSegment("deviceCompliancePolicies"));
    }

    /**
     * <i>“The software update status summary.”</i>
     * 
     * @return navigational property softwareUpdateStatusSummary
     */
    @NavigationProperty(name="softwareUpdateStatusSummary")
    @JsonIgnore
    public SoftwareUpdateStatusSummaryRequest getSoftwareUpdateStatusSummary() {
        return new SoftwareUpdateStatusSummaryRequest(contextPath.addSegment("softwareUpdateStatusSummary"));
    }

    /**
     * <i>“The device compliance state summary for this account.”</i>
     * 
     * @return navigational property deviceCompliancePolicyDeviceStateSummary
     */
    @NavigationProperty(name="deviceCompliancePolicyDeviceStateSummary")
    @JsonIgnore
    public DeviceCompliancePolicyDeviceStateSummaryRequest getDeviceCompliancePolicyDeviceStateSummary() {
        return new DeviceCompliancePolicyDeviceStateSummaryRequest(contextPath.addSegment("deviceCompliancePolicyDeviceStateSummary"));
    }

    /**
     * <i>“The summary states of compliance policy settings for this account.”</i>
     * 
     * @return navigational property deviceCompliancePolicySettingStateSummaries
     */
    @NavigationProperty(name="deviceCompliancePolicySettingStateSummaries")
    @JsonIgnore
    public DeviceCompliancePolicySettingStateSummaryCollectionRequest getDeviceCompliancePolicySettingStateSummaries() {
        return new DeviceCompliancePolicySettingStateSummaryCollectionRequest(
                        contextPath.addSegment("deviceCompliancePolicySettingStateSummaries"));
    }

    /**
     * <i>“The summary state of ATP onboarding state for this account.”</i>
     * 
     * @return navigational property advancedThreatProtectionOnboardingStateSummary
     */
    @NavigationProperty(name="advancedThreatProtectionOnboardingStateSummary")
    @JsonIgnore
    public AdvancedThreatProtectionOnboardingStateSummaryRequest getAdvancedThreatProtectionOnboardingStateSummary() {
        return new AdvancedThreatProtectionOnboardingStateSummaryRequest(contextPath.addSegment("advancedThreatProtectionOnboardingStateSummary"));
    }

    /**
     * <i>“The device configuration device state summary for this account.”</i>
     * 
     * @return navigational property deviceConfigurationDeviceStateSummaries
     */
    @NavigationProperty(name="deviceConfigurationDeviceStateSummaries")
    @JsonIgnore
    public DeviceConfigurationDeviceStateSummaryRequest getDeviceConfigurationDeviceStateSummaries() {
        return new DeviceConfigurationDeviceStateSummaryRequest(contextPath.addSegment("deviceConfigurationDeviceStateSummaries"));
    }

    /**
     * <i>“The device configuration user state summary for this account.”</i>
     * 
     * @return navigational property deviceConfigurationUserStateSummaries
     */
    @NavigationProperty(name="deviceConfigurationUserStateSummaries")
    @JsonIgnore
    public DeviceConfigurationUserStateSummaryRequest getDeviceConfigurationUserStateSummaries() {
        return new DeviceConfigurationUserStateSummaryRequest(contextPath.addSegment("deviceConfigurationUserStateSummaries"));
    }

    /**
     * <i>“The Cart To Class Associations.”</i>
     * 
     * @return navigational property cartToClassAssociations
     */
    @NavigationProperty(name="cartToClassAssociations")
    @JsonIgnore
    public CartToClassAssociationCollectionRequest getCartToClassAssociations() {
        return new CartToClassAssociationCollectionRequest(
                        contextPath.addSegment("cartToClassAssociations"));
    }

    /**
     * <i>“The IOS software update installation statuses for this account.”</i>
     * 
     * @return navigational property iosUpdateStatuses
     */
    @NavigationProperty(name="iosUpdateStatuses")
    @JsonIgnore
    public IosUpdateDeviceStatusCollectionRequest getIosUpdateStatuses() {
        return new IosUpdateDeviceStatusCollectionRequest(
                        contextPath.addSegment("iosUpdateStatuses"));
    }

    /**
     * <i>“The collection of Ndes connectors for this account.”</i>
     * 
     * @return navigational property ndesConnectors
     */
    @NavigationProperty(name="ndesConnectors")
    @JsonIgnore
    public NdesConnectorCollectionRequest getNdesConnectors() {
        return new NdesConnectorCollectionRequest(
                        contextPath.addSegment("ndesConnectors"));
    }

    /**
     * <i>“Restricted apps violations for this account.”</i>
     * 
     * @return navigational property deviceConfigurationRestrictedAppsViolations
     */
    @NavigationProperty(name="deviceConfigurationRestrictedAppsViolations")
    @JsonIgnore
    public RestrictedAppsViolationCollectionRequest getDeviceConfigurationRestrictedAppsViolations() {
        return new RestrictedAppsViolationCollectionRequest(
                        contextPath.addSegment("deviceConfigurationRestrictedAppsViolations"));
    }

    /**
     * <i>“Encryption report for devices in this account”</i>
     * 
     * @return navigational property managedDeviceEncryptionStates
     */
    @NavigationProperty(name="managedDeviceEncryptionStates")
    @JsonIgnore
    public ManagedDeviceEncryptionStateCollectionRequest getManagedDeviceEncryptionStates() {
        return new ManagedDeviceEncryptionStateCollectionRequest(
                        contextPath.addSegment("managedDeviceEncryptionStates"));
    }

    /**
     * <i>“Summary of policies in conflict state for this account.”</i>
     * 
     * @return navigational property deviceConfigurationConflictSummary
     */
    @NavigationProperty(name="deviceConfigurationConflictSummary")
    @JsonIgnore
    public DeviceConfigurationConflictSummaryCollectionRequest getDeviceConfigurationConflictSummary() {
        return new DeviceConfigurationConflictSummaryCollectionRequest(
                        contextPath.addSegment("deviceConfigurationConflictSummary"));
    }

    /**
     * <i>“Summary of all certificates for all devices.”</i>
     * 
     * @return navigational property deviceConfigurationsAllManagedDeviceCertificateStates
     */
    @NavigationProperty(name="deviceConfigurationsAllManagedDeviceCertificateStates")
    @JsonIgnore
    public ManagedAllDeviceCertificateStateCollectionRequest getDeviceConfigurationsAllManagedDeviceCertificateStates() {
        return new ManagedAllDeviceCertificateStateCollectionRequest(
                        contextPath.addSegment("deviceConfigurationsAllManagedDeviceCertificateStates"));
    }

    /**
     * <i>“The list of device categories with the tenant.”</i>
     * 
     * @return navigational property deviceCategories
     */
    @NavigationProperty(name="deviceCategories")
    @JsonIgnore
    public DeviceCategoryCollectionRequest getDeviceCategories() {
        return new DeviceCategoryCollectionRequest(
                        contextPath.addSegment("deviceCategories"));
    }

    /**
     * <i>“The list of Exchange Connectors configured by the tenant.”</i>
     * 
     * @return navigational property exchangeConnectors
     */
    @NavigationProperty(name="exchangeConnectors")
    @JsonIgnore
    public DeviceManagementExchangeConnectorCollectionRequest getExchangeConnectors() {
        return new DeviceManagementExchangeConnectorCollectionRequest(
                        contextPath.addSegment("exchangeConnectors"));
    }

    /**
     * <i>“The list of device enrollment configurations”</i>
     * 
     * @return navigational property deviceEnrollmentConfigurations
     */
    @NavigationProperty(name="deviceEnrollmentConfigurations")
    @JsonIgnore
    public DeviceEnrollmentConfigurationCollectionRequest getDeviceEnrollmentConfigurations() {
        return new DeviceEnrollmentConfigurationCollectionRequest(
                        contextPath.addSegment("deviceEnrollmentConfigurations"));
    }

    /**
     * <i>“The policy which controls mobile device access to Exchange On Premises”</i>
     * 
     * @return navigational property exchangeOnPremisesPolicy
     */
    @NavigationProperty(name="exchangeOnPremisesPolicy")
    @JsonIgnore
    public DeviceManagementExchangeOnPremisesPolicyRequest getExchangeOnPremisesPolicy() {
        return new DeviceManagementExchangeOnPremisesPolicyRequest(contextPath.addSegment("exchangeOnPremisesPolicy"));
    }

    /**
     * <i>“The list of Exchange On Premisis policies configured by the tenant.”</i>
     * 
     * @return navigational property exchangeOnPremisesPolicies
     */
    @NavigationProperty(name="exchangeOnPremisesPolicies")
    @JsonIgnore
    public DeviceManagementExchangeOnPremisesPolicyCollectionRequest getExchangeOnPremisesPolicies() {
        return new DeviceManagementExchangeOnPremisesPolicyCollectionRequest(
                        contextPath.addSegment("exchangeOnPremisesPolicies"));
    }

    /**
     * <i>“The Exchange on premises conditional access settings. On premises conditional
     * access will require devices to be both enrolled and compliant for mail access”</i>
     * 
     * @return navigational property conditionalAccessSettings
     */
    @NavigationProperty(name="conditionalAccessSettings")
    @JsonIgnore
    public OnPremisesConditionalAccessSettingsRequest getConditionalAccessSettings() {
        return new OnPremisesConditionalAccessSettingsRequest(contextPath.addSegment("conditionalAccessSettings"));
    }

    /**
     * <i>“The list of Mobile threat Defense connectors configured by the tenant.”</i>
     * 
     * @return navigational property mobileThreatDefenseConnectors
     */
    @NavigationProperty(name="mobileThreatDefenseConnectors")
    @JsonIgnore
    public MobileThreatDefenseConnectorCollectionRequest getMobileThreatDefenseConnectors() {
        return new MobileThreatDefenseConnectorCollectionRequest(
                        contextPath.addSegment("mobileThreatDefenseConnectors"));
    }

    /**
     * <i>“The list of Device Management Partners configured by the tenant.”</i>
     * 
     * @return navigational property deviceManagementPartners
     */
    @NavigationProperty(name="deviceManagementPartners")
    @JsonIgnore
    public DeviceManagementPartnerCollectionRequest getDeviceManagementPartners() {
        return new DeviceManagementPartnerCollectionRequest(
                        contextPath.addSegment("deviceManagementPartners"));
    }

    /**
     * <i>“The list of Compliance Management Partners configured by the tenant.”</i>
     * 
     * @return navigational property complianceManagementPartners
     */
    @NavigationProperty(name="complianceManagementPartners")
    @JsonIgnore
    public ComplianceManagementPartnerCollectionRequest getComplianceManagementPartners() {
        return new ComplianceManagementPartnerCollectionRequest(
                        contextPath.addSegment("complianceManagementPartners"));
    }

    /**
     * <i>“The device management intents”</i>
     * 
     * @return navigational property intents
     */
    @NavigationProperty(name="intents")
    @JsonIgnore
    public DeviceManagementIntentCollectionRequest getIntents() {
        return new DeviceManagementIntentCollectionRequest(
                        contextPath.addSegment("intents"));
    }

    /**
     * <i>“The device management intent setting definitions”</i>
     * 
     * @return navigational property settingDefinitions
     */
    @NavigationProperty(name="settingDefinitions")
    @JsonIgnore
    public DeviceManagementSettingDefinitionCollectionRequest getSettingDefinitions() {
        return new DeviceManagementSettingDefinitionCollectionRequest(
                        contextPath.addSegment("settingDefinitions"));
    }

    /**
     * <i>“The available templates”</i>
     * 
     * @return navigational property templates
     */
    @NavigationProperty(name="templates")
    @JsonIgnore
    public DeviceManagementTemplateCollectionRequest getTemplates() {
        return new DeviceManagementTemplateCollectionRequest(
                        contextPath.addSegment("templates"));
    }

    /**
     * <i>“The available categories”</i>
     * 
     * @return navigational property categories
     */
    @NavigationProperty(name="categories")
    @JsonIgnore
    public DeviceManagementSettingCategoryCollectionRequest getCategories() {
        return new DeviceManagementSettingCategoryCollectionRequest(
                        contextPath.addSegment("categories"));
    }

    /**
     * <i>“The list of device remote action audits with the tenant.”</i>
     * 
     * @return navigational property remoteActionAudits
     */
    @NavigationProperty(name="remoteActionAudits")
    @JsonIgnore
    public RemoteActionAuditCollectionRequest getRemoteActionAudits() {
        return new RemoteActionAuditCollectionRequest(
                        contextPath.addSegment("remoteActionAudits"));
    }

    /**
     * <i>“Apple push notification certificate.”</i>
     * 
     * @return navigational property applePushNotificationCertificate
     */
    @NavigationProperty(name="applePushNotificationCertificate")
    @JsonIgnore
    public ApplePushNotificationCertificateRequest getApplePushNotificationCertificate() {
        return new ApplePushNotificationCertificateRequest(contextPath.addSegment("applePushNotificationCertificate"));
    }

    /**
     * <i>“The list of device management scripts associated with the tenant.”</i>
     * 
     * @return navigational property deviceManagementScripts
     */
    @NavigationProperty(name="deviceManagementScripts")
    @JsonIgnore
    public DeviceManagementScriptCollectionRequest getDeviceManagementScripts() {
        return new DeviceManagementScriptCollectionRequest(
                        contextPath.addSegment("deviceManagementScripts"));
    }

    /**
     * <i>“The list of device shell scripts associated with the tenant.”</i>
     * 
     * @return navigational property deviceShellScripts
     */
    @NavigationProperty(name="deviceShellScripts")
    @JsonIgnore
    public DeviceShellScriptCollectionRequest getDeviceShellScripts() {
        return new DeviceShellScriptCollectionRequest(
                        contextPath.addSegment("deviceShellScripts"));
    }

    /**
     * <i>“The list of device health scripts associated with the tenant.”</i>
     * 
     * @return navigational property deviceHealthScripts
     */
    @NavigationProperty(name="deviceHealthScripts")
    @JsonIgnore
    public DeviceHealthScriptCollectionRequest getDeviceHealthScripts() {
        return new DeviceHealthScriptCollectionRequest(
                        contextPath.addSegment("deviceHealthScripts"));
    }

    /**
     * <i>“The list of device compliance scripts associated with the tenant.”</i>
     * 
     * @return navigational property deviceComplianceScripts
     */
    @NavigationProperty(name="deviceComplianceScripts")
    @JsonIgnore
    public DeviceComplianceScriptCollectionRequest getDeviceComplianceScripts() {
        return new DeviceComplianceScriptCollectionRequest(
                        contextPath.addSegment("deviceComplianceScripts"));
    }

    /**
     * <i>“Device overview”</i>
     * 
     * @return navigational property managedDeviceOverview
     */
    @NavigationProperty(name="managedDeviceOverview")
    @JsonIgnore
    public ManagedDeviceOverviewRequest getManagedDeviceOverview() {
        return new ManagedDeviceOverviewRequest(contextPath.addSegment("managedDeviceOverview"));
    }

    /**
     * <i>“The list of detected apps associated with a device.”</i>
     * 
     * @return navigational property detectedApps
     */
    @NavigationProperty(name="detectedApps")
    @JsonIgnore
    public DetectedAppCollectionRequest getDetectedApps() {
        return new DetectedAppCollectionRequest(
                        contextPath.addSegment("detectedApps"));
    }

    /**
     * <i>“The list of managed devices.”</i>
     * 
     * @return navigational property managedDevices
     */
    @NavigationProperty(name="managedDevices")
    @JsonIgnore
    public ManagedDeviceCollectionRequest getManagedDevices() {
        return new ManagedDeviceCollectionRequest(
                        contextPath.addSegment("managedDevices"));
    }

    /**
     * <i>“The list of affected malware in the tenant.”</i>
     * 
     * @return navigational property windowsMalwareInformation
     */
    @NavigationProperty(name="windowsMalwareInformation")
    @JsonIgnore
    public WindowsMalwareInformationCollectionRequest getWindowsMalwareInformation() {
        return new WindowsMalwareInformationCollectionRequest(
                        contextPath.addSegment("windowsMalwareInformation"));
    }

    /**
     * <i>“Data sharing consents.”</i>
     * 
     * @return navigational property dataSharingConsents
     */
    @NavigationProperty(name="dataSharingConsents")
    @JsonIgnore
    public DataSharingConsentCollectionRequest getDataSharingConsents() {
        return new DataSharingConsentCollectionRequest(
                        contextPath.addSegment("dataSharingConsents"));
    }

    /**
     * <i>“The collection property of MobileAppTroubleshootingEvent.”</i>
     * 
     * @return navigational property mobileAppTroubleshootingEvents
     */
    @NavigationProperty(name="mobileAppTroubleshootingEvents")
    @JsonIgnore
    public MobileAppTroubleshootingEventCollectionRequest getMobileAppTroubleshootingEvents() {
        return new MobileAppTroubleshootingEventCollectionRequest(
                        contextPath.addSegment("mobileAppTroubleshootingEvents"));
    }

    /**
     * <i>“User experience analytics overview”</i>
     * 
     * @return navigational property userExperienceAnalyticsOverview
     */
    @NavigationProperty(name="userExperienceAnalyticsOverview")
    @JsonIgnore
    public UserExperienceAnalyticsOverviewRequest getUserExperienceAnalyticsOverview() {
        return new UserExperienceAnalyticsOverviewRequest(contextPath.addSegment("userExperienceAnalyticsOverview"));
    }

    /**
     * <i>“User experience analytics baselines”</i>
     * 
     * @return navigational property userExperienceAnalyticsBaselines
     */
    @NavigationProperty(name="userExperienceAnalyticsBaselines")
    @JsonIgnore
    public UserExperienceAnalyticsBaselineCollectionRequest getUserExperienceAnalyticsBaselines() {
        return new UserExperienceAnalyticsBaselineCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsBaselines"));
    }

    /**
     * <i>“User experience analytics categories”</i>
     * 
     * @return navigational property userExperienceAnalyticsCategories
     */
    @NavigationProperty(name="userExperienceAnalyticsCategories")
    @JsonIgnore
    public UserExperienceAnalyticsCategoryCollectionRequest getUserExperienceAnalyticsCategories() {
        return new UserExperienceAnalyticsCategoryCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsCategories"));
    }

    /**
     * <i>“User experience analytics device performance”</i>
     * 
     * @return navigational property userExperienceAnalyticsDevicePerformance
     */
    @NavigationProperty(name="userExperienceAnalyticsDevicePerformance")
    @JsonIgnore
    public UserExperienceAnalyticsDevicePerformanceCollectionRequest getUserExperienceAnalyticsDevicePerformance() {
        return new UserExperienceAnalyticsDevicePerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDevicePerformance"));
    }

    /**
     * <i>“User experience analytics regression summary”</i>
     * 
     * @return navigational property userExperienceAnalyticsRegressionSummary
     */
    @NavigationProperty(name="userExperienceAnalyticsRegressionSummary")
    @JsonIgnore
    public UserExperienceAnalyticsRegressionSummaryRequest getUserExperienceAnalyticsRegressionSummary() {
        return new UserExperienceAnalyticsRegressionSummaryRequest(contextPath.addSegment("userExperienceAnalyticsRegressionSummary"));
    }

    /**
     * <i>“User experience analytics device Startup History”</i>
     * 
     * @return navigational property userExperienceAnalyticsDeviceStartupHistory
     */
    @NavigationProperty(name="userExperienceAnalyticsDeviceStartupHistory")
    @JsonIgnore
    public UserExperienceAnalyticsDeviceStartupHistoryCollectionRequest getUserExperienceAnalyticsDeviceStartupHistory() {
        return new UserExperienceAnalyticsDeviceStartupHistoryCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDeviceStartupHistory"));
    }

    /**
     * <i>“User experience analytics device Startup Processes”</i>
     * 
     * @return navigational property userExperienceAnalyticsDeviceStartupProcesses
     */
    @NavigationProperty(name="userExperienceAnalyticsDeviceStartupProcesses")
    @JsonIgnore
    public UserExperienceAnalyticsDeviceStartupProcessCollectionRequest getUserExperienceAnalyticsDeviceStartupProcesses() {
        return new UserExperienceAnalyticsDeviceStartupProcessCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDeviceStartupProcesses"));
    }

    /**
     * <i>“User experience analytics device Startup Process Performance”</i>
     * 
     * @return navigational property userExperienceAnalyticsDeviceStartupProcessPerformance
     */
    @NavigationProperty(name="userExperienceAnalyticsDeviceStartupProcessPerformance")
    @JsonIgnore
    public UserExperienceAnalyticsDeviceStartupProcessPerformanceCollectionRequest getUserExperienceAnalyticsDeviceStartupProcessPerformance() {
        return new UserExperienceAnalyticsDeviceStartupProcessPerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDeviceStartupProcessPerformance"));
    }

    /**
     * <i>“User experience analytics device Startup Score History”</i>
     * 
     * @return navigational property userExperienceAnalyticsScoreHistory
     */
    @NavigationProperty(name="userExperienceAnalyticsScoreHistory")
    @JsonIgnore
    public UserExperienceAnalyticsScoreHistoryCollectionRequest getUserExperienceAnalyticsScoreHistory() {
        return new UserExperienceAnalyticsScoreHistoryCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsScoreHistory"));
    }

    /**
     * <i>“The list of co-managed devices report”</i>
     * 
     * @return navigational property comanagedDevices
     */
    @NavigationProperty(name="comanagedDevices")
    @JsonIgnore
    public ManagedDeviceCollectionRequest getComanagedDevices() {
        return new ManagedDeviceCollectionRequest(
                        contextPath.addSegment("comanagedDevices"));
    }

    /**
     * <i>“The list of co-management eligible devices report”</i>
     * 
     * @return navigational property comanagementEligibleDevices
     */
    @NavigationProperty(name="comanagementEligibleDevices")
    @JsonIgnore
    public ComanagementEligibleDeviceCollectionRequest getComanagementEligibleDevices() {
        return new ComanagementEligibleDeviceCollectionRequest(
                        contextPath.addSegment("comanagementEligibleDevices"));
    }

    /**
     * <i>“Collection of Derived credential settings associated with account.”</i>
     * 
     * @return navigational property derivedCredentials
     */
    @NavigationProperty(name="derivedCredentials")
    @JsonIgnore
    public DeviceManagementDerivedCredentialSettingsCollectionRequest getDerivedCredentials() {
        return new DeviceManagementDerivedCredentialSettingsCollectionRequest(
                        contextPath.addSegment("derivedCredentials"));
    }

    /**
     * <i>“The Windows autopilot account settings.”</i>
     * 
     * @return navigational property windowsAutopilotSettings
     */
    @NavigationProperty(name="windowsAutopilotSettings")
    @JsonIgnore
    public WindowsAutopilotSettingsRequest getWindowsAutopilotSettings() {
        return new WindowsAutopilotSettingsRequest(contextPath.addSegment("windowsAutopilotSettings"));
    }

    /**
     * <i>“The Windows autopilot device identities contained collection.”</i>
     * 
     * @return navigational property windowsAutopilotDeviceIdentities
     */
    @NavigationProperty(name="windowsAutopilotDeviceIdentities")
    @JsonIgnore
    public WindowsAutopilotDeviceIdentityCollectionRequest getWindowsAutopilotDeviceIdentities() {
        return new WindowsAutopilotDeviceIdentityCollectionRequest(
                        contextPath.addSegment("windowsAutopilotDeviceIdentities"));
    }

    /**
     * <i>“Windows auto pilot deployment profiles”</i>
     * 
     * @return navigational property windowsAutopilotDeploymentProfiles
     */
    @NavigationProperty(name="windowsAutopilotDeploymentProfiles")
    @JsonIgnore
    public WindowsAutopilotDeploymentProfileCollectionRequest getWindowsAutopilotDeploymentProfiles() {
        return new WindowsAutopilotDeploymentProfileCollectionRequest(
                        contextPath.addSegment("windowsAutopilotDeploymentProfiles"));
    }

    /**
     * <i>“The imported device identities.”</i>
     * 
     * @return navigational property importedDeviceIdentities
     */
    @NavigationProperty(name="importedDeviceIdentities")
    @JsonIgnore
    public ImportedDeviceIdentityCollectionRequest getImportedDeviceIdentities() {
        return new ImportedDeviceIdentityCollectionRequest(
                        contextPath.addSegment("importedDeviceIdentities"));
    }

    /**
     * <i>“This collections of multiple DEP tokens per-tenant.”</i>
     * 
     * @return navigational property depOnboardingSettings
     */
    @NavigationProperty(name="depOnboardingSettings")
    @JsonIgnore
    public DepOnboardingSettingCollectionRequest getDepOnboardingSettings() {
        return new DepOnboardingSettingCollectionRequest(
                        contextPath.addSegment("depOnboardingSettings"));
    }

    /**
     * <i>“Collection of imported Windows autopilot devices.”</i>
     * 
     * @return navigational property importedWindowsAutopilotDeviceIdentities
     */
    @NavigationProperty(name="importedWindowsAutopilotDeviceIdentities")
    @JsonIgnore
    public ImportedWindowsAutopilotDeviceIdentityCollectionRequest getImportedWindowsAutopilotDeviceIdentities() {
        return new ImportedWindowsAutopilotDeviceIdentityCollectionRequest(
                        contextPath.addSegment("importedWindowsAutopilotDeviceIdentities"));
    }

    /**
     * <i>“Apple user initiated enrollment profiles”</i>
     * 
     * @return navigational property appleUserInitiatedEnrollmentProfiles
     */
    @NavigationProperty(name="appleUserInitiatedEnrollmentProfiles")
    @JsonIgnore
    public AppleUserInitiatedEnrollmentProfileCollectionRequest getAppleUserInitiatedEnrollmentProfiles() {
        return new AppleUserInitiatedEnrollmentProfileCollectionRequest(
                        contextPath.addSegment("appleUserInitiatedEnrollmentProfiles"));
    }

    /**
     * <i>“The management conditions associated with device management of the company.”</i>
     * 
     * @return navigational property managementConditions
     */
    @NavigationProperty(name="managementConditions")
    @JsonIgnore
    public ManagementConditionCollectionRequest getManagementConditions() {
        return new ManagementConditionCollectionRequest(
                        contextPath.addSegment("managementConditions"));
    }

    /**
     * <i>“The management condition statements associated with device management of the
     * company.”</i>
     * 
     * @return navigational property managementConditionStatements
     */
    @NavigationProperty(name="managementConditionStatements")
    @JsonIgnore
    public ManagementConditionStatementCollectionRequest getManagementConditionStatements() {
        return new ManagementConditionStatementCollectionRequest(
                        contextPath.addSegment("managementConditionStatements"));
    }

    /**
     * <i>“A list of Group Policy Object files uploaded.”</i>
     * 
     * @return navigational property groupPolicyObjectFiles
     */
    @NavigationProperty(name="groupPolicyObjectFiles")
    @JsonIgnore
    public GroupPolicyObjectFileCollectionRequest getGroupPolicyObjectFiles() {
        return new GroupPolicyObjectFileCollectionRequest(
                        contextPath.addSegment("groupPolicyObjectFiles"));
    }

    /**
     * <i>“A list of Group Policy migration reports.”</i>
     * 
     * @return navigational property groupPolicyMigrationReports
     */
    @NavigationProperty(name="groupPolicyMigrationReports")
    @JsonIgnore
    public GroupPolicyMigrationReportCollectionRequest getGroupPolicyMigrationReports() {
        return new GroupPolicyMigrationReportCollectionRequest(
                        contextPath.addSegment("groupPolicyMigrationReports"));
    }

    /**
     * <i>“The group policy configurations created by this account.”</i>
     * 
     * @return navigational property groupPolicyConfigurations
     */
    @NavigationProperty(name="groupPolicyConfigurations")
    @JsonIgnore
    public GroupPolicyConfigurationCollectionRequest getGroupPolicyConfigurations() {
        return new GroupPolicyConfigurationCollectionRequest(
                        contextPath.addSegment("groupPolicyConfigurations"));
    }

    /**
     * <i>“The available group policy categories for this account.”</i>
     * 
     * @return navigational property groupPolicyCategories
     */
    @NavigationProperty(name="groupPolicyCategories")
    @JsonIgnore
    public GroupPolicyCategoryCollectionRequest getGroupPolicyCategories() {
        return new GroupPolicyCategoryCollectionRequest(
                        contextPath.addSegment("groupPolicyCategories"));
    }

    /**
     * <i>“The available group policy definitions for this account.”</i>
     * 
     * @return navigational property groupPolicyDefinitions
     */
    @NavigationProperty(name="groupPolicyDefinitions")
    @JsonIgnore
    public GroupPolicyDefinitionCollectionRequest getGroupPolicyDefinitions() {
        return new GroupPolicyDefinitionCollectionRequest(
                        contextPath.addSegment("groupPolicyDefinitions"));
    }

    /**
     * <i>“The available group policy definition files for this account.”</i>
     * 
     * @return navigational property groupPolicyDefinitionFiles
     */
    @NavigationProperty(name="groupPolicyDefinitionFiles")
    @JsonIgnore
    public GroupPolicyDefinitionFileCollectionRequest getGroupPolicyDefinitionFiles() {
        return new GroupPolicyDefinitionFileCollectionRequest(
                        contextPath.addSegment("groupPolicyDefinitionFiles"));
    }

    /**
     * <i>“The available group policy uploaded definition files for this account.”</i>
     * 
     * @return navigational property groupPolicyUploadedDefinitionFiles
     */
    @NavigationProperty(name="groupPolicyUploadedDefinitionFiles")
    @JsonIgnore
    public GroupPolicyUploadedDefinitionFileCollectionRequest getGroupPolicyUploadedDefinitionFiles() {
        return new GroupPolicyUploadedDefinitionFileCollectionRequest(
                        contextPath.addSegment("groupPolicyUploadedDefinitionFiles"));
    }

    /**
     * <i>“The Notification Message Templates.”</i>
     * 
     * @return navigational property notificationMessageTemplates
     */
    @NavigationProperty(name="notificationMessageTemplates")
    @JsonIgnore
    public NotificationMessageTemplateCollectionRequest getNotificationMessageTemplates() {
        return new NotificationMessageTemplateCollectionRequest(
                        contextPath.addSegment("notificationMessageTemplates"));
    }

    /**
     * <i>“A list of connector objects.”</i>
     * 
     * @return navigational property domainJoinConnectors
     */
    @NavigationProperty(name="domainJoinConnectors")
    @JsonIgnore
    public DeviceManagementDomainJoinConnectorCollectionRequest getDomainJoinConnectors() {
        return new DeviceManagementDomainJoinConnectorCollectionRequest(
                        contextPath.addSegment("domainJoinConnectors"));
    }

    /**
     * <i>“The Role Definitions.”</i>
     * 
     * @return navigational property roleDefinitions
     */
    @NavigationProperty(name="roleDefinitions")
    @JsonIgnore
    public RoleDefinitionCollectionRequest getRoleDefinitions() {
        return new RoleDefinitionCollectionRequest(
                        contextPath.addSegment("roleDefinitions"));
    }

    /**
     * <i>“The Role Assignments.”</i>
     * 
     * @return navigational property roleAssignments
     */
    @NavigationProperty(name="roleAssignments")
    @JsonIgnore
    public DeviceAndAppManagementRoleAssignmentCollectionRequest getRoleAssignments() {
        return new DeviceAndAppManagementRoleAssignmentCollectionRequest(
                        contextPath.addSegment("roleAssignments"));
    }

    /**
     * <i>“The Role Scope Tags.”</i>
     * 
     * @return navigational property roleScopeTags
     */
    @NavigationProperty(name="roleScopeTags")
    @JsonIgnore
    public RoleScopeTagCollectionRequest getRoleScopeTags() {
        return new RoleScopeTagCollectionRequest(
                        contextPath.addSegment("roleScopeTags"));
    }

    /**
     * <i>“The Resource Operations.”</i>
     * 
     * @return navigational property resourceOperations
     */
    @NavigationProperty(name="resourceOperations")
    @JsonIgnore
    public ResourceOperationCollectionRequest getResourceOperations() {
        return new ResourceOperationCollectionRequest(
                        contextPath.addSegment("resourceOperations"));
    }

    /**
     * <i>“The remote assist partners.”</i>
     * 
     * @return navigational property remoteAssistancePartners
     */
    @NavigationProperty(name="remoteAssistancePartners")
    @JsonIgnore
    public RemoteAssistancePartnerCollectionRequest getRemoteAssistancePartners() {
        return new RemoteAssistancePartnerCollectionRequest(
                        contextPath.addSegment("remoteAssistancePartners"));
    }

    /**
     * <i>“Reports singleton”</i>
     * 
     * @return navigational property reports
     */
    @NavigationProperty(name="reports")
    @JsonIgnore
    public DeviceManagementReportsRequest getReports() {
        return new DeviceManagementReportsRequest(contextPath.addSegment("reports"));
    }

    /**
     * <i>“The telecom expense management partners.”</i>
     * 
     * @return navigational property telecomExpenseManagementPartners
     */
    @NavigationProperty(name="telecomExpenseManagementPartners")
    @JsonIgnore
    public TelecomExpenseManagementPartnerCollectionRequest getTelecomExpenseManagementPartners() {
        return new TelecomExpenseManagementPartnerCollectionRequest(
                        contextPath.addSegment("telecomExpenseManagementPartners"));
    }

    /**
     * <i>“The embedded SIM activation code pools created by this account.”</i>
     * 
     * @return navigational property embeddedSIMActivationCodePools
     */
    @NavigationProperty(name="embeddedSIMActivationCodePools")
    @JsonIgnore
    public EmbeddedSIMActivationCodePoolCollectionRequest getEmbeddedSIMActivationCodePools() {
        return new EmbeddedSIMActivationCodePoolCollectionRequest(
                        contextPath.addSegment("embeddedSIMActivationCodePools"));
    }

    /**
     * <i>“The list of troubleshooting events for the tenant.”</i>
     * 
     * @return navigational property troubleshootingEvents
     */
    @NavigationProperty(name="troubleshootingEvents")
    @JsonIgnore
    public DeviceManagementTroubleshootingEventCollectionRequest getTroubleshootingEvents() {
        return new DeviceManagementTroubleshootingEventCollectionRequest(
                        contextPath.addSegment("troubleshootingEvents"));
    }

    /**
     * <i>“The list of autopilot events for the tenant.”</i>
     * 
     * @return navigational property autopilotEvents
     */
    @NavigationProperty(name="autopilotEvents")
    @JsonIgnore
    public DeviceManagementAutopilotEventCollectionRequest getAutopilotEvents() {
        return new DeviceManagementAutopilotEventCollectionRequest(
                        contextPath.addSegment("autopilotEvents"));
    }

    /**
     * <i>“A collection of windows feature update profiles”</i>
     * 
     * @return navigational property windowsFeatureUpdateProfiles
     */
    @NavigationProperty(name="windowsFeatureUpdateProfiles")
    @JsonIgnore
    public WindowsFeatureUpdateProfileCollectionRequest getWindowsFeatureUpdateProfiles() {
        return new WindowsFeatureUpdateProfileCollectionRequest(
                        contextPath.addSegment("windowsFeatureUpdateProfiles"));
    }

    /**
     * <i>“The windows information protection app learning summaries.”</i>
     * 
     * @return navigational property windowsInformationProtectionAppLearningSummaries
     */
    @NavigationProperty(name="windowsInformationProtectionAppLearningSummaries")
    @JsonIgnore
    public WindowsInformationProtectionAppLearningSummaryCollectionRequest getWindowsInformationProtectionAppLearningSummaries() {
        return new WindowsInformationProtectionAppLearningSummaryCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionAppLearningSummaries"));
    }

    /**
     * <i>“The windows information protection network learning summaries.”</i>
     * 
     * @return navigational property windowsInformationProtectionNetworkLearningSummaries
     */
    @NavigationProperty(name="windowsInformationProtectionNetworkLearningSummaries")
    @JsonIgnore
    public WindowsInformationProtectionNetworkLearningSummaryCollectionRequest getWindowsInformationProtectionNetworkLearningSummaries() {
        return new WindowsInformationProtectionNetworkLearningSummaryCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionNetworkLearningSummaries"));
    }

    /**
     * <i>“Intune branding profiles targeted to AAD groups”</i>
     * 
     * @return navigational property intuneBrandingProfiles
     */
    @NavigationProperty(name="intuneBrandingProfiles")
    @JsonIgnore
    public IntuneBrandingProfileCollectionRequest getIntuneBrandingProfiles() {
        return new IntuneBrandingProfileCollectionRequest(
                        contextPath.addSegment("intuneBrandingProfiles"));
    }

    /**
     * <i>“Collection of PFX certificates associated with a user.”</i>
     * 
     * @return navigational property userPfxCertificates
     */
    @NavigationProperty(name="userPfxCertificates")
    @JsonIgnore
    public UserPFXCertificateCollectionRequest getUserPfxCertificates() {
        return new UserPFXCertificateCollectionRequest(
                        contextPath.addSegment("userPfxCertificates"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagement patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagement put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagement _copy() {
        DeviceManagement _x = new DeviceManagement();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.settings = settings;
        _x.maximumDepTokens = maximumDepTokens;
        _x.intuneAccountId = intuneAccountId;
        _x.lastReportAggregationDateTime = lastReportAggregationDateTime;
        _x.deviceComplianceReportSummarizationDateTime = deviceComplianceReportSummarizationDateTime;
        _x.legacyPcManangementEnabled = legacyPcManangementEnabled;
        _x.unlicensedAdminstratorsEnabled = unlicensedAdminstratorsEnabled;
        _x.intuneBrand = intuneBrand;
        _x.subscriptionState = subscriptionState;
        _x.subscriptions = subscriptions;
        _x.managedDeviceCleanupSettings = managedDeviceCleanupSettings;
        _x.adminConsent = adminConsent;
        _x.deviceProtectionOverview = deviceProtectionOverview;
        _x.windowsMalwareOverview = windowsMalwareOverview;
        _x.accountMoveCompletionDateTime = accountMoveCompletionDateTime;
        _x.userExperienceAnalyticsSettings = userExperienceAnalyticsSettings;
        return _x;
    }

    @Action(name = "enableUnlicensedAdminstrators")
    @JsonIgnore
    public ActionRequestNoReturn enableUnlicensedAdminstrators() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enableUnlicensedAdminstrators"), _parameters);
    }

    @Action(name = "enableLegacyPcManagement")
    @JsonIgnore
    public ActionRequestNoReturn enableLegacyPcManagement() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enableLegacyPcManagement"), _parameters);
    }

    @Action(name = "enableAndroidDeviceAdministratorEnrollment")
    @JsonIgnore
    public ActionRequestNoReturn enableAndroidDeviceAdministratorEnrollment() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enableAndroidDeviceAdministratorEnrollment"), _parameters);
    }

    @Action(name = "sendCustomNotificationToCompanyPortal")
    @JsonIgnore
    public ActionRequestNoReturn sendCustomNotificationToCompanyPortal(String notificationTitle, String notificationBody, List<String> groupsToNotify) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("notificationTitle", "Edm.String", Checks.checkIsAscii(notificationTitle))
            .put("notificationBody", "Edm.String", Checks.checkIsAscii(notificationBody))
            .put("groupsToNotify", "Collection(Edm.String)", Checks.checkIsAscii(groupsToNotify))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendCustomNotificationToCompanyPortal"), _parameters);
    }

    @Function(name = "verifyWindowsEnrollmentAutoDiscovery")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> verifyWindowsEnrollmentAutoDiscovery(String domainName) {
        Preconditions.checkNotNull(domainName, "domainName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("domainName", "Edm.String", Checks.checkIsAscii(domainName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.verifyWindowsEnrollmentAutoDiscovery"), Boolean.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Function(name = "getComanagedDevicesSummary")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ComanagedDevicesSummary> getComanagedDevicesSummary() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<ComanagedDevicesSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getComanagedDevicesSummary"), ComanagedDevicesSummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getComanagementEligibleDevicesSummary")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ComanagementEligibleDevicesSummary> getComanagementEligibleDevicesSummary() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<ComanagementEligibleDevicesSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getComanagementEligibleDevicesSummary"), ComanagementEligibleDevicesSummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getEffectivePermissions")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getEffectivePermissions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEffectivePermissions"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Function(name = "getEffectivePermissions")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RolePermission> getEffectivePermissions_Function(String scope) {
        Preconditions.checkNotNull(scope, "scope cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("scope", "Edm.String", Checks.checkIsAscii(scope))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEffectivePermissions"), RolePermission.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getRoleScopeTagsByResource")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RoleScopeTag> getRoleScopeTagsByResource(String resource) {
        Preconditions.checkNotNull(resource, "resource cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("resource", "Edm.String", Checks.checkIsAscii(resource))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRoleScopeTagsByResource"), RoleScopeTag.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getRoleScopeTagsByIds")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RoleScopeTag> getRoleScopeTagsByIds(List<String> ids) {
        Preconditions.checkNotNull(ids, "ids cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ids", "Collection(Edm.String)", Checks.checkIsAscii(ids))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRoleScopeTagsByIds"), RoleScopeTag.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getAssignedRoleDetails")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementAssignedRoleDetails> getAssignedRoleDetails() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementAssignedRoleDetails>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAssignedRoleDetails"), DeviceAndAppManagementAssignedRoleDetails.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "scopedForResource")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> scopedForResource(String resource) {
        Preconditions.checkNotNull(resource, "resource cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("resource", "Edm.String", Checks.checkIsAscii(resource))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.scopedForResource"), Boolean.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagement[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append(", ");
        b.append("maximumDepTokens=");
        b.append(this.maximumDepTokens);
        b.append(", ");
        b.append("intuneAccountId=");
        b.append(this.intuneAccountId);
        b.append(", ");
        b.append("lastReportAggregationDateTime=");
        b.append(this.lastReportAggregationDateTime);
        b.append(", ");
        b.append("deviceComplianceReportSummarizationDateTime=");
        b.append(this.deviceComplianceReportSummarizationDateTime);
        b.append(", ");
        b.append("legacyPcManangementEnabled=");
        b.append(this.legacyPcManangementEnabled);
        b.append(", ");
        b.append("unlicensedAdminstratorsEnabled=");
        b.append(this.unlicensedAdminstratorsEnabled);
        b.append(", ");
        b.append("intuneBrand=");
        b.append(this.intuneBrand);
        b.append(", ");
        b.append("subscriptionState=");
        b.append(this.subscriptionState);
        b.append(", ");
        b.append("subscriptions=");
        b.append(this.subscriptions);
        b.append(", ");
        b.append("managedDeviceCleanupSettings=");
        b.append(this.managedDeviceCleanupSettings);
        b.append(", ");
        b.append("adminConsent=");
        b.append(this.adminConsent);
        b.append(", ");
        b.append("deviceProtectionOverview=");
        b.append(this.deviceProtectionOverview);
        b.append(", ");
        b.append("windowsMalwareOverview=");
        b.append(this.windowsMalwareOverview);
        b.append(", ");
        b.append("accountMoveCompletionDateTime=");
        b.append(this.accountMoveCompletionDateTime);
        b.append(", ");
        b.append("userExperienceAnalyticsSettings=");
        b.append(this.userExperienceAnalyticsSettings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
