package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.ManagedDeviceRequest;
import odata.msgraph.client.beta.enums.RemediationState;
import odata.msgraph.client.beta.enums.RunState;


/**
 * <i>“Contains properties for device run state of the device health script.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "detectionState", 
    "lastStateUpdateDateTime", 
    "expectedStateUpdateDateTime", 
    "lastSyncDateTime", 
    "preRemediationDetectionScriptOutput", 
    "preRemediationDetectionScriptError", 
    "remediationScriptError", 
    "postRemediationDetectionScriptOutput", 
    "postRemediationDetectionScriptError", 
    "remediationState"})
@JsonInclude(Include.NON_NULL)
public class DeviceHealthScriptDeviceState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceHealthScriptDeviceState";
    }

    @JsonProperty("detectionState")
    protected RunState detectionState;

    @JsonProperty("lastStateUpdateDateTime")
    protected OffsetDateTime lastStateUpdateDateTime;

    @JsonProperty("expectedStateUpdateDateTime")
    protected OffsetDateTime expectedStateUpdateDateTime;

    @JsonProperty("lastSyncDateTime")
    protected OffsetDateTime lastSyncDateTime;

    @JsonProperty("preRemediationDetectionScriptOutput")
    protected String preRemediationDetectionScriptOutput;

    @JsonProperty("preRemediationDetectionScriptError")
    protected String preRemediationDetectionScriptError;

    @JsonProperty("remediationScriptError")
    protected String remediationScriptError;

    @JsonProperty("postRemediationDetectionScriptOutput")
    protected String postRemediationDetectionScriptOutput;

    @JsonProperty("postRemediationDetectionScriptError")
    protected String postRemediationDetectionScriptError;

    @JsonProperty("remediationState")
    protected RemediationState remediationState;

    protected DeviceHealthScriptDeviceState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceHealthScriptDeviceState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private RunState detectionState;
        private OffsetDateTime lastStateUpdateDateTime;
        private OffsetDateTime expectedStateUpdateDateTime;
        private OffsetDateTime lastSyncDateTime;
        private String preRemediationDetectionScriptOutput;
        private String preRemediationDetectionScriptError;
        private String remediationScriptError;
        private String postRemediationDetectionScriptOutput;
        private String postRemediationDetectionScriptError;
        private RemediationState remediationState;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Detection state from the lastest device health script execution”</i>
         * 
         * @param detectionState
         *            value of {@code detectionState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionState(RunState detectionState) {
            this.detectionState = detectionState;
            this.changedFields = changedFields.add("detectionState");
            return this;
        }

        /**
         * <i>“The last timestamp of when the device health script executed”</i>
         * 
         * @param lastStateUpdateDateTime
         *            value of {@code lastStateUpdateDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastStateUpdateDateTime(OffsetDateTime lastStateUpdateDateTime) {
            this.lastStateUpdateDateTime = lastStateUpdateDateTime;
            this.changedFields = changedFields.add("lastStateUpdateDateTime");
            return this;
        }

        /**
         * <i>“The next timestamp of when the device health script is expected to execute”</i>
         * 
         * @param expectedStateUpdateDateTime
         *            value of {@code expectedStateUpdateDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder expectedStateUpdateDateTime(OffsetDateTime expectedStateUpdateDateTime) {
            this.expectedStateUpdateDateTime = expectedStateUpdateDateTime;
            this.changedFields = changedFields.add("expectedStateUpdateDateTime");
            return this;
        }

        /**
         * <i>“The last time that Intune Managment Extension synced with Intune”</i>
         * 
         * @param lastSyncDateTime
         *            value of {@code lastSyncDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastSyncDateTime(OffsetDateTime lastSyncDateTime) {
            this.lastSyncDateTime = lastSyncDateTime;
            this.changedFields = changedFields.add("lastSyncDateTime");
            return this;
        }

        /**
         * <i>“Output of the detection script before remediation”</i>
         * 
         * @param preRemediationDetectionScriptOutput
         *            value of {@code preRemediationDetectionScriptOutput} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder preRemediationDetectionScriptOutput(String preRemediationDetectionScriptOutput) {
            this.preRemediationDetectionScriptOutput = preRemediationDetectionScriptOutput;
            this.changedFields = changedFields.add("preRemediationDetectionScriptOutput");
            return this;
        }

        /**
         * <i>“Error from the detection script before remediation”</i>
         * 
         * @param preRemediationDetectionScriptError
         *            value of {@code preRemediationDetectionScriptError} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder preRemediationDetectionScriptError(String preRemediationDetectionScriptError) {
            this.preRemediationDetectionScriptError = preRemediationDetectionScriptError;
            this.changedFields = changedFields.add("preRemediationDetectionScriptError");
            return this;
        }

        /**
         * <i>“Error output of the remediation script”</i>
         * 
         * @param remediationScriptError
         *            value of {@code remediationScriptError} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remediationScriptError(String remediationScriptError) {
            this.remediationScriptError = remediationScriptError;
            this.changedFields = changedFields.add("remediationScriptError");
            return this;
        }

        /**
         * <i>“Detection script output after remediation”</i>
         * 
         * @param postRemediationDetectionScriptOutput
         *            value of {@code postRemediationDetectionScriptOutput} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder postRemediationDetectionScriptOutput(String postRemediationDetectionScriptOutput) {
            this.postRemediationDetectionScriptOutput = postRemediationDetectionScriptOutput;
            this.changedFields = changedFields.add("postRemediationDetectionScriptOutput");
            return this;
        }

        /**
         * <i>“Error from the detection script after remediation”</i>
         * 
         * @param postRemediationDetectionScriptError
         *            value of {@code postRemediationDetectionScriptError} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder postRemediationDetectionScriptError(String postRemediationDetectionScriptError) {
            this.postRemediationDetectionScriptError = postRemediationDetectionScriptError;
            this.changedFields = changedFields.add("postRemediationDetectionScriptError");
            return this;
        }

        /**
         * <i>“Remediation state from the lastest device health script execution”</i>
         * 
         * @param remediationState
         *            value of {@code remediationState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remediationState(RemediationState remediationState) {
            this.remediationState = remediationState;
            this.changedFields = changedFields.add("remediationState");
            return this;
        }

        public DeviceHealthScriptDeviceState build() {
            DeviceHealthScriptDeviceState _x = new DeviceHealthScriptDeviceState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceHealthScriptDeviceState";
            _x.id = id;
            _x.detectionState = detectionState;
            _x.lastStateUpdateDateTime = lastStateUpdateDateTime;
            _x.expectedStateUpdateDateTime = expectedStateUpdateDateTime;
            _x.lastSyncDateTime = lastSyncDateTime;
            _x.preRemediationDetectionScriptOutput = preRemediationDetectionScriptOutput;
            _x.preRemediationDetectionScriptError = preRemediationDetectionScriptError;
            _x.remediationScriptError = remediationScriptError;
            _x.postRemediationDetectionScriptOutput = postRemediationDetectionScriptOutput;
            _x.postRemediationDetectionScriptError = postRemediationDetectionScriptError;
            _x.remediationState = remediationState;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Detection state from the lastest device health script execution”</i>
     * 
     * @return property detectionState
     */
    @Property(name="detectionState")
    @JsonIgnore
    public Optional<RunState> getDetectionState() {
        return Optional.ofNullable(detectionState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code detectionState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Detection state from the lastest device health script execution”</i>
     * 
     * @param detectionState
     *            new value of {@code detectionState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectionState} field changed
     */
    public DeviceHealthScriptDeviceState withDetectionState(RunState detectionState) {
        DeviceHealthScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("detectionState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptDeviceState");
        _x.detectionState = detectionState;
        return _x;
    }

    /**
     * <i>“The last timestamp of when the device health script executed”</i>
     * 
     * @return property lastStateUpdateDateTime
     */
    @Property(name="lastStateUpdateDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastStateUpdateDateTime() {
        return Optional.ofNullable(lastStateUpdateDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastStateUpdateDateTime} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The last timestamp of when the device health script executed”</i>
     * 
     * @param lastStateUpdateDateTime
     *            new value of {@code lastStateUpdateDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastStateUpdateDateTime} field changed
     */
    public DeviceHealthScriptDeviceState withLastStateUpdateDateTime(OffsetDateTime lastStateUpdateDateTime) {
        DeviceHealthScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("lastStateUpdateDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptDeviceState");
        _x.lastStateUpdateDateTime = lastStateUpdateDateTime;
        return _x;
    }

    /**
     * <i>“The next timestamp of when the device health script is expected to execute”</i>
     * 
     * @return property expectedStateUpdateDateTime
     */
    @Property(name="expectedStateUpdateDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpectedStateUpdateDateTime() {
        return Optional.ofNullable(expectedStateUpdateDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * expectedStateUpdateDateTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The next timestamp of when the device health script is expected to execute”</i>
     * 
     * @param expectedStateUpdateDateTime
     *            new value of {@code expectedStateUpdateDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code expectedStateUpdateDateTime} field changed
     */
    public DeviceHealthScriptDeviceState withExpectedStateUpdateDateTime(OffsetDateTime expectedStateUpdateDateTime) {
        DeviceHealthScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("expectedStateUpdateDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptDeviceState");
        _x.expectedStateUpdateDateTime = expectedStateUpdateDateTime;
        return _x;
    }

    /**
     * <i>“The last time that Intune Managment Extension synced with Intune”</i>
     * 
     * @return property lastSyncDateTime
     */
    @Property(name="lastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSyncDateTime() {
        return Optional.ofNullable(lastSyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastSyncDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The last time that Intune Managment Extension synced with Intune”</i>
     * 
     * @param lastSyncDateTime
     *            new value of {@code lastSyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastSyncDateTime} field changed
     */
    public DeviceHealthScriptDeviceState withLastSyncDateTime(OffsetDateTime lastSyncDateTime) {
        DeviceHealthScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("lastSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptDeviceState");
        _x.lastSyncDateTime = lastSyncDateTime;
        return _x;
    }

    /**
     * <i>“Output of the detection script before remediation”</i>
     * 
     * @return property preRemediationDetectionScriptOutput
     */
    @Property(name="preRemediationDetectionScriptOutput")
    @JsonIgnore
    public Optional<String> getPreRemediationDetectionScriptOutput() {
        return Optional.ofNullable(preRemediationDetectionScriptOutput);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * preRemediationDetectionScriptOutput} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Output of the detection script before remediation”</i>
     * 
     * @param preRemediationDetectionScriptOutput
     *            new value of {@code preRemediationDetectionScriptOutput} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code preRemediationDetectionScriptOutput} field changed
     */
    public DeviceHealthScriptDeviceState withPreRemediationDetectionScriptOutput(String preRemediationDetectionScriptOutput) {
        DeviceHealthScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("preRemediationDetectionScriptOutput");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptDeviceState");
        _x.preRemediationDetectionScriptOutput = preRemediationDetectionScriptOutput;
        return _x;
    }

    /**
     * <i>“Error from the detection script before remediation”</i>
     * 
     * @return property preRemediationDetectionScriptError
     */
    @Property(name="preRemediationDetectionScriptError")
    @JsonIgnore
    public Optional<String> getPreRemediationDetectionScriptError() {
        return Optional.ofNullable(preRemediationDetectionScriptError);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * preRemediationDetectionScriptError} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Error from the detection script before remediation”</i>
     * 
     * @param preRemediationDetectionScriptError
     *            new value of {@code preRemediationDetectionScriptError} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code preRemediationDetectionScriptError} field changed
     */
    public DeviceHealthScriptDeviceState withPreRemediationDetectionScriptError(String preRemediationDetectionScriptError) {
        DeviceHealthScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("preRemediationDetectionScriptError");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptDeviceState");
        _x.preRemediationDetectionScriptError = preRemediationDetectionScriptError;
        return _x;
    }

    /**
     * <i>“Error output of the remediation script”</i>
     * 
     * @return property remediationScriptError
     */
    @Property(name="remediationScriptError")
    @JsonIgnore
    public Optional<String> getRemediationScriptError() {
        return Optional.ofNullable(remediationScriptError);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * remediationScriptError} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Error output of the remediation script”</i>
     * 
     * @param remediationScriptError
     *            new value of {@code remediationScriptError} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remediationScriptError} field changed
     */
    public DeviceHealthScriptDeviceState withRemediationScriptError(String remediationScriptError) {
        DeviceHealthScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("remediationScriptError");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptDeviceState");
        _x.remediationScriptError = remediationScriptError;
        return _x;
    }

    /**
     * <i>“Detection script output after remediation”</i>
     * 
     * @return property postRemediationDetectionScriptOutput
     */
    @Property(name="postRemediationDetectionScriptOutput")
    @JsonIgnore
    public Optional<String> getPostRemediationDetectionScriptOutput() {
        return Optional.ofNullable(postRemediationDetectionScriptOutput);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * postRemediationDetectionScriptOutput} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Detection script output after remediation”</i>
     * 
     * @param postRemediationDetectionScriptOutput
     *            new value of {@code postRemediationDetectionScriptOutput} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code postRemediationDetectionScriptOutput} field changed
     */
    public DeviceHealthScriptDeviceState withPostRemediationDetectionScriptOutput(String postRemediationDetectionScriptOutput) {
        DeviceHealthScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("postRemediationDetectionScriptOutput");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptDeviceState");
        _x.postRemediationDetectionScriptOutput = postRemediationDetectionScriptOutput;
        return _x;
    }

    /**
     * <i>“Error from the detection script after remediation”</i>
     * 
     * @return property postRemediationDetectionScriptError
     */
    @Property(name="postRemediationDetectionScriptError")
    @JsonIgnore
    public Optional<String> getPostRemediationDetectionScriptError() {
        return Optional.ofNullable(postRemediationDetectionScriptError);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * postRemediationDetectionScriptError} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Error from the detection script after remediation”</i>
     * 
     * @param postRemediationDetectionScriptError
     *            new value of {@code postRemediationDetectionScriptError} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code postRemediationDetectionScriptError} field changed
     */
    public DeviceHealthScriptDeviceState withPostRemediationDetectionScriptError(String postRemediationDetectionScriptError) {
        DeviceHealthScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("postRemediationDetectionScriptError");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptDeviceState");
        _x.postRemediationDetectionScriptError = postRemediationDetectionScriptError;
        return _x;
    }

    /**
     * <i>“Remediation state from the lastest device health script execution”</i>
     * 
     * @return property remediationState
     */
    @Property(name="remediationState")
    @JsonIgnore
    public Optional<RemediationState> getRemediationState() {
        return Optional.ofNullable(remediationState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code remediationState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Remediation state from the lastest device health script execution”</i>
     * 
     * @param remediationState
     *            new value of {@code remediationState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remediationState} field changed
     */
    public DeviceHealthScriptDeviceState withRemediationState(RemediationState remediationState) {
        DeviceHealthScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("remediationState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptDeviceState");
        _x.remediationState = remediationState;
        return _x;
    }

    /**
     * <i>“The managed device on which the device health script executed”</i>
     * 
     * @return navigational property managedDevice
     */
    @NavigationProperty(name="managedDevice")
    @JsonIgnore
    public ManagedDeviceRequest getManagedDevice() {
        return new ManagedDeviceRequest(contextPath.addSegment("managedDevice"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceHealthScriptDeviceState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceHealthScriptDeviceState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceHealthScriptDeviceState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceHealthScriptDeviceState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceHealthScriptDeviceState _copy() {
        DeviceHealthScriptDeviceState _x = new DeviceHealthScriptDeviceState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.detectionState = detectionState;
        _x.lastStateUpdateDateTime = lastStateUpdateDateTime;
        _x.expectedStateUpdateDateTime = expectedStateUpdateDateTime;
        _x.lastSyncDateTime = lastSyncDateTime;
        _x.preRemediationDetectionScriptOutput = preRemediationDetectionScriptOutput;
        _x.preRemediationDetectionScriptError = preRemediationDetectionScriptError;
        _x.remediationScriptError = remediationScriptError;
        _x.postRemediationDetectionScriptOutput = postRemediationDetectionScriptOutput;
        _x.postRemediationDetectionScriptError = postRemediationDetectionScriptError;
        _x.remediationState = remediationState;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceHealthScriptDeviceState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("detectionState=");
        b.append(this.detectionState);
        b.append(", ");
        b.append("lastStateUpdateDateTime=");
        b.append(this.lastStateUpdateDateTime);
        b.append(", ");
        b.append("expectedStateUpdateDateTime=");
        b.append(this.expectedStateUpdateDateTime);
        b.append(", ");
        b.append("lastSyncDateTime=");
        b.append(this.lastSyncDateTime);
        b.append(", ");
        b.append("preRemediationDetectionScriptOutput=");
        b.append(this.preRemediationDetectionScriptOutput);
        b.append(", ");
        b.append("preRemediationDetectionScriptError=");
        b.append(this.preRemediationDetectionScriptError);
        b.append(", ");
        b.append("remediationScriptError=");
        b.append(this.remediationScriptError);
        b.append(", ");
        b.append("postRemediationDetectionScriptOutput=");
        b.append(this.postRemediationDetectionScriptOutput);
        b.append(", ");
        b.append("postRemediationDetectionScriptError=");
        b.append(this.postRemediationDetectionScriptError);
        b.append(", ");
        b.append("remediationState=");
        b.append(this.remediationState);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
