package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceAndAppManagementAssignmentTarget;
import odata.msgraph.client.beta.complex.DeviceHealthScriptRunSchedule;


/**
 * <i>“Contains properties used to assign a device management script to a group.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "target", 
    "runRemediationScript", 
    "runSchedule"})
@JsonInclude(Include.NON_NULL)
public class DeviceHealthScriptAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceHealthScriptAssignment";
    }

    @JsonProperty("target")
    protected DeviceAndAppManagementAssignmentTarget target;

    @JsonProperty("runRemediationScript")
    protected Boolean runRemediationScript;

    @JsonProperty("runSchedule")
    protected DeviceHealthScriptRunSchedule runSchedule;

    protected DeviceHealthScriptAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceHealthScriptAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DeviceAndAppManagementAssignmentTarget target;
        private Boolean runRemediationScript;
        private DeviceHealthScriptRunSchedule runSchedule;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The Azure Active Directory group we are targeting the script to”</i>
         * 
         * @param target
         *            value of {@code target} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder target(DeviceAndAppManagementAssignmentTarget target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        /**
         * <i>“Determine whether we want to run detection script only or run both detection
         * script and remediation script”</i>
         * 
         * @param runRemediationScript
         *            value of {@code runRemediationScript} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder runRemediationScript(Boolean runRemediationScript) {
            this.runRemediationScript = runRemediationScript;
            this.changedFields = changedFields.add("runRemediationScript");
            return this;
        }

        /**
         * <i>“Script run schedule for the target group”</i>
         * 
         * @param runSchedule
         *            value of {@code runSchedule} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder runSchedule(DeviceHealthScriptRunSchedule runSchedule) {
            this.runSchedule = runSchedule;
            this.changedFields = changedFields.add("runSchedule");
            return this;
        }

        public DeviceHealthScriptAssignment build() {
            DeviceHealthScriptAssignment _x = new DeviceHealthScriptAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceHealthScriptAssignment";
            _x.id = id;
            _x.target = target;
            _x.runRemediationScript = runRemediationScript;
            _x.runSchedule = runSchedule;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The Azure Active Directory group we are targeting the script to”</i>
     * 
     * @return property target
     */
    @Property(name="target")
    @JsonIgnore
    public Optional<DeviceAndAppManagementAssignmentTarget> getTarget() {
        return Optional.ofNullable(target);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code target} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Azure Active Directory group we are targeting the script to”</i>
     * 
     * @param target
     *            new value of {@code target} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code target} field changed
     */
    public DeviceHealthScriptAssignment withTarget(DeviceAndAppManagementAssignmentTarget target) {
        DeviceHealthScriptAssignment _x = _copy();
        _x.changedFields = changedFields.add("target");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptAssignment");
        _x.target = target;
        return _x;
    }

    /**
     * <i>“Determine whether we want to run detection script only or run both detection
     * script and remediation script”</i>
     * 
     * @return property runRemediationScript
     */
    @Property(name="runRemediationScript")
    @JsonIgnore
    public Optional<Boolean> getRunRemediationScript() {
        return Optional.ofNullable(runRemediationScript);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * runRemediationScript} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Determine whether we want to run detection script only or run both detection
     * script and remediation script”</i>
     * 
     * @param runRemediationScript
     *            new value of {@code runRemediationScript} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code runRemediationScript} field changed
     */
    public DeviceHealthScriptAssignment withRunRemediationScript(Boolean runRemediationScript) {
        DeviceHealthScriptAssignment _x = _copy();
        _x.changedFields = changedFields.add("runRemediationScript");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptAssignment");
        _x.runRemediationScript = runRemediationScript;
        return _x;
    }

    /**
     * <i>“Script run schedule for the target group”</i>
     * 
     * @return property runSchedule
     */
    @Property(name="runSchedule")
    @JsonIgnore
    public Optional<DeviceHealthScriptRunSchedule> getRunSchedule() {
        return Optional.ofNullable(runSchedule);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code runSchedule}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Script run schedule for the target group”</i>
     * 
     * @param runSchedule
     *            new value of {@code runSchedule} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code runSchedule} field changed
     */
    public DeviceHealthScriptAssignment withRunSchedule(DeviceHealthScriptRunSchedule runSchedule) {
        DeviceHealthScriptAssignment _x = _copy();
        _x.changedFields = changedFields.add("runSchedule");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptAssignment");
        _x.runSchedule = runSchedule;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceHealthScriptAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceHealthScriptAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceHealthScriptAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceHealthScriptAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceHealthScriptAssignment _copy() {
        DeviceHealthScriptAssignment _x = new DeviceHealthScriptAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.target = target;
        _x.runRemediationScript = runRemediationScript;
        _x.runSchedule = runSchedule;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceHealthScriptAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("target=");
        b.append(this.target);
        b.append(", ");
        b.append("runRemediationScript=");
        b.append(this.runRemediationScript);
        b.append(", ");
        b.append("runSchedule=");
        b.append(this.runSchedule);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
