package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.Enablement;
import odata.msgraph.client.beta.enums.WindowsHelloForBusinessPinUsage;


/**
 * <i>“Windows Hello for Business settings lets users access their devices using a
 * gesture, such as biometric authentication, or a PIN. Configure settings for
 * enrolled Windows 10, Windows 10 Mobile and later.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "pinMinimumLength", 
    "pinMaximumLength", 
    "pinUppercaseCharactersUsage", 
    "pinLowercaseCharactersUsage", 
    "pinSpecialCharactersUsage", 
    "state", 
    "securityDeviceRequired", 
    "unlockWithBiometricsEnabled", 
    "remotePassportEnabled", 
    "pinPreviousBlockCount", 
    "pinExpirationInDays", 
    "enhancedBiometricsState", 
    "securityKeyForSignIn"})
@JsonInclude(Include.NON_NULL)
public class DeviceEnrollmentWindowsHelloForBusinessConfiguration extends DeviceEnrollmentConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceEnrollmentWindowsHelloForBusinessConfiguration";
    }

    @JsonProperty("pinMinimumLength")
    protected Integer pinMinimumLength;

    @JsonProperty("pinMaximumLength")
    protected Integer pinMaximumLength;

    @JsonProperty("pinUppercaseCharactersUsage")
    protected WindowsHelloForBusinessPinUsage pinUppercaseCharactersUsage;

    @JsonProperty("pinLowercaseCharactersUsage")
    protected WindowsHelloForBusinessPinUsage pinLowercaseCharactersUsage;

    @JsonProperty("pinSpecialCharactersUsage")
    protected WindowsHelloForBusinessPinUsage pinSpecialCharactersUsage;

    @JsonProperty("state")
    protected Enablement state;

    @JsonProperty("securityDeviceRequired")
    protected Boolean securityDeviceRequired;

    @JsonProperty("unlockWithBiometricsEnabled")
    protected Boolean unlockWithBiometricsEnabled;

    @JsonProperty("remotePassportEnabled")
    protected Boolean remotePassportEnabled;

    @JsonProperty("pinPreviousBlockCount")
    protected Integer pinPreviousBlockCount;

    @JsonProperty("pinExpirationInDays")
    protected Integer pinExpirationInDays;

    @JsonProperty("enhancedBiometricsState")
    protected Enablement enhancedBiometricsState;

    @JsonProperty("securityKeyForSignIn")
    protected Enablement securityKeyForSignIn;

    protected DeviceEnrollmentWindowsHelloForBusinessConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceEnrollmentWindowsHelloForBusinessConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private Integer priority;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private Integer version;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer pinMinimumLength;
        private Integer pinMaximumLength;
        private WindowsHelloForBusinessPinUsage pinUppercaseCharactersUsage;
        private WindowsHelloForBusinessPinUsage pinLowercaseCharactersUsage;
        private WindowsHelloForBusinessPinUsage pinSpecialCharactersUsage;
        private Enablement state;
        private Boolean securityDeviceRequired;
        private Boolean unlockWithBiometricsEnabled;
        private Boolean remotePassportEnabled;
        private Integer pinPreviousBlockCount;
        private Integer pinExpirationInDays;
        private Enablement enhancedBiometricsState;
        private Enablement securityKeyForSignIn;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“Controls the minimum number of characters required for the Windows Hello for
         * Business PIN.  This value must be between 4 and 127, inclusive, and less than or
         * equal to the value set for the maximum PIN.”</i>
         * 
         * @param pinMinimumLength
         *            value of {@code pinMinimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinMinimumLength(Integer pinMinimumLength) {
            this.pinMinimumLength = pinMinimumLength;
            this.changedFields = changedFields.add("pinMinimumLength");
            return this;
        }

        /**
         * <i>“Controls the maximum number of characters allowed for the Windows Hello for
         * Business PIN. This value must be between 4 and 127, inclusive. This value must
         * be greater than or equal to the value set for the minimum PIN.”</i>
         * 
         * @param pinMaximumLength
         *            value of {@code pinMaximumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinMaximumLength(Integer pinMaximumLength) {
            this.pinMaximumLength = pinMaximumLength;
            this.changedFields = changedFields.add("pinMaximumLength");
            return this;
        }

        /**
         * <i>“Controls the ability to use uppercase letters in the Windows Hello for Business
         * PIN.  Allowed permits the use of uppercase letter(s), whereas Required ensures
         * they are present. If set to Not Allowed, uppercase letters will not be permitted
         * .”</i>
         * 
         * @param pinUppercaseCharactersUsage
         *            value of {@code pinUppercaseCharactersUsage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinUppercaseCharactersUsage(WindowsHelloForBusinessPinUsage pinUppercaseCharactersUsage) {
            this.pinUppercaseCharactersUsage = pinUppercaseCharactersUsage;
            this.changedFields = changedFields.add("pinUppercaseCharactersUsage");
            return this;
        }

        /**
         * <i>“Controls the ability to use lowercase letters in the Windows Hello for Business
         * PIN.  Allowed permits the use of lowercase letter(s), whereas Required ensures
         * they are present. If set to Not Allowed, lowercase letters will not be permitted
         * .”</i>
         * 
         * @param pinLowercaseCharactersUsage
         *            value of {@code pinLowercaseCharactersUsage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinLowercaseCharactersUsage(WindowsHelloForBusinessPinUsage pinLowercaseCharactersUsage) {
            this.pinLowercaseCharactersUsage = pinLowercaseCharactersUsage;
            this.changedFields = changedFields.add("pinLowercaseCharactersUsage");
            return this;
        }

        /**
         * <i>“Controls the ability to use special characters in the Windows Hello for Business
         * PIN.  Allowed permits the use of special character(s), whereas Required ensures
         * they are present. If set to Not Allowed, special character(s) will not be
         * permitted.”</i>
         * 
         * @param pinSpecialCharactersUsage
         *            value of {@code pinSpecialCharactersUsage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinSpecialCharactersUsage(WindowsHelloForBusinessPinUsage pinSpecialCharactersUsage) {
            this.pinSpecialCharactersUsage = pinSpecialCharactersUsage;
            this.changedFields = changedFields.add("pinSpecialCharactersUsage");
            return this;
        }

        /**
         * <i>“Controls whether to allow the device to be configured for Windows Hello for
         * Business. If set to disabled, the user cannot provision Windows Hello for
         * Business except on Azure Active Directory joined mobile phones if otherwise
         * required. If set to Not Configured, Intune will not override client defaults.”</i>
         * 
         * @param state
         *            value of {@code state} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder state(Enablement state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        /**
         * <i>“Controls whether to require a Trusted Platform Module (TPM) for provisioning
         * Windows Hello for Business. A TPM provides an additional security benefit in
         * that data stored on it cannot be used on other devices. If set to False, all
         * devices can provision Windows Hello for Business even if there is not a usable
         * TPM.”</i>
         * 
         * @param securityDeviceRequired
         *            value of {@code securityDeviceRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securityDeviceRequired(Boolean securityDeviceRequired) {
            this.securityDeviceRequired = securityDeviceRequired;
            this.changedFields = changedFields.add("securityDeviceRequired");
            return this;
        }

        /**
         * <i>“Controls the use of biometric gestures, such as face and fingerprint, as an
         * alternative to the Windows Hello for Business PIN.  If set to False, biometric
         * gestures are not allowed. Users must still configure a PIN as a backup in case
         * of failures.”</i>
         * 
         * @param unlockWithBiometricsEnabled
         *            value of {@code unlockWithBiometricsEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unlockWithBiometricsEnabled(Boolean unlockWithBiometricsEnabled) {
            this.unlockWithBiometricsEnabled = unlockWithBiometricsEnabled;
            this.changedFields = changedFields.add("unlockWithBiometricsEnabled");
            return this;
        }

        /**
         * <i>“Controls the use of Remote Windows Hello for Business. Remote Windows Hello for
         * Business provides the ability for a portable, registered device to be usable as
         * a companion for desktop authentication. The desktop must be Azure AD joined and
         * the companion device must have a Windows Hello for Business PIN.”</i>
         * 
         * @param remotePassportEnabled
         *            value of {@code remotePassportEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remotePassportEnabled(Boolean remotePassportEnabled) {
            this.remotePassportEnabled = remotePassportEnabled;
            this.changedFields = changedFields.add("remotePassportEnabled");
            return this;
        }

        /**
         * <i>“Controls the ability to prevent users from using past PINs. This must be set
         * between 0 and 50, inclusive, and the current PIN of the user is included in that
         * count. If set to 0, previous PINs are not stored. PIN history is not preserved
         * through a PIN reset.”</i>
         * 
         * @param pinPreviousBlockCount
         *            value of {@code pinPreviousBlockCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinPreviousBlockCount(Integer pinPreviousBlockCount) {
            this.pinPreviousBlockCount = pinPreviousBlockCount;
            this.changedFields = changedFields.add("pinPreviousBlockCount");
            return this;
        }

        /**
         * <i>“Controls the period of time (in days) that a PIN can be used before the system
         * requires the user to change it. This must be set between 0 and 730, inclusive.
         * If set to 0, the user's PIN will never expire”</i>
         * 
         * @param pinExpirationInDays
         *            value of {@code pinExpirationInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinExpirationInDays(Integer pinExpirationInDays) {
            this.pinExpirationInDays = pinExpirationInDays;
            this.changedFields = changedFields.add("pinExpirationInDays");
            return this;
        }

        /**
         * <i>“Controls the ability to use the anti-spoofing features for facial recognition on
         * devices which support it. If set to disabled, anti-spoofing features are not
         * allowed. If set to Not Configured, the user can choose whether they want to use
         * anti-spoofing.”</i>
         * 
         * @param enhancedBiometricsState
         *            value of {@code enhancedBiometricsState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enhancedBiometricsState(Enablement enhancedBiometricsState) {
            this.enhancedBiometricsState = enhancedBiometricsState;
            this.changedFields = changedFields.add("enhancedBiometricsState");
            return this;
        }

        /**
         * <i>“Security key for Sign In provides the capacity for remotely turning ON/OFF
         * Windows Hello Sercurity Keyl Not configured will honor configurations done on
         * the clinet.”</i>
         * 
         * @param securityKeyForSignIn
         *            value of {@code securityKeyForSignIn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securityKeyForSignIn(Enablement securityKeyForSignIn) {
            this.securityKeyForSignIn = securityKeyForSignIn;
            this.changedFields = changedFields.add("securityKeyForSignIn");
            return this;
        }

        public DeviceEnrollmentWindowsHelloForBusinessConfiguration build() {
            DeviceEnrollmentWindowsHelloForBusinessConfiguration _x = new DeviceEnrollmentWindowsHelloForBusinessConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceEnrollmentWindowsHelloForBusinessConfiguration";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.priority = priority;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.version = version;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.pinMinimumLength = pinMinimumLength;
            _x.pinMaximumLength = pinMaximumLength;
            _x.pinUppercaseCharactersUsage = pinUppercaseCharactersUsage;
            _x.pinLowercaseCharactersUsage = pinLowercaseCharactersUsage;
            _x.pinSpecialCharactersUsage = pinSpecialCharactersUsage;
            _x.state = state;
            _x.securityDeviceRequired = securityDeviceRequired;
            _x.unlockWithBiometricsEnabled = unlockWithBiometricsEnabled;
            _x.remotePassportEnabled = remotePassportEnabled;
            _x.pinPreviousBlockCount = pinPreviousBlockCount;
            _x.pinExpirationInDays = pinExpirationInDays;
            _x.enhancedBiometricsState = enhancedBiometricsState;
            _x.securityKeyForSignIn = securityKeyForSignIn;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Controls the minimum number of characters required for the Windows Hello for
     * Business PIN.  This value must be between 4 and 127, inclusive, and less than or
     * equal to the value set for the maximum PIN.”</i>
     * 
     * @return property pinMinimumLength
     */
    @Property(name="pinMinimumLength")
    @JsonIgnore
    public Optional<Integer> getPinMinimumLength() {
        return Optional.ofNullable(pinMinimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code pinMinimumLength}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Controls the minimum number of characters required for the Windows Hello for
     * Business PIN.  This value must be between 4 and 127, inclusive, and less than or
     * equal to the value set for the maximum PIN.”</i>
     * 
     * @param pinMinimumLength
     *            new value of {@code pinMinimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinMinimumLength} field changed
     */
    public DeviceEnrollmentWindowsHelloForBusinessConfiguration withPinMinimumLength(Integer pinMinimumLength) {
        DeviceEnrollmentWindowsHelloForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("pinMinimumLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentWindowsHelloForBusinessConfiguration");
        _x.pinMinimumLength = pinMinimumLength;
        return _x;
    }

    /**
     * <i>“Controls the maximum number of characters allowed for the Windows Hello for
     * Business PIN. This value must be between 4 and 127, inclusive. This value must
     * be greater than or equal to the value set for the minimum PIN.”</i>
     * 
     * @return property pinMaximumLength
     */
    @Property(name="pinMaximumLength")
    @JsonIgnore
    public Optional<Integer> getPinMaximumLength() {
        return Optional.ofNullable(pinMaximumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code pinMaximumLength}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Controls the maximum number of characters allowed for the Windows Hello for
     * Business PIN. This value must be between 4 and 127, inclusive. This value must
     * be greater than or equal to the value set for the minimum PIN.”</i>
     * 
     * @param pinMaximumLength
     *            new value of {@code pinMaximumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinMaximumLength} field changed
     */
    public DeviceEnrollmentWindowsHelloForBusinessConfiguration withPinMaximumLength(Integer pinMaximumLength) {
        DeviceEnrollmentWindowsHelloForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("pinMaximumLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentWindowsHelloForBusinessConfiguration");
        _x.pinMaximumLength = pinMaximumLength;
        return _x;
    }

    /**
     * <i>“Controls the ability to use uppercase letters in the Windows Hello for Business
     * PIN.  Allowed permits the use of uppercase letter(s), whereas Required ensures
     * they are present. If set to Not Allowed, uppercase letters will not be permitted
     * .”</i>
     * 
     * @return property pinUppercaseCharactersUsage
     */
    @Property(name="pinUppercaseCharactersUsage")
    @JsonIgnore
    public Optional<WindowsHelloForBusinessPinUsage> getPinUppercaseCharactersUsage() {
        return Optional.ofNullable(pinUppercaseCharactersUsage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * pinUppercaseCharactersUsage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Controls the ability to use uppercase letters in the Windows Hello for Business
     * PIN.  Allowed permits the use of uppercase letter(s), whereas Required ensures
     * they are present. If set to Not Allowed, uppercase letters will not be permitted
     * .”</i>
     * 
     * @param pinUppercaseCharactersUsage
     *            new value of {@code pinUppercaseCharactersUsage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinUppercaseCharactersUsage} field changed
     */
    public DeviceEnrollmentWindowsHelloForBusinessConfiguration withPinUppercaseCharactersUsage(WindowsHelloForBusinessPinUsage pinUppercaseCharactersUsage) {
        DeviceEnrollmentWindowsHelloForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("pinUppercaseCharactersUsage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentWindowsHelloForBusinessConfiguration");
        _x.pinUppercaseCharactersUsage = pinUppercaseCharactersUsage;
        return _x;
    }

    /**
     * <i>“Controls the ability to use lowercase letters in the Windows Hello for Business
     * PIN.  Allowed permits the use of lowercase letter(s), whereas Required ensures
     * they are present. If set to Not Allowed, lowercase letters will not be permitted
     * .”</i>
     * 
     * @return property pinLowercaseCharactersUsage
     */
    @Property(name="pinLowercaseCharactersUsage")
    @JsonIgnore
    public Optional<WindowsHelloForBusinessPinUsage> getPinLowercaseCharactersUsage() {
        return Optional.ofNullable(pinLowercaseCharactersUsage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * pinLowercaseCharactersUsage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Controls the ability to use lowercase letters in the Windows Hello for Business
     * PIN.  Allowed permits the use of lowercase letter(s), whereas Required ensures
     * they are present. If set to Not Allowed, lowercase letters will not be permitted
     * .”</i>
     * 
     * @param pinLowercaseCharactersUsage
     *            new value of {@code pinLowercaseCharactersUsage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinLowercaseCharactersUsage} field changed
     */
    public DeviceEnrollmentWindowsHelloForBusinessConfiguration withPinLowercaseCharactersUsage(WindowsHelloForBusinessPinUsage pinLowercaseCharactersUsage) {
        DeviceEnrollmentWindowsHelloForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("pinLowercaseCharactersUsage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentWindowsHelloForBusinessConfiguration");
        _x.pinLowercaseCharactersUsage = pinLowercaseCharactersUsage;
        return _x;
    }

    /**
     * <i>“Controls the ability to use special characters in the Windows Hello for Business
     * PIN.  Allowed permits the use of special character(s), whereas Required ensures
     * they are present. If set to Not Allowed, special character(s) will not be
     * permitted.”</i>
     * 
     * @return property pinSpecialCharactersUsage
     */
    @Property(name="pinSpecialCharactersUsage")
    @JsonIgnore
    public Optional<WindowsHelloForBusinessPinUsage> getPinSpecialCharactersUsage() {
        return Optional.ofNullable(pinSpecialCharactersUsage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * pinSpecialCharactersUsage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Controls the ability to use special characters in the Windows Hello for Business
     * PIN.  Allowed permits the use of special character(s), whereas Required ensures
     * they are present. If set to Not Allowed, special character(s) will not be
     * permitted.”</i>
     * 
     * @param pinSpecialCharactersUsage
     *            new value of {@code pinSpecialCharactersUsage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinSpecialCharactersUsage} field changed
     */
    public DeviceEnrollmentWindowsHelloForBusinessConfiguration withPinSpecialCharactersUsage(WindowsHelloForBusinessPinUsage pinSpecialCharactersUsage) {
        DeviceEnrollmentWindowsHelloForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("pinSpecialCharactersUsage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentWindowsHelloForBusinessConfiguration");
        _x.pinSpecialCharactersUsage = pinSpecialCharactersUsage;
        return _x;
    }

    /**
     * <i>“Controls whether to allow the device to be configured for Windows Hello for
     * Business. If set to disabled, the user cannot provision Windows Hello for
     * Business except on Azure Active Directory joined mobile phones if otherwise
     * required. If set to Not Configured, Intune will not override client defaults.”</i>
     * 
     * @return property state
     */
    @Property(name="state")
    @JsonIgnore
    public Optional<Enablement> getState() {
        return Optional.ofNullable(state);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code state} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Controls whether to allow the device to be configured for Windows Hello for
     * Business. If set to disabled, the user cannot provision Windows Hello for
     * Business except on Azure Active Directory joined mobile phones if otherwise
     * required. If set to Not Configured, Intune will not override client defaults.”</i>
     * 
     * @param state
     *            new value of {@code state} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code state} field changed
     */
    public DeviceEnrollmentWindowsHelloForBusinessConfiguration withState(Enablement state) {
        DeviceEnrollmentWindowsHelloForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentWindowsHelloForBusinessConfiguration");
        _x.state = state;
        return _x;
    }

    /**
     * <i>“Controls whether to require a Trusted Platform Module (TPM) for provisioning
     * Windows Hello for Business. A TPM provides an additional security benefit in
     * that data stored on it cannot be used on other devices. If set to False, all
     * devices can provision Windows Hello for Business even if there is not a usable
     * TPM.”</i>
     * 
     * @return property securityDeviceRequired
     */
    @Property(name="securityDeviceRequired")
    @JsonIgnore
    public Optional<Boolean> getSecurityDeviceRequired() {
        return Optional.ofNullable(securityDeviceRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securityDeviceRequired} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Controls whether to require a Trusted Platform Module (TPM) for provisioning
     * Windows Hello for Business. A TPM provides an additional security benefit in
     * that data stored on it cannot be used on other devices. If set to False, all
     * devices can provision Windows Hello for Business even if there is not a usable
     * TPM.”</i>
     * 
     * @param securityDeviceRequired
     *            new value of {@code securityDeviceRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securityDeviceRequired} field changed
     */
    public DeviceEnrollmentWindowsHelloForBusinessConfiguration withSecurityDeviceRequired(Boolean securityDeviceRequired) {
        DeviceEnrollmentWindowsHelloForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("securityDeviceRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentWindowsHelloForBusinessConfiguration");
        _x.securityDeviceRequired = securityDeviceRequired;
        return _x;
    }

    /**
     * <i>“Controls the use of biometric gestures, such as face and fingerprint, as an
     * alternative to the Windows Hello for Business PIN.  If set to False, biometric
     * gestures are not allowed. Users must still configure a PIN as a backup in case
     * of failures.”</i>
     * 
     * @return property unlockWithBiometricsEnabled
     */
    @Property(name="unlockWithBiometricsEnabled")
    @JsonIgnore
    public Optional<Boolean> getUnlockWithBiometricsEnabled() {
        return Optional.ofNullable(unlockWithBiometricsEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * unlockWithBiometricsEnabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Controls the use of biometric gestures, such as face and fingerprint, as an
     * alternative to the Windows Hello for Business PIN.  If set to False, biometric
     * gestures are not allowed. Users must still configure a PIN as a backup in case
     * of failures.”</i>
     * 
     * @param unlockWithBiometricsEnabled
     *            new value of {@code unlockWithBiometricsEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unlockWithBiometricsEnabled} field changed
     */
    public DeviceEnrollmentWindowsHelloForBusinessConfiguration withUnlockWithBiometricsEnabled(Boolean unlockWithBiometricsEnabled) {
        DeviceEnrollmentWindowsHelloForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("unlockWithBiometricsEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentWindowsHelloForBusinessConfiguration");
        _x.unlockWithBiometricsEnabled = unlockWithBiometricsEnabled;
        return _x;
    }

    /**
     * <i>“Controls the use of Remote Windows Hello for Business. Remote Windows Hello for
     * Business provides the ability for a portable, registered device to be usable as
     * a companion for desktop authentication. The desktop must be Azure AD joined and
     * the companion device must have a Windows Hello for Business PIN.”</i>
     * 
     * @return property remotePassportEnabled
     */
    @Property(name="remotePassportEnabled")
    @JsonIgnore
    public Optional<Boolean> getRemotePassportEnabled() {
        return Optional.ofNullable(remotePassportEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * remotePassportEnabled} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Controls the use of Remote Windows Hello for Business. Remote Windows Hello for
     * Business provides the ability for a portable, registered device to be usable as
     * a companion for desktop authentication. The desktop must be Azure AD joined and
     * the companion device must have a Windows Hello for Business PIN.”</i>
     * 
     * @param remotePassportEnabled
     *            new value of {@code remotePassportEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remotePassportEnabled} field changed
     */
    public DeviceEnrollmentWindowsHelloForBusinessConfiguration withRemotePassportEnabled(Boolean remotePassportEnabled) {
        DeviceEnrollmentWindowsHelloForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("remotePassportEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentWindowsHelloForBusinessConfiguration");
        _x.remotePassportEnabled = remotePassportEnabled;
        return _x;
    }

    /**
     * <i>“Controls the ability to prevent users from using past PINs. This must be set
     * between 0 and 50, inclusive, and the current PIN of the user is included in that
     * count. If set to 0, previous PINs are not stored. PIN history is not preserved
     * through a PIN reset.”</i>
     * 
     * @return property pinPreviousBlockCount
     */
    @Property(name="pinPreviousBlockCount")
    @JsonIgnore
    public Optional<Integer> getPinPreviousBlockCount() {
        return Optional.ofNullable(pinPreviousBlockCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * pinPreviousBlockCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Controls the ability to prevent users from using past PINs. This must be set
     * between 0 and 50, inclusive, and the current PIN of the user is included in that
     * count. If set to 0, previous PINs are not stored. PIN history is not preserved
     * through a PIN reset.”</i>
     * 
     * @param pinPreviousBlockCount
     *            new value of {@code pinPreviousBlockCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinPreviousBlockCount} field changed
     */
    public DeviceEnrollmentWindowsHelloForBusinessConfiguration withPinPreviousBlockCount(Integer pinPreviousBlockCount) {
        DeviceEnrollmentWindowsHelloForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("pinPreviousBlockCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentWindowsHelloForBusinessConfiguration");
        _x.pinPreviousBlockCount = pinPreviousBlockCount;
        return _x;
    }

    /**
     * <i>“Controls the period of time (in days) that a PIN can be used before the system
     * requires the user to change it. This must be set between 0 and 730, inclusive.
     * If set to 0, the user's PIN will never expire”</i>
     * 
     * @return property pinExpirationInDays
     */
    @Property(name="pinExpirationInDays")
    @JsonIgnore
    public Optional<Integer> getPinExpirationInDays() {
        return Optional.ofNullable(pinExpirationInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * pinExpirationInDays} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Controls the period of time (in days) that a PIN can be used before the system
     * requires the user to change it. This must be set between 0 and 730, inclusive.
     * If set to 0, the user's PIN will never expire”</i>
     * 
     * @param pinExpirationInDays
     *            new value of {@code pinExpirationInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinExpirationInDays} field changed
     */
    public DeviceEnrollmentWindowsHelloForBusinessConfiguration withPinExpirationInDays(Integer pinExpirationInDays) {
        DeviceEnrollmentWindowsHelloForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("pinExpirationInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentWindowsHelloForBusinessConfiguration");
        _x.pinExpirationInDays = pinExpirationInDays;
        return _x;
    }

    /**
     * <i>“Controls the ability to use the anti-spoofing features for facial recognition on
     * devices which support it. If set to disabled, anti-spoofing features are not
     * allowed. If set to Not Configured, the user can choose whether they want to use
     * anti-spoofing.”</i>
     * 
     * @return property enhancedBiometricsState
     */
    @Property(name="enhancedBiometricsState")
    @JsonIgnore
    public Optional<Enablement> getEnhancedBiometricsState() {
        return Optional.ofNullable(enhancedBiometricsState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enhancedBiometricsState} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Controls the ability to use the anti-spoofing features for facial recognition on
     * devices which support it. If set to disabled, anti-spoofing features are not
     * allowed. If set to Not Configured, the user can choose whether they want to use
     * anti-spoofing.”</i>
     * 
     * @param enhancedBiometricsState
     *            new value of {@code enhancedBiometricsState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enhancedBiometricsState} field changed
     */
    public DeviceEnrollmentWindowsHelloForBusinessConfiguration withEnhancedBiometricsState(Enablement enhancedBiometricsState) {
        DeviceEnrollmentWindowsHelloForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enhancedBiometricsState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentWindowsHelloForBusinessConfiguration");
        _x.enhancedBiometricsState = enhancedBiometricsState;
        return _x;
    }

    /**
     * <i>“Security key for Sign In provides the capacity for remotely turning ON/OFF
     * Windows Hello Sercurity Keyl Not configured will honor configurations done on
     * the clinet.”</i>
     * 
     * @return property securityKeyForSignIn
     */
    @Property(name="securityKeyForSignIn")
    @JsonIgnore
    public Optional<Enablement> getSecurityKeyForSignIn() {
        return Optional.ofNullable(securityKeyForSignIn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securityKeyForSignIn} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Security key for Sign In provides the capacity for remotely turning ON/OFF
     * Windows Hello Sercurity Keyl Not configured will honor configurations done on
     * the clinet.”</i>
     * 
     * @param securityKeyForSignIn
     *            new value of {@code securityKeyForSignIn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securityKeyForSignIn} field changed
     */
    public DeviceEnrollmentWindowsHelloForBusinessConfiguration withSecurityKeyForSignIn(Enablement securityKeyForSignIn) {
        DeviceEnrollmentWindowsHelloForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("securityKeyForSignIn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentWindowsHelloForBusinessConfiguration");
        _x.securityKeyForSignIn = securityKeyForSignIn;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceEnrollmentWindowsHelloForBusinessConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceEnrollmentWindowsHelloForBusinessConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceEnrollmentWindowsHelloForBusinessConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceEnrollmentWindowsHelloForBusinessConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceEnrollmentWindowsHelloForBusinessConfiguration _copy() {
        DeviceEnrollmentWindowsHelloForBusinessConfiguration _x = new DeviceEnrollmentWindowsHelloForBusinessConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.priority = priority;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.version = version;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.pinMinimumLength = pinMinimumLength;
        _x.pinMaximumLength = pinMaximumLength;
        _x.pinUppercaseCharactersUsage = pinUppercaseCharactersUsage;
        _x.pinLowercaseCharactersUsage = pinLowercaseCharactersUsage;
        _x.pinSpecialCharactersUsage = pinSpecialCharactersUsage;
        _x.state = state;
        _x.securityDeviceRequired = securityDeviceRequired;
        _x.unlockWithBiometricsEnabled = unlockWithBiometricsEnabled;
        _x.remotePassportEnabled = remotePassportEnabled;
        _x.pinPreviousBlockCount = pinPreviousBlockCount;
        _x.pinExpirationInDays = pinExpirationInDays;
        _x.enhancedBiometricsState = enhancedBiometricsState;
        _x.securityKeyForSignIn = securityKeyForSignIn;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceEnrollmentWindowsHelloForBusinessConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("pinMinimumLength=");
        b.append(this.pinMinimumLength);
        b.append(", ");
        b.append("pinMaximumLength=");
        b.append(this.pinMaximumLength);
        b.append(", ");
        b.append("pinUppercaseCharactersUsage=");
        b.append(this.pinUppercaseCharactersUsage);
        b.append(", ");
        b.append("pinLowercaseCharactersUsage=");
        b.append(this.pinLowercaseCharactersUsage);
        b.append(", ");
        b.append("pinSpecialCharactersUsage=");
        b.append(this.pinSpecialCharactersUsage);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("securityDeviceRequired=");
        b.append(this.securityDeviceRequired);
        b.append(", ");
        b.append("unlockWithBiometricsEnabled=");
        b.append(this.unlockWithBiometricsEnabled);
        b.append(", ");
        b.append("remotePassportEnabled=");
        b.append(this.remotePassportEnabled);
        b.append(", ");
        b.append("pinPreviousBlockCount=");
        b.append(this.pinPreviousBlockCount);
        b.append(", ");
        b.append("pinExpirationInDays=");
        b.append(this.pinExpirationInDays);
        b.append(", ");
        b.append("enhancedBiometricsState=");
        b.append(this.enhancedBiometricsState);
        b.append(", ");
        b.append("securityKeyForSignIn=");
        b.append(this.securityKeyForSignIn);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
