package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceEnrollmentPlatformRestriction;


/**
 * <i>“Device Enrollment Configuration that restricts the types of devices a user can
 * enroll”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "iosRestriction", 
    "windowsRestriction", 
    "windowsMobileRestriction", 
    "androidRestriction", 
    "androidForWorkRestriction", 
    "macRestriction", 
    "macOSRestriction"})
@JsonInclude(Include.NON_NULL)
public class DeviceEnrollmentPlatformRestrictionsConfiguration extends DeviceEnrollmentConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceEnrollmentPlatformRestrictionsConfiguration";
    }

    @JsonProperty("iosRestriction")
    protected DeviceEnrollmentPlatformRestriction iosRestriction;

    @JsonProperty("windowsRestriction")
    protected DeviceEnrollmentPlatformRestriction windowsRestriction;

    @JsonProperty("windowsMobileRestriction")
    protected DeviceEnrollmentPlatformRestriction windowsMobileRestriction;

    @JsonProperty("androidRestriction")
    protected DeviceEnrollmentPlatformRestriction androidRestriction;

    @JsonProperty("androidForWorkRestriction")
    protected DeviceEnrollmentPlatformRestriction androidForWorkRestriction;

    @JsonProperty("macRestriction")
    protected DeviceEnrollmentPlatformRestriction macRestriction;

    @JsonProperty("macOSRestriction")
    protected DeviceEnrollmentPlatformRestriction macOSRestriction;

    protected DeviceEnrollmentPlatformRestrictionsConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceEnrollmentPlatformRestrictionsConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private Integer priority;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private Integer version;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private DeviceEnrollmentPlatformRestriction iosRestriction;
        private DeviceEnrollmentPlatformRestriction windowsRestriction;
        private DeviceEnrollmentPlatformRestriction windowsMobileRestriction;
        private DeviceEnrollmentPlatformRestriction androidRestriction;
        private DeviceEnrollmentPlatformRestriction androidForWorkRestriction;
        private DeviceEnrollmentPlatformRestriction macRestriction;
        private DeviceEnrollmentPlatformRestriction macOSRestriction;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“Ios restrictions based on platform, platform operating system version, and
         * device ownership”</i>
         * 
         * @param iosRestriction
         *            value of {@code iosRestriction} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iosRestriction(DeviceEnrollmentPlatformRestriction iosRestriction) {
            this.iosRestriction = iosRestriction;
            this.changedFields = changedFields.add("iosRestriction");
            return this;
        }

        /**
         * <i>“Windows restrictions based on platform, platform operating system version, and
         * device ownership”</i>
         * 
         * @param windowsRestriction
         *            value of {@code windowsRestriction} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsRestriction(DeviceEnrollmentPlatformRestriction windowsRestriction) {
            this.windowsRestriction = windowsRestriction;
            this.changedFields = changedFields.add("windowsRestriction");
            return this;
        }

        /**
         * <i>“Windows mobile restrictions based on platform, platform operating system version
         * , and device ownership”</i>
         * 
         * @param windowsMobileRestriction
         *            value of {@code windowsMobileRestriction} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsMobileRestriction(DeviceEnrollmentPlatformRestriction windowsMobileRestriction) {
            this.windowsMobileRestriction = windowsMobileRestriction;
            this.changedFields = changedFields.add("windowsMobileRestriction");
            return this;
        }

        /**
         * <i>“Android restrictions based on platform, platform operating system version, and
         * device ownership”</i>
         * 
         * @param androidRestriction
         *            value of {@code androidRestriction} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidRestriction(DeviceEnrollmentPlatformRestriction androidRestriction) {
            this.androidRestriction = androidRestriction;
            this.changedFields = changedFields.add("androidRestriction");
            return this;
        }

        /**
         * <i>“Android for work restrictions based on platform, platform operating system
         * version, and device ownership”</i>
         * 
         * @param androidForWorkRestriction
         *            value of {@code androidForWorkRestriction} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidForWorkRestriction(DeviceEnrollmentPlatformRestriction androidForWorkRestriction) {
            this.androidForWorkRestriction = androidForWorkRestriction;
            this.changedFields = changedFields.add("androidForWorkRestriction");
            return this;
        }

        /**
         * <i>“Mac restrictions based on platform, platform operating system version, and
         * device ownership”</i>
         * 
         * @param macRestriction
         *            value of {@code macRestriction} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder macRestriction(DeviceEnrollmentPlatformRestriction macRestriction) {
            this.macRestriction = macRestriction;
            this.changedFields = changedFields.add("macRestriction");
            return this;
        }

        /**
         * <i>“Mac restrictions based on platform, platform operating system version, and
         * device ownership”</i>
         * 
         * @param macOSRestriction
         *            value of {@code macOSRestriction} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder macOSRestriction(DeviceEnrollmentPlatformRestriction macOSRestriction) {
            this.macOSRestriction = macOSRestriction;
            this.changedFields = changedFields.add("macOSRestriction");
            return this;
        }

        public DeviceEnrollmentPlatformRestrictionsConfiguration build() {
            DeviceEnrollmentPlatformRestrictionsConfiguration _x = new DeviceEnrollmentPlatformRestrictionsConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceEnrollmentPlatformRestrictionsConfiguration";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.priority = priority;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.version = version;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.iosRestriction = iosRestriction;
            _x.windowsRestriction = windowsRestriction;
            _x.windowsMobileRestriction = windowsMobileRestriction;
            _x.androidRestriction = androidRestriction;
            _x.androidForWorkRestriction = androidForWorkRestriction;
            _x.macRestriction = macRestriction;
            _x.macOSRestriction = macOSRestriction;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Ios restrictions based on platform, platform operating system version, and
     * device ownership”</i>
     * 
     * @return property iosRestriction
     */
    @Property(name="iosRestriction")
    @JsonIgnore
    public Optional<DeviceEnrollmentPlatformRestriction> getIosRestriction() {
        return Optional.ofNullable(iosRestriction);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code iosRestriction}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Ios restrictions based on platform, platform operating system version, and
     * device ownership”</i>
     * 
     * @param iosRestriction
     *            new value of {@code iosRestriction} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iosRestriction} field changed
     */
    public DeviceEnrollmentPlatformRestrictionsConfiguration withIosRestriction(DeviceEnrollmentPlatformRestriction iosRestriction) {
        DeviceEnrollmentPlatformRestrictionsConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iosRestriction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentPlatformRestrictionsConfiguration");
        _x.iosRestriction = iosRestriction;
        return _x;
    }

    /**
     * <i>“Windows restrictions based on platform, platform operating system version, and
     * device ownership”</i>
     * 
     * @return property windowsRestriction
     */
    @Property(name="windowsRestriction")
    @JsonIgnore
    public Optional<DeviceEnrollmentPlatformRestriction> getWindowsRestriction() {
        return Optional.ofNullable(windowsRestriction);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsRestriction} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Windows restrictions based on platform, platform operating system version, and
     * device ownership”</i>
     * 
     * @param windowsRestriction
     *            new value of {@code windowsRestriction} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsRestriction} field changed
     */
    public DeviceEnrollmentPlatformRestrictionsConfiguration withWindowsRestriction(DeviceEnrollmentPlatformRestriction windowsRestriction) {
        DeviceEnrollmentPlatformRestrictionsConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windowsRestriction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentPlatformRestrictionsConfiguration");
        _x.windowsRestriction = windowsRestriction;
        return _x;
    }

    /**
     * <i>“Windows mobile restrictions based on platform, platform operating system version
     * , and device ownership”</i>
     * 
     * @return property windowsMobileRestriction
     */
    @Property(name="windowsMobileRestriction")
    @JsonIgnore
    public Optional<DeviceEnrollmentPlatformRestriction> getWindowsMobileRestriction() {
        return Optional.ofNullable(windowsMobileRestriction);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsMobileRestriction} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Windows mobile restrictions based on platform, platform operating system version
     * , and device ownership”</i>
     * 
     * @param windowsMobileRestriction
     *            new value of {@code windowsMobileRestriction} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsMobileRestriction} field changed
     */
    public DeviceEnrollmentPlatformRestrictionsConfiguration withWindowsMobileRestriction(DeviceEnrollmentPlatformRestriction windowsMobileRestriction) {
        DeviceEnrollmentPlatformRestrictionsConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windowsMobileRestriction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentPlatformRestrictionsConfiguration");
        _x.windowsMobileRestriction = windowsMobileRestriction;
        return _x;
    }

    /**
     * <i>“Android restrictions based on platform, platform operating system version, and
     * device ownership”</i>
     * 
     * @return property androidRestriction
     */
    @Property(name="androidRestriction")
    @JsonIgnore
    public Optional<DeviceEnrollmentPlatformRestriction> getAndroidRestriction() {
        return Optional.ofNullable(androidRestriction);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * androidRestriction} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Android restrictions based on platform, platform operating system version, and
     * device ownership”</i>
     * 
     * @param androidRestriction
     *            new value of {@code androidRestriction} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidRestriction} field changed
     */
    public DeviceEnrollmentPlatformRestrictionsConfiguration withAndroidRestriction(DeviceEnrollmentPlatformRestriction androidRestriction) {
        DeviceEnrollmentPlatformRestrictionsConfiguration _x = _copy();
        _x.changedFields = changedFields.add("androidRestriction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentPlatformRestrictionsConfiguration");
        _x.androidRestriction = androidRestriction;
        return _x;
    }

    /**
     * <i>“Android for work restrictions based on platform, platform operating system
     * version, and device ownership”</i>
     * 
     * @return property androidForWorkRestriction
     */
    @Property(name="androidForWorkRestriction")
    @JsonIgnore
    public Optional<DeviceEnrollmentPlatformRestriction> getAndroidForWorkRestriction() {
        return Optional.ofNullable(androidForWorkRestriction);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * androidForWorkRestriction} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Android for work restrictions based on platform, platform operating system
     * version, and device ownership”</i>
     * 
     * @param androidForWorkRestriction
     *            new value of {@code androidForWorkRestriction} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidForWorkRestriction} field changed
     */
    public DeviceEnrollmentPlatformRestrictionsConfiguration withAndroidForWorkRestriction(DeviceEnrollmentPlatformRestriction androidForWorkRestriction) {
        DeviceEnrollmentPlatformRestrictionsConfiguration _x = _copy();
        _x.changedFields = changedFields.add("androidForWorkRestriction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentPlatformRestrictionsConfiguration");
        _x.androidForWorkRestriction = androidForWorkRestriction;
        return _x;
    }

    /**
     * <i>“Mac restrictions based on platform, platform operating system version, and
     * device ownership”</i>
     * 
     * @return property macRestriction
     */
    @Property(name="macRestriction")
    @JsonIgnore
    public Optional<DeviceEnrollmentPlatformRestriction> getMacRestriction() {
        return Optional.ofNullable(macRestriction);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code macRestriction}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Mac restrictions based on platform, platform operating system version, and
     * device ownership”</i>
     * 
     * @param macRestriction
     *            new value of {@code macRestriction} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code macRestriction} field changed
     */
    public DeviceEnrollmentPlatformRestrictionsConfiguration withMacRestriction(DeviceEnrollmentPlatformRestriction macRestriction) {
        DeviceEnrollmentPlatformRestrictionsConfiguration _x = _copy();
        _x.changedFields = changedFields.add("macRestriction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentPlatformRestrictionsConfiguration");
        _x.macRestriction = macRestriction;
        return _x;
    }

    /**
     * <i>“Mac restrictions based on platform, platform operating system version, and
     * device ownership”</i>
     * 
     * @return property macOSRestriction
     */
    @Property(name="macOSRestriction")
    @JsonIgnore
    public Optional<DeviceEnrollmentPlatformRestriction> getMacOSRestriction() {
        return Optional.ofNullable(macOSRestriction);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code macOSRestriction}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Mac restrictions based on platform, platform operating system version, and
     * device ownership”</i>
     * 
     * @param macOSRestriction
     *            new value of {@code macOSRestriction} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code macOSRestriction} field changed
     */
    public DeviceEnrollmentPlatformRestrictionsConfiguration withMacOSRestriction(DeviceEnrollmentPlatformRestriction macOSRestriction) {
        DeviceEnrollmentPlatformRestrictionsConfiguration _x = _copy();
        _x.changedFields = changedFields.add("macOSRestriction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentPlatformRestrictionsConfiguration");
        _x.macOSRestriction = macOSRestriction;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceEnrollmentPlatformRestrictionsConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceEnrollmentPlatformRestrictionsConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceEnrollmentPlatformRestrictionsConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceEnrollmentPlatformRestrictionsConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceEnrollmentPlatformRestrictionsConfiguration _copy() {
        DeviceEnrollmentPlatformRestrictionsConfiguration _x = new DeviceEnrollmentPlatformRestrictionsConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.priority = priority;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.version = version;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.iosRestriction = iosRestriction;
        _x.windowsRestriction = windowsRestriction;
        _x.windowsMobileRestriction = windowsMobileRestriction;
        _x.androidRestriction = androidRestriction;
        _x.androidForWorkRestriction = androidForWorkRestriction;
        _x.macRestriction = macRestriction;
        _x.macOSRestriction = macOSRestriction;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceEnrollmentPlatformRestrictionsConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("iosRestriction=");
        b.append(this.iosRestriction);
        b.append(", ");
        b.append("windowsRestriction=");
        b.append(this.windowsRestriction);
        b.append(", ");
        b.append("windowsMobileRestriction=");
        b.append(this.windowsMobileRestriction);
        b.append(", ");
        b.append("androidRestriction=");
        b.append(this.androidRestriction);
        b.append(", ");
        b.append("androidForWorkRestriction=");
        b.append(this.androidForWorkRestriction);
        b.append(", ");
        b.append("macRestriction=");
        b.append(this.macRestriction);
        b.append(", ");
        b.append("macOSRestriction=");
        b.append(this.macOSRestriction);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
