package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.SettingSource;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Conflict summary for a set of device configuration policies.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "conflictingDeviceConfigurations", 
    "contributingSettings", 
    "deviceCheckinsImpacted"})
@JsonInclude(Include.NON_NULL)
public class DeviceConfigurationConflictSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceConfigurationConflictSummary";
    }

    @JsonProperty("conflictingDeviceConfigurations")
    protected List<SettingSource> conflictingDeviceConfigurations;

    @JsonProperty("conflictingDeviceConfigurations@nextLink")
    protected String conflictingDeviceConfigurationsNextLink;

    @JsonProperty("contributingSettings")
    protected List<String> contributingSettings;

    @JsonProperty("contributingSettings@nextLink")
    protected String contributingSettingsNextLink;

    @JsonProperty("deviceCheckinsImpacted")
    protected Integer deviceCheckinsImpacted;

    protected DeviceConfigurationConflictSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceConfigurationConflictSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<SettingSource> conflictingDeviceConfigurations;
        private String conflictingDeviceConfigurationsNextLink;
        private List<String> contributingSettings;
        private String contributingSettingsNextLink;
        private Integer deviceCheckinsImpacted;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The set of policies in conflict with the given setting”</i>
         * 
         * @param conflictingDeviceConfigurations
         *            value of {@code conflictingDeviceConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder conflictingDeviceConfigurations(List<SettingSource> conflictingDeviceConfigurations) {
            this.conflictingDeviceConfigurations = conflictingDeviceConfigurations;
            this.changedFields = changedFields.add("conflictingDeviceConfigurations");
            return this;
        }

        /**
         * <i>“The set of policies in conflict with the given setting”</i>
         * 
         * @param conflictingDeviceConfigurations
         *            value of {@code conflictingDeviceConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder conflictingDeviceConfigurations(SettingSource... conflictingDeviceConfigurations) {
            return conflictingDeviceConfigurations(Arrays.asList(conflictingDeviceConfigurations));
        }

        /**
         * <i>“The set of policies in conflict with the given setting”</i>
         * 
         * @param conflictingDeviceConfigurationsNextLink
         *            value of {@code conflictingDeviceConfigurations@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder conflictingDeviceConfigurationsNextLink(String conflictingDeviceConfigurationsNextLink) {
            this.conflictingDeviceConfigurationsNextLink = conflictingDeviceConfigurationsNextLink;
            this.changedFields = changedFields.add("conflictingDeviceConfigurations");
            return this;
        }

        /**
         * <i>“The set of settings in conflict with the given policies”</i>
         * 
         * @param contributingSettings
         *            value of {@code contributingSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contributingSettings(List<String> contributingSettings) {
            this.contributingSettings = contributingSettings;
            this.changedFields = changedFields.add("contributingSettings");
            return this;
        }

        /**
         * <i>“The set of settings in conflict with the given policies”</i>
         * 
         * @param contributingSettings
         *            value of {@code contributingSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contributingSettings(String... contributingSettings) {
            return contributingSettings(Arrays.asList(contributingSettings));
        }

        /**
         * <i>“The set of settings in conflict with the given policies”</i>
         * 
         * @param contributingSettingsNextLink
         *            value of {@code contributingSettings@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contributingSettingsNextLink(String contributingSettingsNextLink) {
            this.contributingSettingsNextLink = contributingSettingsNextLink;
            this.changedFields = changedFields.add("contributingSettings");
            return this;
        }

        /**
         * <i>“The count of checkins impacted by the conflicting policies and settings”</i>
         * 
         * @param deviceCheckinsImpacted
         *            value of {@code deviceCheckinsImpacted} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCheckinsImpacted(Integer deviceCheckinsImpacted) {
            this.deviceCheckinsImpacted = deviceCheckinsImpacted;
            this.changedFields = changedFields.add("deviceCheckinsImpacted");
            return this;
        }

        public DeviceConfigurationConflictSummary build() {
            DeviceConfigurationConflictSummary _x = new DeviceConfigurationConflictSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceConfigurationConflictSummary";
            _x.id = id;
            _x.conflictingDeviceConfigurations = conflictingDeviceConfigurations;
            _x.conflictingDeviceConfigurationsNextLink = conflictingDeviceConfigurationsNextLink;
            _x.contributingSettings = contributingSettings;
            _x.contributingSettingsNextLink = contributingSettingsNextLink;
            _x.deviceCheckinsImpacted = deviceCheckinsImpacted;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The set of policies in conflict with the given setting”</i>
     * 
     * @return property conflictingDeviceConfigurations
     */
    @Property(name="conflictingDeviceConfigurations")
    @JsonIgnore
    public CollectionPage<SettingSource> getConflictingDeviceConfigurations() {
        return new CollectionPage<SettingSource>(contextPath, SettingSource.class, conflictingDeviceConfigurations, Optional.ofNullable(conflictingDeviceConfigurationsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The set of policies in conflict with the given setting”</i>
     * 
     * @return property conflictingDeviceConfigurations
     */
    @Property(name="conflictingDeviceConfigurations")
    @JsonIgnore
    public CollectionPage<SettingSource> getConflictingDeviceConfigurations(HttpRequestOptions options) {
        return new CollectionPage<SettingSource>(contextPath, SettingSource.class, conflictingDeviceConfigurations, Optional.ofNullable(conflictingDeviceConfigurationsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“The set of settings in conflict with the given policies”</i>
     * 
     * @return property contributingSettings
     */
    @Property(name="contributingSettings")
    @JsonIgnore
    public CollectionPage<String> getContributingSettings() {
        return new CollectionPage<String>(contextPath, String.class, contributingSettings, Optional.ofNullable(contributingSettingsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The set of settings in conflict with the given policies”</i>
     * 
     * @return property contributingSettings
     */
    @Property(name="contributingSettings")
    @JsonIgnore
    public CollectionPage<String> getContributingSettings(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, contributingSettings, Optional.ofNullable(contributingSettingsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“The count of checkins impacted by the conflicting policies and settings”</i>
     * 
     * @return property deviceCheckinsImpacted
     */
    @Property(name="deviceCheckinsImpacted")
    @JsonIgnore
    public Optional<Integer> getDeviceCheckinsImpacted() {
        return Optional.ofNullable(deviceCheckinsImpacted);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceCheckinsImpacted} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The count of checkins impacted by the conflicting policies and settings”</i>
     * 
     * @param deviceCheckinsImpacted
     *            new value of {@code deviceCheckinsImpacted} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCheckinsImpacted} field changed
     */
    public DeviceConfigurationConflictSummary withDeviceCheckinsImpacted(Integer deviceCheckinsImpacted) {
        DeviceConfigurationConflictSummary _x = _copy();
        _x.changedFields = changedFields.add("deviceCheckinsImpacted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfigurationConflictSummary");
        _x.deviceCheckinsImpacted = deviceCheckinsImpacted;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceConfigurationConflictSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceConfigurationConflictSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceConfigurationConflictSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceConfigurationConflictSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceConfigurationConflictSummary _copy() {
        DeviceConfigurationConflictSummary _x = new DeviceConfigurationConflictSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.conflictingDeviceConfigurations = conflictingDeviceConfigurations;
        _x.contributingSettings = contributingSettings;
        _x.deviceCheckinsImpacted = deviceCheckinsImpacted;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceConfigurationConflictSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("conflictingDeviceConfigurations=");
        b.append(this.conflictingDeviceConfigurations);
        b.append(", ");
        b.append("contributingSettings=");
        b.append(this.contributingSettings);
        b.append(", ");
        b.append("deviceCheckinsImpacted=");
        b.append(this.deviceCheckinsImpacted);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
