package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationDeviceStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationGroupAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationUserStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SettingStateDeviceSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.request.DeviceConfigurationDeviceOverviewRequest;
import odata.msgraph.client.beta.entity.request.DeviceConfigurationUserOverviewRequest;


/**
 * <i>“Device Configuration.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "lastModifiedDateTime", 
    "roleScopeTagIds", 
    "supportsScopeTags", 
    "deviceManagementApplicabilityRuleOsEdition", 
    "deviceManagementApplicabilityRuleOsVersion", 
    "deviceManagementApplicabilityRuleDeviceMode", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "version"})
@JsonInclude(Include.NON_NULL)
public class DeviceConfiguration extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceConfiguration";
    }

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("supportsScopeTags")
    protected Boolean supportsScopeTags;

    @JsonProperty("deviceManagementApplicabilityRuleOsEdition")
    protected DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;

    @JsonProperty("deviceManagementApplicabilityRuleOsVersion")
    protected DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;

    @JsonProperty("deviceManagementApplicabilityRuleDeviceMode")
    protected DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("version")
    protected Integer version;

    protected DeviceConfiguration() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public DeviceConfiguration withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates whether or not the underlying Device Configuration supports the
     * assignment of scope tags. Assigning to the ScopeTags property is not allowed
     * when this value is false and entities will not be visible to scoped users. This
     * occurs for Legacy policies created in Silverlight and can be resolved by
     * deleting and recreating the policy in the Azure Portal. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property supportsScopeTags
     */
    @Property(name="supportsScopeTags")
    @JsonIgnore
    public Optional<Boolean> getSupportsScopeTags() {
        return Optional.ofNullable(supportsScopeTags);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code supportsScopeTags
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not the underlying Device Configuration supports the
     * assignment of scope tags. Assigning to the ScopeTags property is not allowed
     * when this value is false and entities will not be visible to scoped users. This
     * occurs for Legacy policies created in Silverlight and can be resolved by
     * deleting and recreating the policy in the Azure Portal. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param supportsScopeTags
     *            new value of {@code supportsScopeTags} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supportsScopeTags} field changed
     */
    public DeviceConfiguration withSupportsScopeTags(Boolean supportsScopeTags) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("supportsScopeTags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.supportsScopeTags = supportsScopeTags;
        return _x;
    }

    /**
     * <i>“The OS edition applicability for this Policy.”</i>
     * 
     * @return property deviceManagementApplicabilityRuleOsEdition
     */
    @Property(name="deviceManagementApplicabilityRuleOsEdition")
    @JsonIgnore
    public Optional<DeviceManagementApplicabilityRuleOsEdition> getDeviceManagementApplicabilityRuleOsEdition() {
        return Optional.ofNullable(deviceManagementApplicabilityRuleOsEdition);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceManagementApplicabilityRuleOsEdition} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The OS edition applicability for this Policy.”</i>
     * 
     * @param deviceManagementApplicabilityRuleOsEdition
     *            new value of {@code deviceManagementApplicabilityRuleOsEdition} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceManagementApplicabilityRuleOsEdition} field changed
     */
    public DeviceConfiguration withDeviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        return _x;
    }

    /**
     * <i>“The OS version applicability rule for this Policy.”</i>
     * 
     * @return property deviceManagementApplicabilityRuleOsVersion
     */
    @Property(name="deviceManagementApplicabilityRuleOsVersion")
    @JsonIgnore
    public Optional<DeviceManagementApplicabilityRuleOsVersion> getDeviceManagementApplicabilityRuleOsVersion() {
        return Optional.ofNullable(deviceManagementApplicabilityRuleOsVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceManagementApplicabilityRuleOsVersion} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The OS version applicability rule for this Policy.”</i>
     * 
     * @param deviceManagementApplicabilityRuleOsVersion
     *            new value of {@code deviceManagementApplicabilityRuleOsVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceManagementApplicabilityRuleOsVersion} field changed
     */
    public DeviceConfiguration withDeviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        return _x;
    }

    /**
     * <i>“The device mode applicability rule for this Policy.”</i>
     * 
     * @return property deviceManagementApplicabilityRuleDeviceMode
     */
    @Property(name="deviceManagementApplicabilityRuleDeviceMode")
    @JsonIgnore
    public Optional<DeviceManagementApplicabilityRuleDeviceMode> getDeviceManagementApplicabilityRuleDeviceMode() {
        return Optional.ofNullable(deviceManagementApplicabilityRuleDeviceMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceManagementApplicabilityRuleDeviceMode} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The device mode applicability rule for this Policy.”</i>
     * 
     * @param deviceManagementApplicabilityRuleDeviceMode
     *            new value of {@code deviceManagementApplicabilityRuleDeviceMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceManagementApplicabilityRuleDeviceMode} field changed
     */
    public DeviceConfiguration withDeviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        return _x;
    }

    /**
     * <i>“DateTime the object was created.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“DateTime the object was created.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public DeviceConfiguration withCreatedDateTime(OffsetDateTime createdDateTime) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Admin provided description of the Device Configuration.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Admin provided description of the Device Configuration.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceConfiguration withDescription(String description) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Admin provided name of the device configuration.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Admin provided name of the device configuration.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceConfiguration withDisplayName(String displayName) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Version of the device configuration.”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version of the device configuration.”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public DeviceConfiguration withVersion(Integer version) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.version = version;
        return _x;
    }

    /**
     * <i>“The list of group assignments for the device configuration profile.”</i>
     * 
     * @return navigational property groupAssignments
     */
    @NavigationProperty(name="groupAssignments")
    @JsonIgnore
    public DeviceConfigurationGroupAssignmentCollectionRequest getGroupAssignments() {
        return new DeviceConfigurationGroupAssignmentCollectionRequest(
                        contextPath.addSegment("groupAssignments"));
    }

    /**
     * <i>“The list of assignments for the device configuration profile.”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public DeviceConfigurationAssignmentCollectionRequest getAssignments() {
        return new DeviceConfigurationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    /**
     * <i>“Device configuration installation status by device.”</i>
     * 
     * @return navigational property deviceStatuses
     */
    @NavigationProperty(name="deviceStatuses")
    @JsonIgnore
    public DeviceConfigurationDeviceStatusCollectionRequest getDeviceStatuses() {
        return new DeviceConfigurationDeviceStatusCollectionRequest(
                        contextPath.addSegment("deviceStatuses"));
    }

    /**
     * <i>“Device configuration installation status by user.”</i>
     * 
     * @return navigational property userStatuses
     */
    @NavigationProperty(name="userStatuses")
    @JsonIgnore
    public DeviceConfigurationUserStatusCollectionRequest getUserStatuses() {
        return new DeviceConfigurationUserStatusCollectionRequest(
                        contextPath.addSegment("userStatuses"));
    }

    /**
     * <i>“Device Configuration devices status overview”</i>
     * 
     * @return navigational property deviceStatusOverview
     */
    @NavigationProperty(name="deviceStatusOverview")
    @JsonIgnore
    public DeviceConfigurationDeviceOverviewRequest getDeviceStatusOverview() {
        return new DeviceConfigurationDeviceOverviewRequest(contextPath.addSegment("deviceStatusOverview"));
    }

    /**
     * <i>“Device Configuration users status overview”</i>
     * 
     * @return navigational property userStatusOverview
     */
    @NavigationProperty(name="userStatusOverview")
    @JsonIgnore
    public DeviceConfigurationUserOverviewRequest getUserStatusOverview() {
        return new DeviceConfigurationUserOverviewRequest(contextPath.addSegment("userStatusOverview"));
    }

    /**
     * <i>“Device Configuration Setting State Device Summary”</i>
     * 
     * @return navigational property deviceSettingStateSummaries
     */
    @NavigationProperty(name="deviceSettingStateSummaries")
    @JsonIgnore
    public SettingStateDeviceSummaryCollectionRequest getDeviceSettingStateSummaries() {
        return new SettingStateDeviceSummaryCollectionRequest(
                        contextPath.addSegment("deviceSettingStateSummaries"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceConfiguration _copy() {
        DeviceConfiguration _x = new DeviceConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceConfigurationAssignment> assign(List<DeviceConfigurationGroupAssignment> deviceConfigurationGroupAssignments, List<DeviceConfigurationAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceConfigurationGroupAssignments", "Collection(microsoft.graph.deviceConfigurationGroupAssignment)", deviceConfigurationGroupAssignments)
            .put("assignments", "Collection(microsoft.graph.deviceConfigurationAssignment)", assignments)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), DeviceConfigurationAssignment.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "windowsPrivacyAccessControls")
    @JsonIgnore
    public ActionRequestNoReturn windowsPrivacyAccessControls(List<WindowsPrivacyDataAccessControlItem> windowsPrivacyAccessControls) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("windowsPrivacyAccessControls", "Collection(microsoft.graph.windowsPrivacyDataAccessControlItem)", windowsPrivacyAccessControls)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsPrivacyAccessControls"), _parameters);
    }

    @Action(name = "assignedAccessMultiModeProfiles")
    @JsonIgnore
    public ActionRequestNoReturn assignedAccessMultiModeProfiles(List<WindowsAssignedAccessProfile> assignedAccessMultiModeProfiles) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignedAccessMultiModeProfiles", "Collection(microsoft.graph.windowsAssignedAccessProfile)", assignedAccessMultiModeProfiles)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assignedAccessMultiModeProfiles"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
