package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.ManagedDeviceRequest;
import odata.msgraph.client.beta.enums.RunState;


/**
 * <i>“Contains properties for device run state of the device compliance script.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "detectionState", 
    "lastStateUpdateDateTime", 
    "expectedStateUpdateDateTime", 
    "lastSyncDateTime", 
    "scriptOutput", 
    "scriptError"})
@JsonInclude(Include.NON_NULL)
public class DeviceComplianceScriptDeviceState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceComplianceScriptDeviceState";
    }

    @JsonProperty("detectionState")
    protected RunState detectionState;

    @JsonProperty("lastStateUpdateDateTime")
    protected OffsetDateTime lastStateUpdateDateTime;

    @JsonProperty("expectedStateUpdateDateTime")
    protected OffsetDateTime expectedStateUpdateDateTime;

    @JsonProperty("lastSyncDateTime")
    protected OffsetDateTime lastSyncDateTime;

    @JsonProperty("scriptOutput")
    protected String scriptOutput;

    @JsonProperty("scriptError")
    protected String scriptError;

    protected DeviceComplianceScriptDeviceState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceComplianceScriptDeviceState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private RunState detectionState;
        private OffsetDateTime lastStateUpdateDateTime;
        private OffsetDateTime expectedStateUpdateDateTime;
        private OffsetDateTime lastSyncDateTime;
        private String scriptOutput;
        private String scriptError;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Detection state from the lastest device compliance script execution”</i>
         * 
         * @param detectionState
         *            value of {@code detectionState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionState(RunState detectionState) {
            this.detectionState = detectionState;
            this.changedFields = changedFields.add("detectionState");
            return this;
        }

        /**
         * <i>“The last timestamp of when the device compliance script executed”</i>
         * 
         * @param lastStateUpdateDateTime
         *            value of {@code lastStateUpdateDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastStateUpdateDateTime(OffsetDateTime lastStateUpdateDateTime) {
            this.lastStateUpdateDateTime = lastStateUpdateDateTime;
            this.changedFields = changedFields.add("lastStateUpdateDateTime");
            return this;
        }

        /**
         * <i>“The next timestamp of when the device compliance script is expected to execute”</i>
         * 
         * @param expectedStateUpdateDateTime
         *            value of {@code expectedStateUpdateDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder expectedStateUpdateDateTime(OffsetDateTime expectedStateUpdateDateTime) {
            this.expectedStateUpdateDateTime = expectedStateUpdateDateTime;
            this.changedFields = changedFields.add("expectedStateUpdateDateTime");
            return this;
        }

        /**
         * <i>“The last time that Intune Managment Extension synced with Intune”</i>
         * 
         * @param lastSyncDateTime
         *            value of {@code lastSyncDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastSyncDateTime(OffsetDateTime lastSyncDateTime) {
            this.lastSyncDateTime = lastSyncDateTime;
            this.changedFields = changedFields.add("lastSyncDateTime");
            return this;
        }

        /**
         * <i>“Output of the detection script”</i>
         * 
         * @param scriptOutput
         *            value of {@code scriptOutput} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scriptOutput(String scriptOutput) {
            this.scriptOutput = scriptOutput;
            this.changedFields = changedFields.add("scriptOutput");
            return this;
        }

        /**
         * <i>“Error from the detection script”</i>
         * 
         * @param scriptError
         *            value of {@code scriptError} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scriptError(String scriptError) {
            this.scriptError = scriptError;
            this.changedFields = changedFields.add("scriptError");
            return this;
        }

        public DeviceComplianceScriptDeviceState build() {
            DeviceComplianceScriptDeviceState _x = new DeviceComplianceScriptDeviceState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceComplianceScriptDeviceState";
            _x.id = id;
            _x.detectionState = detectionState;
            _x.lastStateUpdateDateTime = lastStateUpdateDateTime;
            _x.expectedStateUpdateDateTime = expectedStateUpdateDateTime;
            _x.lastSyncDateTime = lastSyncDateTime;
            _x.scriptOutput = scriptOutput;
            _x.scriptError = scriptError;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Detection state from the lastest device compliance script execution”</i>
     * 
     * @return property detectionState
     */
    @Property(name="detectionState")
    @JsonIgnore
    public Optional<RunState> getDetectionState() {
        return Optional.ofNullable(detectionState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code detectionState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Detection state from the lastest device compliance script execution”</i>
     * 
     * @param detectionState
     *            new value of {@code detectionState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectionState} field changed
     */
    public DeviceComplianceScriptDeviceState withDetectionState(RunState detectionState) {
        DeviceComplianceScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("detectionState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptDeviceState");
        _x.detectionState = detectionState;
        return _x;
    }

    /**
     * <i>“The last timestamp of when the device compliance script executed”</i>
     * 
     * @return property lastStateUpdateDateTime
     */
    @Property(name="lastStateUpdateDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastStateUpdateDateTime() {
        return Optional.ofNullable(lastStateUpdateDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastStateUpdateDateTime} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The last timestamp of when the device compliance script executed”</i>
     * 
     * @param lastStateUpdateDateTime
     *            new value of {@code lastStateUpdateDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastStateUpdateDateTime} field changed
     */
    public DeviceComplianceScriptDeviceState withLastStateUpdateDateTime(OffsetDateTime lastStateUpdateDateTime) {
        DeviceComplianceScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("lastStateUpdateDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptDeviceState");
        _x.lastStateUpdateDateTime = lastStateUpdateDateTime;
        return _x;
    }

    /**
     * <i>“The next timestamp of when the device compliance script is expected to execute”</i>
     * 
     * @return property expectedStateUpdateDateTime
     */
    @Property(name="expectedStateUpdateDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpectedStateUpdateDateTime() {
        return Optional.ofNullable(expectedStateUpdateDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * expectedStateUpdateDateTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The next timestamp of when the device compliance script is expected to execute”</i>
     * 
     * @param expectedStateUpdateDateTime
     *            new value of {@code expectedStateUpdateDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code expectedStateUpdateDateTime} field changed
     */
    public DeviceComplianceScriptDeviceState withExpectedStateUpdateDateTime(OffsetDateTime expectedStateUpdateDateTime) {
        DeviceComplianceScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("expectedStateUpdateDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptDeviceState");
        _x.expectedStateUpdateDateTime = expectedStateUpdateDateTime;
        return _x;
    }

    /**
     * <i>“The last time that Intune Managment Extension synced with Intune”</i>
     * 
     * @return property lastSyncDateTime
     */
    @Property(name="lastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSyncDateTime() {
        return Optional.ofNullable(lastSyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastSyncDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The last time that Intune Managment Extension synced with Intune”</i>
     * 
     * @param lastSyncDateTime
     *            new value of {@code lastSyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastSyncDateTime} field changed
     */
    public DeviceComplianceScriptDeviceState withLastSyncDateTime(OffsetDateTime lastSyncDateTime) {
        DeviceComplianceScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("lastSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptDeviceState");
        _x.lastSyncDateTime = lastSyncDateTime;
        return _x;
    }

    /**
     * <i>“Output of the detection script”</i>
     * 
     * @return property scriptOutput
     */
    @Property(name="scriptOutput")
    @JsonIgnore
    public Optional<String> getScriptOutput() {
        return Optional.ofNullable(scriptOutput);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code scriptOutput}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Output of the detection script”</i>
     * 
     * @param scriptOutput
     *            new value of {@code scriptOutput} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code scriptOutput} field changed
     */
    public DeviceComplianceScriptDeviceState withScriptOutput(String scriptOutput) {
        DeviceComplianceScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("scriptOutput");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptDeviceState");
        _x.scriptOutput = scriptOutput;
        return _x;
    }

    /**
     * <i>“Error from the detection script”</i>
     * 
     * @return property scriptError
     */
    @Property(name="scriptError")
    @JsonIgnore
    public Optional<String> getScriptError() {
        return Optional.ofNullable(scriptError);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code scriptError}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Error from the detection script”</i>
     * 
     * @param scriptError
     *            new value of {@code scriptError} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code scriptError} field changed
     */
    public DeviceComplianceScriptDeviceState withScriptError(String scriptError) {
        DeviceComplianceScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("scriptError");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptDeviceState");
        _x.scriptError = scriptError;
        return _x;
    }

    /**
     * <i>“The managed device on which the device compliance script executed”</i>
     * 
     * @return navigational property managedDevice
     */
    @NavigationProperty(name="managedDevice")
    @JsonIgnore
    public ManagedDeviceRequest getManagedDevice() {
        return new ManagedDeviceRequest(contextPath.addSegment("managedDevice"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceComplianceScriptDeviceState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceComplianceScriptDeviceState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceComplianceScriptDeviceState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceComplianceScriptDeviceState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceComplianceScriptDeviceState _copy() {
        DeviceComplianceScriptDeviceState _x = new DeviceComplianceScriptDeviceState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.detectionState = detectionState;
        _x.lastStateUpdateDateTime = lastStateUpdateDateTime;
        _x.expectedStateUpdateDateTime = expectedStateUpdateDateTime;
        _x.lastSyncDateTime = lastSyncDateTime;
        _x.scriptOutput = scriptOutput;
        _x.scriptError = scriptError;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceComplianceScriptDeviceState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("detectionState=");
        b.append(this.detectionState);
        b.append(", ");
        b.append("lastStateUpdateDateTime=");
        b.append(this.lastStateUpdateDateTime);
        b.append(", ");
        b.append("expectedStateUpdateDateTime=");
        b.append(this.expectedStateUpdateDateTime);
        b.append(", ");
        b.append("lastSyncDateTime=");
        b.append(this.lastSyncDateTime);
        b.append(", ");
        b.append("scriptOutput=");
        b.append(this.scriptOutput);
        b.append(", ");
        b.append("scriptError=");
        b.append(this.scriptError);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
