package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.DeviceComplianceScriptDeviceStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceHealthScriptAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.request.DeviceComplianceScriptRunSummaryRequest;
import odata.msgraph.client.beta.enums.RunAsAccountType;


/**
 * <i>“Intune will provide customer the ability to run their Powershell Compliance
 * scripts (detection) on the enrolled windows 10 Azure Active Directory joined
 * devices.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "publisher", 
    "version", 
    "displayName", 
    "description", 
    "detectionScriptContent", 
    "createdDateTime", 
    "lastModifiedDateTime", 
    "runAsAccount", 
    "enforceSignatureCheck", 
    "runAs32Bit", 
    "roleScopeTagIds"})
@JsonInclude(Include.NON_NULL)
public class DeviceComplianceScript extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceComplianceScript";
    }

    @JsonProperty("publisher")
    protected String publisher;

    @JsonProperty("version")
    protected String version;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("detectionScriptContent")
    protected byte[] detectionScriptContent;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("runAsAccount")
    protected RunAsAccountType runAsAccount;

    @JsonProperty("enforceSignatureCheck")
    protected Boolean enforceSignatureCheck;

    @JsonProperty("runAs32Bit")
    protected Boolean runAs32Bit;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    protected DeviceComplianceScript() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceComplianceScript() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String publisher;
        private String version;
        private String displayName;
        private String description;
        private byte[] detectionScriptContent;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private RunAsAccountType runAsAccount;
        private Boolean enforceSignatureCheck;
        private Boolean runAs32Bit;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Name of the device compliance script publisher”</i>
         * 
         * @param publisher
         *            value of {@code publisher} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        /**
         * <i>“Version of the device compliance script”</i>
         * 
         * @param version
         *            value of {@code version} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Name of the device compliance script”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Description of the device compliance script”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“The entire content of the detection powershell script”</i>
         * 
         * @param detectionScriptContent
         *            value of {@code detectionScriptContent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionScriptContent(byte[] detectionScriptContent) {
            this.detectionScriptContent = detectionScriptContent;
            this.changedFields = changedFields.add("detectionScriptContent");
            return this;
        }

        /**
         * <i>“The timestamp of when the device compliance script was created. This property is
         * read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“The timestamp of when the device compliance script was modified. This property
         * is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“Indicates the type of execution context”</i>
         * 
         * @param runAsAccount
         *            value of {@code runAsAccount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder runAsAccount(RunAsAccountType runAsAccount) {
            this.runAsAccount = runAsAccount;
            this.changedFields = changedFields.add("runAsAccount");
            return this;
        }

        /**
         * <i>“Indicate whether the script signature needs be checked”</i>
         * 
         * @param enforceSignatureCheck
         *            value of {@code enforceSignatureCheck} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enforceSignatureCheck(Boolean enforceSignatureCheck) {
            this.enforceSignatureCheck = enforceSignatureCheck;
            this.changedFields = changedFields.add("enforceSignatureCheck");
            return this;
        }

        /**
         * <i>“Indicate whether PowerShell script(s) should run as 32-bit”</i>
         * 
         * @param runAs32Bit
         *            value of {@code runAs32Bit} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder runAs32Bit(Boolean runAs32Bit) {
            this.runAs32Bit = runAs32Bit;
            this.changedFields = changedFields.add("runAs32Bit");
            return this;
        }

        /**
         * <i>“List of Scope Tag IDs for the device compliance script”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tag IDs for the device compliance script”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tag IDs for the device compliance script”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public DeviceComplianceScript build() {
            DeviceComplianceScript _x = new DeviceComplianceScript();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceComplianceScript";
            _x.id = id;
            _x.publisher = publisher;
            _x.version = version;
            _x.displayName = displayName;
            _x.description = description;
            _x.detectionScriptContent = detectionScriptContent;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.runAsAccount = runAsAccount;
            _x.enforceSignatureCheck = enforceSignatureCheck;
            _x.runAs32Bit = runAs32Bit;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Name of the device compliance script publisher”</i>
     * 
     * @return property publisher
     */
    @Property(name="publisher")
    @JsonIgnore
    public Optional<String> getPublisher() {
        return Optional.ofNullable(publisher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code publisher} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name of the device compliance script publisher”</i>
     * 
     * @param publisher
     *            new value of {@code publisher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code publisher} field changed
     */
    public DeviceComplianceScript withPublisher(String publisher) {
        DeviceComplianceScript _x = _copy();
        _x.changedFields = changedFields.add("publisher");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScript");
        _x.publisher = publisher;
        return _x;
    }

    /**
     * <i>“Version of the device compliance script”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version of the device compliance script”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public DeviceComplianceScript withVersion(String version) {
        DeviceComplianceScript _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScript");
        _x.version = version;
        return _x;
    }

    /**
     * <i>“Name of the device compliance script”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Name of the device compliance script”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceComplianceScript withDisplayName(String displayName) {
        DeviceComplianceScript _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScript");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Description of the device compliance script”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Description of the device compliance script”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceComplianceScript withDescription(String description) {
        DeviceComplianceScript _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScript");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The entire content of the detection powershell script”</i>
     * 
     * @return property detectionScriptContent
     */
    @Property(name="detectionScriptContent")
    @JsonIgnore
    public Optional<byte[]> getDetectionScriptContent() {
        return Optional.ofNullable(detectionScriptContent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * detectionScriptContent} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The entire content of the detection powershell script”</i>
     * 
     * @param detectionScriptContent
     *            new value of {@code detectionScriptContent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectionScriptContent} field changed
     */
    public DeviceComplianceScript withDetectionScriptContent(byte[] detectionScriptContent) {
        DeviceComplianceScript _x = _copy();
        _x.changedFields = changedFields.add("detectionScriptContent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScript");
        _x.detectionScriptContent = detectionScriptContent;
        return _x;
    }

    /**
     * <i>“The timestamp of when the device compliance script was created. This property is
     * read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The timestamp of when the device compliance script was created. This property is
     * read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public DeviceComplianceScript withCreatedDateTime(OffsetDateTime createdDateTime) {
        DeviceComplianceScript _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScript");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“The timestamp of when the device compliance script was modified. This property
     * is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The timestamp of when the device compliance script was modified. This property
     * is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public DeviceComplianceScript withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        DeviceComplianceScript _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScript");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“Indicates the type of execution context”</i>
     * 
     * @return property runAsAccount
     */
    @Property(name="runAsAccount")
    @JsonIgnore
    public Optional<RunAsAccountType> getRunAsAccount() {
        return Optional.ofNullable(runAsAccount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code runAsAccount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates the type of execution context”</i>
     * 
     * @param runAsAccount
     *            new value of {@code runAsAccount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code runAsAccount} field changed
     */
    public DeviceComplianceScript withRunAsAccount(RunAsAccountType runAsAccount) {
        DeviceComplianceScript _x = _copy();
        _x.changedFields = changedFields.add("runAsAccount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScript");
        _x.runAsAccount = runAsAccount;
        return _x;
    }

    /**
     * <i>“Indicate whether the script signature needs be checked”</i>
     * 
     * @return property enforceSignatureCheck
     */
    @Property(name="enforceSignatureCheck")
    @JsonIgnore
    public Optional<Boolean> getEnforceSignatureCheck() {
        return Optional.ofNullable(enforceSignatureCheck);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enforceSignatureCheck} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicate whether the script signature needs be checked”</i>
     * 
     * @param enforceSignatureCheck
     *            new value of {@code enforceSignatureCheck} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enforceSignatureCheck} field changed
     */
    public DeviceComplianceScript withEnforceSignatureCheck(Boolean enforceSignatureCheck) {
        DeviceComplianceScript _x = _copy();
        _x.changedFields = changedFields.add("enforceSignatureCheck");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScript");
        _x.enforceSignatureCheck = enforceSignatureCheck;
        return _x;
    }

    /**
     * <i>“Indicate whether PowerShell script(s) should run as 32-bit”</i>
     * 
     * @return property runAs32Bit
     */
    @Property(name="runAs32Bit")
    @JsonIgnore
    public Optional<Boolean> getRunAs32Bit() {
        return Optional.ofNullable(runAs32Bit);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code runAs32Bit} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicate whether PowerShell script(s) should run as 32-bit”</i>
     * 
     * @param runAs32Bit
     *            new value of {@code runAs32Bit} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code runAs32Bit} field changed
     */
    public DeviceComplianceScript withRunAs32Bit(Boolean runAs32Bit) {
        DeviceComplianceScript _x = _copy();
        _x.changedFields = changedFields.add("runAs32Bit");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScript");
        _x.runAs32Bit = runAs32Bit;
        return _x;
    }

    /**
     * <i>“List of Scope Tag IDs for the device compliance script”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Scope Tag IDs for the device compliance script”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“The list of group assignments for the device compliance script”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public DeviceHealthScriptAssignmentCollectionRequest getAssignments() {
        return new DeviceHealthScriptAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    /**
     * <i>“High level run summary for device compliance script.”</i>
     * 
     * @return navigational property runSummary
     */
    @NavigationProperty(name="runSummary")
    @JsonIgnore
    public DeviceComplianceScriptRunSummaryRequest getRunSummary() {
        return new DeviceComplianceScriptRunSummaryRequest(contextPath.addSegment("runSummary"));
    }

    /**
     * <i>“List of run states for the device compliance script across all devices”</i>
     * 
     * @return navigational property deviceRunStates
     */
    @NavigationProperty(name="deviceRunStates")
    @JsonIgnore
    public DeviceComplianceScriptDeviceStateCollectionRequest getDeviceRunStates() {
        return new DeviceComplianceScriptDeviceStateCollectionRequest(
                        contextPath.addSegment("deviceRunStates"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceComplianceScript patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceComplianceScript _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceComplianceScript put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceComplianceScript _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceComplianceScript _copy() {
        DeviceComplianceScript _x = new DeviceComplianceScript();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.publisher = publisher;
        _x.version = version;
        _x.displayName = displayName;
        _x.description = description;
        _x.detectionScriptContent = detectionScriptContent;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.runAsAccount = runAsAccount;
        _x.enforceSignatureCheck = enforceSignatureCheck;
        _x.runAs32Bit = runAs32Bit;
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<DeviceHealthScriptAssignment> deviceHealthScriptAssignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceHealthScriptAssignments", "Collection(microsoft.graph.deviceHealthScriptAssignment)", deviceHealthScriptAssignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceComplianceScript[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("detectionScriptContent=");
        b.append(this.detectionScriptContent);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("runAsAccount=");
        b.append(this.runAsAccount);
        b.append(", ");
        b.append("enforceSignatureCheck=");
        b.append(this.enforceSignatureCheck);
        b.append(", ");
        b.append("runAs32Bit=");
        b.append(this.runAs32Bit);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
