package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceCompliancePolicySettingState;
import odata.msgraph.client.beta.enums.ComplianceStatus;
import odata.msgraph.client.beta.enums.PolicyPlatformType;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Device Compliance Policy State for a given device.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "settingStates", 
    "displayName", 
    "version", 
    "platformType", 
    "state", 
    "settingCount", 
    "userId", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class DeviceCompliancePolicyState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceCompliancePolicyState";
    }

    @JsonProperty("settingStates")
    protected List<DeviceCompliancePolicySettingState> settingStates;

    @JsonProperty("settingStates@nextLink")
    protected String settingStatesNextLink;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("version")
    protected Integer version;

    @JsonProperty("platformType")
    protected PolicyPlatformType platformType;

    @JsonProperty("state")
    protected ComplianceStatus state;

    @JsonProperty("settingCount")
    protected Integer settingCount;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected DeviceCompliancePolicyState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceCompliancePolicyState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<DeviceCompliancePolicySettingState> settingStates;
        private String settingStatesNextLink;
        private String displayName;
        private Integer version;
        private PolicyPlatformType platformType;
        private ComplianceStatus state;
        private Integer settingCount;
        private String userId;
        private String userPrincipalName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder settingStates(List<DeviceCompliancePolicySettingState> settingStates) {
            this.settingStates = settingStates;
            this.changedFields = changedFields.add("settingStates");
            return this;
        }

        public Builder settingStates(DeviceCompliancePolicySettingState... settingStates) {
            return settingStates(Arrays.asList(settingStates));
        }

        public Builder settingStatesNextLink(String settingStatesNextLink) {
            this.settingStatesNextLink = settingStatesNextLink;
            this.changedFields = changedFields.add("settingStates");
            return this;
        }

        /**
         * <i>“The name of the policy for this policyBase”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The version of the policy”</i>
         * 
         * @param version
         *            value of {@code version} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Platform type that the policy applies to”</i>
         * 
         * @param platformType
         *            value of {@code platformType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder platformType(PolicyPlatformType platformType) {
            this.platformType = platformType;
            this.changedFields = changedFields.add("platformType");
            return this;
        }

        /**
         * <i>“The compliance state of the policy”</i>
         * 
         * @param state
         *            value of {@code state} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder state(ComplianceStatus state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        /**
         * <i>“Count of how many setting a policy holds”</i>
         * 
         * @param settingCount
         *            value of {@code settingCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingCount(Integer settingCount) {
            this.settingCount = settingCount;
            this.changedFields = changedFields.add("settingCount");
            return this;
        }

        /**
         * <i>“User unique identifier, must be Guid”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        /**
         * <i>“User Principal Name”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public DeviceCompliancePolicyState build() {
            DeviceCompliancePolicyState _x = new DeviceCompliancePolicyState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceCompliancePolicyState";
            _x.id = id;
            _x.settingStates = settingStates;
            _x.settingStatesNextLink = settingStatesNextLink;
            _x.displayName = displayName;
            _x.version = version;
            _x.platformType = platformType;
            _x.state = state;
            _x.settingCount = settingCount;
            _x.userId = userId;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="settingStates")
    @JsonIgnore
    public CollectionPage<DeviceCompliancePolicySettingState> getSettingStates() {
        return new CollectionPage<DeviceCompliancePolicySettingState>(contextPath, DeviceCompliancePolicySettingState.class, settingStates, Optional.ofNullable(settingStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="settingStates")
    @JsonIgnore
    public CollectionPage<DeviceCompliancePolicySettingState> getSettingStates(HttpRequestOptions options) {
        return new CollectionPage<DeviceCompliancePolicySettingState>(contextPath, DeviceCompliancePolicySettingState.class, settingStates, Optional.ofNullable(settingStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“The name of the policy for this policyBase”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The name of the policy for this policyBase”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceCompliancePolicyState withDisplayName(String displayName) {
        DeviceCompliancePolicyState _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyState");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The version of the policy”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The version of the policy”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public DeviceCompliancePolicyState withVersion(Integer version) {
        DeviceCompliancePolicyState _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyState");
        _x.version = version;
        return _x;
    }

    /**
     * <i>“Platform type that the policy applies to”</i>
     * 
     * @return property platformType
     */
    @Property(name="platformType")
    @JsonIgnore
    public Optional<PolicyPlatformType> getPlatformType() {
        return Optional.ofNullable(platformType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code platformType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Platform type that the policy applies to”</i>
     * 
     * @param platformType
     *            new value of {@code platformType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code platformType} field changed
     */
    public DeviceCompliancePolicyState withPlatformType(PolicyPlatformType platformType) {
        DeviceCompliancePolicyState _x = _copy();
        _x.changedFields = changedFields.add("platformType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyState");
        _x.platformType = platformType;
        return _x;
    }

    /**
     * <i>“The compliance state of the policy”</i>
     * 
     * @return property state
     */
    @Property(name="state")
    @JsonIgnore
    public Optional<ComplianceStatus> getState() {
        return Optional.ofNullable(state);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code state} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The compliance state of the policy”</i>
     * 
     * @param state
     *            new value of {@code state} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code state} field changed
     */
    public DeviceCompliancePolicyState withState(ComplianceStatus state) {
        DeviceCompliancePolicyState _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyState");
        _x.state = state;
        return _x;
    }

    /**
     * <i>“Count of how many setting a policy holds”</i>
     * 
     * @return property settingCount
     */
    @Property(name="settingCount")
    @JsonIgnore
    public Optional<Integer> getSettingCount() {
        return Optional.ofNullable(settingCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Count of how many setting a policy holds”</i>
     * 
     * @param settingCount
     *            new value of {@code settingCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingCount} field changed
     */
    public DeviceCompliancePolicyState withSettingCount(Integer settingCount) {
        DeviceCompliancePolicyState _x = _copy();
        _x.changedFields = changedFields.add("settingCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyState");
        _x.settingCount = settingCount;
        return _x;
    }

    /**
     * <i>“User unique identifier, must be Guid”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“User unique identifier, must be Guid”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public DeviceCompliancePolicyState withUserId(String userId) {
        DeviceCompliancePolicyState _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyState");
        _x.userId = userId;
        return _x;
    }

    /**
     * <i>“User Principal Name”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User Principal Name”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public DeviceCompliancePolicyState withUserPrincipalName(String userPrincipalName) {
        DeviceCompliancePolicyState _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyState");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceCompliancePolicyState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceCompliancePolicyState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceCompliancePolicyState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceCompliancePolicyState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceCompliancePolicyState _copy() {
        DeviceCompliancePolicyState _x = new DeviceCompliancePolicyState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.settingStates = settingStates;
        _x.displayName = displayName;
        _x.version = version;
        _x.platformType = platformType;
        _x.state = state;
        _x.settingCount = settingCount;
        _x.userId = userId;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceCompliancePolicyState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("settingStates=");
        b.append(this.settingStates);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("platformType=");
        b.append(this.platformType);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("settingCount=");
        b.append(this.settingCount);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
