package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AndroidManagedAppProtectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DefaultManagedAppProtectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceAppManagementTaskCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EnterpriseCodeSigningCertificateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IosLobAppProvisioningConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IosManagedAppProtectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedAppPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedAppRegistrationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedAppStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedEBookCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedEBookCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MdmWindowsInformationProtectionPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PolicySetCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SideLoadingKeyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TargetedManagedAppConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.VppTokenCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsDefenderApplicationControlSupplementalPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionDeviceRegistrationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionWipeActionCollectionRequest;
import odata.msgraph.client.beta.entity.request.SymantecCodeSigningCertificateRequest;
import odata.msgraph.client.beta.entity.request.WindowsManagementAppRequest;
import odata.msgraph.client.beta.enums.MicrosoftStoreForBusinessPortalSelectionOptions;


/**
 * <i>“Singleton entity that acts as a container for all device app management
 * functionality.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "microsoftStoreForBusinessLastSuccessfulSyncDateTime", 
    "isEnabledForMicrosoftStoreForBusiness", 
    "microsoftStoreForBusinessLanguage", 
    "microsoftStoreForBusinessLastCompletedApplicationSyncTime", 
    "microsoftStoreForBusinessPortalSelection"})
@JsonInclude(Include.NON_NULL)
public class DeviceAppManagement extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceAppManagement";
    }

    @JsonProperty("microsoftStoreForBusinessLastSuccessfulSyncDateTime")
    protected OffsetDateTime microsoftStoreForBusinessLastSuccessfulSyncDateTime;

    @JsonProperty("isEnabledForMicrosoftStoreForBusiness")
    protected Boolean isEnabledForMicrosoftStoreForBusiness;

    @JsonProperty("microsoftStoreForBusinessLanguage")
    protected String microsoftStoreForBusinessLanguage;

    @JsonProperty("microsoftStoreForBusinessLastCompletedApplicationSyncTime")
    protected OffsetDateTime microsoftStoreForBusinessLastCompletedApplicationSyncTime;

    @JsonProperty("microsoftStoreForBusinessPortalSelection")
    protected MicrosoftStoreForBusinessPortalSelectionOptions microsoftStoreForBusinessPortalSelection;

    protected DeviceAppManagement() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceAppManagement() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime microsoftStoreForBusinessLastSuccessfulSyncDateTime;
        private Boolean isEnabledForMicrosoftStoreForBusiness;
        private String microsoftStoreForBusinessLanguage;
        private OffsetDateTime microsoftStoreForBusinessLastCompletedApplicationSyncTime;
        private MicrosoftStoreForBusinessPortalSelectionOptions microsoftStoreForBusinessPortalSelection;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The last time the apps from the Microsoft Store for Business were synced
         * successfully for the account.”</i>
         * 
         * @param microsoftStoreForBusinessLastSuccessfulSyncDateTime
         *            value of {@code microsoftStoreForBusinessLastSuccessfulSyncDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftStoreForBusinessLastSuccessfulSyncDateTime(OffsetDateTime microsoftStoreForBusinessLastSuccessfulSyncDateTime) {
            this.microsoftStoreForBusinessLastSuccessfulSyncDateTime = microsoftStoreForBusinessLastSuccessfulSyncDateTime;
            this.changedFields = changedFields.add("microsoftStoreForBusinessLastSuccessfulSyncDateTime");
            return this;
        }

        /**
         * <i>“Whether the account is enabled for syncing applications from the Microsoft Store
         * for Business.”</i>
         * 
         * @param isEnabledForMicrosoftStoreForBusiness
         *            value of {@code isEnabledForMicrosoftStoreForBusiness} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isEnabledForMicrosoftStoreForBusiness(Boolean isEnabledForMicrosoftStoreForBusiness) {
            this.isEnabledForMicrosoftStoreForBusiness = isEnabledForMicrosoftStoreForBusiness;
            this.changedFields = changedFields.add("isEnabledForMicrosoftStoreForBusiness");
            return this;
        }

        /**
         * <i>“The locale information used to sync applications from the Microsoft Store for
         * Business. Cultures that are specific to a country/region. The names of these
         * cultures follow RFC 4646 (Windows Vista and later). The format is &amp;lt;languagecode2
         * &amp;gt;-&amp;lt;country/regioncode2&amp;gt;, where &amp;lt;languagecode2&amp;gt; is a lowercase two-letter code
         * derived from ISO 639-1 and &amp;lt;country/regioncode2&amp;gt; is an uppercase two-letter code
         * derived from ISO 3166. For example, en-US for English (United States) is a
         * specific culture.”</i>
         * 
         * @param microsoftStoreForBusinessLanguage
         *            value of {@code microsoftStoreForBusinessLanguage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftStoreForBusinessLanguage(String microsoftStoreForBusinessLanguage) {
            this.microsoftStoreForBusinessLanguage = microsoftStoreForBusinessLanguage;
            this.changedFields = changedFields.add("microsoftStoreForBusinessLanguage");
            return this;
        }

        /**
         * <i>“The last time an application sync from the Microsoft Store for Business was
         * completed.”</i>
         * 
         * @param microsoftStoreForBusinessLastCompletedApplicationSyncTime
         *            value of {@code microsoftStoreForBusinessLastCompletedApplicationSyncTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftStoreForBusinessLastCompletedApplicationSyncTime(OffsetDateTime microsoftStoreForBusinessLastCompletedApplicationSyncTime) {
            this.microsoftStoreForBusinessLastCompletedApplicationSyncTime = microsoftStoreForBusinessLastCompletedApplicationSyncTime;
            this.changedFields = changedFields.add("microsoftStoreForBusinessLastCompletedApplicationSyncTime");
            return this;
        }

        /**
         * <i>“The end user portal information is used to sync applications from the Microsoft
         * Store for Business to Intune Company Portal. There are three options to pick
         * from ['Company portal only', 'Company portal and private store', 'Private store
         * only']”</i>
         * 
         * @param microsoftStoreForBusinessPortalSelection
         *            value of {@code microsoftStoreForBusinessPortalSelection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftStoreForBusinessPortalSelection(MicrosoftStoreForBusinessPortalSelectionOptions microsoftStoreForBusinessPortalSelection) {
            this.microsoftStoreForBusinessPortalSelection = microsoftStoreForBusinessPortalSelection;
            this.changedFields = changedFields.add("microsoftStoreForBusinessPortalSelection");
            return this;
        }

        public DeviceAppManagement build() {
            DeviceAppManagement _x = new DeviceAppManagement();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceAppManagement";
            _x.id = id;
            _x.microsoftStoreForBusinessLastSuccessfulSyncDateTime = microsoftStoreForBusinessLastSuccessfulSyncDateTime;
            _x.isEnabledForMicrosoftStoreForBusiness = isEnabledForMicrosoftStoreForBusiness;
            _x.microsoftStoreForBusinessLanguage = microsoftStoreForBusinessLanguage;
            _x.microsoftStoreForBusinessLastCompletedApplicationSyncTime = microsoftStoreForBusinessLastCompletedApplicationSyncTime;
            _x.microsoftStoreForBusinessPortalSelection = microsoftStoreForBusinessPortalSelection;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The last time the apps from the Microsoft Store for Business were synced
     * successfully for the account.”</i>
     * 
     * @return property microsoftStoreForBusinessLastSuccessfulSyncDateTime
     */
    @Property(name="microsoftStoreForBusinessLastSuccessfulSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getMicrosoftStoreForBusinessLastSuccessfulSyncDateTime() {
        return Optional.ofNullable(microsoftStoreForBusinessLastSuccessfulSyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftStoreForBusinessLastSuccessfulSyncDateTime} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“The last time the apps from the Microsoft Store for Business were synced
     * successfully for the account.”</i>
     * 
     * @param microsoftStoreForBusinessLastSuccessfulSyncDateTime
     *            new value of {@code microsoftStoreForBusinessLastSuccessfulSyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftStoreForBusinessLastSuccessfulSyncDateTime} field changed
     */
    public DeviceAppManagement withMicrosoftStoreForBusinessLastSuccessfulSyncDateTime(OffsetDateTime microsoftStoreForBusinessLastSuccessfulSyncDateTime) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("microsoftStoreForBusinessLastSuccessfulSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.microsoftStoreForBusinessLastSuccessfulSyncDateTime = microsoftStoreForBusinessLastSuccessfulSyncDateTime;
        return _x;
    }

    /**
     * <i>“Whether the account is enabled for syncing applications from the Microsoft Store
     * for Business.”</i>
     * 
     * @return property isEnabledForMicrosoftStoreForBusiness
     */
    @Property(name="isEnabledForMicrosoftStoreForBusiness")
    @JsonIgnore
    public Optional<Boolean> getIsEnabledForMicrosoftStoreForBusiness() {
        return Optional.ofNullable(isEnabledForMicrosoftStoreForBusiness);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * isEnabledForMicrosoftStoreForBusiness} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Whether the account is enabled for syncing applications from the Microsoft Store
     * for Business.”</i>
     * 
     * @param isEnabledForMicrosoftStoreForBusiness
     *            new value of {@code isEnabledForMicrosoftStoreForBusiness} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isEnabledForMicrosoftStoreForBusiness} field changed
     */
    public DeviceAppManagement withIsEnabledForMicrosoftStoreForBusiness(Boolean isEnabledForMicrosoftStoreForBusiness) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("isEnabledForMicrosoftStoreForBusiness");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.isEnabledForMicrosoftStoreForBusiness = isEnabledForMicrosoftStoreForBusiness;
        return _x;
    }

    /**
     * <i>“The locale information used to sync applications from the Microsoft Store for
     * Business. Cultures that are specific to a country/region. The names of these
     * cultures follow RFC 4646 (Windows Vista and later). The format is &amp;lt;languagecode2
     * &amp;gt;-&amp;lt;country/regioncode2&amp;gt;, where &amp;lt;languagecode2&amp;gt; is a lowercase two-letter code
     * derived from ISO 639-1 and &amp;lt;country/regioncode2&amp;gt; is an uppercase two-letter code
     * derived from ISO 3166. For example, en-US for English (United States) is a
     * specific culture.”</i>
     * 
     * @return property microsoftStoreForBusinessLanguage
     */
    @Property(name="microsoftStoreForBusinessLanguage")
    @JsonIgnore
    public Optional<String> getMicrosoftStoreForBusinessLanguage() {
        return Optional.ofNullable(microsoftStoreForBusinessLanguage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftStoreForBusinessLanguage} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The locale information used to sync applications from the Microsoft Store for
     * Business. Cultures that are specific to a country/region. The names of these
     * cultures follow RFC 4646 (Windows Vista and later). The format is &amp;lt;languagecode2
     * &amp;gt;-&amp;lt;country/regioncode2&amp;gt;, where &amp;lt;languagecode2&amp;gt; is a lowercase two-letter code
     * derived from ISO 639-1 and &amp;lt;country/regioncode2&amp;gt; is an uppercase two-letter code
     * derived from ISO 3166. For example, en-US for English (United States) is a
     * specific culture.”</i>
     * 
     * @param microsoftStoreForBusinessLanguage
     *            new value of {@code microsoftStoreForBusinessLanguage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftStoreForBusinessLanguage} field changed
     */
    public DeviceAppManagement withMicrosoftStoreForBusinessLanguage(String microsoftStoreForBusinessLanguage) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("microsoftStoreForBusinessLanguage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.microsoftStoreForBusinessLanguage = microsoftStoreForBusinessLanguage;
        return _x;
    }

    /**
     * <i>“The last time an application sync from the Microsoft Store for Business was
     * completed.”</i>
     * 
     * @return property microsoftStoreForBusinessLastCompletedApplicationSyncTime
     */
    @Property(name="microsoftStoreForBusinessLastCompletedApplicationSyncTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getMicrosoftStoreForBusinessLastCompletedApplicationSyncTime() {
        return Optional.ofNullable(microsoftStoreForBusinessLastCompletedApplicationSyncTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftStoreForBusinessLastCompletedApplicationSyncTime} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“The last time an application sync from the Microsoft Store for Business was
     * completed.”</i>
     * 
     * @param microsoftStoreForBusinessLastCompletedApplicationSyncTime
     *            new value of {@code microsoftStoreForBusinessLastCompletedApplicationSyncTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftStoreForBusinessLastCompletedApplicationSyncTime} field changed
     */
    public DeviceAppManagement withMicrosoftStoreForBusinessLastCompletedApplicationSyncTime(OffsetDateTime microsoftStoreForBusinessLastCompletedApplicationSyncTime) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("microsoftStoreForBusinessLastCompletedApplicationSyncTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.microsoftStoreForBusinessLastCompletedApplicationSyncTime = microsoftStoreForBusinessLastCompletedApplicationSyncTime;
        return _x;
    }

    /**
     * <i>“The end user portal information is used to sync applications from the Microsoft
     * Store for Business to Intune Company Portal. There are three options to pick
     * from ['Company portal only', 'Company portal and private store', 'Private store
     * only']”</i>
     * 
     * @return property microsoftStoreForBusinessPortalSelection
     */
    @Property(name="microsoftStoreForBusinessPortalSelection")
    @JsonIgnore
    public Optional<MicrosoftStoreForBusinessPortalSelectionOptions> getMicrosoftStoreForBusinessPortalSelection() {
        return Optional.ofNullable(microsoftStoreForBusinessPortalSelection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftStoreForBusinessPortalSelection} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The end user portal information is used to sync applications from the Microsoft
     * Store for Business to Intune Company Portal. There are three options to pick
     * from ['Company portal only', 'Company portal and private store', 'Private store
     * only']”</i>
     * 
     * @param microsoftStoreForBusinessPortalSelection
     *            new value of {@code microsoftStoreForBusinessPortalSelection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftStoreForBusinessPortalSelection} field changed
     */
    public DeviceAppManagement withMicrosoftStoreForBusinessPortalSelection(MicrosoftStoreForBusinessPortalSelectionOptions microsoftStoreForBusinessPortalSelection) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("microsoftStoreForBusinessPortalSelection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.microsoftStoreForBusinessPortalSelection = microsoftStoreForBusinessPortalSelection;
        return _x;
    }

    /**
     * <i>“The Managed eBook.”</i>
     * 
     * @return navigational property managedEBooks
     */
    @NavigationProperty(name="managedEBooks")
    @JsonIgnore
    public ManagedEBookCollectionRequest getManagedEBooks() {
        return new ManagedEBookCollectionRequest(
                        contextPath.addSegment("managedEBooks"));
    }

    /**
     * <i>“The mobile apps.”</i>
     * 
     * @return navigational property mobileApps
     */
    @NavigationProperty(name="mobileApps")
    @JsonIgnore
    public MobileAppCollectionRequest getMobileApps() {
        return new MobileAppCollectionRequest(
                        contextPath.addSegment("mobileApps"));
    }

    /**
     * <i>“The mobile app categories.”</i>
     * 
     * @return navigational property mobileAppCategories
     */
    @NavigationProperty(name="mobileAppCategories")
    @JsonIgnore
    public MobileAppCategoryCollectionRequest getMobileAppCategories() {
        return new MobileAppCategoryCollectionRequest(
                        contextPath.addSegment("mobileAppCategories"));
    }

    /**
     * <i>“The Windows Enterprise Code Signing Certificate.”</i>
     * 
     * @return navigational property enterpriseCodeSigningCertificates
     */
    @NavigationProperty(name="enterpriseCodeSigningCertificates")
    @JsonIgnore
    public EnterpriseCodeSigningCertificateCollectionRequest getEnterpriseCodeSigningCertificates() {
        return new EnterpriseCodeSigningCertificateCollectionRequest(
                        contextPath.addSegment("enterpriseCodeSigningCertificates"));
    }

    /**
     * <i>“The IOS Lob App Provisioning Configurations.”</i>
     * 
     * @return navigational property iosLobAppProvisioningConfigurations
     */
    @NavigationProperty(name="iosLobAppProvisioningConfigurations")
    @JsonIgnore
    public IosLobAppProvisioningConfigurationCollectionRequest getIosLobAppProvisioningConfigurations() {
        return new IosLobAppProvisioningConfigurationCollectionRequest(
                        contextPath.addSegment("iosLobAppProvisioningConfigurations"));
    }

    /**
     * <i>“The WinPhone Symantec Code Signing Certificate.”</i>
     * 
     * @return navigational property symantecCodeSigningCertificate
     */
    @NavigationProperty(name="symantecCodeSigningCertificate")
    @JsonIgnore
    public SymantecCodeSigningCertificateRequest getSymantecCodeSigningCertificate() {
        return new SymantecCodeSigningCertificateRequest(contextPath.addSegment("symantecCodeSigningCertificate"));
    }

    /**
     * <i>“The Managed Device Mobile Application Configurations.”</i>
     * 
     * @return navigational property mobileAppConfigurations
     */
    @NavigationProperty(name="mobileAppConfigurations")
    @JsonIgnore
    public ManagedDeviceMobileAppConfigurationCollectionRequest getMobileAppConfigurations() {
        return new ManagedDeviceMobileAppConfigurationCollectionRequest(
                        contextPath.addSegment("mobileAppConfigurations"));
    }

    /**
     * <i>“The mobile eBook categories.”</i>
     * 
     * @return navigational property managedEBookCategories
     */
    @NavigationProperty(name="managedEBookCategories")
    @JsonIgnore
    public ManagedEBookCategoryCollectionRequest getManagedEBookCategories() {
        return new ManagedEBookCategoryCollectionRequest(
                        contextPath.addSegment("managedEBookCategories"));
    }

    /**
     * <i>“The PolicySet of Policies and Applications”</i>
     * 
     * @return navigational property policySets
     */
    @NavigationProperty(name="policySets")
    @JsonIgnore
    public PolicySetCollectionRequest getPolicySets() {
        return new PolicySetCollectionRequest(
                        contextPath.addSegment("policySets"));
    }

    /**
     * <i>“Side Loading Keys that are required for the Windows 8 and 8.1 Apps installation.”</i>
     * 
     * @return navigational property sideLoadingKeys
     */
    @NavigationProperty(name="sideLoadingKeys")
    @JsonIgnore
    public SideLoadingKeyCollectionRequest getSideLoadingKeys() {
        return new SideLoadingKeyCollectionRequest(
                        contextPath.addSegment("sideLoadingKeys"));
    }

    /**
     * <i>“List of Vpp tokens for this organization.”</i>
     * 
     * @return navigational property vppTokens
     */
    @NavigationProperty(name="vppTokens")
    @JsonIgnore
    public VppTokenCollectionRequest getVppTokens() {
        return new VppTokenCollectionRequest(
                        contextPath.addSegment("vppTokens"));
    }

    /**
     * <i>“Windows management app.”</i>
     * 
     * @return navigational property windowsManagementApp
     */
    @NavigationProperty(name="windowsManagementApp")
    @JsonIgnore
    public WindowsManagementAppRequest getWindowsManagementApp() {
        return new WindowsManagementAppRequest(contextPath.addSegment("windowsManagementApp"));
    }

    /**
     * <i>“Managed app policies.”</i>
     * 
     * @return navigational property managedAppPolicies
     */
    @NavigationProperty(name="managedAppPolicies")
    @JsonIgnore
    public ManagedAppPolicyCollectionRequest getManagedAppPolicies() {
        return new ManagedAppPolicyCollectionRequest(
                        contextPath.addSegment("managedAppPolicies"));
    }

    /**
     * <i>“iOS managed app policies.”</i>
     * 
     * @return navigational property iosManagedAppProtections
     */
    @NavigationProperty(name="iosManagedAppProtections")
    @JsonIgnore
    public IosManagedAppProtectionCollectionRequest getIosManagedAppProtections() {
        return new IosManagedAppProtectionCollectionRequest(
                        contextPath.addSegment("iosManagedAppProtections"));
    }

    /**
     * <i>“Android managed app policies.”</i>
     * 
     * @return navigational property androidManagedAppProtections
     */
    @NavigationProperty(name="androidManagedAppProtections")
    @JsonIgnore
    public AndroidManagedAppProtectionCollectionRequest getAndroidManagedAppProtections() {
        return new AndroidManagedAppProtectionCollectionRequest(
                        contextPath.addSegment("androidManagedAppProtections"));
    }

    /**
     * <i>“Default managed app policies.”</i>
     * 
     * @return navigational property defaultManagedAppProtections
     */
    @NavigationProperty(name="defaultManagedAppProtections")
    @JsonIgnore
    public DefaultManagedAppProtectionCollectionRequest getDefaultManagedAppProtections() {
        return new DefaultManagedAppProtectionCollectionRequest(
                        contextPath.addSegment("defaultManagedAppProtections"));
    }

    /**
     * <i>“Targeted managed app configurations.”</i>
     * 
     * @return navigational property targetedManagedAppConfigurations
     */
    @NavigationProperty(name="targetedManagedAppConfigurations")
    @JsonIgnore
    public TargetedManagedAppConfigurationCollectionRequest getTargetedManagedAppConfigurations() {
        return new TargetedManagedAppConfigurationCollectionRequest(
                        contextPath.addSegment("targetedManagedAppConfigurations"));
    }

    /**
     * <i>“Windows information protection for apps running on devices which are MDM
     * enrolled.”</i>
     * 
     * @return navigational property mdmWindowsInformationProtectionPolicies
     */
    @NavigationProperty(name="mdmWindowsInformationProtectionPolicies")
    @JsonIgnore
    public MdmWindowsInformationProtectionPolicyCollectionRequest getMdmWindowsInformationProtectionPolicies() {
        return new MdmWindowsInformationProtectionPolicyCollectionRequest(
                        contextPath.addSegment("mdmWindowsInformationProtectionPolicies"));
    }

    /**
     * <i>“Windows information protection for apps running on devices which are not MDM
     * enrolled.”</i>
     * 
     * @return navigational property windowsInformationProtectionPolicies
     */
    @NavigationProperty(name="windowsInformationProtectionPolicies")
    @JsonIgnore
    public WindowsInformationProtectionPolicyCollectionRequest getWindowsInformationProtectionPolicies() {
        return new WindowsInformationProtectionPolicyCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionPolicies"));
    }

    /**
     * <i>“The managed app registrations.”</i>
     * 
     * @return navigational property managedAppRegistrations
     */
    @NavigationProperty(name="managedAppRegistrations")
    @JsonIgnore
    public ManagedAppRegistrationCollectionRequest getManagedAppRegistrations() {
        return new ManagedAppRegistrationCollectionRequest(
                        contextPath.addSegment("managedAppRegistrations"));
    }

    /**
     * <i>“The managed app statuses.”</i>
     * 
     * @return navigational property managedAppStatuses
     */
    @NavigationProperty(name="managedAppStatuses")
    @JsonIgnore
    public ManagedAppStatusCollectionRequest getManagedAppStatuses() {
        return new ManagedAppStatusCollectionRequest(
                        contextPath.addSegment("managedAppStatuses"));
    }

    /**
     * <i>“Windows information protection device registrations that are not MDM enrolled.”</i>
     * 
     * @return navigational property windowsInformationProtectionDeviceRegistrations
     */
    @NavigationProperty(name="windowsInformationProtectionDeviceRegistrations")
    @JsonIgnore
    public WindowsInformationProtectionDeviceRegistrationCollectionRequest getWindowsInformationProtectionDeviceRegistrations() {
        return new WindowsInformationProtectionDeviceRegistrationCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionDeviceRegistrations"));
    }

    /**
     * <i>“Windows information protection wipe actions.”</i>
     * 
     * @return navigational property windowsInformationProtectionWipeActions
     */
    @NavigationProperty(name="windowsInformationProtectionWipeActions")
    @JsonIgnore
    public WindowsInformationProtectionWipeActionCollectionRequest getWindowsInformationProtectionWipeActions() {
        return new WindowsInformationProtectionWipeActionCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionWipeActions"));
    }

    /**
     * <i>“Device app management tasks.”</i>
     * 
     * @return navigational property deviceAppManagementTasks
     */
    @NavigationProperty(name="deviceAppManagementTasks")
    @JsonIgnore
    public DeviceAppManagementTaskCollectionRequest getDeviceAppManagementTasks() {
        return new DeviceAppManagementTaskCollectionRequest(
                        contextPath.addSegment("deviceAppManagementTasks"));
    }

    /**
     * <i>“The collection of Windows Defender Application Control Supplemental Policies.”</i>
     * 
     * @return navigational property wdacSupplementalPolicies
     */
    @NavigationProperty(name="wdacSupplementalPolicies")
    @JsonIgnore
    public WindowsDefenderApplicationControlSupplementalPolicyCollectionRequest getWdacSupplementalPolicies() {
        return new WindowsDefenderApplicationControlSupplementalPolicyCollectionRequest(
                        contextPath.addSegment("wdacSupplementalPolicies"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceAppManagement patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceAppManagement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceAppManagement put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceAppManagement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceAppManagement _copy() {
        DeviceAppManagement _x = new DeviceAppManagement();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.microsoftStoreForBusinessLastSuccessfulSyncDateTime = microsoftStoreForBusinessLastSuccessfulSyncDateTime;
        _x.isEnabledForMicrosoftStoreForBusiness = isEnabledForMicrosoftStoreForBusiness;
        _x.microsoftStoreForBusinessLanguage = microsoftStoreForBusinessLanguage;
        _x.microsoftStoreForBusinessLastCompletedApplicationSyncTime = microsoftStoreForBusinessLastCompletedApplicationSyncTime;
        _x.microsoftStoreForBusinessPortalSelection = microsoftStoreForBusinessPortalSelection;
        return _x;
    }

    @Action(name = "syncMicrosoftStoreForBusinessApps")
    @JsonIgnore
    public ActionRequestNoReturn syncMicrosoftStoreForBusinessApps() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.syncMicrosoftStoreForBusinessApps"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceAppManagement[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("microsoftStoreForBusinessLastSuccessfulSyncDateTime=");
        b.append(this.microsoftStoreForBusinessLastSuccessfulSyncDateTime);
        b.append(", ");
        b.append("isEnabledForMicrosoftStoreForBusiness=");
        b.append(this.isEnabledForMicrosoftStoreForBusiness);
        b.append(", ");
        b.append("microsoftStoreForBusinessLanguage=");
        b.append(this.microsoftStoreForBusinessLanguage);
        b.append(", ");
        b.append("microsoftStoreForBusinessLastCompletedApplicationSyncTime=");
        b.append(this.microsoftStoreForBusinessLastCompletedApplicationSyncTime);
        b.append(", ");
        b.append("microsoftStoreForBusinessPortalSelection=");
        b.append(this.microsoftStoreForBusinessPortalSelection);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
