package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.List;

import odata.msgraph.client.beta.complex.RolePermission;


/**
 * <i>“The Role Definition resource. The role definition is the foundation of role
 * based access in Intune. The role combines an Intune resource such as a Mobile
 * App and associated role permissions such as Create or Read for the resource.
 * There are two types of roles, built-in and custom. Built-in roles cannot be
 * modified. Both built-in roles and custom roles must have assignments to be
 * enforced. Create custom roles if you want to define a role that allows any of
 * the available resources and role permissions to be combined into a single role.”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class DeviceAndAppManagementRoleDefinition extends RoleDefinition implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceAndAppManagementRoleDefinition";
    }

    protected DeviceAndAppManagementRoleDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceAndAppManagementRoleDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private List<RolePermission> permissions;
        private String permissionsNextLink;
        private List<RolePermission> rolePermissions;
        private String rolePermissionsNextLink;
        private Boolean isBuiltInRoleDefinition;
        private Boolean isBuiltIn;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder permissions(List<RolePermission> permissions) {
            this.permissions = permissions;
            this.changedFields = changedFields.add("permissions");
            return this;
        }

        public Builder permissions(RolePermission... permissions) {
            return permissions(Arrays.asList(permissions));
        }

        public Builder permissionsNextLink(String permissionsNextLink) {
            this.permissionsNextLink = permissionsNextLink;
            this.changedFields = changedFields.add("permissions");
            return this;
        }

        public Builder rolePermissions(List<RolePermission> rolePermissions) {
            this.rolePermissions = rolePermissions;
            this.changedFields = changedFields.add("rolePermissions");
            return this;
        }

        public Builder rolePermissions(RolePermission... rolePermissions) {
            return rolePermissions(Arrays.asList(rolePermissions));
        }

        public Builder rolePermissionsNextLink(String rolePermissionsNextLink) {
            this.rolePermissionsNextLink = rolePermissionsNextLink;
            this.changedFields = changedFields.add("rolePermissions");
            return this;
        }

        public Builder isBuiltInRoleDefinition(Boolean isBuiltInRoleDefinition) {
            this.isBuiltInRoleDefinition = isBuiltInRoleDefinition;
            this.changedFields = changedFields.add("isBuiltInRoleDefinition");
            return this;
        }

        public Builder isBuiltIn(Boolean isBuiltIn) {
            this.isBuiltIn = isBuiltIn;
            this.changedFields = changedFields.add("isBuiltIn");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public DeviceAndAppManagementRoleDefinition build() {
            DeviceAndAppManagementRoleDefinition _x = new DeviceAndAppManagementRoleDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceAndAppManagementRoleDefinition";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.permissions = permissions;
            _x.permissionsNextLink = permissionsNextLink;
            _x.rolePermissions = rolePermissions;
            _x.rolePermissionsNextLink = rolePermissionsNextLink;
            _x.isBuiltInRoleDefinition = isBuiltInRoleDefinition;
            _x.isBuiltIn = isBuiltIn;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceAndAppManagementRoleDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceAndAppManagementRoleDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceAndAppManagementRoleDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceAndAppManagementRoleDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceAndAppManagementRoleDefinition _copy() {
        DeviceAndAppManagementRoleDefinition _x = new DeviceAndAppManagementRoleDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.permissions = permissions;
        _x.rolePermissions = rolePermissions;
        _x.isBuiltInRoleDefinition = isBuiltInRoleDefinition;
        _x.isBuiltIn = isBuiltIn;
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceAndAppManagementRoleDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("permissions=");
        b.append(this.permissions);
        b.append(", ");
        b.append("rolePermissions=");
        b.append(this.rolePermissions);
        b.append(", ");
        b.append("isBuiltInRoleDefinition=");
        b.append(this.isBuiltInRoleDefinition);
        b.append(", ");
        b.append("isBuiltIn=");
        b.append(this.isBuiltIn);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
