package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AlternativeSecurityId;
import odata.msgraph.client.beta.complex.OnPremisesExtensionAttributes;
import odata.msgraph.client.beta.entity.collection.request.CommandCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "accountEnabled", 
    "alternativeSecurityIds", 
    "approximateLastSignInDateTime", 
    "complianceExpirationDateTime", 
    "deviceId", 
    "deviceMetadata", 
    "deviceVersion", 
    "displayName", 
    "extensionAttributes", 
    "isCompliant", 
    "isManaged", 
    "onPremisesLastSyncDateTime", 
    "onPremisesSyncEnabled", 
    "operatingSystem", 
    "operatingSystemVersion", 
    "physicalIds", 
    "profileType", 
    "systemLabels", 
    "trustType", 
    "Name", 
    "Manufacturer", 
    "Model", 
    "Kind", 
    "Status", 
    "Platform"})
@JsonInclude(Include.NON_NULL)
public class Device extends DirectoryObject implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.device";
    }

    @JsonProperty("accountEnabled")
    protected Boolean accountEnabled;

    @JsonProperty("alternativeSecurityIds")
    protected List<AlternativeSecurityId> alternativeSecurityIds;

    @JsonProperty("alternativeSecurityIds@nextLink")
    protected String alternativeSecurityIdsNextLink;

    @JsonProperty("approximateLastSignInDateTime")
    protected OffsetDateTime approximateLastSignInDateTime;

    @JsonProperty("complianceExpirationDateTime")
    protected OffsetDateTime complianceExpirationDateTime;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("deviceMetadata")
    protected String deviceMetadata;

    @JsonProperty("deviceVersion")
    protected Integer deviceVersion;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("extensionAttributes")
    protected OnPremisesExtensionAttributes extensionAttributes;

    @JsonProperty("isCompliant")
    protected Boolean isCompliant;

    @JsonProperty("isManaged")
    protected Boolean isManaged;

    @JsonProperty("onPremisesLastSyncDateTime")
    protected OffsetDateTime onPremisesLastSyncDateTime;

    @JsonProperty("onPremisesSyncEnabled")
    protected Boolean onPremisesSyncEnabled;

    @JsonProperty("operatingSystem")
    protected String operatingSystem;

    @JsonProperty("operatingSystemVersion")
    protected String operatingSystemVersion;

    @JsonProperty("physicalIds")
    protected List<String> physicalIds;

    @JsonProperty("physicalIds@nextLink")
    protected String physicalIdsNextLink;

    @JsonProperty("profileType")
    protected String profileType;

    @JsonProperty("systemLabels")
    protected List<String> systemLabels;

    @JsonProperty("systemLabels@nextLink")
    protected String systemLabelsNextLink;

    @JsonProperty("trustType")
    protected String trustType;

    @JsonProperty("Name")
    protected String name;

    @JsonProperty("Manufacturer")
    protected String manufacturer;

    @JsonProperty("Model")
    protected String model;

    @JsonProperty("Kind")
    protected String kind;

    @JsonProperty("Status")
    protected String status;

    @JsonProperty("Platform")
    protected String platform;

    protected Device() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDevice() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private Boolean accountEnabled;
        private List<AlternativeSecurityId> alternativeSecurityIds;
        private String alternativeSecurityIdsNextLink;
        private OffsetDateTime approximateLastSignInDateTime;
        private OffsetDateTime complianceExpirationDateTime;
        private String deviceId;
        private String deviceMetadata;
        private Integer deviceVersion;
        private String displayName;
        private OnPremisesExtensionAttributes extensionAttributes;
        private Boolean isCompliant;
        private Boolean isManaged;
        private OffsetDateTime onPremisesLastSyncDateTime;
        private Boolean onPremisesSyncEnabled;
        private String operatingSystem;
        private String operatingSystemVersion;
        private List<String> physicalIds;
        private String physicalIdsNextLink;
        private String profileType;
        private List<String> systemLabels;
        private String systemLabelsNextLink;
        private String trustType;
        private String name;
        private String manufacturer;
        private String model;
        private String kind;
        private String status;
        private String platform;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder accountEnabled(Boolean accountEnabled) {
            this.accountEnabled = accountEnabled;
            this.changedFields = changedFields.add("accountEnabled");
            return this;
        }

        public Builder alternativeSecurityIds(List<AlternativeSecurityId> alternativeSecurityIds) {
            this.alternativeSecurityIds = alternativeSecurityIds;
            this.changedFields = changedFields.add("alternativeSecurityIds");
            return this;
        }

        public Builder alternativeSecurityIds(AlternativeSecurityId... alternativeSecurityIds) {
            return alternativeSecurityIds(Arrays.asList(alternativeSecurityIds));
        }

        public Builder alternativeSecurityIdsNextLink(String alternativeSecurityIdsNextLink) {
            this.alternativeSecurityIdsNextLink = alternativeSecurityIdsNextLink;
            this.changedFields = changedFields.add("alternativeSecurityIds");
            return this;
        }

        public Builder approximateLastSignInDateTime(OffsetDateTime approximateLastSignInDateTime) {
            this.approximateLastSignInDateTime = approximateLastSignInDateTime;
            this.changedFields = changedFields.add("approximateLastSignInDateTime");
            return this;
        }

        public Builder complianceExpirationDateTime(OffsetDateTime complianceExpirationDateTime) {
            this.complianceExpirationDateTime = complianceExpirationDateTime;
            this.changedFields = changedFields.add("complianceExpirationDateTime");
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        public Builder deviceMetadata(String deviceMetadata) {
            this.deviceMetadata = deviceMetadata;
            this.changedFields = changedFields.add("deviceMetadata");
            return this;
        }

        public Builder deviceVersion(Integer deviceVersion) {
            this.deviceVersion = deviceVersion;
            this.changedFields = changedFields.add("deviceVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder extensionAttributes(OnPremisesExtensionAttributes extensionAttributes) {
            this.extensionAttributes = extensionAttributes;
            this.changedFields = changedFields.add("extensionAttributes");
            return this;
        }

        public Builder isCompliant(Boolean isCompliant) {
            this.isCompliant = isCompliant;
            this.changedFields = changedFields.add("isCompliant");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("isManaged");
            return this;
        }

        public Builder onPremisesLastSyncDateTime(OffsetDateTime onPremisesLastSyncDateTime) {
            this.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
            this.changedFields = changedFields.add("onPremisesLastSyncDateTime");
            return this;
        }

        public Builder onPremisesSyncEnabled(Boolean onPremisesSyncEnabled) {
            this.onPremisesSyncEnabled = onPremisesSyncEnabled;
            this.changedFields = changedFields.add("onPremisesSyncEnabled");
            return this;
        }

        public Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.changedFields = changedFields.add("operatingSystem");
            return this;
        }

        public Builder operatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            this.changedFields = changedFields.add("operatingSystemVersion");
            return this;
        }

        public Builder physicalIds(List<String> physicalIds) {
            this.physicalIds = physicalIds;
            this.changedFields = changedFields.add("physicalIds");
            return this;
        }

        public Builder physicalIds(String... physicalIds) {
            return physicalIds(Arrays.asList(physicalIds));
        }

        public Builder physicalIdsNextLink(String physicalIdsNextLink) {
            this.physicalIdsNextLink = physicalIdsNextLink;
            this.changedFields = changedFields.add("physicalIds");
            return this;
        }

        public Builder profileType(String profileType) {
            this.profileType = profileType;
            this.changedFields = changedFields.add("profileType");
            return this;
        }

        public Builder systemLabels(List<String> systemLabels) {
            this.systemLabels = systemLabels;
            this.changedFields = changedFields.add("systemLabels");
            return this;
        }

        public Builder systemLabels(String... systemLabels) {
            return systemLabels(Arrays.asList(systemLabels));
        }

        public Builder systemLabelsNextLink(String systemLabelsNextLink) {
            this.systemLabelsNextLink = systemLabelsNextLink;
            this.changedFields = changedFields.add("systemLabels");
            return this;
        }

        public Builder trustType(String trustType) {
            this.trustType = trustType;
            this.changedFields = changedFields.add("trustType");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("Manufacturer");
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("Model");
            return this;
        }

        public Builder kind(String kind) {
            this.kind = kind;
            this.changedFields = changedFields.add("Kind");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("Status");
            return this;
        }

        public Builder platform(String platform) {
            this.platform = platform;
            this.changedFields = changedFields.add("Platform");
            return this;
        }

        public Device build() {
            Device _x = new Device();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.device";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.accountEnabled = accountEnabled;
            _x.alternativeSecurityIds = alternativeSecurityIds;
            _x.alternativeSecurityIdsNextLink = alternativeSecurityIdsNextLink;
            _x.approximateLastSignInDateTime = approximateLastSignInDateTime;
            _x.complianceExpirationDateTime = complianceExpirationDateTime;
            _x.deviceId = deviceId;
            _x.deviceMetadata = deviceMetadata;
            _x.deviceVersion = deviceVersion;
            _x.displayName = displayName;
            _x.extensionAttributes = extensionAttributes;
            _x.isCompliant = isCompliant;
            _x.isManaged = isManaged;
            _x.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
            _x.onPremisesSyncEnabled = onPremisesSyncEnabled;
            _x.operatingSystem = operatingSystem;
            _x.operatingSystemVersion = operatingSystemVersion;
            _x.physicalIds = physicalIds;
            _x.physicalIdsNextLink = physicalIdsNextLink;
            _x.profileType = profileType;
            _x.systemLabels = systemLabels;
            _x.systemLabelsNextLink = systemLabelsNextLink;
            _x.trustType = trustType;
            _x.name = name;
            _x.manufacturer = manufacturer;
            _x.model = model;
            _x.kind = kind;
            _x.status = status;
            _x.platform = platform;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="accountEnabled")
    @JsonIgnore
    public Optional<Boolean> getAccountEnabled() {
        return Optional.ofNullable(accountEnabled);
    }

    public Device withAccountEnabled(Boolean accountEnabled) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("accountEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.accountEnabled = accountEnabled;
        return _x;
    }

    @Property(name="alternativeSecurityIds")
    @JsonIgnore
    public CollectionPage<AlternativeSecurityId> getAlternativeSecurityIds() {
        return new CollectionPage<AlternativeSecurityId>(contextPath, AlternativeSecurityId.class, alternativeSecurityIds, Optional.ofNullable(alternativeSecurityIdsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="alternativeSecurityIds")
    @JsonIgnore
    public CollectionPage<AlternativeSecurityId> getAlternativeSecurityIds(HttpRequestOptions options) {
        return new CollectionPage<AlternativeSecurityId>(contextPath, AlternativeSecurityId.class, alternativeSecurityIds, Optional.ofNullable(alternativeSecurityIdsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="approximateLastSignInDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getApproximateLastSignInDateTime() {
        return Optional.ofNullable(approximateLastSignInDateTime);
    }

    public Device withApproximateLastSignInDateTime(OffsetDateTime approximateLastSignInDateTime) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("approximateLastSignInDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.approximateLastSignInDateTime = approximateLastSignInDateTime;
        return _x;
    }

    @Property(name="complianceExpirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getComplianceExpirationDateTime() {
        return Optional.ofNullable(complianceExpirationDateTime);
    }

    public Device withComplianceExpirationDateTime(OffsetDateTime complianceExpirationDateTime) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("complianceExpirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.complianceExpirationDateTime = complianceExpirationDateTime;
        return _x;
    }

    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    public Device withDeviceId(String deviceId) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.deviceId = deviceId;
        return _x;
    }

    @Property(name="deviceMetadata")
    @JsonIgnore
    public Optional<String> getDeviceMetadata() {
        return Optional.ofNullable(deviceMetadata);
    }

    public Device withDeviceMetadata(String deviceMetadata) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("deviceMetadata");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.deviceMetadata = deviceMetadata;
        return _x;
    }

    @Property(name="deviceVersion")
    @JsonIgnore
    public Optional<Integer> getDeviceVersion() {
        return Optional.ofNullable(deviceVersion);
    }

    public Device withDeviceVersion(Integer deviceVersion) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("deviceVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.deviceVersion = deviceVersion;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Device withDisplayName(String displayName) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="extensionAttributes")
    @JsonIgnore
    public Optional<OnPremisesExtensionAttributes> getExtensionAttributes() {
        return Optional.ofNullable(extensionAttributes);
    }

    public Device withExtensionAttributes(OnPremisesExtensionAttributes extensionAttributes) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("extensionAttributes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.extensionAttributes = extensionAttributes;
        return _x;
    }

    @Property(name="isCompliant")
    @JsonIgnore
    public Optional<Boolean> getIsCompliant() {
        return Optional.ofNullable(isCompliant);
    }

    public Device withIsCompliant(Boolean isCompliant) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("isCompliant");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.isCompliant = isCompliant;
        return _x;
    }

    @Property(name="isManaged")
    @JsonIgnore
    public Optional<Boolean> getIsManaged() {
        return Optional.ofNullable(isManaged);
    }

    public Device withIsManaged(Boolean isManaged) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("isManaged");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.isManaged = isManaged;
        return _x;
    }

    @Property(name="onPremisesLastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOnPremisesLastSyncDateTime() {
        return Optional.ofNullable(onPremisesLastSyncDateTime);
    }

    public Device withOnPremisesLastSyncDateTime(OffsetDateTime onPremisesLastSyncDateTime) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("onPremisesLastSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
        return _x;
    }

    @Property(name="onPremisesSyncEnabled")
    @JsonIgnore
    public Optional<Boolean> getOnPremisesSyncEnabled() {
        return Optional.ofNullable(onPremisesSyncEnabled);
    }

    public Device withOnPremisesSyncEnabled(Boolean onPremisesSyncEnabled) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("onPremisesSyncEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.onPremisesSyncEnabled = onPremisesSyncEnabled;
        return _x;
    }

    @Property(name="operatingSystem")
    @JsonIgnore
    public Optional<String> getOperatingSystem() {
        return Optional.ofNullable(operatingSystem);
    }

    public Device withOperatingSystem(String operatingSystem) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("operatingSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.operatingSystem = operatingSystem;
        return _x;
    }

    @Property(name="operatingSystemVersion")
    @JsonIgnore
    public Optional<String> getOperatingSystemVersion() {
        return Optional.ofNullable(operatingSystemVersion);
    }

    public Device withOperatingSystemVersion(String operatingSystemVersion) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("operatingSystemVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.operatingSystemVersion = operatingSystemVersion;
        return _x;
    }

    @Property(name="physicalIds")
    @JsonIgnore
    public CollectionPage<String> getPhysicalIds() {
        return new CollectionPage<String>(contextPath, String.class, physicalIds, Optional.ofNullable(physicalIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="physicalIds")
    @JsonIgnore
    public CollectionPage<String> getPhysicalIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, physicalIds, Optional.ofNullable(physicalIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="profileType")
    @JsonIgnore
    public Optional<String> getProfileType() {
        return Optional.ofNullable(profileType);
    }

    public Device withProfileType(String profileType) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("profileType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.profileType = profileType;
        return _x;
    }

    @Property(name="systemLabels")
    @JsonIgnore
    public CollectionPage<String> getSystemLabels() {
        return new CollectionPage<String>(contextPath, String.class, systemLabels, Optional.ofNullable(systemLabelsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="systemLabels")
    @JsonIgnore
    public CollectionPage<String> getSystemLabels(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, systemLabels, Optional.ofNullable(systemLabelsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="trustType")
    @JsonIgnore
    public Optional<String> getTrustType() {
        return Optional.ofNullable(trustType);
    }

    public Device withTrustType(String trustType) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("trustType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.trustType = trustType;
        return _x;
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Device withName(String name) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("Name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.name = name;
        return _x;
    }

    @Property(name="Manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    public Device withManufacturer(String manufacturer) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("Manufacturer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.manufacturer = manufacturer;
        return _x;
    }

    @Property(name="Model")
    @JsonIgnore
    public Optional<String> getModel() {
        return Optional.ofNullable(model);
    }

    public Device withModel(String model) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("Model");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.model = model;
        return _x;
    }

    @Property(name="Kind")
    @JsonIgnore
    public Optional<String> getKind() {
        return Optional.ofNullable(kind);
    }

    public Device withKind(String kind) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("Kind");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.kind = kind;
        return _x;
    }

    @Property(name="Status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public Device withStatus(String status) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("Status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.status = status;
        return _x;
    }

    @Property(name="Platform")
    @JsonIgnore
    public Optional<String> getPlatform() {
        return Optional.ofNullable(platform);
    }

    public Device withPlatform(String platform) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("Platform");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.platform = platform;
        return _x;
    }

    @NavigationProperty(name="memberOf")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getMemberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("memberOf"));
    }

    @NavigationProperty(name="registeredOwners")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getRegisteredOwners() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("registeredOwners"));
    }

    @NavigationProperty(name="registeredUsers")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getRegisteredUsers() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("registeredUsers"));
    }

    @NavigationProperty(name="transitiveMemberOf")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getTransitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("transitiveMemberOf"));
    }

    @NavigationProperty(name="extensions")
    @JsonIgnore
    public ExtensionCollectionRequest getExtensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"));
    }

    @NavigationProperty(name="commands")
    @JsonIgnore
    public CommandCollectionRequest getCommands() {
        return new CommandCollectionRequest(
                        contextPath.addSegment("commands"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Device patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Device _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Device put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Device _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Device _copy() {
        Device _x = new Device();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.accountEnabled = accountEnabled;
        _x.alternativeSecurityIds = alternativeSecurityIds;
        _x.approximateLastSignInDateTime = approximateLastSignInDateTime;
        _x.complianceExpirationDateTime = complianceExpirationDateTime;
        _x.deviceId = deviceId;
        _x.deviceMetadata = deviceMetadata;
        _x.deviceVersion = deviceVersion;
        _x.displayName = displayName;
        _x.extensionAttributes = extensionAttributes;
        _x.isCompliant = isCompliant;
        _x.isManaged = isManaged;
        _x.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
        _x.onPremisesSyncEnabled = onPremisesSyncEnabled;
        _x.operatingSystem = operatingSystem;
        _x.operatingSystemVersion = operatingSystemVersion;
        _x.physicalIds = physicalIds;
        _x.profileType = profileType;
        _x.systemLabels = systemLabels;
        _x.trustType = trustType;
        _x.name = name;
        _x.manufacturer = manufacturer;
        _x.model = model;
        _x.kind = kind;
        _x.status = status;
        _x.platform = platform;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Device[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("accountEnabled=");
        b.append(this.accountEnabled);
        b.append(", ");
        b.append("alternativeSecurityIds=");
        b.append(this.alternativeSecurityIds);
        b.append(", ");
        b.append("approximateLastSignInDateTime=");
        b.append(this.approximateLastSignInDateTime);
        b.append(", ");
        b.append("complianceExpirationDateTime=");
        b.append(this.complianceExpirationDateTime);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("deviceMetadata=");
        b.append(this.deviceMetadata);
        b.append(", ");
        b.append("deviceVersion=");
        b.append(this.deviceVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("extensionAttributes=");
        b.append(this.extensionAttributes);
        b.append(", ");
        b.append("isCompliant=");
        b.append(this.isCompliant);
        b.append(", ");
        b.append("isManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("onPremisesLastSyncDateTime=");
        b.append(this.onPremisesLastSyncDateTime);
        b.append(", ");
        b.append("onPremisesSyncEnabled=");
        b.append(this.onPremisesSyncEnabled);
        b.append(", ");
        b.append("operatingSystem=");
        b.append(this.operatingSystem);
        b.append(", ");
        b.append("operatingSystemVersion=");
        b.append(this.operatingSystemVersion);
        b.append(", ");
        b.append("physicalIds=");
        b.append(this.physicalIds);
        b.append(", ");
        b.append("profileType=");
        b.append(this.profileType);
        b.append(", ");
        b.append("systemLabels=");
        b.append(this.systemLabels);
        b.append(", ");
        b.append("trustType=");
        b.append(this.trustType);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("Manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("Model=");
        b.append(this.model);
        b.append(", ");
        b.append("Kind=");
        b.append(this.kind);
        b.append(", ");
        b.append("Status=");
        b.append(this.status);
        b.append(", ");
        b.append("Platform=");
        b.append(this.platform);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
