package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.EnrollmentProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ImportedAppleDeviceIdentityCollectionRequest;
import odata.msgraph.client.beta.entity.request.DepIOSEnrollmentProfileRequest;
import odata.msgraph.client.beta.entity.request.DepMacOSEnrollmentProfileRequest;
import odata.msgraph.client.beta.enums.DepTokenType;


/**
 * <i>“The depOnboardingSetting represents an instance of the Apple DEP service being
 * onboarded to Intune. The onboarded service instance manages an Apple Token used
 * to synchronize data between Apple and Intune.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appleIdentifier", 
    "tokenExpirationDateTime", 
    "lastModifiedDateTime", 
    "lastSuccessfulSyncDateTime", 
    "lastSyncTriggeredDateTime", 
    "shareTokenWithSchoolDataSyncService", 
    "lastSyncErrorCode", 
    "tokenType", 
    "tokenName", 
    "syncedDeviceCount", 
    "dataSharingConsentGranted", 
    "roleScopeTagIds"})
@JsonInclude(Include.NON_NULL)
public class DepOnboardingSetting extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.depOnboardingSetting";
    }

    @JsonProperty("appleIdentifier")
    protected String appleIdentifier;

    @JsonProperty("tokenExpirationDateTime")
    protected OffsetDateTime tokenExpirationDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("lastSuccessfulSyncDateTime")
    protected OffsetDateTime lastSuccessfulSyncDateTime;

    @JsonProperty("lastSyncTriggeredDateTime")
    protected OffsetDateTime lastSyncTriggeredDateTime;

    @JsonProperty("shareTokenWithSchoolDataSyncService")
    protected Boolean shareTokenWithSchoolDataSyncService;

    @JsonProperty("lastSyncErrorCode")
    protected Integer lastSyncErrorCode;

    @JsonProperty("tokenType")
    protected DepTokenType tokenType;

    @JsonProperty("tokenName")
    protected String tokenName;

    @JsonProperty("syncedDeviceCount")
    protected Integer syncedDeviceCount;

    @JsonProperty("dataSharingConsentGranted")
    protected Boolean dataSharingConsentGranted;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    protected DepOnboardingSetting() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDepOnboardingSetting() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String appleIdentifier;
        private OffsetDateTime tokenExpirationDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private OffsetDateTime lastSuccessfulSyncDateTime;
        private OffsetDateTime lastSyncTriggeredDateTime;
        private Boolean shareTokenWithSchoolDataSyncService;
        private Integer lastSyncErrorCode;
        private DepTokenType tokenType;
        private String tokenName;
        private Integer syncedDeviceCount;
        private Boolean dataSharingConsentGranted;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The Apple ID used to obtain the current token.”</i>
         * 
         * @param appleIdentifier
         *            value of {@code appleIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appleIdentifier(String appleIdentifier) {
            this.appleIdentifier = appleIdentifier;
            this.changedFields = changedFields.add("appleIdentifier");
            return this;
        }

        /**
         * <i>“When the token will expire.”</i>
         * 
         * @param tokenExpirationDateTime
         *            value of {@code tokenExpirationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tokenExpirationDateTime(OffsetDateTime tokenExpirationDateTime) {
            this.tokenExpirationDateTime = tokenExpirationDateTime;
            this.changedFields = changedFields.add("tokenExpirationDateTime");
            return this;
        }

        /**
         * <i>“When the service was onboarded.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“When the service last syned with Intune”</i>
         * 
         * @param lastSuccessfulSyncDateTime
         *            value of {@code lastSuccessfulSyncDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastSuccessfulSyncDateTime(OffsetDateTime lastSuccessfulSyncDateTime) {
            this.lastSuccessfulSyncDateTime = lastSuccessfulSyncDateTime;
            this.changedFields = changedFields.add("lastSuccessfulSyncDateTime");
            return this;
        }

        /**
         * <i>“When Intune last requested a sync.”</i>
         * 
         * @param lastSyncTriggeredDateTime
         *            value of {@code lastSyncTriggeredDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastSyncTriggeredDateTime(OffsetDateTime lastSyncTriggeredDateTime) {
            this.lastSyncTriggeredDateTime = lastSyncTriggeredDateTime;
            this.changedFields = changedFields.add("lastSyncTriggeredDateTime");
            return this;
        }

        /**
         * <i>“Whether or not the Dep token sharing is enabled with the School Data Sync
         * service.”</i>
         * 
         * @param shareTokenWithSchoolDataSyncService
         *            value of {@code shareTokenWithSchoolDataSyncService} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder shareTokenWithSchoolDataSyncService(Boolean shareTokenWithSchoolDataSyncService) {
            this.shareTokenWithSchoolDataSyncService = shareTokenWithSchoolDataSyncService;
            this.changedFields = changedFields.add("shareTokenWithSchoolDataSyncService");
            return this;
        }

        /**
         * <i>“Error code reported by Apple during last dep sync.”</i>
         * 
         * @param lastSyncErrorCode
         *            value of {@code lastSyncErrorCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastSyncErrorCode(Integer lastSyncErrorCode) {
            this.lastSyncErrorCode = lastSyncErrorCode;
            this.changedFields = changedFields.add("lastSyncErrorCode");
            return this;
        }

        /**
         * <i>“Gets or sets the Dep Token Type.”</i>
         * 
         * @param tokenType
         *            value of {@code tokenType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tokenType(DepTokenType tokenType) {
            this.tokenType = tokenType;
            this.changedFields = changedFields.add("tokenType");
            return this;
        }

        /**
         * <i>“Friendly Name for Dep Token”</i>
         * 
         * @param tokenName
         *            value of {@code tokenName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tokenName(String tokenName) {
            this.tokenName = tokenName;
            this.changedFields = changedFields.add("tokenName");
            return this;
        }

        /**
         * <i>“Gets synced device count”</i>
         * 
         * @param syncedDeviceCount
         *            value of {@code syncedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder syncedDeviceCount(Integer syncedDeviceCount) {
            this.syncedDeviceCount = syncedDeviceCount;
            this.changedFields = changedFields.add("syncedDeviceCount");
            return this;
        }

        /**
         * <i>“Consent granted for data sharing with Apple Dep Service”</i>
         * 
         * @param dataSharingConsentGranted
         *            value of {@code dataSharingConsentGranted} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dataSharingConsentGranted(Boolean dataSharingConsentGranted) {
            this.dataSharingConsentGranted = dataSharingConsentGranted;
            this.changedFields = changedFields.add("dataSharingConsentGranted");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public DepOnboardingSetting build() {
            DepOnboardingSetting _x = new DepOnboardingSetting();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.depOnboardingSetting";
            _x.id = id;
            _x.appleIdentifier = appleIdentifier;
            _x.tokenExpirationDateTime = tokenExpirationDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.lastSuccessfulSyncDateTime = lastSuccessfulSyncDateTime;
            _x.lastSyncTriggeredDateTime = lastSyncTriggeredDateTime;
            _x.shareTokenWithSchoolDataSyncService = shareTokenWithSchoolDataSyncService;
            _x.lastSyncErrorCode = lastSyncErrorCode;
            _x.tokenType = tokenType;
            _x.tokenName = tokenName;
            _x.syncedDeviceCount = syncedDeviceCount;
            _x.dataSharingConsentGranted = dataSharingConsentGranted;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The Apple ID used to obtain the current token.”</i>
     * 
     * @return property appleIdentifier
     */
    @Property(name="appleIdentifier")
    @JsonIgnore
    public Optional<String> getAppleIdentifier() {
        return Optional.ofNullable(appleIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appleIdentifier}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Apple ID used to obtain the current token.”</i>
     * 
     * @param appleIdentifier
     *            new value of {@code appleIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appleIdentifier} field changed
     */
    public DepOnboardingSetting withAppleIdentifier(String appleIdentifier) {
        DepOnboardingSetting _x = _copy();
        _x.changedFields = changedFields.add("appleIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depOnboardingSetting");
        _x.appleIdentifier = appleIdentifier;
        return _x;
    }

    /**
     * <i>“When the token will expire.”</i>
     * 
     * @return property tokenExpirationDateTime
     */
    @Property(name="tokenExpirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getTokenExpirationDateTime() {
        return Optional.ofNullable(tokenExpirationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * tokenExpirationDateTime} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“When the token will expire.”</i>
     * 
     * @param tokenExpirationDateTime
     *            new value of {@code tokenExpirationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tokenExpirationDateTime} field changed
     */
    public DepOnboardingSetting withTokenExpirationDateTime(OffsetDateTime tokenExpirationDateTime) {
        DepOnboardingSetting _x = _copy();
        _x.changedFields = changedFields.add("tokenExpirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depOnboardingSetting");
        _x.tokenExpirationDateTime = tokenExpirationDateTime;
        return _x;
    }

    /**
     * <i>“When the service was onboarded.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“When the service was onboarded.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public DepOnboardingSetting withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        DepOnboardingSetting _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depOnboardingSetting");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“When the service last syned with Intune”</i>
     * 
     * @return property lastSuccessfulSyncDateTime
     */
    @Property(name="lastSuccessfulSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSuccessfulSyncDateTime() {
        return Optional.ofNullable(lastSuccessfulSyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastSuccessfulSyncDateTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“When the service last syned with Intune”</i>
     * 
     * @param lastSuccessfulSyncDateTime
     *            new value of {@code lastSuccessfulSyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastSuccessfulSyncDateTime} field changed
     */
    public DepOnboardingSetting withLastSuccessfulSyncDateTime(OffsetDateTime lastSuccessfulSyncDateTime) {
        DepOnboardingSetting _x = _copy();
        _x.changedFields = changedFields.add("lastSuccessfulSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depOnboardingSetting");
        _x.lastSuccessfulSyncDateTime = lastSuccessfulSyncDateTime;
        return _x;
    }

    /**
     * <i>“When Intune last requested a sync.”</i>
     * 
     * @return property lastSyncTriggeredDateTime
     */
    @Property(name="lastSyncTriggeredDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSyncTriggeredDateTime() {
        return Optional.ofNullable(lastSyncTriggeredDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastSyncTriggeredDateTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“When Intune last requested a sync.”</i>
     * 
     * @param lastSyncTriggeredDateTime
     *            new value of {@code lastSyncTriggeredDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastSyncTriggeredDateTime} field changed
     */
    public DepOnboardingSetting withLastSyncTriggeredDateTime(OffsetDateTime lastSyncTriggeredDateTime) {
        DepOnboardingSetting _x = _copy();
        _x.changedFields = changedFields.add("lastSyncTriggeredDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depOnboardingSetting");
        _x.lastSyncTriggeredDateTime = lastSyncTriggeredDateTime;
        return _x;
    }

    /**
     * <i>“Whether or not the Dep token sharing is enabled with the School Data Sync
     * service.”</i>
     * 
     * @return property shareTokenWithSchoolDataSyncService
     */
    @Property(name="shareTokenWithSchoolDataSyncService")
    @JsonIgnore
    public Optional<Boolean> getShareTokenWithSchoolDataSyncService() {
        return Optional.ofNullable(shareTokenWithSchoolDataSyncService);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * shareTokenWithSchoolDataSyncService} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Whether or not the Dep token sharing is enabled with the School Data Sync
     * service.”</i>
     * 
     * @param shareTokenWithSchoolDataSyncService
     *            new value of {@code shareTokenWithSchoolDataSyncService} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code shareTokenWithSchoolDataSyncService} field changed
     */
    public DepOnboardingSetting withShareTokenWithSchoolDataSyncService(Boolean shareTokenWithSchoolDataSyncService) {
        DepOnboardingSetting _x = _copy();
        _x.changedFields = changedFields.add("shareTokenWithSchoolDataSyncService");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depOnboardingSetting");
        _x.shareTokenWithSchoolDataSyncService = shareTokenWithSchoolDataSyncService;
        return _x;
    }

    /**
     * <i>“Error code reported by Apple during last dep sync.”</i>
     * 
     * @return property lastSyncErrorCode
     */
    @Property(name="lastSyncErrorCode")
    @JsonIgnore
    public Optional<Integer> getLastSyncErrorCode() {
        return Optional.ofNullable(lastSyncErrorCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastSyncErrorCode
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Error code reported by Apple during last dep sync.”</i>
     * 
     * @param lastSyncErrorCode
     *            new value of {@code lastSyncErrorCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastSyncErrorCode} field changed
     */
    public DepOnboardingSetting withLastSyncErrorCode(Integer lastSyncErrorCode) {
        DepOnboardingSetting _x = _copy();
        _x.changedFields = changedFields.add("lastSyncErrorCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depOnboardingSetting");
        _x.lastSyncErrorCode = lastSyncErrorCode;
        return _x;
    }

    /**
     * <i>“Gets or sets the Dep Token Type.”</i>
     * 
     * @return property tokenType
     */
    @Property(name="tokenType")
    @JsonIgnore
    public Optional<DepTokenType> getTokenType() {
        return Optional.ofNullable(tokenType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code tokenType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Gets or sets the Dep Token Type.”</i>
     * 
     * @param tokenType
     *            new value of {@code tokenType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tokenType} field changed
     */
    public DepOnboardingSetting withTokenType(DepTokenType tokenType) {
        DepOnboardingSetting _x = _copy();
        _x.changedFields = changedFields.add("tokenType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depOnboardingSetting");
        _x.tokenType = tokenType;
        return _x;
    }

    /**
     * <i>“Friendly Name for Dep Token”</i>
     * 
     * @return property tokenName
     */
    @Property(name="tokenName")
    @JsonIgnore
    public Optional<String> getTokenName() {
        return Optional.ofNullable(tokenName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code tokenName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Friendly Name for Dep Token”</i>
     * 
     * @param tokenName
     *            new value of {@code tokenName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tokenName} field changed
     */
    public DepOnboardingSetting withTokenName(String tokenName) {
        DepOnboardingSetting _x = _copy();
        _x.changedFields = changedFields.add("tokenName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depOnboardingSetting");
        _x.tokenName = tokenName;
        return _x;
    }

    /**
     * <i>“Gets synced device count”</i>
     * 
     * @return property syncedDeviceCount
     */
    @Property(name="syncedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getSyncedDeviceCount() {
        return Optional.ofNullable(syncedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code syncedDeviceCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Gets synced device count”</i>
     * 
     * @param syncedDeviceCount
     *            new value of {@code syncedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code syncedDeviceCount} field changed
     */
    public DepOnboardingSetting withSyncedDeviceCount(Integer syncedDeviceCount) {
        DepOnboardingSetting _x = _copy();
        _x.changedFields = changedFields.add("syncedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depOnboardingSetting");
        _x.syncedDeviceCount = syncedDeviceCount;
        return _x;
    }

    /**
     * <i>“Consent granted for data sharing with Apple Dep Service”</i>
     * 
     * @return property dataSharingConsentGranted
     */
    @Property(name="dataSharingConsentGranted")
    @JsonIgnore
    public Optional<Boolean> getDataSharingConsentGranted() {
        return Optional.ofNullable(dataSharingConsentGranted);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * dataSharingConsentGranted} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Consent granted for data sharing with Apple Dep Service”</i>
     * 
     * @param dataSharingConsentGranted
     *            new value of {@code dataSharingConsentGranted} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dataSharingConsentGranted} field changed
     */
    public DepOnboardingSetting withDataSharingConsentGranted(Boolean dataSharingConsentGranted) {
        DepOnboardingSetting _x = _copy();
        _x.changedFields = changedFields.add("dataSharingConsentGranted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depOnboardingSetting");
        _x.dataSharingConsentGranted = dataSharingConsentGranted;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Default iOS Enrollment Profile”</i>
     * 
     * @return navigational property defaultIosEnrollmentProfile
     */
    @NavigationProperty(name="defaultIosEnrollmentProfile")
    @JsonIgnore
    public DepIOSEnrollmentProfileRequest getDefaultIosEnrollmentProfile() {
        return new DepIOSEnrollmentProfileRequest(contextPath.addSegment("defaultIosEnrollmentProfile"));
    }

    /**
     * <i>“Default MacOs Enrollment Profile”</i>
     * 
     * @return navigational property defaultMacOsEnrollmentProfile
     */
    @NavigationProperty(name="defaultMacOsEnrollmentProfile")
    @JsonIgnore
    public DepMacOSEnrollmentProfileRequest getDefaultMacOsEnrollmentProfile() {
        return new DepMacOSEnrollmentProfileRequest(contextPath.addSegment("defaultMacOsEnrollmentProfile"));
    }

    /**
     * <i>“The enrollment profiles.”</i>
     * 
     * @return navigational property enrollmentProfiles
     */
    @NavigationProperty(name="enrollmentProfiles")
    @JsonIgnore
    public EnrollmentProfileCollectionRequest getEnrollmentProfiles() {
        return new EnrollmentProfileCollectionRequest(
                        contextPath.addSegment("enrollmentProfiles"));
    }

    /**
     * <i>“The imported Apple device identities.”</i>
     * 
     * @return navigational property importedAppleDeviceIdentities
     */
    @NavigationProperty(name="importedAppleDeviceIdentities")
    @JsonIgnore
    public ImportedAppleDeviceIdentityCollectionRequest getImportedAppleDeviceIdentities() {
        return new ImportedAppleDeviceIdentityCollectionRequest(
                        contextPath.addSegment("importedAppleDeviceIdentities"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DepOnboardingSetting patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DepOnboardingSetting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DepOnboardingSetting put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DepOnboardingSetting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DepOnboardingSetting _copy() {
        DepOnboardingSetting _x = new DepOnboardingSetting();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.appleIdentifier = appleIdentifier;
        _x.tokenExpirationDateTime = tokenExpirationDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastSuccessfulSyncDateTime = lastSuccessfulSyncDateTime;
        _x.lastSyncTriggeredDateTime = lastSyncTriggeredDateTime;
        _x.shareTokenWithSchoolDataSyncService = shareTokenWithSchoolDataSyncService;
        _x.lastSyncErrorCode = lastSyncErrorCode;
        _x.tokenType = tokenType;
        _x.tokenName = tokenName;
        _x.syncedDeviceCount = syncedDeviceCount;
        _x.dataSharingConsentGranted = dataSharingConsentGranted;
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    @Action(name = "generateEncryptionPublicKey")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> generateEncryptionPublicKey() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.generateEncryptionPublicKey"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "uploadDepToken")
    @JsonIgnore
    public ActionRequestNoReturn uploadDepToken(String appleId, String depToken) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("appleId", "Edm.String", Checks.checkIsAscii(appleId))
            .put("depToken", "Edm.String", Checks.checkIsAscii(depToken))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.uploadDepToken"), _parameters);
    }

    @Action(name = "syncWithAppleDeviceEnrollmentProgram")
    @JsonIgnore
    public ActionRequestNoReturn syncWithAppleDeviceEnrollmentProgram() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.syncWithAppleDeviceEnrollmentProgram"), _parameters);
    }

    @Action(name = "shareForSchoolDataSyncService")
    @JsonIgnore
    public ActionRequestNoReturn shareForSchoolDataSyncService() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.shareForSchoolDataSyncService"), _parameters);
    }

    @Action(name = "unshareForSchoolDataSyncService")
    @JsonIgnore
    public ActionRequestNoReturn unshareForSchoolDataSyncService() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unshareForSchoolDataSyncService"), _parameters);
    }

    @Function(name = "getEncryptionPublicKey")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> getEncryptionPublicKey() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEncryptionPublicKey"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DepOnboardingSetting[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appleIdentifier=");
        b.append(this.appleIdentifier);
        b.append(", ");
        b.append("tokenExpirationDateTime=");
        b.append(this.tokenExpirationDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastSuccessfulSyncDateTime=");
        b.append(this.lastSuccessfulSyncDateTime);
        b.append(", ");
        b.append("lastSyncTriggeredDateTime=");
        b.append(this.lastSyncTriggeredDateTime);
        b.append(", ");
        b.append("shareTokenWithSchoolDataSyncService=");
        b.append(this.shareTokenWithSchoolDataSyncService);
        b.append(", ");
        b.append("lastSyncErrorCode=");
        b.append(this.lastSyncErrorCode);
        b.append(", ");
        b.append("tokenType=");
        b.append(this.tokenType);
        b.append(", ");
        b.append("tokenName=");
        b.append(this.tokenName);
        b.append(", ");
        b.append("syncedDeviceCount=");
        b.append(this.syncedDeviceCount);
        b.append(", ");
        b.append("dataSharingConsentGranted=");
        b.append(this.dataSharingConsentGranted);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
