package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“The DepMacOSEnrollmentProfile resource represents an Apple Device Enrollment
 * Program (DEP) enrollment profile specific to macOS configuration. This type of
 * profile must be assigned to Apple DEP serial numbers before the corresponding
 * devices can enroll via DEP.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "registrationDisabled", 
    "fileVaultDisabled", 
    "iCloudDiagnosticsDisabled", 
    "iCloudStorageDisabled", 
    "chooseYourLockScreenDisabled"})
@JsonInclude(Include.NON_NULL)
public class DepMacOSEnrollmentProfile extends DepEnrollmentBaseProfile implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.depMacOSEnrollmentProfile";
    }

    @JsonProperty("registrationDisabled")
    protected Boolean registrationDisabled;

    @JsonProperty("fileVaultDisabled")
    protected Boolean fileVaultDisabled;

    @JsonProperty("iCloudDiagnosticsDisabled")
    protected Boolean iCloudDiagnosticsDisabled;

    @JsonProperty("iCloudStorageDisabled")
    protected Boolean iCloudStorageDisabled;

    @JsonProperty("chooseYourLockScreenDisabled")
    protected Boolean chooseYourLockScreenDisabled;

    protected DepMacOSEnrollmentProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDepMacOSEnrollmentProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private Boolean requiresUserAuthentication;
        private String configurationEndpointUrl;
        private Boolean enableAuthenticationViaCompanyPortal;
        private Boolean requireCompanyPortalOnSetupAssistantEnrolledDevices;
        private Boolean isDefault;
        private Boolean supervisedModeEnabled;
        private String supportDepartment;
        private Boolean passCodeDisabled;
        private Boolean isMandatory;
        private Boolean locationDisabled;
        private String supportPhoneNumber;
        private Boolean profileRemovalDisabled;
        private Boolean restoreBlocked;
        private Boolean appleIdDisabled;
        private Boolean termsAndConditionsDisabled;
        private Boolean touchIdDisabled;
        private Boolean applePayDisabled;
        private Boolean zoomDisabled;
        private Boolean siriDisabled;
        private Boolean diagnosticsDisabled;
        private Boolean displayToneSetupDisabled;
        private Boolean privacyPaneDisabled;
        private Boolean screenTimeScreenDisabled;
        private String deviceNameTemplate;
        private Boolean configurationWebUrl;
        private Boolean registrationDisabled;
        private Boolean fileVaultDisabled;
        private Boolean iCloudDiagnosticsDisabled;
        private Boolean iCloudStorageDisabled;
        private Boolean chooseYourLockScreenDisabled;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder requiresUserAuthentication(Boolean requiresUserAuthentication) {
            this.requiresUserAuthentication = requiresUserAuthentication;
            this.changedFields = changedFields.add("requiresUserAuthentication");
            return this;
        }

        public Builder configurationEndpointUrl(String configurationEndpointUrl) {
            this.configurationEndpointUrl = configurationEndpointUrl;
            this.changedFields = changedFields.add("configurationEndpointUrl");
            return this;
        }

        public Builder enableAuthenticationViaCompanyPortal(Boolean enableAuthenticationViaCompanyPortal) {
            this.enableAuthenticationViaCompanyPortal = enableAuthenticationViaCompanyPortal;
            this.changedFields = changedFields.add("enableAuthenticationViaCompanyPortal");
            return this;
        }

        public Builder requireCompanyPortalOnSetupAssistantEnrolledDevices(Boolean requireCompanyPortalOnSetupAssistantEnrolledDevices) {
            this.requireCompanyPortalOnSetupAssistantEnrolledDevices = requireCompanyPortalOnSetupAssistantEnrolledDevices;
            this.changedFields = changedFields.add("requireCompanyPortalOnSetupAssistantEnrolledDevices");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.changedFields = changedFields.add("isDefault");
            return this;
        }

        public Builder supervisedModeEnabled(Boolean supervisedModeEnabled) {
            this.supervisedModeEnabled = supervisedModeEnabled;
            this.changedFields = changedFields.add("supervisedModeEnabled");
            return this;
        }

        public Builder supportDepartment(String supportDepartment) {
            this.supportDepartment = supportDepartment;
            this.changedFields = changedFields.add("supportDepartment");
            return this;
        }

        public Builder passCodeDisabled(Boolean passCodeDisabled) {
            this.passCodeDisabled = passCodeDisabled;
            this.changedFields = changedFields.add("passCodeDisabled");
            return this;
        }

        public Builder isMandatory(Boolean isMandatory) {
            this.isMandatory = isMandatory;
            this.changedFields = changedFields.add("isMandatory");
            return this;
        }

        public Builder locationDisabled(Boolean locationDisabled) {
            this.locationDisabled = locationDisabled;
            this.changedFields = changedFields.add("locationDisabled");
            return this;
        }

        public Builder supportPhoneNumber(String supportPhoneNumber) {
            this.supportPhoneNumber = supportPhoneNumber;
            this.changedFields = changedFields.add("supportPhoneNumber");
            return this;
        }

        public Builder profileRemovalDisabled(Boolean profileRemovalDisabled) {
            this.profileRemovalDisabled = profileRemovalDisabled;
            this.changedFields = changedFields.add("profileRemovalDisabled");
            return this;
        }

        public Builder restoreBlocked(Boolean restoreBlocked) {
            this.restoreBlocked = restoreBlocked;
            this.changedFields = changedFields.add("restoreBlocked");
            return this;
        }

        public Builder appleIdDisabled(Boolean appleIdDisabled) {
            this.appleIdDisabled = appleIdDisabled;
            this.changedFields = changedFields.add("appleIdDisabled");
            return this;
        }

        public Builder termsAndConditionsDisabled(Boolean termsAndConditionsDisabled) {
            this.termsAndConditionsDisabled = termsAndConditionsDisabled;
            this.changedFields = changedFields.add("termsAndConditionsDisabled");
            return this;
        }

        public Builder touchIdDisabled(Boolean touchIdDisabled) {
            this.touchIdDisabled = touchIdDisabled;
            this.changedFields = changedFields.add("touchIdDisabled");
            return this;
        }

        public Builder applePayDisabled(Boolean applePayDisabled) {
            this.applePayDisabled = applePayDisabled;
            this.changedFields = changedFields.add("applePayDisabled");
            return this;
        }

        public Builder zoomDisabled(Boolean zoomDisabled) {
            this.zoomDisabled = zoomDisabled;
            this.changedFields = changedFields.add("zoomDisabled");
            return this;
        }

        public Builder siriDisabled(Boolean siriDisabled) {
            this.siriDisabled = siriDisabled;
            this.changedFields = changedFields.add("siriDisabled");
            return this;
        }

        public Builder diagnosticsDisabled(Boolean diagnosticsDisabled) {
            this.diagnosticsDisabled = diagnosticsDisabled;
            this.changedFields = changedFields.add("diagnosticsDisabled");
            return this;
        }

        public Builder displayToneSetupDisabled(Boolean displayToneSetupDisabled) {
            this.displayToneSetupDisabled = displayToneSetupDisabled;
            this.changedFields = changedFields.add("displayToneSetupDisabled");
            return this;
        }

        public Builder privacyPaneDisabled(Boolean privacyPaneDisabled) {
            this.privacyPaneDisabled = privacyPaneDisabled;
            this.changedFields = changedFields.add("privacyPaneDisabled");
            return this;
        }

        public Builder screenTimeScreenDisabled(Boolean screenTimeScreenDisabled) {
            this.screenTimeScreenDisabled = screenTimeScreenDisabled;
            this.changedFields = changedFields.add("screenTimeScreenDisabled");
            return this;
        }

        public Builder deviceNameTemplate(String deviceNameTemplate) {
            this.deviceNameTemplate = deviceNameTemplate;
            this.changedFields = changedFields.add("deviceNameTemplate");
            return this;
        }

        public Builder configurationWebUrl(Boolean configurationWebUrl) {
            this.configurationWebUrl = configurationWebUrl;
            this.changedFields = changedFields.add("configurationWebUrl");
            return this;
        }

        /**
         * <i>“Indicates if registration is disabled”</i>
         * 
         * @param registrationDisabled
         *            value of {@code registrationDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder registrationDisabled(Boolean registrationDisabled) {
            this.registrationDisabled = registrationDisabled;
            this.changedFields = changedFields.add("registrationDisabled");
            return this;
        }

        /**
         * <i>“Indicates if file vault is disabled”</i>
         * 
         * @param fileVaultDisabled
         *            value of {@code fileVaultDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder fileVaultDisabled(Boolean fileVaultDisabled) {
            this.fileVaultDisabled = fileVaultDisabled;
            this.changedFields = changedFields.add("fileVaultDisabled");
            return this;
        }

        /**
         * <i>“Indicates if iCloud Analytics screen is disabled”</i>
         * 
         * @param iCloudDiagnosticsDisabled
         *            value of {@code iCloudDiagnosticsDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iCloudDiagnosticsDisabled(Boolean iCloudDiagnosticsDisabled) {
            this.iCloudDiagnosticsDisabled = iCloudDiagnosticsDisabled;
            this.changedFields = changedFields.add("iCloudDiagnosticsDisabled");
            return this;
        }

        /**
         * <i>“Indicates if iCloud Documents and Desktop screen is disabled”</i>
         * 
         * @param iCloudStorageDisabled
         *            value of {@code iCloudStorageDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iCloudStorageDisabled(Boolean iCloudStorageDisabled) {
            this.iCloudStorageDisabled = iCloudStorageDisabled;
            this.changedFields = changedFields.add("iCloudStorageDisabled");
            return this;
        }

        /**
         * <i>“Indicates if iCloud Documents and Desktop screen is disabled”</i>
         * 
         * @param chooseYourLockScreenDisabled
         *            value of {@code chooseYourLockScreenDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder chooseYourLockScreenDisabled(Boolean chooseYourLockScreenDisabled) {
            this.chooseYourLockScreenDisabled = chooseYourLockScreenDisabled;
            this.changedFields = changedFields.add("chooseYourLockScreenDisabled");
            return this;
        }

        public DepMacOSEnrollmentProfile build() {
            DepMacOSEnrollmentProfile _x = new DepMacOSEnrollmentProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.depMacOSEnrollmentProfile";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.requiresUserAuthentication = requiresUserAuthentication;
            _x.configurationEndpointUrl = configurationEndpointUrl;
            _x.enableAuthenticationViaCompanyPortal = enableAuthenticationViaCompanyPortal;
            _x.requireCompanyPortalOnSetupAssistantEnrolledDevices = requireCompanyPortalOnSetupAssistantEnrolledDevices;
            _x.isDefault = isDefault;
            _x.supervisedModeEnabled = supervisedModeEnabled;
            _x.supportDepartment = supportDepartment;
            _x.passCodeDisabled = passCodeDisabled;
            _x.isMandatory = isMandatory;
            _x.locationDisabled = locationDisabled;
            _x.supportPhoneNumber = supportPhoneNumber;
            _x.profileRemovalDisabled = profileRemovalDisabled;
            _x.restoreBlocked = restoreBlocked;
            _x.appleIdDisabled = appleIdDisabled;
            _x.termsAndConditionsDisabled = termsAndConditionsDisabled;
            _x.touchIdDisabled = touchIdDisabled;
            _x.applePayDisabled = applePayDisabled;
            _x.zoomDisabled = zoomDisabled;
            _x.siriDisabled = siriDisabled;
            _x.diagnosticsDisabled = diagnosticsDisabled;
            _x.displayToneSetupDisabled = displayToneSetupDisabled;
            _x.privacyPaneDisabled = privacyPaneDisabled;
            _x.screenTimeScreenDisabled = screenTimeScreenDisabled;
            _x.deviceNameTemplate = deviceNameTemplate;
            _x.configurationWebUrl = configurationWebUrl;
            _x.registrationDisabled = registrationDisabled;
            _x.fileVaultDisabled = fileVaultDisabled;
            _x.iCloudDiagnosticsDisabled = iCloudDiagnosticsDisabled;
            _x.iCloudStorageDisabled = iCloudStorageDisabled;
            _x.chooseYourLockScreenDisabled = chooseYourLockScreenDisabled;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Indicates if registration is disabled”</i>
     * 
     * @return property registrationDisabled
     */
    @Property(name="registrationDisabled")
    @JsonIgnore
    public Optional<Boolean> getRegistrationDisabled() {
        return Optional.ofNullable(registrationDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * registrationDisabled} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates if registration is disabled”</i>
     * 
     * @param registrationDisabled
     *            new value of {@code registrationDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code registrationDisabled} field changed
     */
    public DepMacOSEnrollmentProfile withRegistrationDisabled(Boolean registrationDisabled) {
        DepMacOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("registrationDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depMacOSEnrollmentProfile");
        _x.registrationDisabled = registrationDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if file vault is disabled”</i>
     * 
     * @return property fileVaultDisabled
     */
    @Property(name="fileVaultDisabled")
    @JsonIgnore
    public Optional<Boolean> getFileVaultDisabled() {
        return Optional.ofNullable(fileVaultDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code fileVaultDisabled
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if file vault is disabled”</i>
     * 
     * @param fileVaultDisabled
     *            new value of {@code fileVaultDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code fileVaultDisabled} field changed
     */
    public DepMacOSEnrollmentProfile withFileVaultDisabled(Boolean fileVaultDisabled) {
        DepMacOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("fileVaultDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depMacOSEnrollmentProfile");
        _x.fileVaultDisabled = fileVaultDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if iCloud Analytics screen is disabled”</i>
     * 
     * @return property iCloudDiagnosticsDisabled
     */
    @Property(name="iCloudDiagnosticsDisabled")
    @JsonIgnore
    public Optional<Boolean> getICloudDiagnosticsDisabled() {
        return Optional.ofNullable(iCloudDiagnosticsDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iCloudDiagnosticsDisabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if iCloud Analytics screen is disabled”</i>
     * 
     * @param iCloudDiagnosticsDisabled
     *            new value of {@code iCloudDiagnosticsDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iCloudDiagnosticsDisabled} field changed
     */
    public DepMacOSEnrollmentProfile withICloudDiagnosticsDisabled(Boolean iCloudDiagnosticsDisabled) {
        DepMacOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("iCloudDiagnosticsDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depMacOSEnrollmentProfile");
        _x.iCloudDiagnosticsDisabled = iCloudDiagnosticsDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if iCloud Documents and Desktop screen is disabled”</i>
     * 
     * @return property iCloudStorageDisabled
     */
    @Property(name="iCloudStorageDisabled")
    @JsonIgnore
    public Optional<Boolean> getICloudStorageDisabled() {
        return Optional.ofNullable(iCloudStorageDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iCloudStorageDisabled} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates if iCloud Documents and Desktop screen is disabled”</i>
     * 
     * @param iCloudStorageDisabled
     *            new value of {@code iCloudStorageDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iCloudStorageDisabled} field changed
     */
    public DepMacOSEnrollmentProfile withICloudStorageDisabled(Boolean iCloudStorageDisabled) {
        DepMacOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("iCloudStorageDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depMacOSEnrollmentProfile");
        _x.iCloudStorageDisabled = iCloudStorageDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if iCloud Documents and Desktop screen is disabled”</i>
     * 
     * @return property chooseYourLockScreenDisabled
     */
    @Property(name="chooseYourLockScreenDisabled")
    @JsonIgnore
    public Optional<Boolean> getChooseYourLockScreenDisabled() {
        return Optional.ofNullable(chooseYourLockScreenDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * chooseYourLockScreenDisabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if iCloud Documents and Desktop screen is disabled”</i>
     * 
     * @param chooseYourLockScreenDisabled
     *            new value of {@code chooseYourLockScreenDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code chooseYourLockScreenDisabled} field changed
     */
    public DepMacOSEnrollmentProfile withChooseYourLockScreenDisabled(Boolean chooseYourLockScreenDisabled) {
        DepMacOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("chooseYourLockScreenDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depMacOSEnrollmentProfile");
        _x.chooseYourLockScreenDisabled = chooseYourLockScreenDisabled;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DepMacOSEnrollmentProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DepMacOSEnrollmentProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DepMacOSEnrollmentProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DepMacOSEnrollmentProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DepMacOSEnrollmentProfile _copy() {
        DepMacOSEnrollmentProfile _x = new DepMacOSEnrollmentProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.requiresUserAuthentication = requiresUserAuthentication;
        _x.configurationEndpointUrl = configurationEndpointUrl;
        _x.enableAuthenticationViaCompanyPortal = enableAuthenticationViaCompanyPortal;
        _x.requireCompanyPortalOnSetupAssistantEnrolledDevices = requireCompanyPortalOnSetupAssistantEnrolledDevices;
        _x.isDefault = isDefault;
        _x.supervisedModeEnabled = supervisedModeEnabled;
        _x.supportDepartment = supportDepartment;
        _x.passCodeDisabled = passCodeDisabled;
        _x.isMandatory = isMandatory;
        _x.locationDisabled = locationDisabled;
        _x.supportPhoneNumber = supportPhoneNumber;
        _x.profileRemovalDisabled = profileRemovalDisabled;
        _x.restoreBlocked = restoreBlocked;
        _x.appleIdDisabled = appleIdDisabled;
        _x.termsAndConditionsDisabled = termsAndConditionsDisabled;
        _x.touchIdDisabled = touchIdDisabled;
        _x.applePayDisabled = applePayDisabled;
        _x.zoomDisabled = zoomDisabled;
        _x.siriDisabled = siriDisabled;
        _x.diagnosticsDisabled = diagnosticsDisabled;
        _x.displayToneSetupDisabled = displayToneSetupDisabled;
        _x.privacyPaneDisabled = privacyPaneDisabled;
        _x.screenTimeScreenDisabled = screenTimeScreenDisabled;
        _x.deviceNameTemplate = deviceNameTemplate;
        _x.configurationWebUrl = configurationWebUrl;
        _x.registrationDisabled = registrationDisabled;
        _x.fileVaultDisabled = fileVaultDisabled;
        _x.iCloudDiagnosticsDisabled = iCloudDiagnosticsDisabled;
        _x.iCloudStorageDisabled = iCloudStorageDisabled;
        _x.chooseYourLockScreenDisabled = chooseYourLockScreenDisabled;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DepMacOSEnrollmentProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("requiresUserAuthentication=");
        b.append(this.requiresUserAuthentication);
        b.append(", ");
        b.append("configurationEndpointUrl=");
        b.append(this.configurationEndpointUrl);
        b.append(", ");
        b.append("enableAuthenticationViaCompanyPortal=");
        b.append(this.enableAuthenticationViaCompanyPortal);
        b.append(", ");
        b.append("requireCompanyPortalOnSetupAssistantEnrolledDevices=");
        b.append(this.requireCompanyPortalOnSetupAssistantEnrolledDevices);
        b.append(", ");
        b.append("isDefault=");
        b.append(this.isDefault);
        b.append(", ");
        b.append("supervisedModeEnabled=");
        b.append(this.supervisedModeEnabled);
        b.append(", ");
        b.append("supportDepartment=");
        b.append(this.supportDepartment);
        b.append(", ");
        b.append("passCodeDisabled=");
        b.append(this.passCodeDisabled);
        b.append(", ");
        b.append("isMandatory=");
        b.append(this.isMandatory);
        b.append(", ");
        b.append("locationDisabled=");
        b.append(this.locationDisabled);
        b.append(", ");
        b.append("supportPhoneNumber=");
        b.append(this.supportPhoneNumber);
        b.append(", ");
        b.append("profileRemovalDisabled=");
        b.append(this.profileRemovalDisabled);
        b.append(", ");
        b.append("restoreBlocked=");
        b.append(this.restoreBlocked);
        b.append(", ");
        b.append("appleIdDisabled=");
        b.append(this.appleIdDisabled);
        b.append(", ");
        b.append("termsAndConditionsDisabled=");
        b.append(this.termsAndConditionsDisabled);
        b.append(", ");
        b.append("touchIdDisabled=");
        b.append(this.touchIdDisabled);
        b.append(", ");
        b.append("applePayDisabled=");
        b.append(this.applePayDisabled);
        b.append(", ");
        b.append("zoomDisabled=");
        b.append(this.zoomDisabled);
        b.append(", ");
        b.append("siriDisabled=");
        b.append(this.siriDisabled);
        b.append(", ");
        b.append("diagnosticsDisabled=");
        b.append(this.diagnosticsDisabled);
        b.append(", ");
        b.append("displayToneSetupDisabled=");
        b.append(this.displayToneSetupDisabled);
        b.append(", ");
        b.append("privacyPaneDisabled=");
        b.append(this.privacyPaneDisabled);
        b.append(", ");
        b.append("screenTimeScreenDisabled=");
        b.append(this.screenTimeScreenDisabled);
        b.append(", ");
        b.append("deviceNameTemplate=");
        b.append(this.deviceNameTemplate);
        b.append(", ");
        b.append("configurationWebUrl=");
        b.append(this.configurationWebUrl);
        b.append(", ");
        b.append("registrationDisabled=");
        b.append(this.registrationDisabled);
        b.append(", ");
        b.append("fileVaultDisabled=");
        b.append(this.fileVaultDisabled);
        b.append(", ");
        b.append("iCloudDiagnosticsDisabled=");
        b.append(this.iCloudDiagnosticsDisabled);
        b.append(", ");
        b.append("iCloudStorageDisabled=");
        b.append(this.iCloudStorageDisabled);
        b.append(", ");
        b.append("chooseYourLockScreenDisabled=");
        b.append(this.chooseYourLockScreenDisabled);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
