package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ManagementCertificateWithThumbprint;
import odata.msgraph.client.beta.enums.ITunesPairingMode;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“The DepIOSEnrollmentProfile resource represents an Apple Device Enrollment
 * Program (DEP) enrollment profile specific to iOS configuration. This type of
 * profile must be assigned to Apple DEP serial numbers before the corresponding
 * devices can enroll via DEP.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "iTunesPairingMode", 
    "managementCertificates", 
    "restoreFromAndroidDisabled", 
    "awaitDeviceConfiguredConfirmation", 
    "sharedIPadMaximumUserCount", 
    "enableSharedIPad", 
    "companyPortalVppTokenId", 
    "enableSingleAppEnrollmentMode", 
    "homeButtonScreenDisabled", 
    "iMessageAndFaceTimeScreenDisabled", 
    "onBoardingScreenDisabled", 
    "simSetupScreenDisabled", 
    "softwareUpdateScreenDisabled", 
    "watchMigrationScreenDisabled", 
    "appearanceScreenDisabled", 
    "expressLanguageScreenDisabled", 
    "preferredLanguageScreenDisabled", 
    "deviceToDeviceMigrationDisabled", 
    "welcomeScreenDisabled"})
@JsonInclude(Include.NON_NULL)
public class DepIOSEnrollmentProfile extends DepEnrollmentBaseProfile implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.depIOSEnrollmentProfile";
    }

    @JsonProperty("iTunesPairingMode")
    protected ITunesPairingMode iTunesPairingMode;

    @JsonProperty("managementCertificates")
    protected List<ManagementCertificateWithThumbprint> managementCertificates;

    @JsonProperty("managementCertificates@nextLink")
    protected String managementCertificatesNextLink;

    @JsonProperty("restoreFromAndroidDisabled")
    protected Boolean restoreFromAndroidDisabled;

    @JsonProperty("awaitDeviceConfiguredConfirmation")
    protected Boolean awaitDeviceConfiguredConfirmation;

    @JsonProperty("sharedIPadMaximumUserCount")
    protected Integer sharedIPadMaximumUserCount;

    @JsonProperty("enableSharedIPad")
    protected Boolean enableSharedIPad;

    @JsonProperty("companyPortalVppTokenId")
    protected String companyPortalVppTokenId;

    @JsonProperty("enableSingleAppEnrollmentMode")
    protected Boolean enableSingleAppEnrollmentMode;

    @JsonProperty("homeButtonScreenDisabled")
    protected Boolean homeButtonScreenDisabled;

    @JsonProperty("iMessageAndFaceTimeScreenDisabled")
    protected Boolean iMessageAndFaceTimeScreenDisabled;

    @JsonProperty("onBoardingScreenDisabled")
    protected Boolean onBoardingScreenDisabled;

    @JsonProperty("simSetupScreenDisabled")
    protected Boolean simSetupScreenDisabled;

    @JsonProperty("softwareUpdateScreenDisabled")
    protected Boolean softwareUpdateScreenDisabled;

    @JsonProperty("watchMigrationScreenDisabled")
    protected Boolean watchMigrationScreenDisabled;

    @JsonProperty("appearanceScreenDisabled")
    protected Boolean appearanceScreenDisabled;

    @JsonProperty("expressLanguageScreenDisabled")
    protected Boolean expressLanguageScreenDisabled;

    @JsonProperty("preferredLanguageScreenDisabled")
    protected Boolean preferredLanguageScreenDisabled;

    @JsonProperty("deviceToDeviceMigrationDisabled")
    protected Boolean deviceToDeviceMigrationDisabled;

    @JsonProperty("welcomeScreenDisabled")
    protected Boolean welcomeScreenDisabled;

    protected DepIOSEnrollmentProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDepIOSEnrollmentProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private Boolean requiresUserAuthentication;
        private String configurationEndpointUrl;
        private Boolean enableAuthenticationViaCompanyPortal;
        private Boolean requireCompanyPortalOnSetupAssistantEnrolledDevices;
        private Boolean isDefault;
        private Boolean supervisedModeEnabled;
        private String supportDepartment;
        private Boolean passCodeDisabled;
        private Boolean isMandatory;
        private Boolean locationDisabled;
        private String supportPhoneNumber;
        private Boolean profileRemovalDisabled;
        private Boolean restoreBlocked;
        private Boolean appleIdDisabled;
        private Boolean termsAndConditionsDisabled;
        private Boolean touchIdDisabled;
        private Boolean applePayDisabled;
        private Boolean zoomDisabled;
        private Boolean siriDisabled;
        private Boolean diagnosticsDisabled;
        private Boolean displayToneSetupDisabled;
        private Boolean privacyPaneDisabled;
        private Boolean screenTimeScreenDisabled;
        private String deviceNameTemplate;
        private Boolean configurationWebUrl;
        private ITunesPairingMode iTunesPairingMode;
        private List<ManagementCertificateWithThumbprint> managementCertificates;
        private String managementCertificatesNextLink;
        private Boolean restoreFromAndroidDisabled;
        private Boolean awaitDeviceConfiguredConfirmation;
        private Integer sharedIPadMaximumUserCount;
        private Boolean enableSharedIPad;
        private String companyPortalVppTokenId;
        private Boolean enableSingleAppEnrollmentMode;
        private Boolean homeButtonScreenDisabled;
        private Boolean iMessageAndFaceTimeScreenDisabled;
        private Boolean onBoardingScreenDisabled;
        private Boolean simSetupScreenDisabled;
        private Boolean softwareUpdateScreenDisabled;
        private Boolean watchMigrationScreenDisabled;
        private Boolean appearanceScreenDisabled;
        private Boolean expressLanguageScreenDisabled;
        private Boolean preferredLanguageScreenDisabled;
        private Boolean deviceToDeviceMigrationDisabled;
        private Boolean welcomeScreenDisabled;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder requiresUserAuthentication(Boolean requiresUserAuthentication) {
            this.requiresUserAuthentication = requiresUserAuthentication;
            this.changedFields = changedFields.add("requiresUserAuthentication");
            return this;
        }

        public Builder configurationEndpointUrl(String configurationEndpointUrl) {
            this.configurationEndpointUrl = configurationEndpointUrl;
            this.changedFields = changedFields.add("configurationEndpointUrl");
            return this;
        }

        public Builder enableAuthenticationViaCompanyPortal(Boolean enableAuthenticationViaCompanyPortal) {
            this.enableAuthenticationViaCompanyPortal = enableAuthenticationViaCompanyPortal;
            this.changedFields = changedFields.add("enableAuthenticationViaCompanyPortal");
            return this;
        }

        public Builder requireCompanyPortalOnSetupAssistantEnrolledDevices(Boolean requireCompanyPortalOnSetupAssistantEnrolledDevices) {
            this.requireCompanyPortalOnSetupAssistantEnrolledDevices = requireCompanyPortalOnSetupAssistantEnrolledDevices;
            this.changedFields = changedFields.add("requireCompanyPortalOnSetupAssistantEnrolledDevices");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.changedFields = changedFields.add("isDefault");
            return this;
        }

        public Builder supervisedModeEnabled(Boolean supervisedModeEnabled) {
            this.supervisedModeEnabled = supervisedModeEnabled;
            this.changedFields = changedFields.add("supervisedModeEnabled");
            return this;
        }

        public Builder supportDepartment(String supportDepartment) {
            this.supportDepartment = supportDepartment;
            this.changedFields = changedFields.add("supportDepartment");
            return this;
        }

        public Builder passCodeDisabled(Boolean passCodeDisabled) {
            this.passCodeDisabled = passCodeDisabled;
            this.changedFields = changedFields.add("passCodeDisabled");
            return this;
        }

        public Builder isMandatory(Boolean isMandatory) {
            this.isMandatory = isMandatory;
            this.changedFields = changedFields.add("isMandatory");
            return this;
        }

        public Builder locationDisabled(Boolean locationDisabled) {
            this.locationDisabled = locationDisabled;
            this.changedFields = changedFields.add("locationDisabled");
            return this;
        }

        public Builder supportPhoneNumber(String supportPhoneNumber) {
            this.supportPhoneNumber = supportPhoneNumber;
            this.changedFields = changedFields.add("supportPhoneNumber");
            return this;
        }

        public Builder profileRemovalDisabled(Boolean profileRemovalDisabled) {
            this.profileRemovalDisabled = profileRemovalDisabled;
            this.changedFields = changedFields.add("profileRemovalDisabled");
            return this;
        }

        public Builder restoreBlocked(Boolean restoreBlocked) {
            this.restoreBlocked = restoreBlocked;
            this.changedFields = changedFields.add("restoreBlocked");
            return this;
        }

        public Builder appleIdDisabled(Boolean appleIdDisabled) {
            this.appleIdDisabled = appleIdDisabled;
            this.changedFields = changedFields.add("appleIdDisabled");
            return this;
        }

        public Builder termsAndConditionsDisabled(Boolean termsAndConditionsDisabled) {
            this.termsAndConditionsDisabled = termsAndConditionsDisabled;
            this.changedFields = changedFields.add("termsAndConditionsDisabled");
            return this;
        }

        public Builder touchIdDisabled(Boolean touchIdDisabled) {
            this.touchIdDisabled = touchIdDisabled;
            this.changedFields = changedFields.add("touchIdDisabled");
            return this;
        }

        public Builder applePayDisabled(Boolean applePayDisabled) {
            this.applePayDisabled = applePayDisabled;
            this.changedFields = changedFields.add("applePayDisabled");
            return this;
        }

        public Builder zoomDisabled(Boolean zoomDisabled) {
            this.zoomDisabled = zoomDisabled;
            this.changedFields = changedFields.add("zoomDisabled");
            return this;
        }

        public Builder siriDisabled(Boolean siriDisabled) {
            this.siriDisabled = siriDisabled;
            this.changedFields = changedFields.add("siriDisabled");
            return this;
        }

        public Builder diagnosticsDisabled(Boolean diagnosticsDisabled) {
            this.diagnosticsDisabled = diagnosticsDisabled;
            this.changedFields = changedFields.add("diagnosticsDisabled");
            return this;
        }

        public Builder displayToneSetupDisabled(Boolean displayToneSetupDisabled) {
            this.displayToneSetupDisabled = displayToneSetupDisabled;
            this.changedFields = changedFields.add("displayToneSetupDisabled");
            return this;
        }

        public Builder privacyPaneDisabled(Boolean privacyPaneDisabled) {
            this.privacyPaneDisabled = privacyPaneDisabled;
            this.changedFields = changedFields.add("privacyPaneDisabled");
            return this;
        }

        public Builder screenTimeScreenDisabled(Boolean screenTimeScreenDisabled) {
            this.screenTimeScreenDisabled = screenTimeScreenDisabled;
            this.changedFields = changedFields.add("screenTimeScreenDisabled");
            return this;
        }

        public Builder deviceNameTemplate(String deviceNameTemplate) {
            this.deviceNameTemplate = deviceNameTemplate;
            this.changedFields = changedFields.add("deviceNameTemplate");
            return this;
        }

        public Builder configurationWebUrl(Boolean configurationWebUrl) {
            this.configurationWebUrl = configurationWebUrl;
            this.changedFields = changedFields.add("configurationWebUrl");
            return this;
        }

        /**
         * <i>“Indicates the iTunes pairing mode”</i>
         * 
         * @param iTunesPairingMode
         *            value of {@code iTunesPairingMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iTunesPairingMode(ITunesPairingMode iTunesPairingMode) {
            this.iTunesPairingMode = iTunesPairingMode;
            this.changedFields = changedFields.add("iTunesPairingMode");
            return this;
        }

        /**
         * <i>“Management certificates for Apple Configurator”</i>
         * 
         * @param managementCertificates
         *            value of {@code managementCertificates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managementCertificates(List<ManagementCertificateWithThumbprint> managementCertificates) {
            this.managementCertificates = managementCertificates;
            this.changedFields = changedFields.add("managementCertificates");
            return this;
        }

        /**
         * <i>“Management certificates for Apple Configurator”</i>
         * 
         * @param managementCertificates
         *            value of {@code managementCertificates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managementCertificates(ManagementCertificateWithThumbprint... managementCertificates) {
            return managementCertificates(Arrays.asList(managementCertificates));
        }

        /**
         * <i>“Management certificates for Apple Configurator”</i>
         * 
         * @param managementCertificatesNextLink
         *            value of {@code managementCertificates@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managementCertificatesNextLink(String managementCertificatesNextLink) {
            this.managementCertificatesNextLink = managementCertificatesNextLink;
            this.changedFields = changedFields.add("managementCertificates");
            return this;
        }

        /**
         * <i>“Indicates if Restore from Android is disabled”</i>
         * 
         * @param restoreFromAndroidDisabled
         *            value of {@code restoreFromAndroidDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder restoreFromAndroidDisabled(Boolean restoreFromAndroidDisabled) {
            this.restoreFromAndroidDisabled = restoreFromAndroidDisabled;
            this.changedFields = changedFields.add("restoreFromAndroidDisabled");
            return this;
        }

        /**
         * <i>“Indicates if the device will need to wait for configured confirmation”</i>
         * 
         * @param awaitDeviceConfiguredConfirmation
         *            value of {@code awaitDeviceConfiguredConfirmation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder awaitDeviceConfiguredConfirmation(Boolean awaitDeviceConfiguredConfirmation) {
            this.awaitDeviceConfiguredConfirmation = awaitDeviceConfiguredConfirmation;
            this.changedFields = changedFields.add("awaitDeviceConfiguredConfirmation");
            return this;
        }

        /**
         * <i>“This specifies the maximum number of users that can use a shared iPad. Only
         * applicable in shared iPad mode.”</i>
         * 
         * @param sharedIPadMaximumUserCount
         *            value of {@code sharedIPadMaximumUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sharedIPadMaximumUserCount(Integer sharedIPadMaximumUserCount) {
            this.sharedIPadMaximumUserCount = sharedIPadMaximumUserCount;
            this.changedFields = changedFields.add("sharedIPadMaximumUserCount");
            return this;
        }

        /**
         * <i>“This indicates whether the device is to be enrolled in a mode which enables
         * multi user scenarios. Only applicable in shared iPads.”</i>
         * 
         * @param enableSharedIPad
         *            value of {@code enableSharedIPad} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableSharedIPad(Boolean enableSharedIPad) {
            this.enableSharedIPad = enableSharedIPad;
            this.changedFields = changedFields.add("enableSharedIPad");
            return this;
        }

        /**
         * <i>“If set, indicates which Vpp token should be used to deploy the Company Portal w/
         * device licensing. 'enableAuthenticationViaCompanyPortal' must be set in order
         * for this property to be set.”</i>
         * 
         * @param companyPortalVppTokenId
         *            value of {@code companyPortalVppTokenId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder companyPortalVppTokenId(String companyPortalVppTokenId) {
            this.companyPortalVppTokenId = companyPortalVppTokenId;
            this.changedFields = changedFields.add("companyPortalVppTokenId");
            return this;
        }

        /**
         * <i>“Tells the device to enable single app mode and apply app-lock during enrollment.
         * Default is false. 'enableAuthenticationViaCompanyPortal' and '
         * companyPortalVppTokenId' must be set for this property to be set.”</i>
         * 
         * @param enableSingleAppEnrollmentMode
         *            value of {@code enableSingleAppEnrollmentMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableSingleAppEnrollmentMode(Boolean enableSingleAppEnrollmentMode) {
            this.enableSingleAppEnrollmentMode = enableSingleAppEnrollmentMode;
            this.changedFields = changedFields.add("enableSingleAppEnrollmentMode");
            return this;
        }

        /**
         * <i>“Indicates if home button sensitivity screen is disabled”</i>
         * 
         * @param homeButtonScreenDisabled
         *            value of {@code homeButtonScreenDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder homeButtonScreenDisabled(Boolean homeButtonScreenDisabled) {
            this.homeButtonScreenDisabled = homeButtonScreenDisabled;
            this.changedFields = changedFields.add("homeButtonScreenDisabled");
            return this;
        }

        /**
         * <i>“Indicates if iMessage and FaceTime screen is disabled”</i>
         * 
         * @param iMessageAndFaceTimeScreenDisabled
         *            value of {@code iMessageAndFaceTimeScreenDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iMessageAndFaceTimeScreenDisabled(Boolean iMessageAndFaceTimeScreenDisabled) {
            this.iMessageAndFaceTimeScreenDisabled = iMessageAndFaceTimeScreenDisabled;
            this.changedFields = changedFields.add("iMessageAndFaceTimeScreenDisabled");
            return this;
        }

        /**
         * <i>“Indicates if onboarding setup screen is disabled”</i>
         * 
         * @param onBoardingScreenDisabled
         *            value of {@code onBoardingScreenDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder onBoardingScreenDisabled(Boolean onBoardingScreenDisabled) {
            this.onBoardingScreenDisabled = onBoardingScreenDisabled;
            this.changedFields = changedFields.add("onBoardingScreenDisabled");
            return this;
        }

        /**
         * <i>“Indicates if the SIMSetup screen is disabled”</i>
         * 
         * @param simSetupScreenDisabled
         *            value of {@code simSetupScreenDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder simSetupScreenDisabled(Boolean simSetupScreenDisabled) {
            this.simSetupScreenDisabled = simSetupScreenDisabled;
            this.changedFields = changedFields.add("simSetupScreenDisabled");
            return this;
        }

        /**
         * <i>“Indicates if the mandatory sofware update screen is disabled”</i>
         * 
         * @param softwareUpdateScreenDisabled
         *            value of {@code softwareUpdateScreenDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder softwareUpdateScreenDisabled(Boolean softwareUpdateScreenDisabled) {
            this.softwareUpdateScreenDisabled = softwareUpdateScreenDisabled;
            this.changedFields = changedFields.add("softwareUpdateScreenDisabled");
            return this;
        }

        /**
         * <i>“Indicates if the watch migration screen is disabled”</i>
         * 
         * @param watchMigrationScreenDisabled
         *            value of {@code watchMigrationScreenDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder watchMigrationScreenDisabled(Boolean watchMigrationScreenDisabled) {
            this.watchMigrationScreenDisabled = watchMigrationScreenDisabled;
            this.changedFields = changedFields.add("watchMigrationScreenDisabled");
            return this;
        }

        /**
         * <i>“Indicates if Apperance screen is disabled”</i>
         * 
         * @param appearanceScreenDisabled
         *            value of {@code appearanceScreenDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appearanceScreenDisabled(Boolean appearanceScreenDisabled) {
            this.appearanceScreenDisabled = appearanceScreenDisabled;
            this.changedFields = changedFields.add("appearanceScreenDisabled");
            return this;
        }

        /**
         * <i>“Indicates if Express Language screen is disabled”</i>
         * 
         * @param expressLanguageScreenDisabled
         *            value of {@code expressLanguageScreenDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder expressLanguageScreenDisabled(Boolean expressLanguageScreenDisabled) {
            this.expressLanguageScreenDisabled = expressLanguageScreenDisabled;
            this.changedFields = changedFields.add("expressLanguageScreenDisabled");
            return this;
        }

        /**
         * <i>“Indicates if Preferred language screen is disabled”</i>
         * 
         * @param preferredLanguageScreenDisabled
         *            value of {@code preferredLanguageScreenDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder preferredLanguageScreenDisabled(Boolean preferredLanguageScreenDisabled) {
            this.preferredLanguageScreenDisabled = preferredLanguageScreenDisabled;
            this.changedFields = changedFields.add("preferredLanguageScreenDisabled");
            return this;
        }

        /**
         * <i>“Indicates if Device To Device Migration is disabled”</i>
         * 
         * @param deviceToDeviceMigrationDisabled
         *            value of {@code deviceToDeviceMigrationDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceToDeviceMigrationDisabled(Boolean deviceToDeviceMigrationDisabled) {
            this.deviceToDeviceMigrationDisabled = deviceToDeviceMigrationDisabled;
            this.changedFields = changedFields.add("deviceToDeviceMigrationDisabled");
            return this;
        }

        /**
         * <i>“Indicates if Weclome screen is disabled”</i>
         * 
         * @param welcomeScreenDisabled
         *            value of {@code welcomeScreenDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder welcomeScreenDisabled(Boolean welcomeScreenDisabled) {
            this.welcomeScreenDisabled = welcomeScreenDisabled;
            this.changedFields = changedFields.add("welcomeScreenDisabled");
            return this;
        }

        public DepIOSEnrollmentProfile build() {
            DepIOSEnrollmentProfile _x = new DepIOSEnrollmentProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.depIOSEnrollmentProfile";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.requiresUserAuthentication = requiresUserAuthentication;
            _x.configurationEndpointUrl = configurationEndpointUrl;
            _x.enableAuthenticationViaCompanyPortal = enableAuthenticationViaCompanyPortal;
            _x.requireCompanyPortalOnSetupAssistantEnrolledDevices = requireCompanyPortalOnSetupAssistantEnrolledDevices;
            _x.isDefault = isDefault;
            _x.supervisedModeEnabled = supervisedModeEnabled;
            _x.supportDepartment = supportDepartment;
            _x.passCodeDisabled = passCodeDisabled;
            _x.isMandatory = isMandatory;
            _x.locationDisabled = locationDisabled;
            _x.supportPhoneNumber = supportPhoneNumber;
            _x.profileRemovalDisabled = profileRemovalDisabled;
            _x.restoreBlocked = restoreBlocked;
            _x.appleIdDisabled = appleIdDisabled;
            _x.termsAndConditionsDisabled = termsAndConditionsDisabled;
            _x.touchIdDisabled = touchIdDisabled;
            _x.applePayDisabled = applePayDisabled;
            _x.zoomDisabled = zoomDisabled;
            _x.siriDisabled = siriDisabled;
            _x.diagnosticsDisabled = diagnosticsDisabled;
            _x.displayToneSetupDisabled = displayToneSetupDisabled;
            _x.privacyPaneDisabled = privacyPaneDisabled;
            _x.screenTimeScreenDisabled = screenTimeScreenDisabled;
            _x.deviceNameTemplate = deviceNameTemplate;
            _x.configurationWebUrl = configurationWebUrl;
            _x.iTunesPairingMode = iTunesPairingMode;
            _x.managementCertificates = managementCertificates;
            _x.managementCertificatesNextLink = managementCertificatesNextLink;
            _x.restoreFromAndroidDisabled = restoreFromAndroidDisabled;
            _x.awaitDeviceConfiguredConfirmation = awaitDeviceConfiguredConfirmation;
            _x.sharedIPadMaximumUserCount = sharedIPadMaximumUserCount;
            _x.enableSharedIPad = enableSharedIPad;
            _x.companyPortalVppTokenId = companyPortalVppTokenId;
            _x.enableSingleAppEnrollmentMode = enableSingleAppEnrollmentMode;
            _x.homeButtonScreenDisabled = homeButtonScreenDisabled;
            _x.iMessageAndFaceTimeScreenDisabled = iMessageAndFaceTimeScreenDisabled;
            _x.onBoardingScreenDisabled = onBoardingScreenDisabled;
            _x.simSetupScreenDisabled = simSetupScreenDisabled;
            _x.softwareUpdateScreenDisabled = softwareUpdateScreenDisabled;
            _x.watchMigrationScreenDisabled = watchMigrationScreenDisabled;
            _x.appearanceScreenDisabled = appearanceScreenDisabled;
            _x.expressLanguageScreenDisabled = expressLanguageScreenDisabled;
            _x.preferredLanguageScreenDisabled = preferredLanguageScreenDisabled;
            _x.deviceToDeviceMigrationDisabled = deviceToDeviceMigrationDisabled;
            _x.welcomeScreenDisabled = welcomeScreenDisabled;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Indicates the iTunes pairing mode”</i>
     * 
     * @return property iTunesPairingMode
     */
    @Property(name="iTunesPairingMode")
    @JsonIgnore
    public Optional<ITunesPairingMode> getITunesPairingMode() {
        return Optional.ofNullable(iTunesPairingMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code iTunesPairingMode
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates the iTunes pairing mode”</i>
     * 
     * @param iTunesPairingMode
     *            new value of {@code iTunesPairingMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iTunesPairingMode} field changed
     */
    public DepIOSEnrollmentProfile withITunesPairingMode(ITunesPairingMode iTunesPairingMode) {
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("iTunesPairingMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depIOSEnrollmentProfile");
        _x.iTunesPairingMode = iTunesPairingMode;
        return _x;
    }

    /**
     * <i>“Management certificates for Apple Configurator”</i>
     * 
     * @return property managementCertificates
     */
    @Property(name="managementCertificates")
    @JsonIgnore
    public CollectionPage<ManagementCertificateWithThumbprint> getManagementCertificates() {
        return new CollectionPage<ManagementCertificateWithThumbprint>(contextPath, ManagementCertificateWithThumbprint.class, managementCertificates, Optional.ofNullable(managementCertificatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Management certificates for Apple Configurator”</i>
     * 
     * @return property managementCertificates
     */
    @Property(name="managementCertificates")
    @JsonIgnore
    public CollectionPage<ManagementCertificateWithThumbprint> getManagementCertificates(HttpRequestOptions options) {
        return new CollectionPage<ManagementCertificateWithThumbprint>(contextPath, ManagementCertificateWithThumbprint.class, managementCertificates, Optional.ofNullable(managementCertificatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates if Restore from Android is disabled”</i>
     * 
     * @return property restoreFromAndroidDisabled
     */
    @Property(name="restoreFromAndroidDisabled")
    @JsonIgnore
    public Optional<Boolean> getRestoreFromAndroidDisabled() {
        return Optional.ofNullable(restoreFromAndroidDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * restoreFromAndroidDisabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if Restore from Android is disabled”</i>
     * 
     * @param restoreFromAndroidDisabled
     *            new value of {@code restoreFromAndroidDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code restoreFromAndroidDisabled} field changed
     */
    public DepIOSEnrollmentProfile withRestoreFromAndroidDisabled(Boolean restoreFromAndroidDisabled) {
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("restoreFromAndroidDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depIOSEnrollmentProfile");
        _x.restoreFromAndroidDisabled = restoreFromAndroidDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if the device will need to wait for configured confirmation”</i>
     * 
     * @return property awaitDeviceConfiguredConfirmation
     */
    @Property(name="awaitDeviceConfiguredConfirmation")
    @JsonIgnore
    public Optional<Boolean> getAwaitDeviceConfiguredConfirmation() {
        return Optional.ofNullable(awaitDeviceConfiguredConfirmation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * awaitDeviceConfiguredConfirmation} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates if the device will need to wait for configured confirmation”</i>
     * 
     * @param awaitDeviceConfiguredConfirmation
     *            new value of {@code awaitDeviceConfiguredConfirmation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code awaitDeviceConfiguredConfirmation} field changed
     */
    public DepIOSEnrollmentProfile withAwaitDeviceConfiguredConfirmation(Boolean awaitDeviceConfiguredConfirmation) {
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("awaitDeviceConfiguredConfirmation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depIOSEnrollmentProfile");
        _x.awaitDeviceConfiguredConfirmation = awaitDeviceConfiguredConfirmation;
        return _x;
    }

    /**
     * <i>“This specifies the maximum number of users that can use a shared iPad. Only
     * applicable in shared iPad mode.”</i>
     * 
     * @return property sharedIPadMaximumUserCount
     */
    @Property(name="sharedIPadMaximumUserCount")
    @JsonIgnore
    public Optional<Integer> getSharedIPadMaximumUserCount() {
        return Optional.ofNullable(sharedIPadMaximumUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * sharedIPadMaximumUserCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This specifies the maximum number of users that can use a shared iPad. Only
     * applicable in shared iPad mode.”</i>
     * 
     * @param sharedIPadMaximumUserCount
     *            new value of {@code sharedIPadMaximumUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sharedIPadMaximumUserCount} field changed
     */
    public DepIOSEnrollmentProfile withSharedIPadMaximumUserCount(Integer sharedIPadMaximumUserCount) {
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("sharedIPadMaximumUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depIOSEnrollmentProfile");
        _x.sharedIPadMaximumUserCount = sharedIPadMaximumUserCount;
        return _x;
    }

    /**
     * <i>“This indicates whether the device is to be enrolled in a mode which enables
     * multi user scenarios. Only applicable in shared iPads.”</i>
     * 
     * @return property enableSharedIPad
     */
    @Property(name="enableSharedIPad")
    @JsonIgnore
    public Optional<Boolean> getEnableSharedIPad() {
        return Optional.ofNullable(enableSharedIPad);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enableSharedIPad}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“This indicates whether the device is to be enrolled in a mode which enables
     * multi user scenarios. Only applicable in shared iPads.”</i>
     * 
     * @param enableSharedIPad
     *            new value of {@code enableSharedIPad} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableSharedIPad} field changed
     */
    public DepIOSEnrollmentProfile withEnableSharedIPad(Boolean enableSharedIPad) {
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("enableSharedIPad");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depIOSEnrollmentProfile");
        _x.enableSharedIPad = enableSharedIPad;
        return _x;
    }

    /**
     * <i>“If set, indicates which Vpp token should be used to deploy the Company Portal w/
     * device licensing. 'enableAuthenticationViaCompanyPortal' must be set in order
     * for this property to be set.”</i>
     * 
     * @return property companyPortalVppTokenId
     */
    @Property(name="companyPortalVppTokenId")
    @JsonIgnore
    public Optional<String> getCompanyPortalVppTokenId() {
        return Optional.ofNullable(companyPortalVppTokenId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * companyPortalVppTokenId} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“If set, indicates which Vpp token should be used to deploy the Company Portal w/
     * device licensing. 'enableAuthenticationViaCompanyPortal' must be set in order
     * for this property to be set.”</i>
     * 
     * @param companyPortalVppTokenId
     *            new value of {@code companyPortalVppTokenId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code companyPortalVppTokenId} field changed
     */
    public DepIOSEnrollmentProfile withCompanyPortalVppTokenId(String companyPortalVppTokenId) {
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("companyPortalVppTokenId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depIOSEnrollmentProfile");
        _x.companyPortalVppTokenId = companyPortalVppTokenId;
        return _x;
    }

    /**
     * <i>“Tells the device to enable single app mode and apply app-lock during enrollment.
     * Default is false. 'enableAuthenticationViaCompanyPortal' and '
     * companyPortalVppTokenId' must be set for this property to be set.”</i>
     * 
     * @return property enableSingleAppEnrollmentMode
     */
    @Property(name="enableSingleAppEnrollmentMode")
    @JsonIgnore
    public Optional<Boolean> getEnableSingleAppEnrollmentMode() {
        return Optional.ofNullable(enableSingleAppEnrollmentMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enableSingleAppEnrollmentMode} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Tells the device to enable single app mode and apply app-lock during enrollment.
     * Default is false. 'enableAuthenticationViaCompanyPortal' and '
     * companyPortalVppTokenId' must be set for this property to be set.”</i>
     * 
     * @param enableSingleAppEnrollmentMode
     *            new value of {@code enableSingleAppEnrollmentMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableSingleAppEnrollmentMode} field changed
     */
    public DepIOSEnrollmentProfile withEnableSingleAppEnrollmentMode(Boolean enableSingleAppEnrollmentMode) {
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("enableSingleAppEnrollmentMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depIOSEnrollmentProfile");
        _x.enableSingleAppEnrollmentMode = enableSingleAppEnrollmentMode;
        return _x;
    }

    /**
     * <i>“Indicates if home button sensitivity screen is disabled”</i>
     * 
     * @return property homeButtonScreenDisabled
     */
    @Property(name="homeButtonScreenDisabled")
    @JsonIgnore
    public Optional<Boolean> getHomeButtonScreenDisabled() {
        return Optional.ofNullable(homeButtonScreenDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * homeButtonScreenDisabled} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if home button sensitivity screen is disabled”</i>
     * 
     * @param homeButtonScreenDisabled
     *            new value of {@code homeButtonScreenDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code homeButtonScreenDisabled} field changed
     */
    public DepIOSEnrollmentProfile withHomeButtonScreenDisabled(Boolean homeButtonScreenDisabled) {
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("homeButtonScreenDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depIOSEnrollmentProfile");
        _x.homeButtonScreenDisabled = homeButtonScreenDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if iMessage and FaceTime screen is disabled”</i>
     * 
     * @return property iMessageAndFaceTimeScreenDisabled
     */
    @Property(name="iMessageAndFaceTimeScreenDisabled")
    @JsonIgnore
    public Optional<Boolean> getIMessageAndFaceTimeScreenDisabled() {
        return Optional.ofNullable(iMessageAndFaceTimeScreenDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iMessageAndFaceTimeScreenDisabled} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates if iMessage and FaceTime screen is disabled”</i>
     * 
     * @param iMessageAndFaceTimeScreenDisabled
     *            new value of {@code iMessageAndFaceTimeScreenDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iMessageAndFaceTimeScreenDisabled} field changed
     */
    public DepIOSEnrollmentProfile withIMessageAndFaceTimeScreenDisabled(Boolean iMessageAndFaceTimeScreenDisabled) {
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("iMessageAndFaceTimeScreenDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depIOSEnrollmentProfile");
        _x.iMessageAndFaceTimeScreenDisabled = iMessageAndFaceTimeScreenDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if onboarding setup screen is disabled”</i>
     * 
     * @return property onBoardingScreenDisabled
     */
    @Property(name="onBoardingScreenDisabled")
    @JsonIgnore
    public Optional<Boolean> getOnBoardingScreenDisabled() {
        return Optional.ofNullable(onBoardingScreenDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * onBoardingScreenDisabled} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if onboarding setup screen is disabled”</i>
     * 
     * @param onBoardingScreenDisabled
     *            new value of {@code onBoardingScreenDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code onBoardingScreenDisabled} field changed
     */
    public DepIOSEnrollmentProfile withOnBoardingScreenDisabled(Boolean onBoardingScreenDisabled) {
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("onBoardingScreenDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depIOSEnrollmentProfile");
        _x.onBoardingScreenDisabled = onBoardingScreenDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if the SIMSetup screen is disabled”</i>
     * 
     * @return property simSetupScreenDisabled
     */
    @Property(name="simSetupScreenDisabled")
    @JsonIgnore
    public Optional<Boolean> getSimSetupScreenDisabled() {
        return Optional.ofNullable(simSetupScreenDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * simSetupScreenDisabled} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if the SIMSetup screen is disabled”</i>
     * 
     * @param simSetupScreenDisabled
     *            new value of {@code simSetupScreenDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code simSetupScreenDisabled} field changed
     */
    public DepIOSEnrollmentProfile withSimSetupScreenDisabled(Boolean simSetupScreenDisabled) {
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("simSetupScreenDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depIOSEnrollmentProfile");
        _x.simSetupScreenDisabled = simSetupScreenDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if the mandatory sofware update screen is disabled”</i>
     * 
     * @return property softwareUpdateScreenDisabled
     */
    @Property(name="softwareUpdateScreenDisabled")
    @JsonIgnore
    public Optional<Boolean> getSoftwareUpdateScreenDisabled() {
        return Optional.ofNullable(softwareUpdateScreenDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * softwareUpdateScreenDisabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if the mandatory sofware update screen is disabled”</i>
     * 
     * @param softwareUpdateScreenDisabled
     *            new value of {@code softwareUpdateScreenDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code softwareUpdateScreenDisabled} field changed
     */
    public DepIOSEnrollmentProfile withSoftwareUpdateScreenDisabled(Boolean softwareUpdateScreenDisabled) {
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("softwareUpdateScreenDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depIOSEnrollmentProfile");
        _x.softwareUpdateScreenDisabled = softwareUpdateScreenDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if the watch migration screen is disabled”</i>
     * 
     * @return property watchMigrationScreenDisabled
     */
    @Property(name="watchMigrationScreenDisabled")
    @JsonIgnore
    public Optional<Boolean> getWatchMigrationScreenDisabled() {
        return Optional.ofNullable(watchMigrationScreenDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * watchMigrationScreenDisabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if the watch migration screen is disabled”</i>
     * 
     * @param watchMigrationScreenDisabled
     *            new value of {@code watchMigrationScreenDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code watchMigrationScreenDisabled} field changed
     */
    public DepIOSEnrollmentProfile withWatchMigrationScreenDisabled(Boolean watchMigrationScreenDisabled) {
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("watchMigrationScreenDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depIOSEnrollmentProfile");
        _x.watchMigrationScreenDisabled = watchMigrationScreenDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if Apperance screen is disabled”</i>
     * 
     * @return property appearanceScreenDisabled
     */
    @Property(name="appearanceScreenDisabled")
    @JsonIgnore
    public Optional<Boolean> getAppearanceScreenDisabled() {
        return Optional.ofNullable(appearanceScreenDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appearanceScreenDisabled} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if Apperance screen is disabled”</i>
     * 
     * @param appearanceScreenDisabled
     *            new value of {@code appearanceScreenDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appearanceScreenDisabled} field changed
     */
    public DepIOSEnrollmentProfile withAppearanceScreenDisabled(Boolean appearanceScreenDisabled) {
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("appearanceScreenDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depIOSEnrollmentProfile");
        _x.appearanceScreenDisabled = appearanceScreenDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if Express Language screen is disabled”</i>
     * 
     * @return property expressLanguageScreenDisabled
     */
    @Property(name="expressLanguageScreenDisabled")
    @JsonIgnore
    public Optional<Boolean> getExpressLanguageScreenDisabled() {
        return Optional.ofNullable(expressLanguageScreenDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * expressLanguageScreenDisabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if Express Language screen is disabled”</i>
     * 
     * @param expressLanguageScreenDisabled
     *            new value of {@code expressLanguageScreenDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code expressLanguageScreenDisabled} field changed
     */
    public DepIOSEnrollmentProfile withExpressLanguageScreenDisabled(Boolean expressLanguageScreenDisabled) {
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("expressLanguageScreenDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depIOSEnrollmentProfile");
        _x.expressLanguageScreenDisabled = expressLanguageScreenDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if Preferred language screen is disabled”</i>
     * 
     * @return property preferredLanguageScreenDisabled
     */
    @Property(name="preferredLanguageScreenDisabled")
    @JsonIgnore
    public Optional<Boolean> getPreferredLanguageScreenDisabled() {
        return Optional.ofNullable(preferredLanguageScreenDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * preferredLanguageScreenDisabled} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates if Preferred language screen is disabled”</i>
     * 
     * @param preferredLanguageScreenDisabled
     *            new value of {@code preferredLanguageScreenDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code preferredLanguageScreenDisabled} field changed
     */
    public DepIOSEnrollmentProfile withPreferredLanguageScreenDisabled(Boolean preferredLanguageScreenDisabled) {
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("preferredLanguageScreenDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depIOSEnrollmentProfile");
        _x.preferredLanguageScreenDisabled = preferredLanguageScreenDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if Device To Device Migration is disabled”</i>
     * 
     * @return property deviceToDeviceMigrationDisabled
     */
    @Property(name="deviceToDeviceMigrationDisabled")
    @JsonIgnore
    public Optional<Boolean> getDeviceToDeviceMigrationDisabled() {
        return Optional.ofNullable(deviceToDeviceMigrationDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceToDeviceMigrationDisabled} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates if Device To Device Migration is disabled”</i>
     * 
     * @param deviceToDeviceMigrationDisabled
     *            new value of {@code deviceToDeviceMigrationDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceToDeviceMigrationDisabled} field changed
     */
    public DepIOSEnrollmentProfile withDeviceToDeviceMigrationDisabled(Boolean deviceToDeviceMigrationDisabled) {
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("deviceToDeviceMigrationDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depIOSEnrollmentProfile");
        _x.deviceToDeviceMigrationDisabled = deviceToDeviceMigrationDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if Weclome screen is disabled”</i>
     * 
     * @return property welcomeScreenDisabled
     */
    @Property(name="welcomeScreenDisabled")
    @JsonIgnore
    public Optional<Boolean> getWelcomeScreenDisabled() {
        return Optional.ofNullable(welcomeScreenDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * welcomeScreenDisabled} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates if Weclome screen is disabled”</i>
     * 
     * @param welcomeScreenDisabled
     *            new value of {@code welcomeScreenDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code welcomeScreenDisabled} field changed
     */
    public DepIOSEnrollmentProfile withWelcomeScreenDisabled(Boolean welcomeScreenDisabled) {
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("welcomeScreenDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depIOSEnrollmentProfile");
        _x.welcomeScreenDisabled = welcomeScreenDisabled;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DepIOSEnrollmentProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DepIOSEnrollmentProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DepIOSEnrollmentProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DepIOSEnrollmentProfile _copy() {
        DepIOSEnrollmentProfile _x = new DepIOSEnrollmentProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.requiresUserAuthentication = requiresUserAuthentication;
        _x.configurationEndpointUrl = configurationEndpointUrl;
        _x.enableAuthenticationViaCompanyPortal = enableAuthenticationViaCompanyPortal;
        _x.requireCompanyPortalOnSetupAssistantEnrolledDevices = requireCompanyPortalOnSetupAssistantEnrolledDevices;
        _x.isDefault = isDefault;
        _x.supervisedModeEnabled = supervisedModeEnabled;
        _x.supportDepartment = supportDepartment;
        _x.passCodeDisabled = passCodeDisabled;
        _x.isMandatory = isMandatory;
        _x.locationDisabled = locationDisabled;
        _x.supportPhoneNumber = supportPhoneNumber;
        _x.profileRemovalDisabled = profileRemovalDisabled;
        _x.restoreBlocked = restoreBlocked;
        _x.appleIdDisabled = appleIdDisabled;
        _x.termsAndConditionsDisabled = termsAndConditionsDisabled;
        _x.touchIdDisabled = touchIdDisabled;
        _x.applePayDisabled = applePayDisabled;
        _x.zoomDisabled = zoomDisabled;
        _x.siriDisabled = siriDisabled;
        _x.diagnosticsDisabled = diagnosticsDisabled;
        _x.displayToneSetupDisabled = displayToneSetupDisabled;
        _x.privacyPaneDisabled = privacyPaneDisabled;
        _x.screenTimeScreenDisabled = screenTimeScreenDisabled;
        _x.deviceNameTemplate = deviceNameTemplate;
        _x.configurationWebUrl = configurationWebUrl;
        _x.iTunesPairingMode = iTunesPairingMode;
        _x.managementCertificates = managementCertificates;
        _x.restoreFromAndroidDisabled = restoreFromAndroidDisabled;
        _x.awaitDeviceConfiguredConfirmation = awaitDeviceConfiguredConfirmation;
        _x.sharedIPadMaximumUserCount = sharedIPadMaximumUserCount;
        _x.enableSharedIPad = enableSharedIPad;
        _x.companyPortalVppTokenId = companyPortalVppTokenId;
        _x.enableSingleAppEnrollmentMode = enableSingleAppEnrollmentMode;
        _x.homeButtonScreenDisabled = homeButtonScreenDisabled;
        _x.iMessageAndFaceTimeScreenDisabled = iMessageAndFaceTimeScreenDisabled;
        _x.onBoardingScreenDisabled = onBoardingScreenDisabled;
        _x.simSetupScreenDisabled = simSetupScreenDisabled;
        _x.softwareUpdateScreenDisabled = softwareUpdateScreenDisabled;
        _x.watchMigrationScreenDisabled = watchMigrationScreenDisabled;
        _x.appearanceScreenDisabled = appearanceScreenDisabled;
        _x.expressLanguageScreenDisabled = expressLanguageScreenDisabled;
        _x.preferredLanguageScreenDisabled = preferredLanguageScreenDisabled;
        _x.deviceToDeviceMigrationDisabled = deviceToDeviceMigrationDisabled;
        _x.welcomeScreenDisabled = welcomeScreenDisabled;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DepIOSEnrollmentProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("requiresUserAuthentication=");
        b.append(this.requiresUserAuthentication);
        b.append(", ");
        b.append("configurationEndpointUrl=");
        b.append(this.configurationEndpointUrl);
        b.append(", ");
        b.append("enableAuthenticationViaCompanyPortal=");
        b.append(this.enableAuthenticationViaCompanyPortal);
        b.append(", ");
        b.append("requireCompanyPortalOnSetupAssistantEnrolledDevices=");
        b.append(this.requireCompanyPortalOnSetupAssistantEnrolledDevices);
        b.append(", ");
        b.append("isDefault=");
        b.append(this.isDefault);
        b.append(", ");
        b.append("supervisedModeEnabled=");
        b.append(this.supervisedModeEnabled);
        b.append(", ");
        b.append("supportDepartment=");
        b.append(this.supportDepartment);
        b.append(", ");
        b.append("passCodeDisabled=");
        b.append(this.passCodeDisabled);
        b.append(", ");
        b.append("isMandatory=");
        b.append(this.isMandatory);
        b.append(", ");
        b.append("locationDisabled=");
        b.append(this.locationDisabled);
        b.append(", ");
        b.append("supportPhoneNumber=");
        b.append(this.supportPhoneNumber);
        b.append(", ");
        b.append("profileRemovalDisabled=");
        b.append(this.profileRemovalDisabled);
        b.append(", ");
        b.append("restoreBlocked=");
        b.append(this.restoreBlocked);
        b.append(", ");
        b.append("appleIdDisabled=");
        b.append(this.appleIdDisabled);
        b.append(", ");
        b.append("termsAndConditionsDisabled=");
        b.append(this.termsAndConditionsDisabled);
        b.append(", ");
        b.append("touchIdDisabled=");
        b.append(this.touchIdDisabled);
        b.append(", ");
        b.append("applePayDisabled=");
        b.append(this.applePayDisabled);
        b.append(", ");
        b.append("zoomDisabled=");
        b.append(this.zoomDisabled);
        b.append(", ");
        b.append("siriDisabled=");
        b.append(this.siriDisabled);
        b.append(", ");
        b.append("diagnosticsDisabled=");
        b.append(this.diagnosticsDisabled);
        b.append(", ");
        b.append("displayToneSetupDisabled=");
        b.append(this.displayToneSetupDisabled);
        b.append(", ");
        b.append("privacyPaneDisabled=");
        b.append(this.privacyPaneDisabled);
        b.append(", ");
        b.append("screenTimeScreenDisabled=");
        b.append(this.screenTimeScreenDisabled);
        b.append(", ");
        b.append("deviceNameTemplate=");
        b.append(this.deviceNameTemplate);
        b.append(", ");
        b.append("configurationWebUrl=");
        b.append(this.configurationWebUrl);
        b.append(", ");
        b.append("iTunesPairingMode=");
        b.append(this.iTunesPairingMode);
        b.append(", ");
        b.append("managementCertificates=");
        b.append(this.managementCertificates);
        b.append(", ");
        b.append("restoreFromAndroidDisabled=");
        b.append(this.restoreFromAndroidDisabled);
        b.append(", ");
        b.append("awaitDeviceConfiguredConfirmation=");
        b.append(this.awaitDeviceConfiguredConfirmation);
        b.append(", ");
        b.append("sharedIPadMaximumUserCount=");
        b.append(this.sharedIPadMaximumUserCount);
        b.append(", ");
        b.append("enableSharedIPad=");
        b.append(this.enableSharedIPad);
        b.append(", ");
        b.append("companyPortalVppTokenId=");
        b.append(this.companyPortalVppTokenId);
        b.append(", ");
        b.append("enableSingleAppEnrollmentMode=");
        b.append(this.enableSingleAppEnrollmentMode);
        b.append(", ");
        b.append("homeButtonScreenDisabled=");
        b.append(this.homeButtonScreenDisabled);
        b.append(", ");
        b.append("iMessageAndFaceTimeScreenDisabled=");
        b.append(this.iMessageAndFaceTimeScreenDisabled);
        b.append(", ");
        b.append("onBoardingScreenDisabled=");
        b.append(this.onBoardingScreenDisabled);
        b.append(", ");
        b.append("simSetupScreenDisabled=");
        b.append(this.simSetupScreenDisabled);
        b.append(", ");
        b.append("softwareUpdateScreenDisabled=");
        b.append(this.softwareUpdateScreenDisabled);
        b.append(", ");
        b.append("watchMigrationScreenDisabled=");
        b.append(this.watchMigrationScreenDisabled);
        b.append(", ");
        b.append("appearanceScreenDisabled=");
        b.append(this.appearanceScreenDisabled);
        b.append(", ");
        b.append("expressLanguageScreenDisabled=");
        b.append(this.expressLanguageScreenDisabled);
        b.append(", ");
        b.append("preferredLanguageScreenDisabled=");
        b.append(this.preferredLanguageScreenDisabled);
        b.append(", ");
        b.append("deviceToDeviceMigrationDisabled=");
        b.append(this.deviceToDeviceMigrationDisabled);
        b.append(", ");
        b.append("welcomeScreenDisabled=");
        b.append(this.welcomeScreenDisabled);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
