package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ManagementCertificateWithThumbprint;
import odata.msgraph.client.beta.enums.ITunesPairingMode;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“The depEnrollmentProfile resource represents an Apple Device Enrollment Program
 * (DEP) enrollment profile. This type of profile must be assigned to Apple DEP
 * serial numbers before the corresponding devices can enroll via DEP.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "isDefault", 
    "supervisedModeEnabled", 
    "supportDepartment", 
    "passCodeDisabled", 
    "isMandatory", 
    "locationDisabled", 
    "supportPhoneNumber", 
    "iTunesPairingMode", 
    "profileRemovalDisabled", 
    "managementCertificates", 
    "restoreBlocked", 
    "restoreFromAndroidDisabled", 
    "appleIdDisabled", 
    "termsAndConditionsDisabled", 
    "touchIdDisabled", 
    "applePayDisabled", 
    "zoomDisabled", 
    "siriDisabled", 
    "diagnosticsDisabled", 
    "macOSRegistrationDisabled", 
    "macOSFileVaultDisabled", 
    "awaitDeviceConfiguredConfirmation", 
    "sharedIPadMaximumUserCount", 
    "enableSharedIPad"})
@JsonInclude(Include.NON_NULL)
public class DepEnrollmentProfile extends EnrollmentProfile implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.depEnrollmentProfile";
    }

    @JsonProperty("isDefault")
    protected Boolean isDefault;

    @JsonProperty("supervisedModeEnabled")
    protected Boolean supervisedModeEnabled;

    @JsonProperty("supportDepartment")
    protected String supportDepartment;

    @JsonProperty("passCodeDisabled")
    protected Boolean passCodeDisabled;

    @JsonProperty("isMandatory")
    protected Boolean isMandatory;

    @JsonProperty("locationDisabled")
    protected Boolean locationDisabled;

    @JsonProperty("supportPhoneNumber")
    protected String supportPhoneNumber;

    @JsonProperty("iTunesPairingMode")
    protected ITunesPairingMode iTunesPairingMode;

    @JsonProperty("profileRemovalDisabled")
    protected Boolean profileRemovalDisabled;

    @JsonProperty("managementCertificates")
    protected List<ManagementCertificateWithThumbprint> managementCertificates;

    @JsonProperty("managementCertificates@nextLink")
    protected String managementCertificatesNextLink;

    @JsonProperty("restoreBlocked")
    protected Boolean restoreBlocked;

    @JsonProperty("restoreFromAndroidDisabled")
    protected Boolean restoreFromAndroidDisabled;

    @JsonProperty("appleIdDisabled")
    protected Boolean appleIdDisabled;

    @JsonProperty("termsAndConditionsDisabled")
    protected Boolean termsAndConditionsDisabled;

    @JsonProperty("touchIdDisabled")
    protected Boolean touchIdDisabled;

    @JsonProperty("applePayDisabled")
    protected Boolean applePayDisabled;

    @JsonProperty("zoomDisabled")
    protected Boolean zoomDisabled;

    @JsonProperty("siriDisabled")
    protected Boolean siriDisabled;

    @JsonProperty("diagnosticsDisabled")
    protected Boolean diagnosticsDisabled;

    @JsonProperty("macOSRegistrationDisabled")
    protected Boolean macOSRegistrationDisabled;

    @JsonProperty("macOSFileVaultDisabled")
    protected Boolean macOSFileVaultDisabled;

    @JsonProperty("awaitDeviceConfiguredConfirmation")
    protected Boolean awaitDeviceConfiguredConfirmation;

    @JsonProperty("sharedIPadMaximumUserCount")
    protected Integer sharedIPadMaximumUserCount;

    @JsonProperty("enableSharedIPad")
    protected Boolean enableSharedIPad;

    protected DepEnrollmentProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDepEnrollmentProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private Boolean requiresUserAuthentication;
        private String configurationEndpointUrl;
        private Boolean enableAuthenticationViaCompanyPortal;
        private Boolean requireCompanyPortalOnSetupAssistantEnrolledDevices;
        private Boolean isDefault;
        private Boolean supervisedModeEnabled;
        private String supportDepartment;
        private Boolean passCodeDisabled;
        private Boolean isMandatory;
        private Boolean locationDisabled;
        private String supportPhoneNumber;
        private ITunesPairingMode iTunesPairingMode;
        private Boolean profileRemovalDisabled;
        private List<ManagementCertificateWithThumbprint> managementCertificates;
        private String managementCertificatesNextLink;
        private Boolean restoreBlocked;
        private Boolean restoreFromAndroidDisabled;
        private Boolean appleIdDisabled;
        private Boolean termsAndConditionsDisabled;
        private Boolean touchIdDisabled;
        private Boolean applePayDisabled;
        private Boolean zoomDisabled;
        private Boolean siriDisabled;
        private Boolean diagnosticsDisabled;
        private Boolean macOSRegistrationDisabled;
        private Boolean macOSFileVaultDisabled;
        private Boolean awaitDeviceConfiguredConfirmation;
        private Integer sharedIPadMaximumUserCount;
        private Boolean enableSharedIPad;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder requiresUserAuthentication(Boolean requiresUserAuthentication) {
            this.requiresUserAuthentication = requiresUserAuthentication;
            this.changedFields = changedFields.add("requiresUserAuthentication");
            return this;
        }

        public Builder configurationEndpointUrl(String configurationEndpointUrl) {
            this.configurationEndpointUrl = configurationEndpointUrl;
            this.changedFields = changedFields.add("configurationEndpointUrl");
            return this;
        }

        public Builder enableAuthenticationViaCompanyPortal(Boolean enableAuthenticationViaCompanyPortal) {
            this.enableAuthenticationViaCompanyPortal = enableAuthenticationViaCompanyPortal;
            this.changedFields = changedFields.add("enableAuthenticationViaCompanyPortal");
            return this;
        }

        public Builder requireCompanyPortalOnSetupAssistantEnrolledDevices(Boolean requireCompanyPortalOnSetupAssistantEnrolledDevices) {
            this.requireCompanyPortalOnSetupAssistantEnrolledDevices = requireCompanyPortalOnSetupAssistantEnrolledDevices;
            this.changedFields = changedFields.add("requireCompanyPortalOnSetupAssistantEnrolledDevices");
            return this;
        }

        /**
         * <i>“Indicates if this is the default profile”</i>
         * 
         * @param isDefault
         *            value of {@code isDefault} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.changedFields = changedFields.add("isDefault");
            return this;
        }

        /**
         * <i>“Supervised mode, True to enable, false otherwise. See https://docs.microsoft.com
         * /en-us/intune/deploy-use/enroll-devices-in-microsoft-intune for additional
         * information.”</i>
         * 
         * @param supervisedModeEnabled
         *            value of {@code supervisedModeEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supervisedModeEnabled(Boolean supervisedModeEnabled) {
            this.supervisedModeEnabled = supervisedModeEnabled;
            this.changedFields = changedFields.add("supervisedModeEnabled");
            return this;
        }

        /**
         * <i>“Support department information”</i>
         * 
         * @param supportDepartment
         *            value of {@code supportDepartment} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportDepartment(String supportDepartment) {
            this.supportDepartment = supportDepartment;
            this.changedFields = changedFields.add("supportDepartment");
            return this;
        }

        /**
         * <i>“Indicates if Passcode setup pane is disabled”</i>
         * 
         * @param passCodeDisabled
         *            value of {@code passCodeDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passCodeDisabled(Boolean passCodeDisabled) {
            this.passCodeDisabled = passCodeDisabled;
            this.changedFields = changedFields.add("passCodeDisabled");
            return this;
        }

        /**
         * <i>“Indicates if the profile is mandatory”</i>
         * 
         * @param isMandatory
         *            value of {@code isMandatory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isMandatory(Boolean isMandatory) {
            this.isMandatory = isMandatory;
            this.changedFields = changedFields.add("isMandatory");
            return this;
        }

        /**
         * <i>“Indicates if Location service setup pane is disabled”</i>
         * 
         * @param locationDisabled
         *            value of {@code locationDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder locationDisabled(Boolean locationDisabled) {
            this.locationDisabled = locationDisabled;
            this.changedFields = changedFields.add("locationDisabled");
            return this;
        }

        /**
         * <i>“Support phone number”</i>
         * 
         * @param supportPhoneNumber
         *            value of {@code supportPhoneNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportPhoneNumber(String supportPhoneNumber) {
            this.supportPhoneNumber = supportPhoneNumber;
            this.changedFields = changedFields.add("supportPhoneNumber");
            return this;
        }

        /**
         * <i>“Indicates the iTunes pairing mode”</i>
         * 
         * @param iTunesPairingMode
         *            value of {@code iTunesPairingMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iTunesPairingMode(ITunesPairingMode iTunesPairingMode) {
            this.iTunesPairingMode = iTunesPairingMode;
            this.changedFields = changedFields.add("iTunesPairingMode");
            return this;
        }

        /**
         * <i>“Indicates if the profile removal option is disabled”</i>
         * 
         * @param profileRemovalDisabled
         *            value of {@code profileRemovalDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder profileRemovalDisabled(Boolean profileRemovalDisabled) {
            this.profileRemovalDisabled = profileRemovalDisabled;
            this.changedFields = changedFields.add("profileRemovalDisabled");
            return this;
        }

        /**
         * <i>“Management certificates for Apple Configurator”</i>
         * 
         * @param managementCertificates
         *            value of {@code managementCertificates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managementCertificates(List<ManagementCertificateWithThumbprint> managementCertificates) {
            this.managementCertificates = managementCertificates;
            this.changedFields = changedFields.add("managementCertificates");
            return this;
        }

        /**
         * <i>“Management certificates for Apple Configurator”</i>
         * 
         * @param managementCertificates
         *            value of {@code managementCertificates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managementCertificates(ManagementCertificateWithThumbprint... managementCertificates) {
            return managementCertificates(Arrays.asList(managementCertificates));
        }

        /**
         * <i>“Management certificates for Apple Configurator”</i>
         * 
         * @param managementCertificatesNextLink
         *            value of {@code managementCertificates@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managementCertificatesNextLink(String managementCertificatesNextLink) {
            this.managementCertificatesNextLink = managementCertificatesNextLink;
            this.changedFields = changedFields.add("managementCertificates");
            return this;
        }

        /**
         * <i>“Indicates if Restore setup pane is blocked”</i>
         * 
         * @param restoreBlocked
         *            value of {@code restoreBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder restoreBlocked(Boolean restoreBlocked) {
            this.restoreBlocked = restoreBlocked;
            this.changedFields = changedFields.add("restoreBlocked");
            return this;
        }

        /**
         * <i>“Indicates if Restore from Android is disabled”</i>
         * 
         * @param restoreFromAndroidDisabled
         *            value of {@code restoreFromAndroidDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder restoreFromAndroidDisabled(Boolean restoreFromAndroidDisabled) {
            this.restoreFromAndroidDisabled = restoreFromAndroidDisabled;
            this.changedFields = changedFields.add("restoreFromAndroidDisabled");
            return this;
        }

        /**
         * <i>“Indicates if Apple id setup pane is disabled”</i>
         * 
         * @param appleIdDisabled
         *            value of {@code appleIdDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appleIdDisabled(Boolean appleIdDisabled) {
            this.appleIdDisabled = appleIdDisabled;
            this.changedFields = changedFields.add("appleIdDisabled");
            return this;
        }

        /**
         * <i>“Indicates if 'Terms and Conditions' setup pane is disabled”</i>
         * 
         * @param termsAndConditionsDisabled
         *            value of {@code termsAndConditionsDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder termsAndConditionsDisabled(Boolean termsAndConditionsDisabled) {
            this.termsAndConditionsDisabled = termsAndConditionsDisabled;
            this.changedFields = changedFields.add("termsAndConditionsDisabled");
            return this;
        }

        /**
         * <i>“Indicates if touch id setup pane is disabled”</i>
         * 
         * @param touchIdDisabled
         *            value of {@code touchIdDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder touchIdDisabled(Boolean touchIdDisabled) {
            this.touchIdDisabled = touchIdDisabled;
            this.changedFields = changedFields.add("touchIdDisabled");
            return this;
        }

        /**
         * <i>“Indicates if Apple pay setup pane is disabled”</i>
         * 
         * @param applePayDisabled
         *            value of {@code applePayDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applePayDisabled(Boolean applePayDisabled) {
            this.applePayDisabled = applePayDisabled;
            this.changedFields = changedFields.add("applePayDisabled");
            return this;
        }

        /**
         * <i>“Indicates if zoom setup pane is disabled”</i>
         * 
         * @param zoomDisabled
         *            value of {@code zoomDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder zoomDisabled(Boolean zoomDisabled) {
            this.zoomDisabled = zoomDisabled;
            this.changedFields = changedFields.add("zoomDisabled");
            return this;
        }

        /**
         * <i>“Indicates if siri setup pane is disabled”</i>
         * 
         * @param siriDisabled
         *            value of {@code siriDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder siriDisabled(Boolean siriDisabled) {
            this.siriDisabled = siriDisabled;
            this.changedFields = changedFields.add("siriDisabled");
            return this;
        }

        /**
         * <i>“Indicates if diagnostics setup pane is disabled”</i>
         * 
         * @param diagnosticsDisabled
         *            value of {@code diagnosticsDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder diagnosticsDisabled(Boolean diagnosticsDisabled) {
            this.diagnosticsDisabled = diagnosticsDisabled;
            this.changedFields = changedFields.add("diagnosticsDisabled");
            return this;
        }

        /**
         * <i>“Indicates if Mac OS registration is disabled”</i>
         * 
         * @param macOSRegistrationDisabled
         *            value of {@code macOSRegistrationDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder macOSRegistrationDisabled(Boolean macOSRegistrationDisabled) {
            this.macOSRegistrationDisabled = macOSRegistrationDisabled;
            this.changedFields = changedFields.add("macOSRegistrationDisabled");
            return this;
        }

        /**
         * <i>“Indicates if Mac OS file vault is disabled”</i>
         * 
         * @param macOSFileVaultDisabled
         *            value of {@code macOSFileVaultDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder macOSFileVaultDisabled(Boolean macOSFileVaultDisabled) {
            this.macOSFileVaultDisabled = macOSFileVaultDisabled;
            this.changedFields = changedFields.add("macOSFileVaultDisabled");
            return this;
        }

        /**
         * <i>“Indicates if the device will need to wait for configured confirmation”</i>
         * 
         * @param awaitDeviceConfiguredConfirmation
         *            value of {@code awaitDeviceConfiguredConfirmation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder awaitDeviceConfiguredConfirmation(Boolean awaitDeviceConfiguredConfirmation) {
            this.awaitDeviceConfiguredConfirmation = awaitDeviceConfiguredConfirmation;
            this.changedFields = changedFields.add("awaitDeviceConfiguredConfirmation");
            return this;
        }

        /**
         * <i>“This specifies the maximum number of users that can use a shared iPad. Only
         * applicable in shared iPad mode.”</i>
         * 
         * @param sharedIPadMaximumUserCount
         *            value of {@code sharedIPadMaximumUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sharedIPadMaximumUserCount(Integer sharedIPadMaximumUserCount) {
            this.sharedIPadMaximumUserCount = sharedIPadMaximumUserCount;
            this.changedFields = changedFields.add("sharedIPadMaximumUserCount");
            return this;
        }

        /**
         * <i>“This indicates whether the device is to be enrolled in a mode which enables
         * multi user scenarios. Only applicable in shared iPads.”</i>
         * 
         * @param enableSharedIPad
         *            value of {@code enableSharedIPad} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableSharedIPad(Boolean enableSharedIPad) {
            this.enableSharedIPad = enableSharedIPad;
            this.changedFields = changedFields.add("enableSharedIPad");
            return this;
        }

        public DepEnrollmentProfile build() {
            DepEnrollmentProfile _x = new DepEnrollmentProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.depEnrollmentProfile";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.requiresUserAuthentication = requiresUserAuthentication;
            _x.configurationEndpointUrl = configurationEndpointUrl;
            _x.enableAuthenticationViaCompanyPortal = enableAuthenticationViaCompanyPortal;
            _x.requireCompanyPortalOnSetupAssistantEnrolledDevices = requireCompanyPortalOnSetupAssistantEnrolledDevices;
            _x.isDefault = isDefault;
            _x.supervisedModeEnabled = supervisedModeEnabled;
            _x.supportDepartment = supportDepartment;
            _x.passCodeDisabled = passCodeDisabled;
            _x.isMandatory = isMandatory;
            _x.locationDisabled = locationDisabled;
            _x.supportPhoneNumber = supportPhoneNumber;
            _x.iTunesPairingMode = iTunesPairingMode;
            _x.profileRemovalDisabled = profileRemovalDisabled;
            _x.managementCertificates = managementCertificates;
            _x.managementCertificatesNextLink = managementCertificatesNextLink;
            _x.restoreBlocked = restoreBlocked;
            _x.restoreFromAndroidDisabled = restoreFromAndroidDisabled;
            _x.appleIdDisabled = appleIdDisabled;
            _x.termsAndConditionsDisabled = termsAndConditionsDisabled;
            _x.touchIdDisabled = touchIdDisabled;
            _x.applePayDisabled = applePayDisabled;
            _x.zoomDisabled = zoomDisabled;
            _x.siriDisabled = siriDisabled;
            _x.diagnosticsDisabled = diagnosticsDisabled;
            _x.macOSRegistrationDisabled = macOSRegistrationDisabled;
            _x.macOSFileVaultDisabled = macOSFileVaultDisabled;
            _x.awaitDeviceConfiguredConfirmation = awaitDeviceConfiguredConfirmation;
            _x.sharedIPadMaximumUserCount = sharedIPadMaximumUserCount;
            _x.enableSharedIPad = enableSharedIPad;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Indicates if this is the default profile”</i>
     * 
     * @return property isDefault
     */
    @Property(name="isDefault")
    @JsonIgnore
    public Optional<Boolean> getIsDefault() {
        return Optional.ofNullable(isDefault);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isDefault} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates if this is the default profile”</i>
     * 
     * @param isDefault
     *            new value of {@code isDefault} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isDefault} field changed
     */
    public DepEnrollmentProfile withIsDefault(Boolean isDefault) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("isDefault");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.isDefault = isDefault;
        return _x;
    }

    /**
     * <i>“Supervised mode, True to enable, false otherwise. See https://docs.microsoft.com
     * /en-us/intune/deploy-use/enroll-devices-in-microsoft-intune for additional
     * information.”</i>
     * 
     * @return property supervisedModeEnabled
     */
    @Property(name="supervisedModeEnabled")
    @JsonIgnore
    public Optional<Boolean> getSupervisedModeEnabled() {
        return Optional.ofNullable(supervisedModeEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * supervisedModeEnabled} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Supervised mode, True to enable, false otherwise. See https://docs.microsoft.com
     * /en-us/intune/deploy-use/enroll-devices-in-microsoft-intune for additional
     * information.”</i>
     * 
     * @param supervisedModeEnabled
     *            new value of {@code supervisedModeEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supervisedModeEnabled} field changed
     */
    public DepEnrollmentProfile withSupervisedModeEnabled(Boolean supervisedModeEnabled) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("supervisedModeEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.supervisedModeEnabled = supervisedModeEnabled;
        return _x;
    }

    /**
     * <i>“Support department information”</i>
     * 
     * @return property supportDepartment
     */
    @Property(name="supportDepartment")
    @JsonIgnore
    public Optional<String> getSupportDepartment() {
        return Optional.ofNullable(supportDepartment);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code supportDepartment
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Support department information”</i>
     * 
     * @param supportDepartment
     *            new value of {@code supportDepartment} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supportDepartment} field changed
     */
    public DepEnrollmentProfile withSupportDepartment(String supportDepartment) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("supportDepartment");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.supportDepartment = supportDepartment;
        return _x;
    }

    /**
     * <i>“Indicates if Passcode setup pane is disabled”</i>
     * 
     * @return property passCodeDisabled
     */
    @Property(name="passCodeDisabled")
    @JsonIgnore
    public Optional<Boolean> getPassCodeDisabled() {
        return Optional.ofNullable(passCodeDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code passCodeDisabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if Passcode setup pane is disabled”</i>
     * 
     * @param passCodeDisabled
     *            new value of {@code passCodeDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passCodeDisabled} field changed
     */
    public DepEnrollmentProfile withPassCodeDisabled(Boolean passCodeDisabled) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("passCodeDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.passCodeDisabled = passCodeDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if the profile is mandatory”</i>
     * 
     * @return property isMandatory
     */
    @Property(name="isMandatory")
    @JsonIgnore
    public Optional<Boolean> getIsMandatory() {
        return Optional.ofNullable(isMandatory);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isMandatory}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if the profile is mandatory”</i>
     * 
     * @param isMandatory
     *            new value of {@code isMandatory} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isMandatory} field changed
     */
    public DepEnrollmentProfile withIsMandatory(Boolean isMandatory) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("isMandatory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.isMandatory = isMandatory;
        return _x;
    }

    /**
     * <i>“Indicates if Location service setup pane is disabled”</i>
     * 
     * @return property locationDisabled
     */
    @Property(name="locationDisabled")
    @JsonIgnore
    public Optional<Boolean> getLocationDisabled() {
        return Optional.ofNullable(locationDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code locationDisabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if Location service setup pane is disabled”</i>
     * 
     * @param locationDisabled
     *            new value of {@code locationDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code locationDisabled} field changed
     */
    public DepEnrollmentProfile withLocationDisabled(Boolean locationDisabled) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("locationDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.locationDisabled = locationDisabled;
        return _x;
    }

    /**
     * <i>“Support phone number”</i>
     * 
     * @return property supportPhoneNumber
     */
    @Property(name="supportPhoneNumber")
    @JsonIgnore
    public Optional<String> getSupportPhoneNumber() {
        return Optional.ofNullable(supportPhoneNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * supportPhoneNumber} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Support phone number”</i>
     * 
     * @param supportPhoneNumber
     *            new value of {@code supportPhoneNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supportPhoneNumber} field changed
     */
    public DepEnrollmentProfile withSupportPhoneNumber(String supportPhoneNumber) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("supportPhoneNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.supportPhoneNumber = supportPhoneNumber;
        return _x;
    }

    /**
     * <i>“Indicates the iTunes pairing mode”</i>
     * 
     * @return property iTunesPairingMode
     */
    @Property(name="iTunesPairingMode")
    @JsonIgnore
    public Optional<ITunesPairingMode> getITunesPairingMode() {
        return Optional.ofNullable(iTunesPairingMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code iTunesPairingMode
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates the iTunes pairing mode”</i>
     * 
     * @param iTunesPairingMode
     *            new value of {@code iTunesPairingMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iTunesPairingMode} field changed
     */
    public DepEnrollmentProfile withITunesPairingMode(ITunesPairingMode iTunesPairingMode) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("iTunesPairingMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.iTunesPairingMode = iTunesPairingMode;
        return _x;
    }

    /**
     * <i>“Indicates if the profile removal option is disabled”</i>
     * 
     * @return property profileRemovalDisabled
     */
    @Property(name="profileRemovalDisabled")
    @JsonIgnore
    public Optional<Boolean> getProfileRemovalDisabled() {
        return Optional.ofNullable(profileRemovalDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * profileRemovalDisabled} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if the profile removal option is disabled”</i>
     * 
     * @param profileRemovalDisabled
     *            new value of {@code profileRemovalDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code profileRemovalDisabled} field changed
     */
    public DepEnrollmentProfile withProfileRemovalDisabled(Boolean profileRemovalDisabled) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("profileRemovalDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.profileRemovalDisabled = profileRemovalDisabled;
        return _x;
    }

    /**
     * <i>“Management certificates for Apple Configurator”</i>
     * 
     * @return property managementCertificates
     */
    @Property(name="managementCertificates")
    @JsonIgnore
    public CollectionPage<ManagementCertificateWithThumbprint> getManagementCertificates() {
        return new CollectionPage<ManagementCertificateWithThumbprint>(contextPath, ManagementCertificateWithThumbprint.class, managementCertificates, Optional.ofNullable(managementCertificatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Management certificates for Apple Configurator”</i>
     * 
     * @return property managementCertificates
     */
    @Property(name="managementCertificates")
    @JsonIgnore
    public CollectionPage<ManagementCertificateWithThumbprint> getManagementCertificates(HttpRequestOptions options) {
        return new CollectionPage<ManagementCertificateWithThumbprint>(contextPath, ManagementCertificateWithThumbprint.class, managementCertificates, Optional.ofNullable(managementCertificatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates if Restore setup pane is blocked”</i>
     * 
     * @return property restoreBlocked
     */
    @Property(name="restoreBlocked")
    @JsonIgnore
    public Optional<Boolean> getRestoreBlocked() {
        return Optional.ofNullable(restoreBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code restoreBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if Restore setup pane is blocked”</i>
     * 
     * @param restoreBlocked
     *            new value of {@code restoreBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code restoreBlocked} field changed
     */
    public DepEnrollmentProfile withRestoreBlocked(Boolean restoreBlocked) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("restoreBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.restoreBlocked = restoreBlocked;
        return _x;
    }

    /**
     * <i>“Indicates if Restore from Android is disabled”</i>
     * 
     * @return property restoreFromAndroidDisabled
     */
    @Property(name="restoreFromAndroidDisabled")
    @JsonIgnore
    public Optional<Boolean> getRestoreFromAndroidDisabled() {
        return Optional.ofNullable(restoreFromAndroidDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * restoreFromAndroidDisabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if Restore from Android is disabled”</i>
     * 
     * @param restoreFromAndroidDisabled
     *            new value of {@code restoreFromAndroidDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code restoreFromAndroidDisabled} field changed
     */
    public DepEnrollmentProfile withRestoreFromAndroidDisabled(Boolean restoreFromAndroidDisabled) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("restoreFromAndroidDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.restoreFromAndroidDisabled = restoreFromAndroidDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if Apple id setup pane is disabled”</i>
     * 
     * @return property appleIdDisabled
     */
    @Property(name="appleIdDisabled")
    @JsonIgnore
    public Optional<Boolean> getAppleIdDisabled() {
        return Optional.ofNullable(appleIdDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appleIdDisabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if Apple id setup pane is disabled”</i>
     * 
     * @param appleIdDisabled
     *            new value of {@code appleIdDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appleIdDisabled} field changed
     */
    public DepEnrollmentProfile withAppleIdDisabled(Boolean appleIdDisabled) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("appleIdDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.appleIdDisabled = appleIdDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if 'Terms and Conditions' setup pane is disabled”</i>
     * 
     * @return property termsAndConditionsDisabled
     */
    @Property(name="termsAndConditionsDisabled")
    @JsonIgnore
    public Optional<Boolean> getTermsAndConditionsDisabled() {
        return Optional.ofNullable(termsAndConditionsDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * termsAndConditionsDisabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if 'Terms and Conditions' setup pane is disabled”</i>
     * 
     * @param termsAndConditionsDisabled
     *            new value of {@code termsAndConditionsDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code termsAndConditionsDisabled} field changed
     */
    public DepEnrollmentProfile withTermsAndConditionsDisabled(Boolean termsAndConditionsDisabled) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("termsAndConditionsDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.termsAndConditionsDisabled = termsAndConditionsDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if touch id setup pane is disabled”</i>
     * 
     * @return property touchIdDisabled
     */
    @Property(name="touchIdDisabled")
    @JsonIgnore
    public Optional<Boolean> getTouchIdDisabled() {
        return Optional.ofNullable(touchIdDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code touchIdDisabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if touch id setup pane is disabled”</i>
     * 
     * @param touchIdDisabled
     *            new value of {@code touchIdDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code touchIdDisabled} field changed
     */
    public DepEnrollmentProfile withTouchIdDisabled(Boolean touchIdDisabled) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("touchIdDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.touchIdDisabled = touchIdDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if Apple pay setup pane is disabled”</i>
     * 
     * @return property applePayDisabled
     */
    @Property(name="applePayDisabled")
    @JsonIgnore
    public Optional<Boolean> getApplePayDisabled() {
        return Optional.ofNullable(applePayDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code applePayDisabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if Apple pay setup pane is disabled”</i>
     * 
     * @param applePayDisabled
     *            new value of {@code applePayDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applePayDisabled} field changed
     */
    public DepEnrollmentProfile withApplePayDisabled(Boolean applePayDisabled) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("applePayDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.applePayDisabled = applePayDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if zoom setup pane is disabled”</i>
     * 
     * @return property zoomDisabled
     */
    @Property(name="zoomDisabled")
    @JsonIgnore
    public Optional<Boolean> getZoomDisabled() {
        return Optional.ofNullable(zoomDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code zoomDisabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if zoom setup pane is disabled”</i>
     * 
     * @param zoomDisabled
     *            new value of {@code zoomDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code zoomDisabled} field changed
     */
    public DepEnrollmentProfile withZoomDisabled(Boolean zoomDisabled) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("zoomDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.zoomDisabled = zoomDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if siri setup pane is disabled”</i>
     * 
     * @return property siriDisabled
     */
    @Property(name="siriDisabled")
    @JsonIgnore
    public Optional<Boolean> getSiriDisabled() {
        return Optional.ofNullable(siriDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code siriDisabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if siri setup pane is disabled”</i>
     * 
     * @param siriDisabled
     *            new value of {@code siriDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code siriDisabled} field changed
     */
    public DepEnrollmentProfile withSiriDisabled(Boolean siriDisabled) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("siriDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.siriDisabled = siriDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if diagnostics setup pane is disabled”</i>
     * 
     * @return property diagnosticsDisabled
     */
    @Property(name="diagnosticsDisabled")
    @JsonIgnore
    public Optional<Boolean> getDiagnosticsDisabled() {
        return Optional.ofNullable(diagnosticsDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * diagnosticsDisabled} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates if diagnostics setup pane is disabled”</i>
     * 
     * @param diagnosticsDisabled
     *            new value of {@code diagnosticsDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code diagnosticsDisabled} field changed
     */
    public DepEnrollmentProfile withDiagnosticsDisabled(Boolean diagnosticsDisabled) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("diagnosticsDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.diagnosticsDisabled = diagnosticsDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if Mac OS registration is disabled”</i>
     * 
     * @return property macOSRegistrationDisabled
     */
    @Property(name="macOSRegistrationDisabled")
    @JsonIgnore
    public Optional<Boolean> getMacOSRegistrationDisabled() {
        return Optional.ofNullable(macOSRegistrationDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * macOSRegistrationDisabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if Mac OS registration is disabled”</i>
     * 
     * @param macOSRegistrationDisabled
     *            new value of {@code macOSRegistrationDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code macOSRegistrationDisabled} field changed
     */
    public DepEnrollmentProfile withMacOSRegistrationDisabled(Boolean macOSRegistrationDisabled) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("macOSRegistrationDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.macOSRegistrationDisabled = macOSRegistrationDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if Mac OS file vault is disabled”</i>
     * 
     * @return property macOSFileVaultDisabled
     */
    @Property(name="macOSFileVaultDisabled")
    @JsonIgnore
    public Optional<Boolean> getMacOSFileVaultDisabled() {
        return Optional.ofNullable(macOSFileVaultDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * macOSFileVaultDisabled} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if Mac OS file vault is disabled”</i>
     * 
     * @param macOSFileVaultDisabled
     *            new value of {@code macOSFileVaultDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code macOSFileVaultDisabled} field changed
     */
    public DepEnrollmentProfile withMacOSFileVaultDisabled(Boolean macOSFileVaultDisabled) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("macOSFileVaultDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.macOSFileVaultDisabled = macOSFileVaultDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if the device will need to wait for configured confirmation”</i>
     * 
     * @return property awaitDeviceConfiguredConfirmation
     */
    @Property(name="awaitDeviceConfiguredConfirmation")
    @JsonIgnore
    public Optional<Boolean> getAwaitDeviceConfiguredConfirmation() {
        return Optional.ofNullable(awaitDeviceConfiguredConfirmation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * awaitDeviceConfiguredConfirmation} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates if the device will need to wait for configured confirmation”</i>
     * 
     * @param awaitDeviceConfiguredConfirmation
     *            new value of {@code awaitDeviceConfiguredConfirmation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code awaitDeviceConfiguredConfirmation} field changed
     */
    public DepEnrollmentProfile withAwaitDeviceConfiguredConfirmation(Boolean awaitDeviceConfiguredConfirmation) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("awaitDeviceConfiguredConfirmation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.awaitDeviceConfiguredConfirmation = awaitDeviceConfiguredConfirmation;
        return _x;
    }

    /**
     * <i>“This specifies the maximum number of users that can use a shared iPad. Only
     * applicable in shared iPad mode.”</i>
     * 
     * @return property sharedIPadMaximumUserCount
     */
    @Property(name="sharedIPadMaximumUserCount")
    @JsonIgnore
    public Optional<Integer> getSharedIPadMaximumUserCount() {
        return Optional.ofNullable(sharedIPadMaximumUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * sharedIPadMaximumUserCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This specifies the maximum number of users that can use a shared iPad. Only
     * applicable in shared iPad mode.”</i>
     * 
     * @param sharedIPadMaximumUserCount
     *            new value of {@code sharedIPadMaximumUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sharedIPadMaximumUserCount} field changed
     */
    public DepEnrollmentProfile withSharedIPadMaximumUserCount(Integer sharedIPadMaximumUserCount) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("sharedIPadMaximumUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.sharedIPadMaximumUserCount = sharedIPadMaximumUserCount;
        return _x;
    }

    /**
     * <i>“This indicates whether the device is to be enrolled in a mode which enables
     * multi user scenarios. Only applicable in shared iPads.”</i>
     * 
     * @return property enableSharedIPad
     */
    @Property(name="enableSharedIPad")
    @JsonIgnore
    public Optional<Boolean> getEnableSharedIPad() {
        return Optional.ofNullable(enableSharedIPad);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enableSharedIPad}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“This indicates whether the device is to be enrolled in a mode which enables
     * multi user scenarios. Only applicable in shared iPads.”</i>
     * 
     * @param enableSharedIPad
     *            new value of {@code enableSharedIPad} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableSharedIPad} field changed
     */
    public DepEnrollmentProfile withEnableSharedIPad(Boolean enableSharedIPad) {
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("enableSharedIPad");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentProfile");
        _x.enableSharedIPad = enableSharedIPad;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DepEnrollmentProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DepEnrollmentProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DepEnrollmentProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DepEnrollmentProfile _copy() {
        DepEnrollmentProfile _x = new DepEnrollmentProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.requiresUserAuthentication = requiresUserAuthentication;
        _x.configurationEndpointUrl = configurationEndpointUrl;
        _x.enableAuthenticationViaCompanyPortal = enableAuthenticationViaCompanyPortal;
        _x.requireCompanyPortalOnSetupAssistantEnrolledDevices = requireCompanyPortalOnSetupAssistantEnrolledDevices;
        _x.isDefault = isDefault;
        _x.supervisedModeEnabled = supervisedModeEnabled;
        _x.supportDepartment = supportDepartment;
        _x.passCodeDisabled = passCodeDisabled;
        _x.isMandatory = isMandatory;
        _x.locationDisabled = locationDisabled;
        _x.supportPhoneNumber = supportPhoneNumber;
        _x.iTunesPairingMode = iTunesPairingMode;
        _x.profileRemovalDisabled = profileRemovalDisabled;
        _x.managementCertificates = managementCertificates;
        _x.restoreBlocked = restoreBlocked;
        _x.restoreFromAndroidDisabled = restoreFromAndroidDisabled;
        _x.appleIdDisabled = appleIdDisabled;
        _x.termsAndConditionsDisabled = termsAndConditionsDisabled;
        _x.touchIdDisabled = touchIdDisabled;
        _x.applePayDisabled = applePayDisabled;
        _x.zoomDisabled = zoomDisabled;
        _x.siriDisabled = siriDisabled;
        _x.diagnosticsDisabled = diagnosticsDisabled;
        _x.macOSRegistrationDisabled = macOSRegistrationDisabled;
        _x.macOSFileVaultDisabled = macOSFileVaultDisabled;
        _x.awaitDeviceConfiguredConfirmation = awaitDeviceConfiguredConfirmation;
        _x.sharedIPadMaximumUserCount = sharedIPadMaximumUserCount;
        _x.enableSharedIPad = enableSharedIPad;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DepEnrollmentProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("requiresUserAuthentication=");
        b.append(this.requiresUserAuthentication);
        b.append(", ");
        b.append("configurationEndpointUrl=");
        b.append(this.configurationEndpointUrl);
        b.append(", ");
        b.append("enableAuthenticationViaCompanyPortal=");
        b.append(this.enableAuthenticationViaCompanyPortal);
        b.append(", ");
        b.append("requireCompanyPortalOnSetupAssistantEnrolledDevices=");
        b.append(this.requireCompanyPortalOnSetupAssistantEnrolledDevices);
        b.append(", ");
        b.append("isDefault=");
        b.append(this.isDefault);
        b.append(", ");
        b.append("supervisedModeEnabled=");
        b.append(this.supervisedModeEnabled);
        b.append(", ");
        b.append("supportDepartment=");
        b.append(this.supportDepartment);
        b.append(", ");
        b.append("passCodeDisabled=");
        b.append(this.passCodeDisabled);
        b.append(", ");
        b.append("isMandatory=");
        b.append(this.isMandatory);
        b.append(", ");
        b.append("locationDisabled=");
        b.append(this.locationDisabled);
        b.append(", ");
        b.append("supportPhoneNumber=");
        b.append(this.supportPhoneNumber);
        b.append(", ");
        b.append("iTunesPairingMode=");
        b.append(this.iTunesPairingMode);
        b.append(", ");
        b.append("profileRemovalDisabled=");
        b.append(this.profileRemovalDisabled);
        b.append(", ");
        b.append("managementCertificates=");
        b.append(this.managementCertificates);
        b.append(", ");
        b.append("restoreBlocked=");
        b.append(this.restoreBlocked);
        b.append(", ");
        b.append("restoreFromAndroidDisabled=");
        b.append(this.restoreFromAndroidDisabled);
        b.append(", ");
        b.append("appleIdDisabled=");
        b.append(this.appleIdDisabled);
        b.append(", ");
        b.append("termsAndConditionsDisabled=");
        b.append(this.termsAndConditionsDisabled);
        b.append(", ");
        b.append("touchIdDisabled=");
        b.append(this.touchIdDisabled);
        b.append(", ");
        b.append("applePayDisabled=");
        b.append(this.applePayDisabled);
        b.append(", ");
        b.append("zoomDisabled=");
        b.append(this.zoomDisabled);
        b.append(", ");
        b.append("siriDisabled=");
        b.append(this.siriDisabled);
        b.append(", ");
        b.append("diagnosticsDisabled=");
        b.append(this.diagnosticsDisabled);
        b.append(", ");
        b.append("macOSRegistrationDisabled=");
        b.append(this.macOSRegistrationDisabled);
        b.append(", ");
        b.append("macOSFileVaultDisabled=");
        b.append(this.macOSFileVaultDisabled);
        b.append(", ");
        b.append("awaitDeviceConfiguredConfirmation=");
        b.append(this.awaitDeviceConfiguredConfirmation);
        b.append(", ");
        b.append("sharedIPadMaximumUserCount=");
        b.append(this.sharedIPadMaximumUserCount);
        b.append(", ");
        b.append("enableSharedIPad=");
        b.append(this.enableSharedIPad);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
