package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.PermissionClassificationType;

@JsonPropertyOrder({
    "@odata.type", 
    "permissionId", 
    "permissionName", 
    "classification"})
@JsonInclude(Include.NON_NULL)
public class DelegatedPermissionClassification extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.delegatedPermissionClassification";
    }

    @JsonProperty("permissionId")
    protected String permissionId;

    @JsonProperty("permissionName")
    protected String permissionName;

    @JsonProperty("classification")
    protected PermissionClassificationType classification;

    protected DelegatedPermissionClassification() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDelegatedPermissionClassification() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String permissionId;
        private String permissionName;
        private PermissionClassificationType classification;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder permissionId(String permissionId) {
            this.permissionId = permissionId;
            this.changedFields = changedFields.add("permissionId");
            return this;
        }

        public Builder permissionName(String permissionName) {
            this.permissionName = permissionName;
            this.changedFields = changedFields.add("permissionName");
            return this;
        }

        public Builder classification(PermissionClassificationType classification) {
            this.classification = classification;
            this.changedFields = changedFields.add("classification");
            return this;
        }

        public DelegatedPermissionClassification build() {
            DelegatedPermissionClassification _x = new DelegatedPermissionClassification();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.delegatedPermissionClassification";
            _x.id = id;
            _x.permissionId = permissionId;
            _x.permissionName = permissionName;
            _x.classification = classification;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="permissionId")
    @JsonIgnore
    public Optional<String> getPermissionId() {
        return Optional.ofNullable(permissionId);
    }

    public DelegatedPermissionClassification withPermissionId(String permissionId) {
        DelegatedPermissionClassification _x = _copy();
        _x.changedFields = changedFields.add("permissionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedPermissionClassification");
        _x.permissionId = permissionId;
        return _x;
    }

    @Property(name="permissionName")
    @JsonIgnore
    public Optional<String> getPermissionName() {
        return Optional.ofNullable(permissionName);
    }

    public DelegatedPermissionClassification withPermissionName(String permissionName) {
        DelegatedPermissionClassification _x = _copy();
        _x.changedFields = changedFields.add("permissionName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedPermissionClassification");
        _x.permissionName = permissionName;
        return _x;
    }

    @Property(name="classification")
    @JsonIgnore
    public Optional<PermissionClassificationType> getClassification() {
        return Optional.ofNullable(classification);
    }

    public DelegatedPermissionClassification withClassification(PermissionClassificationType classification) {
        DelegatedPermissionClassification _x = _copy();
        _x.changedFields = changedFields.add("classification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedPermissionClassification");
        _x.classification = classification;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DelegatedPermissionClassification patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DelegatedPermissionClassification _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DelegatedPermissionClassification put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DelegatedPermissionClassification _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DelegatedPermissionClassification _copy() {
        DelegatedPermissionClassification _x = new DelegatedPermissionClassification();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.permissionId = permissionId;
        _x.permissionName = permissionName;
        _x.classification = classification;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DelegatedPermissionClassification[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("permissionId=");
        b.append(this.permissionId);
        b.append(", ");
        b.append("permissionName=");
        b.append(this.permissionName);
        b.append(", ");
        b.append("classification=");
        b.append(this.classification);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
