package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.ContentClassification;
import odata.msgraph.client.beta.complex.ExactMatchClassificationResult;
import odata.msgraph.client.beta.entity.collection.request.ExactMatchDataStoreCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExactMatchUploadAgentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.FileClassificationRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.JobResponseBaseCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SensitiveTypeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SensitivityLabelCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TextClassificationRequestCollectionRequest;

@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class DataClassificationService extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.dataClassificationService";
    }

    protected DataClassificationService() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDataClassificationService() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public DataClassificationService build() {
            DataClassificationService _x = new DataClassificationService();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.dataClassificationService";
            _x.id = id;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @NavigationProperty(name="exactMatchDataStores")
    @JsonIgnore
    public ExactMatchDataStoreCollectionRequest getExactMatchDataStores() {
        return new ExactMatchDataStoreCollectionRequest(
                        contextPath.addSegment("exactMatchDataStores"));
    }

    @NavigationProperty(name="sensitiveTypes")
    @JsonIgnore
    public SensitiveTypeCollectionRequest getSensitiveTypes() {
        return new SensitiveTypeCollectionRequest(
                        contextPath.addSegment("sensitiveTypes"));
    }

    @NavigationProperty(name="jobs")
    @JsonIgnore
    public JobResponseBaseCollectionRequest getJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("jobs"));
    }

    @NavigationProperty(name="classifyFileJobs")
    @JsonIgnore
    public JobResponseBaseCollectionRequest getClassifyFileJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("classifyFileJobs"));
    }

    @NavigationProperty(name="classifyTextJobs")
    @JsonIgnore
    public JobResponseBaseCollectionRequest getClassifyTextJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("classifyTextJobs"));
    }

    @NavigationProperty(name="evaluateLabelJobs")
    @JsonIgnore
    public JobResponseBaseCollectionRequest getEvaluateLabelJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("evaluateLabelJobs"));
    }

    @NavigationProperty(name="evaluateDlpPoliciesJobs")
    @JsonIgnore
    public JobResponseBaseCollectionRequest getEvaluateDlpPoliciesJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("evaluateDlpPoliciesJobs"));
    }

    @NavigationProperty(name="labelsAndPoliciesEvaluationJobs")
    @JsonIgnore
    public JobResponseBaseCollectionRequest getLabelsAndPoliciesEvaluationJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("labelsAndPoliciesEvaluationJobs"));
    }

    @NavigationProperty(name="classifyText")
    @JsonIgnore
    public TextClassificationRequestCollectionRequest getClassifyText() {
        return new TextClassificationRequestCollectionRequest(
                        contextPath.addSegment("classifyText"));
    }

    @NavigationProperty(name="classifyFile")
    @JsonIgnore
    public FileClassificationRequestCollectionRequest getClassifyFile() {
        return new FileClassificationRequestCollectionRequest(
                        contextPath.addSegment("classifyFile"));
    }

    @NavigationProperty(name="sensitivityLabels")
    @JsonIgnore
    public SensitivityLabelCollectionRequest getSensitivityLabels() {
        return new SensitivityLabelCollectionRequest(
                        contextPath.addSegment("sensitivityLabels"));
    }

    @NavigationProperty(name="exactMatchUploadAgents")
    @JsonIgnore
    public ExactMatchUploadAgentCollectionRequest getExactMatchUploadAgents() {
        return new ExactMatchUploadAgentCollectionRequest(
                        contextPath.addSegment("exactMatchUploadAgents"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DataClassificationService patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DataClassificationService _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DataClassificationService put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DataClassificationService _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DataClassificationService _copy() {
        DataClassificationService _x = new DataClassificationService();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        return _x;
    }

    @Action(name = "classifyExactMatches")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ExactMatchClassificationResult> classifyExactMatches(String text, String timeoutInMs, List<String> sensitiveTypeIds, List<ContentClassification> contentClassifications) {
        Preconditions.checkNotNull(contentClassifications, "contentClassifications cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "Edm.String", Checks.checkIsAscii(text))
            .put("timeoutInMs", "Edm.String", Checks.checkIsAscii(timeoutInMs))
            .put("sensitiveTypeIds", "Collection(Edm.String)", Checks.checkIsAscii(sensitiveTypeIds))
            .put("contentClassifications", "Collection(microsoft.graph.contentClassification)", contentClassifications)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ExactMatchClassificationResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.classifyExactMatches"), ExactMatchClassificationResult.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DataClassificationService[");
        b.append("id=");
        b.append(this.id);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
