package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "code", 
    "displayName", 
    "symbol", 
    "amountDecimalPlaces", 
    "amountRoundingPrecision", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class Currency extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.currency";
    }

    @JsonProperty("code")
    protected String code;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("symbol")
    protected String symbol;

    @JsonProperty("amountDecimalPlaces")
    protected String amountDecimalPlaces;

    @JsonProperty("amountRoundingPrecision")
    protected BigDecimal amountRoundingPrecision;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected Currency() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCurrency() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String code;
        private String displayName;
        private String symbol;
        private String amountDecimalPlaces;
        private BigDecimal amountRoundingPrecision;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            this.changedFields = changedFields.add("code");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder symbol(String symbol) {
            this.symbol = symbol;
            this.changedFields = changedFields.add("symbol");
            return this;
        }

        public Builder amountDecimalPlaces(String amountDecimalPlaces) {
            this.amountDecimalPlaces = amountDecimalPlaces;
            this.changedFields = changedFields.add("amountDecimalPlaces");
            return this;
        }

        public Builder amountRoundingPrecision(BigDecimal amountRoundingPrecision) {
            this.amountRoundingPrecision = amountRoundingPrecision;
            this.changedFields = changedFields.add("amountRoundingPrecision");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Currency build() {
            Currency _x = new Currency();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.currency";
            _x.id = id;
            _x.code = code;
            _x.displayName = displayName;
            _x.symbol = symbol;
            _x.amountDecimalPlaces = amountDecimalPlaces;
            _x.amountRoundingPrecision = amountRoundingPrecision;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="code")
    @JsonIgnore
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    public Currency withCode(String code) {
        Currency _x = _copy();
        _x.changedFields = changedFields.add("code");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.currency");
        _x.code = code;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Currency withDisplayName(String displayName) {
        Currency _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.currency");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="symbol")
    @JsonIgnore
    public Optional<String> getSymbol() {
        return Optional.ofNullable(symbol);
    }

    public Currency withSymbol(String symbol) {
        Currency _x = _copy();
        _x.changedFields = changedFields.add("symbol");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.currency");
        _x.symbol = symbol;
        return _x;
    }

    @Property(name="amountDecimalPlaces")
    @JsonIgnore
    public Optional<String> getAmountDecimalPlaces() {
        return Optional.ofNullable(amountDecimalPlaces);
    }

    public Currency withAmountDecimalPlaces(String amountDecimalPlaces) {
        Currency _x = _copy();
        _x.changedFields = changedFields.add("amountDecimalPlaces");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.currency");
        _x.amountDecimalPlaces = amountDecimalPlaces;
        return _x;
    }

    @Property(name="amountRoundingPrecision")
    @JsonIgnore
    public Optional<BigDecimal> getAmountRoundingPrecision() {
        return Optional.ofNullable(amountRoundingPrecision);
    }

    public Currency withAmountRoundingPrecision(BigDecimal amountRoundingPrecision) {
        Currency _x = _copy();
        _x.changedFields = changedFields.add("amountRoundingPrecision");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.currency");
        _x.amountRoundingPrecision = amountRoundingPrecision;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public Currency withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        Currency _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.currency");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Currency patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Currency _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Currency put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Currency _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Currency _copy() {
        Currency _x = new Currency();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.code = code;
        _x.displayName = displayName;
        _x.symbol = symbol;
        _x.amountDecimalPlaces = amountDecimalPlaces;
        _x.amountRoundingPrecision = amountRoundingPrecision;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Currency[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("code=");
        b.append(this.code);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("symbol=");
        b.append(this.symbol);
        b.append(", ");
        b.append("amountDecimalPlaces=");
        b.append(this.amountDecimalPlaces);
        b.append(", ");
        b.append("amountRoundingPrecision=");
        b.append(this.amountRoundingPrecision);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
