package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.UserRegistrationCount;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 */@JsonPropertyOrder({
    "@odata.type", 
    "totalUserCount", 
    "userRegistrationCounts"})
@JsonInclude(Include.NON_NULL)
public class CredentialUserRegistrationCount extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.credentialUserRegistrationCount";
    }

    @JsonProperty("totalUserCount")
    protected Long totalUserCount;

    @JsonProperty("userRegistrationCounts")
    protected List<UserRegistrationCount> userRegistrationCounts;

    @JsonProperty("userRegistrationCounts@nextLink")
    protected String userRegistrationCountsNextLink;

    protected CredentialUserRegistrationCount() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCredentialUserRegistrationCount() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Long totalUserCount;
        private List<UserRegistrationCount> userRegistrationCounts;
        private String userRegistrationCountsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder totalUserCount(Long totalUserCount) {
            this.totalUserCount = totalUserCount;
            this.changedFields = changedFields.add("totalUserCount");
            return this;
        }

        public Builder userRegistrationCounts(List<UserRegistrationCount> userRegistrationCounts) {
            this.userRegistrationCounts = userRegistrationCounts;
            this.changedFields = changedFields.add("userRegistrationCounts");
            return this;
        }

        public Builder userRegistrationCounts(UserRegistrationCount... userRegistrationCounts) {
            return userRegistrationCounts(Arrays.asList(userRegistrationCounts));
        }

        public Builder userRegistrationCountsNextLink(String userRegistrationCountsNextLink) {
            this.userRegistrationCountsNextLink = userRegistrationCountsNextLink;
            this.changedFields = changedFields.add("userRegistrationCounts");
            return this;
        }

        public CredentialUserRegistrationCount build() {
            CredentialUserRegistrationCount _x = new CredentialUserRegistrationCount();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.credentialUserRegistrationCount";
            _x.id = id;
            _x.totalUserCount = totalUserCount;
            _x.userRegistrationCounts = userRegistrationCounts;
            _x.userRegistrationCountsNextLink = userRegistrationCountsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="totalUserCount")
    @JsonIgnore
    public Optional<Long> getTotalUserCount() {
        return Optional.ofNullable(totalUserCount);
    }

    public CredentialUserRegistrationCount withTotalUserCount(Long totalUserCount) {
        CredentialUserRegistrationCount _x = _copy();
        _x.changedFields = changedFields.add("totalUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.credentialUserRegistrationCount");
        _x.totalUserCount = totalUserCount;
        return _x;
    }

    @Property(name="userRegistrationCounts")
    @JsonIgnore
    public CollectionPage<UserRegistrationCount> getUserRegistrationCounts() {
        return new CollectionPage<UserRegistrationCount>(contextPath, UserRegistrationCount.class, userRegistrationCounts, Optional.ofNullable(userRegistrationCountsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="userRegistrationCounts")
    @JsonIgnore
    public CollectionPage<UserRegistrationCount> getUserRegistrationCounts(HttpRequestOptions options) {
        return new CollectionPage<UserRegistrationCount>(contextPath, UserRegistrationCount.class, userRegistrationCounts, Optional.ofNullable(userRegistrationCountsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CredentialUserRegistrationCount patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CredentialUserRegistrationCount _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CredentialUserRegistrationCount put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CredentialUserRegistrationCount _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CredentialUserRegistrationCount _copy() {
        CredentialUserRegistrationCount _x = new CredentialUserRegistrationCount();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.totalUserCount = totalUserCount;
        _x.userRegistrationCounts = userRegistrationCounts;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CredentialUserRegistrationCount[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("totalUserCount=");
        b.append(this.totalUserCount);
        b.append(", ");
        b.append("userRegistrationCounts=");
        b.append(this.userRegistrationCounts);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
