package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.ContentTypeOrder;
import odata.msgraph.client.beta.complex.ItemReference;
import odata.msgraph.client.beta.entity.collection.request.ColumnLinkCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "group", 
    "hidden", 
    "inheritedFrom", 
    "name", 
    "order", 
    "parentId", 
    "readOnly", 
    "sealed"})
@JsonInclude(Include.NON_NULL)
public class ContentType extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.contentType";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("group")
    protected String group;

    @JsonProperty("hidden")
    protected Boolean hidden;

    @JsonProperty("inheritedFrom")
    protected ItemReference inheritedFrom;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("order")
    protected ContentTypeOrder order;

    @JsonProperty("parentId")
    protected String parentId;

    @JsonProperty("readOnly")
    protected Boolean readOnly;

    @JsonProperty("sealed")
    protected Boolean sealed;

    protected ContentType() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderContentType() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private String group;
        private Boolean hidden;
        private ItemReference inheritedFrom;
        private String name;
        private ContentTypeOrder order;
        private String parentId;
        private Boolean readOnly;
        private Boolean sealed;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            this.changedFields = changedFields.add("group");
            return this;
        }

        public Builder hidden(Boolean hidden) {
            this.hidden = hidden;
            this.changedFields = changedFields.add("hidden");
            return this;
        }

        public Builder inheritedFrom(ItemReference inheritedFrom) {
            this.inheritedFrom = inheritedFrom;
            this.changedFields = changedFields.add("inheritedFrom");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder order(ContentTypeOrder order) {
            this.order = order;
            this.changedFields = changedFields.add("order");
            return this;
        }

        public Builder parentId(String parentId) {
            this.parentId = parentId;
            this.changedFields = changedFields.add("parentId");
            return this;
        }

        public Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            this.changedFields = changedFields.add("readOnly");
            return this;
        }

        public Builder sealed(Boolean sealed) {
            this.sealed = sealed;
            this.changedFields = changedFields.add("sealed");
            return this;
        }

        public ContentType build() {
            ContentType _x = new ContentType();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.contentType";
            _x.id = id;
            _x.description = description;
            _x.group = group;
            _x.hidden = hidden;
            _x.inheritedFrom = inheritedFrom;
            _x.name = name;
            _x.order = order;
            _x.parentId = parentId;
            _x.readOnly = readOnly;
            _x.sealed = sealed;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ContentType withDescription(String description) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.description = description;
        return _x;
    }

    @Property(name="group")
    @JsonIgnore
    public Optional<String> getGroup() {
        return Optional.ofNullable(group);
    }

    public ContentType withGroup(String group) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("group");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.group = group;
        return _x;
    }

    @Property(name="hidden")
    @JsonIgnore
    public Optional<Boolean> getHidden() {
        return Optional.ofNullable(hidden);
    }

    public ContentType withHidden(Boolean hidden) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("hidden");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.hidden = hidden;
        return _x;
    }

    @Property(name="inheritedFrom")
    @JsonIgnore
    public Optional<ItemReference> getInheritedFrom() {
        return Optional.ofNullable(inheritedFrom);
    }

    public ContentType withInheritedFrom(ItemReference inheritedFrom) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("inheritedFrom");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.inheritedFrom = inheritedFrom;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public ContentType withName(String name) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.name = name;
        return _x;
    }

    @Property(name="order")
    @JsonIgnore
    public Optional<ContentTypeOrder> getOrder() {
        return Optional.ofNullable(order);
    }

    public ContentType withOrder(ContentTypeOrder order) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("order");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.order = order;
        return _x;
    }

    @Property(name="parentId")
    @JsonIgnore
    public Optional<String> getParentId() {
        return Optional.ofNullable(parentId);
    }

    public ContentType withParentId(String parentId) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("parentId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.parentId = parentId;
        return _x;
    }

    @Property(name="readOnly")
    @JsonIgnore
    public Optional<Boolean> getReadOnly() {
        return Optional.ofNullable(readOnly);
    }

    public ContentType withReadOnly(Boolean readOnly) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("readOnly");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.readOnly = readOnly;
        return _x;
    }

    @Property(name="sealed")
    @JsonIgnore
    public Optional<Boolean> getSealed() {
        return Optional.ofNullable(sealed);
    }

    public ContentType withSealed(Boolean sealed) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("sealed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.sealed = sealed;
        return _x;
    }

    @NavigationProperty(name="columnLinks")
    @JsonIgnore
    public ColumnLinkCollectionRequest getColumnLinks() {
        return new ColumnLinkCollectionRequest(
                        contextPath.addSegment("columnLinks"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ContentType patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ContentType _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ContentType put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ContentType _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ContentType _copy() {
        ContentType _x = new ContentType();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.group = group;
        _x.hidden = hidden;
        _x.inheritedFrom = inheritedFrom;
        _x.name = name;
        _x.order = order;
        _x.parentId = parentId;
        _x.readOnly = readOnly;
        _x.sealed = sealed;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ContentType[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("group=");
        b.append(this.group);
        b.append(", ");
        b.append("hidden=");
        b.append(this.hidden);
        b.append(", ");
        b.append("inheritedFrom=");
        b.append(this.inheritedFrom);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("order=");
        b.append(this.order);
        b.append(", ");
        b.append("parentId=");
        b.append(this.parentId);
        b.append(", ");
        b.append("readOnly=");
        b.append(this.readOnly);
        b.append(", ");
        b.append("sealed=");
        b.append(this.sealed);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
