package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.ContactCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ContactFolderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "parentFolderId", 
    "displayName", 
    "wellKnownName"})
@JsonInclude(Include.NON_NULL)
public class ContactFolder extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.contactFolder";
    }

    @JsonProperty("parentFolderId")
    protected String parentFolderId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("wellKnownName")
    protected String wellKnownName;

    protected ContactFolder() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderContactFolder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String parentFolderId;
        private String displayName;
        private String wellKnownName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            this.changedFields = changedFields.add("parentFolderId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder wellKnownName(String wellKnownName) {
            this.wellKnownName = wellKnownName;
            this.changedFields = changedFields.add("wellKnownName");
            return this;
        }

        public ContactFolder build() {
            ContactFolder _x = new ContactFolder();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.contactFolder";
            _x.id = id;
            _x.parentFolderId = parentFolderId;
            _x.displayName = displayName;
            _x.wellKnownName = wellKnownName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="parentFolderId")
    @JsonIgnore
    public Optional<String> getParentFolderId() {
        return Optional.ofNullable(parentFolderId);
    }

    public ContactFolder withParentFolderId(String parentFolderId) {
        ContactFolder _x = _copy();
        _x.changedFields = changedFields.add("parentFolderId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contactFolder");
        _x.parentFolderId = parentFolderId;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ContactFolder withDisplayName(String displayName) {
        ContactFolder _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contactFolder");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="wellKnownName")
    @JsonIgnore
    public Optional<String> getWellKnownName() {
        return Optional.ofNullable(wellKnownName);
    }

    public ContactFolder withWellKnownName(String wellKnownName) {
        ContactFolder _x = _copy();
        _x.changedFields = changedFields.add("wellKnownName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contactFolder");
        _x.wellKnownName = wellKnownName;
        return _x;
    }

    @NavigationProperty(name="singleValueExtendedProperties")
    @JsonIgnore
    public SingleValueLegacyExtendedPropertyCollectionRequest getSingleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"));
    }

    @NavigationProperty(name="multiValueExtendedProperties")
    @JsonIgnore
    public MultiValueLegacyExtendedPropertyCollectionRequest getMultiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property contacts
     */
    @NavigationProperty(name="contacts")
    @JsonIgnore
    public ContactCollectionRequest getContacts() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("contacts"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * 
     * @return navigational property childFolders
     */
    @NavigationProperty(name="childFolders")
    @JsonIgnore
    public ContactFolderCollectionRequest getChildFolders() {
        return new ContactFolderCollectionRequest(
                        contextPath.addSegment("childFolders"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ContactFolder patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ContactFolder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ContactFolder put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ContactFolder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ContactFolder _copy() {
        ContactFolder _x = new ContactFolder();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.parentFolderId = parentFolderId;
        _x.displayName = displayName;
        _x.wellKnownName = wellKnownName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ContactFolder[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("parentFolderId=");
        b.append(this.parentFolderId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("wellKnownName=");
        b.append(this.wellKnownName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
