package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ComplianceManagementPartnerAssignment;
import odata.msgraph.client.beta.enums.DeviceManagementPartnerTenantState;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Compliance management partner for all platforms”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "lastHeartbeatDateTime", 
    "partnerState", 
    "displayName", 
    "macOsOnboarded", 
    "windowsOnboarded", 
    "androidOnboarded", 
    "iosOnboarded", 
    "macOsEnrollmentAssignments", 
    "windowsEnrollmentAssignments", 
    "androidEnrollmentAssignments", 
    "iosEnrollmentAssignments"})
@JsonInclude(Include.NON_NULL)
public class ComplianceManagementPartner extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.complianceManagementPartner";
    }

    @JsonProperty("lastHeartbeatDateTime")
    protected OffsetDateTime lastHeartbeatDateTime;

    @JsonProperty("partnerState")
    protected DeviceManagementPartnerTenantState partnerState;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("macOsOnboarded")
    protected Boolean macOsOnboarded;

    @JsonProperty("windowsOnboarded")
    protected Boolean windowsOnboarded;

    @JsonProperty("androidOnboarded")
    protected Boolean androidOnboarded;

    @JsonProperty("iosOnboarded")
    protected Boolean iosOnboarded;

    @JsonProperty("macOsEnrollmentAssignments")
    protected List<ComplianceManagementPartnerAssignment> macOsEnrollmentAssignments;

    @JsonProperty("macOsEnrollmentAssignments@nextLink")
    protected String macOsEnrollmentAssignmentsNextLink;

    @JsonProperty("windowsEnrollmentAssignments")
    protected List<ComplianceManagementPartnerAssignment> windowsEnrollmentAssignments;

    @JsonProperty("windowsEnrollmentAssignments@nextLink")
    protected String windowsEnrollmentAssignmentsNextLink;

    @JsonProperty("androidEnrollmentAssignments")
    protected List<ComplianceManagementPartnerAssignment> androidEnrollmentAssignments;

    @JsonProperty("androidEnrollmentAssignments@nextLink")
    protected String androidEnrollmentAssignmentsNextLink;

    @JsonProperty("iosEnrollmentAssignments")
    protected List<ComplianceManagementPartnerAssignment> iosEnrollmentAssignments;

    @JsonProperty("iosEnrollmentAssignments@nextLink")
    protected String iosEnrollmentAssignmentsNextLink;

    protected ComplianceManagementPartner() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderComplianceManagementPartner() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastHeartbeatDateTime;
        private DeviceManagementPartnerTenantState partnerState;
        private String displayName;
        private Boolean macOsOnboarded;
        private Boolean windowsOnboarded;
        private Boolean androidOnboarded;
        private Boolean iosOnboarded;
        private List<ComplianceManagementPartnerAssignment> macOsEnrollmentAssignments;
        private String macOsEnrollmentAssignmentsNextLink;
        private List<ComplianceManagementPartnerAssignment> windowsEnrollmentAssignments;
        private String windowsEnrollmentAssignmentsNextLink;
        private List<ComplianceManagementPartnerAssignment> androidEnrollmentAssignments;
        private String androidEnrollmentAssignmentsNextLink;
        private List<ComplianceManagementPartnerAssignment> iosEnrollmentAssignments;
        private String iosEnrollmentAssignmentsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Timestamp of last heartbeat after admin onboarded to the compliance management
         * partner”</i>
         * 
         * @param lastHeartbeatDateTime
         *            value of {@code lastHeartbeatDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastHeartbeatDateTime(OffsetDateTime lastHeartbeatDateTime) {
            this.lastHeartbeatDateTime = lastHeartbeatDateTime;
            this.changedFields = changedFields.add("lastHeartbeatDateTime");
            return this;
        }

        /**
         * <i>“Partner state of this tenant”</i>
         * 
         * @param partnerState
         *            value of {@code partnerState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder partnerState(DeviceManagementPartnerTenantState partnerState) {
            this.partnerState = partnerState;
            this.changedFields = changedFields.add("partnerState");
            return this;
        }

        /**
         * <i>“Partner display name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Partner onboarded for Mac devices.”</i>
         * 
         * @param macOsOnboarded
         *            value of {@code macOsOnboarded} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder macOsOnboarded(Boolean macOsOnboarded) {
            this.macOsOnboarded = macOsOnboarded;
            this.changedFields = changedFields.add("macOsOnboarded");
            return this;
        }

        /**
         * <i>“Partner onboarded for Windows devices.”</i>
         * 
         * @param windowsOnboarded
         *            value of {@code windowsOnboarded} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsOnboarded(Boolean windowsOnboarded) {
            this.windowsOnboarded = windowsOnboarded;
            this.changedFields = changedFields.add("windowsOnboarded");
            return this;
        }

        /**
         * <i>“Partner onboarded for Android devices.”</i>
         * 
         * @param androidOnboarded
         *            value of {@code androidOnboarded} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidOnboarded(Boolean androidOnboarded) {
            this.androidOnboarded = androidOnboarded;
            this.changedFields = changedFields.add("androidOnboarded");
            return this;
        }

        /**
         * <i>“Partner onboarded for ios devices.”</i>
         * 
         * @param iosOnboarded
         *            value of {@code iosOnboarded} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iosOnboarded(Boolean iosOnboarded) {
            this.iosOnboarded = iosOnboarded;
            this.changedFields = changedFields.add("iosOnboarded");
            return this;
        }

        /**
         * <i>“User groups which enroll Mac devices through partner.”</i>
         * 
         * @param macOsEnrollmentAssignments
         *            value of {@code macOsEnrollmentAssignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder macOsEnrollmentAssignments(List<ComplianceManagementPartnerAssignment> macOsEnrollmentAssignments) {
            this.macOsEnrollmentAssignments = macOsEnrollmentAssignments;
            this.changedFields = changedFields.add("macOsEnrollmentAssignments");
            return this;
        }

        /**
         * <i>“User groups which enroll Mac devices through partner.”</i>
         * 
         * @param macOsEnrollmentAssignments
         *            value of {@code macOsEnrollmentAssignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder macOsEnrollmentAssignments(ComplianceManagementPartnerAssignment... macOsEnrollmentAssignments) {
            return macOsEnrollmentAssignments(Arrays.asList(macOsEnrollmentAssignments));
        }

        /**
         * <i>“User groups which enroll Mac devices through partner.”</i>
         * 
         * @param macOsEnrollmentAssignmentsNextLink
         *            value of {@code macOsEnrollmentAssignments@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder macOsEnrollmentAssignmentsNextLink(String macOsEnrollmentAssignmentsNextLink) {
            this.macOsEnrollmentAssignmentsNextLink = macOsEnrollmentAssignmentsNextLink;
            this.changedFields = changedFields.add("macOsEnrollmentAssignments");
            return this;
        }

        /**
         * <i>“User groups which enroll Windows devices through partner.”</i>
         * 
         * @param windowsEnrollmentAssignments
         *            value of {@code windowsEnrollmentAssignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsEnrollmentAssignments(List<ComplianceManagementPartnerAssignment> windowsEnrollmentAssignments) {
            this.windowsEnrollmentAssignments = windowsEnrollmentAssignments;
            this.changedFields = changedFields.add("windowsEnrollmentAssignments");
            return this;
        }

        /**
         * <i>“User groups which enroll Windows devices through partner.”</i>
         * 
         * @param windowsEnrollmentAssignments
         *            value of {@code windowsEnrollmentAssignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsEnrollmentAssignments(ComplianceManagementPartnerAssignment... windowsEnrollmentAssignments) {
            return windowsEnrollmentAssignments(Arrays.asList(windowsEnrollmentAssignments));
        }

        /**
         * <i>“User groups which enroll Windows devices through partner.”</i>
         * 
         * @param windowsEnrollmentAssignmentsNextLink
         *            value of {@code windowsEnrollmentAssignments@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsEnrollmentAssignmentsNextLink(String windowsEnrollmentAssignmentsNextLink) {
            this.windowsEnrollmentAssignmentsNextLink = windowsEnrollmentAssignmentsNextLink;
            this.changedFields = changedFields.add("windowsEnrollmentAssignments");
            return this;
        }

        /**
         * <i>“User groups which enroll Android devices through partner.”</i>
         * 
         * @param androidEnrollmentAssignments
         *            value of {@code androidEnrollmentAssignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidEnrollmentAssignments(List<ComplianceManagementPartnerAssignment> androidEnrollmentAssignments) {
            this.androidEnrollmentAssignments = androidEnrollmentAssignments;
            this.changedFields = changedFields.add("androidEnrollmentAssignments");
            return this;
        }

        /**
         * <i>“User groups which enroll Android devices through partner.”</i>
         * 
         * @param androidEnrollmentAssignments
         *            value of {@code androidEnrollmentAssignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidEnrollmentAssignments(ComplianceManagementPartnerAssignment... androidEnrollmentAssignments) {
            return androidEnrollmentAssignments(Arrays.asList(androidEnrollmentAssignments));
        }

        /**
         * <i>“User groups which enroll Android devices through partner.”</i>
         * 
         * @param androidEnrollmentAssignmentsNextLink
         *            value of {@code androidEnrollmentAssignments@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidEnrollmentAssignmentsNextLink(String androidEnrollmentAssignmentsNextLink) {
            this.androidEnrollmentAssignmentsNextLink = androidEnrollmentAssignmentsNextLink;
            this.changedFields = changedFields.add("androidEnrollmentAssignments");
            return this;
        }

        /**
         * <i>“User groups which enroll ios devices through partner.”</i>
         * 
         * @param iosEnrollmentAssignments
         *            value of {@code iosEnrollmentAssignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iosEnrollmentAssignments(List<ComplianceManagementPartnerAssignment> iosEnrollmentAssignments) {
            this.iosEnrollmentAssignments = iosEnrollmentAssignments;
            this.changedFields = changedFields.add("iosEnrollmentAssignments");
            return this;
        }

        /**
         * <i>“User groups which enroll ios devices through partner.”</i>
         * 
         * @param iosEnrollmentAssignments
         *            value of {@code iosEnrollmentAssignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iosEnrollmentAssignments(ComplianceManagementPartnerAssignment... iosEnrollmentAssignments) {
            return iosEnrollmentAssignments(Arrays.asList(iosEnrollmentAssignments));
        }

        /**
         * <i>“User groups which enroll ios devices through partner.”</i>
         * 
         * @param iosEnrollmentAssignmentsNextLink
         *            value of {@code iosEnrollmentAssignments@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iosEnrollmentAssignmentsNextLink(String iosEnrollmentAssignmentsNextLink) {
            this.iosEnrollmentAssignmentsNextLink = iosEnrollmentAssignmentsNextLink;
            this.changedFields = changedFields.add("iosEnrollmentAssignments");
            return this;
        }

        public ComplianceManagementPartner build() {
            ComplianceManagementPartner _x = new ComplianceManagementPartner();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.complianceManagementPartner";
            _x.id = id;
            _x.lastHeartbeatDateTime = lastHeartbeatDateTime;
            _x.partnerState = partnerState;
            _x.displayName = displayName;
            _x.macOsOnboarded = macOsOnboarded;
            _x.windowsOnboarded = windowsOnboarded;
            _x.androidOnboarded = androidOnboarded;
            _x.iosOnboarded = iosOnboarded;
            _x.macOsEnrollmentAssignments = macOsEnrollmentAssignments;
            _x.macOsEnrollmentAssignmentsNextLink = macOsEnrollmentAssignmentsNextLink;
            _x.windowsEnrollmentAssignments = windowsEnrollmentAssignments;
            _x.windowsEnrollmentAssignmentsNextLink = windowsEnrollmentAssignmentsNextLink;
            _x.androidEnrollmentAssignments = androidEnrollmentAssignments;
            _x.androidEnrollmentAssignmentsNextLink = androidEnrollmentAssignmentsNextLink;
            _x.iosEnrollmentAssignments = iosEnrollmentAssignments;
            _x.iosEnrollmentAssignmentsNextLink = iosEnrollmentAssignmentsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Timestamp of last heartbeat after admin onboarded to the compliance management
     * partner”</i>
     * 
     * @return property lastHeartbeatDateTime
     */
    @Property(name="lastHeartbeatDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastHeartbeatDateTime() {
        return Optional.ofNullable(lastHeartbeatDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastHeartbeatDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Timestamp of last heartbeat after admin onboarded to the compliance management
     * partner”</i>
     * 
     * @param lastHeartbeatDateTime
     *            new value of {@code lastHeartbeatDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastHeartbeatDateTime} field changed
     */
    public ComplianceManagementPartner withLastHeartbeatDateTime(OffsetDateTime lastHeartbeatDateTime) {
        ComplianceManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("lastHeartbeatDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.complianceManagementPartner");
        _x.lastHeartbeatDateTime = lastHeartbeatDateTime;
        return _x;
    }

    /**
     * <i>“Partner state of this tenant”</i>
     * 
     * @return property partnerState
     */
    @Property(name="partnerState")
    @JsonIgnore
    public Optional<DeviceManagementPartnerTenantState> getPartnerState() {
        return Optional.ofNullable(partnerState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code partnerState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Partner state of this tenant”</i>
     * 
     * @param partnerState
     *            new value of {@code partnerState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code partnerState} field changed
     */
    public ComplianceManagementPartner withPartnerState(DeviceManagementPartnerTenantState partnerState) {
        ComplianceManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("partnerState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.complianceManagementPartner");
        _x.partnerState = partnerState;
        return _x;
    }

    /**
     * <i>“Partner display name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Partner display name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public ComplianceManagementPartner withDisplayName(String displayName) {
        ComplianceManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.complianceManagementPartner");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Partner onboarded for Mac devices.”</i>
     * 
     * @return property macOsOnboarded
     */
    @Property(name="macOsOnboarded")
    @JsonIgnore
    public Optional<Boolean> getMacOsOnboarded() {
        return Optional.ofNullable(macOsOnboarded);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code macOsOnboarded}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Partner onboarded for Mac devices.”</i>
     * 
     * @param macOsOnboarded
     *            new value of {@code macOsOnboarded} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code macOsOnboarded} field changed
     */
    public ComplianceManagementPartner withMacOsOnboarded(Boolean macOsOnboarded) {
        ComplianceManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("macOsOnboarded");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.complianceManagementPartner");
        _x.macOsOnboarded = macOsOnboarded;
        return _x;
    }

    /**
     * <i>“Partner onboarded for Windows devices.”</i>
     * 
     * @return property windowsOnboarded
     */
    @Property(name="windowsOnboarded")
    @JsonIgnore
    public Optional<Boolean> getWindowsOnboarded() {
        return Optional.ofNullable(windowsOnboarded);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code windowsOnboarded}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Partner onboarded for Windows devices.”</i>
     * 
     * @param windowsOnboarded
     *            new value of {@code windowsOnboarded} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsOnboarded} field changed
     */
    public ComplianceManagementPartner withWindowsOnboarded(Boolean windowsOnboarded) {
        ComplianceManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("windowsOnboarded");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.complianceManagementPartner");
        _x.windowsOnboarded = windowsOnboarded;
        return _x;
    }

    /**
     * <i>“Partner onboarded for Android devices.”</i>
     * 
     * @return property androidOnboarded
     */
    @Property(name="androidOnboarded")
    @JsonIgnore
    public Optional<Boolean> getAndroidOnboarded() {
        return Optional.ofNullable(androidOnboarded);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code androidOnboarded}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Partner onboarded for Android devices.”</i>
     * 
     * @param androidOnboarded
     *            new value of {@code androidOnboarded} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidOnboarded} field changed
     */
    public ComplianceManagementPartner withAndroidOnboarded(Boolean androidOnboarded) {
        ComplianceManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("androidOnboarded");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.complianceManagementPartner");
        _x.androidOnboarded = androidOnboarded;
        return _x;
    }

    /**
     * <i>“Partner onboarded for ios devices.”</i>
     * 
     * @return property iosOnboarded
     */
    @Property(name="iosOnboarded")
    @JsonIgnore
    public Optional<Boolean> getIosOnboarded() {
        return Optional.ofNullable(iosOnboarded);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code iosOnboarded}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Partner onboarded for ios devices.”</i>
     * 
     * @param iosOnboarded
     *            new value of {@code iosOnboarded} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iosOnboarded} field changed
     */
    public ComplianceManagementPartner withIosOnboarded(Boolean iosOnboarded) {
        ComplianceManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("iosOnboarded");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.complianceManagementPartner");
        _x.iosOnboarded = iosOnboarded;
        return _x;
    }

    /**
     * <i>“User groups which enroll Mac devices through partner.”</i>
     * 
     * @return property macOsEnrollmentAssignments
     */
    @Property(name="macOsEnrollmentAssignments")
    @JsonIgnore
    public CollectionPage<ComplianceManagementPartnerAssignment> getMacOsEnrollmentAssignments() {
        return new CollectionPage<ComplianceManagementPartnerAssignment>(contextPath, ComplianceManagementPartnerAssignment.class, macOsEnrollmentAssignments, Optional.ofNullable(macOsEnrollmentAssignmentsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“User groups which enroll Mac devices through partner.”</i>
     * 
     * @return property macOsEnrollmentAssignments
     */
    @Property(name="macOsEnrollmentAssignments")
    @JsonIgnore
    public CollectionPage<ComplianceManagementPartnerAssignment> getMacOsEnrollmentAssignments(HttpRequestOptions options) {
        return new CollectionPage<ComplianceManagementPartnerAssignment>(contextPath, ComplianceManagementPartnerAssignment.class, macOsEnrollmentAssignments, Optional.ofNullable(macOsEnrollmentAssignmentsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“User groups which enroll Windows devices through partner.”</i>
     * 
     * @return property windowsEnrollmentAssignments
     */
    @Property(name="windowsEnrollmentAssignments")
    @JsonIgnore
    public CollectionPage<ComplianceManagementPartnerAssignment> getWindowsEnrollmentAssignments() {
        return new CollectionPage<ComplianceManagementPartnerAssignment>(contextPath, ComplianceManagementPartnerAssignment.class, windowsEnrollmentAssignments, Optional.ofNullable(windowsEnrollmentAssignmentsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“User groups which enroll Windows devices through partner.”</i>
     * 
     * @return property windowsEnrollmentAssignments
     */
    @Property(name="windowsEnrollmentAssignments")
    @JsonIgnore
    public CollectionPage<ComplianceManagementPartnerAssignment> getWindowsEnrollmentAssignments(HttpRequestOptions options) {
        return new CollectionPage<ComplianceManagementPartnerAssignment>(contextPath, ComplianceManagementPartnerAssignment.class, windowsEnrollmentAssignments, Optional.ofNullable(windowsEnrollmentAssignmentsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“User groups which enroll Android devices through partner.”</i>
     * 
     * @return property androidEnrollmentAssignments
     */
    @Property(name="androidEnrollmentAssignments")
    @JsonIgnore
    public CollectionPage<ComplianceManagementPartnerAssignment> getAndroidEnrollmentAssignments() {
        return new CollectionPage<ComplianceManagementPartnerAssignment>(contextPath, ComplianceManagementPartnerAssignment.class, androidEnrollmentAssignments, Optional.ofNullable(androidEnrollmentAssignmentsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“User groups which enroll Android devices through partner.”</i>
     * 
     * @return property androidEnrollmentAssignments
     */
    @Property(name="androidEnrollmentAssignments")
    @JsonIgnore
    public CollectionPage<ComplianceManagementPartnerAssignment> getAndroidEnrollmentAssignments(HttpRequestOptions options) {
        return new CollectionPage<ComplianceManagementPartnerAssignment>(contextPath, ComplianceManagementPartnerAssignment.class, androidEnrollmentAssignments, Optional.ofNullable(androidEnrollmentAssignmentsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“User groups which enroll ios devices through partner.”</i>
     * 
     * @return property iosEnrollmentAssignments
     */
    @Property(name="iosEnrollmentAssignments")
    @JsonIgnore
    public CollectionPage<ComplianceManagementPartnerAssignment> getIosEnrollmentAssignments() {
        return new CollectionPage<ComplianceManagementPartnerAssignment>(contextPath, ComplianceManagementPartnerAssignment.class, iosEnrollmentAssignments, Optional.ofNullable(iosEnrollmentAssignmentsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“User groups which enroll ios devices through partner.”</i>
     * 
     * @return property iosEnrollmentAssignments
     */
    @Property(name="iosEnrollmentAssignments")
    @JsonIgnore
    public CollectionPage<ComplianceManagementPartnerAssignment> getIosEnrollmentAssignments(HttpRequestOptions options) {
        return new CollectionPage<ComplianceManagementPartnerAssignment>(contextPath, ComplianceManagementPartnerAssignment.class, iosEnrollmentAssignments, Optional.ofNullable(iosEnrollmentAssignmentsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ComplianceManagementPartner patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ComplianceManagementPartner _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ComplianceManagementPartner put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ComplianceManagementPartner _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ComplianceManagementPartner _copy() {
        ComplianceManagementPartner _x = new ComplianceManagementPartner();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastHeartbeatDateTime = lastHeartbeatDateTime;
        _x.partnerState = partnerState;
        _x.displayName = displayName;
        _x.macOsOnboarded = macOsOnboarded;
        _x.windowsOnboarded = windowsOnboarded;
        _x.androidOnboarded = androidOnboarded;
        _x.iosOnboarded = iosOnboarded;
        _x.macOsEnrollmentAssignments = macOsEnrollmentAssignments;
        _x.windowsEnrollmentAssignments = windowsEnrollmentAssignments;
        _x.androidEnrollmentAssignments = androidEnrollmentAssignments;
        _x.iosEnrollmentAssignments = iosEnrollmentAssignments;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ComplianceManagementPartner[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastHeartbeatDateTime=");
        b.append(this.lastHeartbeatDateTime);
        b.append(", ");
        b.append("partnerState=");
        b.append(this.partnerState);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("macOsOnboarded=");
        b.append(this.macOsOnboarded);
        b.append(", ");
        b.append("windowsOnboarded=");
        b.append(this.windowsOnboarded);
        b.append(", ");
        b.append("androidOnboarded=");
        b.append(this.androidOnboarded);
        b.append(", ");
        b.append("iosOnboarded=");
        b.append(this.iosOnboarded);
        b.append(", ");
        b.append("macOsEnrollmentAssignments=");
        b.append(this.macOsEnrollmentAssignments);
        b.append(", ");
        b.append("windowsEnrollmentAssignments=");
        b.append(this.windowsEnrollmentAssignments);
        b.append(", ");
        b.append("androidEnrollmentAssignments=");
        b.append(this.androidEnrollmentAssignments);
        b.append(", ");
        b.append("iosEnrollmentAssignments=");
        b.append(this.iosEnrollmentAssignments);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
