package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AccountCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AgedAccountsPayableCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AgedAccountsReceivableCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CompanyInformationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CountryRegionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CurrencyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CustomerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CustomerPaymentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CustomerPaymentJournalCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DimensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DimensionValueCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EmployeeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GeneralLedgerEntryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.JournalCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.JournalLineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PaymentMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PaymentTermCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PictureCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PurchaseInvoiceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PurchaseInvoiceLineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesCreditMemoCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesCreditMemoLineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesInvoiceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesInvoiceLineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesOrderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesOrderLineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesQuoteCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesQuoteLineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ShipmentMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TaxAreaCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TaxGroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnitOfMeasureCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.VendorCollectionRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = false
 */@JsonPropertyOrder({
    "@odata.type", 
    "systemVersion", 
    "name", 
    "displayName", 
    "businessProfileId"})
@JsonInclude(Include.NON_NULL)
public class Company extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.company";
    }

    @JsonProperty("systemVersion")
    protected String systemVersion;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("businessProfileId")
    protected String businessProfileId;

    protected Company() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCompany() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String systemVersion;
        private String name;
        private String displayName;
        private String businessProfileId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder systemVersion(String systemVersion) {
            this.systemVersion = systemVersion;
            this.changedFields = changedFields.add("systemVersion");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder businessProfileId(String businessProfileId) {
            this.businessProfileId = businessProfileId;
            this.changedFields = changedFields.add("businessProfileId");
            return this;
        }

        public Company build() {
            Company _x = new Company();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.company";
            _x.id = id;
            _x.systemVersion = systemVersion;
            _x.name = name;
            _x.displayName = displayName;
            _x.businessProfileId = businessProfileId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="systemVersion")
    @JsonIgnore
    public Optional<String> getSystemVersion() {
        return Optional.ofNullable(systemVersion);
    }

    public Company withSystemVersion(String systemVersion) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("systemVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.systemVersion = systemVersion;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Company withName(String name) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.name = name;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Company withDisplayName(String displayName) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="businessProfileId")
    @JsonIgnore
    public Optional<String> getBusinessProfileId() {
        return Optional.ofNullable(businessProfileId);
    }

    public Company withBusinessProfileId(String businessProfileId) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("businessProfileId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.businessProfileId = businessProfileId;
        return _x;
    }

    @NavigationProperty(name="items")
    @JsonIgnore
    public ItemCollectionRequest getItems() {
        return new ItemCollectionRequest(
                        contextPath.addSegment("items"));
    }

    @NavigationProperty(name="customers")
    @JsonIgnore
    public CustomerCollectionRequest getCustomers() {
        return new CustomerCollectionRequest(
                        contextPath.addSegment("customers"));
    }

    @NavigationProperty(name="vendors")
    @JsonIgnore
    public VendorCollectionRequest getVendors() {
        return new VendorCollectionRequest(
                        contextPath.addSegment("vendors"));
    }

    @NavigationProperty(name="companyInformation")
    @JsonIgnore
    public CompanyInformationCollectionRequest getCompanyInformation() {
        return new CompanyInformationCollectionRequest(
                        contextPath.addSegment("companyInformation"));
    }

    @NavigationProperty(name="salesInvoices")
    @JsonIgnore
    public SalesInvoiceCollectionRequest getSalesInvoices() {
        return new SalesInvoiceCollectionRequest(
                        contextPath.addSegment("salesInvoices"));
    }

    @NavigationProperty(name="salesInvoiceLines")
    @JsonIgnore
    public SalesInvoiceLineCollectionRequest getSalesInvoiceLines() {
        return new SalesInvoiceLineCollectionRequest(
                        contextPath.addSegment("salesInvoiceLines"));
    }

    @NavigationProperty(name="customerPaymentJournals")
    @JsonIgnore
    public CustomerPaymentJournalCollectionRequest getCustomerPaymentJournals() {
        return new CustomerPaymentJournalCollectionRequest(
                        contextPath.addSegment("customerPaymentJournals"));
    }

    @NavigationProperty(name="customerPayments")
    @JsonIgnore
    public CustomerPaymentCollectionRequest getCustomerPayments() {
        return new CustomerPaymentCollectionRequest(
                        contextPath.addSegment("customerPayments"));
    }

    @NavigationProperty(name="accounts")
    @JsonIgnore
    public AccountCollectionRequest getAccounts() {
        return new AccountCollectionRequest(
                        contextPath.addSegment("accounts"));
    }

    @NavigationProperty(name="taxGroups")
    @JsonIgnore
    public TaxGroupCollectionRequest getTaxGroups() {
        return new TaxGroupCollectionRequest(
                        contextPath.addSegment("taxGroups"));
    }

    @NavigationProperty(name="journals")
    @JsonIgnore
    public JournalCollectionRequest getJournals() {
        return new JournalCollectionRequest(
                        contextPath.addSegment("journals"));
    }

    @NavigationProperty(name="journalLines")
    @JsonIgnore
    public JournalLineCollectionRequest getJournalLines() {
        return new JournalLineCollectionRequest(
                        contextPath.addSegment("journalLines"));
    }

    @NavigationProperty(name="employees")
    @JsonIgnore
    public EmployeeCollectionRequest getEmployees() {
        return new EmployeeCollectionRequest(
                        contextPath.addSegment("employees"));
    }

    @NavigationProperty(name="generalLedgerEntries")
    @JsonIgnore
    public GeneralLedgerEntryCollectionRequest getGeneralLedgerEntries() {
        return new GeneralLedgerEntryCollectionRequest(
                        contextPath.addSegment("generalLedgerEntries"));
    }

    @NavigationProperty(name="currencies")
    @JsonIgnore
    public CurrencyCollectionRequest getCurrencies() {
        return new CurrencyCollectionRequest(
                        contextPath.addSegment("currencies"));
    }

    @NavigationProperty(name="paymentMethods")
    @JsonIgnore
    public PaymentMethodCollectionRequest getPaymentMethods() {
        return new PaymentMethodCollectionRequest(
                        contextPath.addSegment("paymentMethods"));
    }

    @NavigationProperty(name="dimensions")
    @JsonIgnore
    public DimensionCollectionRequest getDimensions() {
        return new DimensionCollectionRequest(
                        contextPath.addSegment("dimensions"));
    }

    @NavigationProperty(name="dimensionValues")
    @JsonIgnore
    public DimensionValueCollectionRequest getDimensionValues() {
        return new DimensionValueCollectionRequest(
                        contextPath.addSegment("dimensionValues"));
    }

    @NavigationProperty(name="paymentTerms")
    @JsonIgnore
    public PaymentTermCollectionRequest getPaymentTerms() {
        return new PaymentTermCollectionRequest(
                        contextPath.addSegment("paymentTerms"));
    }

    @NavigationProperty(name="shipmentMethods")
    @JsonIgnore
    public ShipmentMethodCollectionRequest getShipmentMethods() {
        return new ShipmentMethodCollectionRequest(
                        contextPath.addSegment("shipmentMethods"));
    }

    @NavigationProperty(name="itemCategories")
    @JsonIgnore
    public ItemCategoryCollectionRequest getItemCategories() {
        return new ItemCategoryCollectionRequest(
                        contextPath.addSegment("itemCategories"));
    }

    @NavigationProperty(name="countriesRegions")
    @JsonIgnore
    public CountryRegionCollectionRequest getCountriesRegions() {
        return new CountryRegionCollectionRequest(
                        contextPath.addSegment("countriesRegions"));
    }

    @NavigationProperty(name="salesOrders")
    @JsonIgnore
    public SalesOrderCollectionRequest getSalesOrders() {
        return new SalesOrderCollectionRequest(
                        contextPath.addSegment("salesOrders"));
    }

    @NavigationProperty(name="salesOrderLines")
    @JsonIgnore
    public SalesOrderLineCollectionRequest getSalesOrderLines() {
        return new SalesOrderLineCollectionRequest(
                        contextPath.addSegment("salesOrderLines"));
    }

    @NavigationProperty(name="unitsOfMeasure")
    @JsonIgnore
    public UnitOfMeasureCollectionRequest getUnitsOfMeasure() {
        return new UnitOfMeasureCollectionRequest(
                        contextPath.addSegment("unitsOfMeasure"));
    }

    @NavigationProperty(name="agedAccountsReceivable")
    @JsonIgnore
    public AgedAccountsReceivableCollectionRequest getAgedAccountsReceivable() {
        return new AgedAccountsReceivableCollectionRequest(
                        contextPath.addSegment("agedAccountsReceivable"));
    }

    @NavigationProperty(name="agedAccountsPayable")
    @JsonIgnore
    public AgedAccountsPayableCollectionRequest getAgedAccountsPayable() {
        return new AgedAccountsPayableCollectionRequest(
                        contextPath.addSegment("agedAccountsPayable"));
    }

    @NavigationProperty(name="taxAreas")
    @JsonIgnore
    public TaxAreaCollectionRequest getTaxAreas() {
        return new TaxAreaCollectionRequest(
                        contextPath.addSegment("taxAreas"));
    }

    @NavigationProperty(name="salesQuotes")
    @JsonIgnore
    public SalesQuoteCollectionRequest getSalesQuotes() {
        return new SalesQuoteCollectionRequest(
                        contextPath.addSegment("salesQuotes"));
    }

    @NavigationProperty(name="salesQuoteLines")
    @JsonIgnore
    public SalesQuoteLineCollectionRequest getSalesQuoteLines() {
        return new SalesQuoteLineCollectionRequest(
                        contextPath.addSegment("salesQuoteLines"));
    }

    @NavigationProperty(name="salesCreditMemos")
    @JsonIgnore
    public SalesCreditMemoCollectionRequest getSalesCreditMemos() {
        return new SalesCreditMemoCollectionRequest(
                        contextPath.addSegment("salesCreditMemos"));
    }

    @NavigationProperty(name="salesCreditMemoLines")
    @JsonIgnore
    public SalesCreditMemoLineCollectionRequest getSalesCreditMemoLines() {
        return new SalesCreditMemoLineCollectionRequest(
                        contextPath.addSegment("salesCreditMemoLines"));
    }

    @NavigationProperty(name="purchaseInvoices")
    @JsonIgnore
    public PurchaseInvoiceCollectionRequest getPurchaseInvoices() {
        return new PurchaseInvoiceCollectionRequest(
                        contextPath.addSegment("purchaseInvoices"));
    }

    @NavigationProperty(name="purchaseInvoiceLines")
    @JsonIgnore
    public PurchaseInvoiceLineCollectionRequest getPurchaseInvoiceLines() {
        return new PurchaseInvoiceLineCollectionRequest(
                        contextPath.addSegment("purchaseInvoiceLines"));
    }

    @NavigationProperty(name="picture")
    @JsonIgnore
    public PictureCollectionRequest getPicture() {
        return new PictureCollectionRequest(
                        contextPath.addSegment("picture"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Company patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Company _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Company put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Company _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Company _copy() {
        Company _x = new Company();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.systemVersion = systemVersion;
        _x.name = name;
        _x.displayName = displayName;
        _x.businessProfileId = businessProfileId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Company[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("systemVersion=");
        b.append(this.systemVersion);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("businessProfileId=");
        b.append(this.businessProfileId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
