package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.PayloadRequest;
import odata.msgraph.client.beta.entity.request.PayloadResponseRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "Status", 
    "Type", 
    "AppServiceName", 
    "PackageFamilyName", 
    "Error", 
    "Payload", 
    "PermissionTicket", 
    "PostBackUri"})
@JsonInclude(Include.NON_NULL)
public class Command extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.command";
    }

    @JsonProperty("Status")
    protected String status;

    @JsonProperty("Type")
    protected String type;

    @JsonProperty("AppServiceName")
    protected String appServiceName;

    @JsonProperty("PackageFamilyName")
    protected String packageFamilyName;

    @JsonProperty("Error")
    protected String error;

    @JsonProperty("Payload")
    protected PayloadRequest payload;

    @JsonProperty("PermissionTicket")
    protected String permissionTicket;

    @JsonProperty("PostBackUri")
    protected String postBackUri;

    protected Command() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCommand() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String status;
        private String type;
        private String appServiceName;
        private String packageFamilyName;
        private String error;
        private PayloadRequest payload;
        private String permissionTicket;
        private String postBackUri;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("Status");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("Type");
            return this;
        }

        public Builder appServiceName(String appServiceName) {
            this.appServiceName = appServiceName;
            this.changedFields = changedFields.add("AppServiceName");
            return this;
        }

        public Builder packageFamilyName(String packageFamilyName) {
            this.packageFamilyName = packageFamilyName;
            this.changedFields = changedFields.add("PackageFamilyName");
            return this;
        }

        public Builder error(String error) {
            this.error = error;
            this.changedFields = changedFields.add("Error");
            return this;
        }

        public Builder payload(PayloadRequest payload) {
            this.payload = payload;
            this.changedFields = changedFields.add("Payload");
            return this;
        }

        public Builder permissionTicket(String permissionTicket) {
            this.permissionTicket = permissionTicket;
            this.changedFields = changedFields.add("PermissionTicket");
            return this;
        }

        public Builder postBackUri(String postBackUri) {
            this.postBackUri = postBackUri;
            this.changedFields = changedFields.add("PostBackUri");
            return this;
        }

        public Command build() {
            Command _x = new Command();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.command";
            _x.id = id;
            _x.status = status;
            _x.type = type;
            _x.appServiceName = appServiceName;
            _x.packageFamilyName = packageFamilyName;
            _x.error = error;
            _x.payload = payload;
            _x.permissionTicket = permissionTicket;
            _x.postBackUri = postBackUri;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="Status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public Command withStatus(String status) {
        Command _x = _copy();
        _x.changedFields = changedFields.add("Status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.command");
        _x.status = status;
        return _x;
    }

    @Property(name="Type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public Command withType(String type) {
        Command _x = _copy();
        _x.changedFields = changedFields.add("Type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.command");
        _x.type = type;
        return _x;
    }

    @Property(name="AppServiceName")
    @JsonIgnore
    public Optional<String> getAppServiceName() {
        return Optional.ofNullable(appServiceName);
    }

    public Command withAppServiceName(String appServiceName) {
        Command _x = _copy();
        _x.changedFields = changedFields.add("AppServiceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.command");
        _x.appServiceName = appServiceName;
        return _x;
    }

    @Property(name="PackageFamilyName")
    @JsonIgnore
    public Optional<String> getPackageFamilyName() {
        return Optional.ofNullable(packageFamilyName);
    }

    public Command withPackageFamilyName(String packageFamilyName) {
        Command _x = _copy();
        _x.changedFields = changedFields.add("PackageFamilyName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.command");
        _x.packageFamilyName = packageFamilyName;
        return _x;
    }

    @Property(name="Error")
    @JsonIgnore
    public Optional<String> getError() {
        return Optional.ofNullable(error);
    }

    public Command withError(String error) {
        Command _x = _copy();
        _x.changedFields = changedFields.add("Error");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.command");
        _x.error = error;
        return _x;
    }

    @Property(name="Payload")
    @JsonIgnore
    public Optional<PayloadRequest> getPayload() {
        return Optional.ofNullable(payload);
    }

    public Command withPayload(PayloadRequest payload) {
        Command _x = _copy();
        _x.changedFields = changedFields.add("Payload");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.command");
        _x.payload = payload;
        return _x;
    }

    @Property(name="PermissionTicket")
    @JsonIgnore
    public Optional<String> getPermissionTicket() {
        return Optional.ofNullable(permissionTicket);
    }

    public Command withPermissionTicket(String permissionTicket) {
        Command _x = _copy();
        _x.changedFields = changedFields.add("PermissionTicket");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.command");
        _x.permissionTicket = permissionTicket;
        return _x;
    }

    @Property(name="PostBackUri")
    @JsonIgnore
    public Optional<String> getPostBackUri() {
        return Optional.ofNullable(postBackUri);
    }

    public Command withPostBackUri(String postBackUri) {
        Command _x = _copy();
        _x.changedFields = changedFields.add("PostBackUri");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.command");
        _x.postBackUri = postBackUri;
        return _x;
    }

    @NavigationProperty(name="responsepayload")
    @JsonIgnore
    public PayloadResponseRequest getResponsepayload() {
        return new PayloadResponseRequest(contextPath.addSegment("responsepayload"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Command patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Command _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Command put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Command _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Command _copy() {
        Command _x = new Command();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.status = status;
        _x.type = type;
        _x.appServiceName = appServiceName;
        _x.packageFamilyName = packageFamilyName;
        _x.error = error;
        _x.payload = payload;
        _x.permissionTicket = permissionTicket;
        _x.postBackUri = postBackUri;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Command[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("Status=");
        b.append(this.status);
        b.append(", ");
        b.append("Type=");
        b.append(this.type);
        b.append(", ");
        b.append("AppServiceName=");
        b.append(this.appServiceName);
        b.append(", ");
        b.append("PackageFamilyName=");
        b.append(this.packageFamilyName);
        b.append(", ");
        b.append("Error=");
        b.append(this.error);
        b.append(", ");
        b.append("Payload=");
        b.append(this.payload);
        b.append(", ");
        b.append("PermissionTicket=");
        b.append(this.permissionTicket);
        b.append(", ");
        b.append("PostBackUri=");
        b.append(this.postBackUri);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
