package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.ComanagementEligibleType;
import odata.msgraph.client.beta.enums.DeviceRegistrationState;
import odata.msgraph.client.beta.enums.DeviceType;
import odata.msgraph.client.beta.enums.ManagementAgentType;
import odata.msgraph.client.beta.enums.ManagementState;
import odata.msgraph.client.beta.enums.OwnerType;


/**
 * <i>“Device Co-Management eligibility state”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceName", 
    "deviceType", 
    "clientRegistrationStatus", 
    "ownerType", 
    "managementAgents", 
    "managementState", 
    "referenceId", 
    "mdmStatus", 
    "osVersion", 
    "serialNumber", 
    "manufacturer", 
    "model", 
    "osDescription", 
    "entitySource", 
    "userId", 
    "upn", 
    "userEmail", 
    "userName", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class ComanagementEligibleDevice extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.comanagementEligibleDevice";
    }

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("deviceType")
    protected DeviceType deviceType;

    @JsonProperty("clientRegistrationStatus")
    protected DeviceRegistrationState clientRegistrationStatus;

    @JsonProperty("ownerType")
    protected OwnerType ownerType;

    @JsonProperty("managementAgents")
    protected ManagementAgentType managementAgents;

    @JsonProperty("managementState")
    protected ManagementState managementState;

    @JsonProperty("referenceId")
    protected String referenceId;

    @JsonProperty("mdmStatus")
    protected String mdmStatus;

    @JsonProperty("osVersion")
    protected String osVersion;

    @JsonProperty("serialNumber")
    protected String serialNumber;

    @JsonProperty("manufacturer")
    protected String manufacturer;

    @JsonProperty("model")
    protected String model;

    @JsonProperty("osDescription")
    protected String osDescription;

    @JsonProperty("entitySource")
    protected Integer entitySource;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("upn")
    protected String upn;

    @JsonProperty("userEmail")
    protected String userEmail;

    @JsonProperty("userName")
    protected String userName;

    @JsonProperty("status")
    protected ComanagementEligibleType status;

    protected ComanagementEligibleDevice() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderComanagementEligibleDevice() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String deviceName;
        private DeviceType deviceType;
        private DeviceRegistrationState clientRegistrationStatus;
        private OwnerType ownerType;
        private ManagementAgentType managementAgents;
        private ManagementState managementState;
        private String referenceId;
        private String mdmStatus;
        private String osVersion;
        private String serialNumber;
        private String manufacturer;
        private String model;
        private String osDescription;
        private Integer entitySource;
        private String userId;
        private String upn;
        private String userEmail;
        private String userName;
        private ComanagementEligibleType status;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“DeviceName”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“DeviceType”</i>
         * 
         * @param deviceType
         *            value of {@code deviceType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
            this.changedFields = changedFields.add("deviceType");
            return this;
        }

        /**
         * <i>“ClientRegistrationStatus”</i>
         * 
         * @param clientRegistrationStatus
         *            value of {@code clientRegistrationStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder clientRegistrationStatus(DeviceRegistrationState clientRegistrationStatus) {
            this.clientRegistrationStatus = clientRegistrationStatus;
            this.changedFields = changedFields.add("clientRegistrationStatus");
            return this;
        }

        /**
         * <i>“OwnerType”</i>
         * 
         * @param ownerType
         *            value of {@code ownerType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ownerType(OwnerType ownerType) {
            this.ownerType = ownerType;
            this.changedFields = changedFields.add("ownerType");
            return this;
        }

        /**
         * <i>“ManagementAgents”</i>
         * 
         * @param managementAgents
         *            value of {@code managementAgents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managementAgents(ManagementAgentType managementAgents) {
            this.managementAgents = managementAgents;
            this.changedFields = changedFields.add("managementAgents");
            return this;
        }

        /**
         * <i>“ManagementState”</i>
         * 
         * @param managementState
         *            value of {@code managementState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managementState(ManagementState managementState) {
            this.managementState = managementState;
            this.changedFields = changedFields.add("managementState");
            return this;
        }

        /**
         * <i>“ReferenceId”</i>
         * 
         * @param referenceId
         *            value of {@code referenceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            this.changedFields = changedFields.add("referenceId");
            return this;
        }

        /**
         * <i>“MDMStatus”</i>
         * 
         * @param mdmStatus
         *            value of {@code mdmStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mdmStatus(String mdmStatus) {
            this.mdmStatus = mdmStatus;
            this.changedFields = changedFields.add("mdmStatus");
            return this;
        }

        /**
         * <i>“OSVersion”</i>
         * 
         * @param osVersion
         *            value of {@code osVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.changedFields = changedFields.add("osVersion");
            return this;
        }

        /**
         * <i>“SerialNumber”</i>
         * 
         * @param serialNumber
         *            value of {@code serialNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.changedFields = changedFields.add("serialNumber");
            return this;
        }

        /**
         * <i>“Manufacturer”</i>
         * 
         * @param manufacturer
         *            value of {@code manufacturer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        /**
         * <i>“Model”</i>
         * 
         * @param model
         *            value of {@code model} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        /**
         * <i>“OSDescription”</i>
         * 
         * @param osDescription
         *            value of {@code osDescription} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osDescription(String osDescription) {
            this.osDescription = osDescription;
            this.changedFields = changedFields.add("osDescription");
            return this;
        }

        /**
         * <i>“EntitySource”</i>
         * 
         * @param entitySource
         *            value of {@code entitySource} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder entitySource(Integer entitySource) {
            this.entitySource = entitySource;
            this.changedFields = changedFields.add("entitySource");
            return this;
        }

        /**
         * <i>“UserId”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        /**
         * <i>“UPN”</i>
         * 
         * @param upn
         *            value of {@code upn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder upn(String upn) {
            this.upn = upn;
            this.changedFields = changedFields.add("upn");
            return this;
        }

        /**
         * <i>“UserEmail”</i>
         * 
         * @param userEmail
         *            value of {@code userEmail} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userEmail(String userEmail) {
            this.userEmail = userEmail;
            this.changedFields = changedFields.add("userEmail");
            return this;
        }

        /**
         * <i>“UserName”</i>
         * 
         * @param userName
         *            value of {@code userName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userName(String userName) {
            this.userName = userName;
            this.changedFields = changedFields.add("userName");
            return this;
        }

        /**
         * <i>“ComanagementEligibleStatus”</i>
         * 
         * @param status
         *            value of {@code status} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder status(ComanagementEligibleType status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public ComanagementEligibleDevice build() {
            ComanagementEligibleDevice _x = new ComanagementEligibleDevice();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.comanagementEligibleDevice";
            _x.id = id;
            _x.deviceName = deviceName;
            _x.deviceType = deviceType;
            _x.clientRegistrationStatus = clientRegistrationStatus;
            _x.ownerType = ownerType;
            _x.managementAgents = managementAgents;
            _x.managementState = managementState;
            _x.referenceId = referenceId;
            _x.mdmStatus = mdmStatus;
            _x.osVersion = osVersion;
            _x.serialNumber = serialNumber;
            _x.manufacturer = manufacturer;
            _x.model = model;
            _x.osDescription = osDescription;
            _x.entitySource = entitySource;
            _x.userId = userId;
            _x.upn = upn;
            _x.userEmail = userEmail;
            _x.userName = userName;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“DeviceName”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“DeviceName”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public ComanagementEligibleDevice withDeviceName(String deviceName) {
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagementEligibleDevice");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“DeviceType”</i>
     * 
     * @return property deviceType
     */
    @Property(name="deviceType")
    @JsonIgnore
    public Optional<DeviceType> getDeviceType() {
        return Optional.ofNullable(deviceType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“DeviceType”</i>
     * 
     * @param deviceType
     *            new value of {@code deviceType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceType} field changed
     */
    public ComanagementEligibleDevice withDeviceType(DeviceType deviceType) {
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = changedFields.add("deviceType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagementEligibleDevice");
        _x.deviceType = deviceType;
        return _x;
    }

    /**
     * <i>“ClientRegistrationStatus”</i>
     * 
     * @return property clientRegistrationStatus
     */
    @Property(name="clientRegistrationStatus")
    @JsonIgnore
    public Optional<DeviceRegistrationState> getClientRegistrationStatus() {
        return Optional.ofNullable(clientRegistrationStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * clientRegistrationStatus} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“ClientRegistrationStatus”</i>
     * 
     * @param clientRegistrationStatus
     *            new value of {@code clientRegistrationStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code clientRegistrationStatus} field changed
     */
    public ComanagementEligibleDevice withClientRegistrationStatus(DeviceRegistrationState clientRegistrationStatus) {
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = changedFields.add("clientRegistrationStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagementEligibleDevice");
        _x.clientRegistrationStatus = clientRegistrationStatus;
        return _x;
    }

    /**
     * <i>“OwnerType”</i>
     * 
     * @return property ownerType
     */
    @Property(name="ownerType")
    @JsonIgnore
    public Optional<OwnerType> getOwnerType() {
        return Optional.ofNullable(ownerType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ownerType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“OwnerType”</i>
     * 
     * @param ownerType
     *            new value of {@code ownerType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ownerType} field changed
     */
    public ComanagementEligibleDevice withOwnerType(OwnerType ownerType) {
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = changedFields.add("ownerType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagementEligibleDevice");
        _x.ownerType = ownerType;
        return _x;
    }

    /**
     * <i>“ManagementAgents”</i>
     * 
     * @return property managementAgents
     */
    @Property(name="managementAgents")
    @JsonIgnore
    public Optional<ManagementAgentType> getManagementAgents() {
        return Optional.ofNullable(managementAgents);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managementAgents}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“ManagementAgents”</i>
     * 
     * @param managementAgents
     *            new value of {@code managementAgents} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managementAgents} field changed
     */
    public ComanagementEligibleDevice withManagementAgents(ManagementAgentType managementAgents) {
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = changedFields.add("managementAgents");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagementEligibleDevice");
        _x.managementAgents = managementAgents;
        return _x;
    }

    /**
     * <i>“ManagementState”</i>
     * 
     * @return property managementState
     */
    @Property(name="managementState")
    @JsonIgnore
    public Optional<ManagementState> getManagementState() {
        return Optional.ofNullable(managementState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managementState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“ManagementState”</i>
     * 
     * @param managementState
     *            new value of {@code managementState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managementState} field changed
     */
    public ComanagementEligibleDevice withManagementState(ManagementState managementState) {
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = changedFields.add("managementState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagementEligibleDevice");
        _x.managementState = managementState;
        return _x;
    }

    /**
     * <i>“ReferenceId”</i>
     * 
     * @return property referenceId
     */
    @Property(name="referenceId")
    @JsonIgnore
    public Optional<String> getReferenceId() {
        return Optional.ofNullable(referenceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code referenceId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“ReferenceId”</i>
     * 
     * @param referenceId
     *            new value of {@code referenceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code referenceId} field changed
     */
    public ComanagementEligibleDevice withReferenceId(String referenceId) {
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = changedFields.add("referenceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagementEligibleDevice");
        _x.referenceId = referenceId;
        return _x;
    }

    /**
     * <i>“MDMStatus”</i>
     * 
     * @return property mdmStatus
     */
    @Property(name="mdmStatus")
    @JsonIgnore
    public Optional<String> getMdmStatus() {
        return Optional.ofNullable(mdmStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code mdmStatus} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“MDMStatus”</i>
     * 
     * @param mdmStatus
     *            new value of {@code mdmStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mdmStatus} field changed
     */
    public ComanagementEligibleDevice withMdmStatus(String mdmStatus) {
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = changedFields.add("mdmStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagementEligibleDevice");
        _x.mdmStatus = mdmStatus;
        return _x;
    }

    /**
     * <i>“OSVersion”</i>
     * 
     * @return property osVersion
     */
    @Property(name="osVersion")
    @JsonIgnore
    public Optional<String> getOsVersion() {
        return Optional.ofNullable(osVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osVersion} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“OSVersion”</i>
     * 
     * @param osVersion
     *            new value of {@code osVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osVersion} field changed
     */
    public ComanagementEligibleDevice withOsVersion(String osVersion) {
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = changedFields.add("osVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagementEligibleDevice");
        _x.osVersion = osVersion;
        return _x;
    }

    /**
     * <i>“SerialNumber”</i>
     * 
     * @return property serialNumber
     */
    @Property(name="serialNumber")
    @JsonIgnore
    public Optional<String> getSerialNumber() {
        return Optional.ofNullable(serialNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code serialNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“SerialNumber”</i>
     * 
     * @param serialNumber
     *            new value of {@code serialNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serialNumber} field changed
     */
    public ComanagementEligibleDevice withSerialNumber(String serialNumber) {
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = changedFields.add("serialNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagementEligibleDevice");
        _x.serialNumber = serialNumber;
        return _x;
    }

    /**
     * <i>“Manufacturer”</i>
     * 
     * @return property manufacturer
     */
    @Property(name="manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code manufacturer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Manufacturer”</i>
     * 
     * @param manufacturer
     *            new value of {@code manufacturer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code manufacturer} field changed
     */
    public ComanagementEligibleDevice withManufacturer(String manufacturer) {
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = changedFields.add("manufacturer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagementEligibleDevice");
        _x.manufacturer = manufacturer;
        return _x;
    }

    /**
     * <i>“Model”</i>
     * 
     * @return property model
     */
    @Property(name="model")
    @JsonIgnore
    public Optional<String> getModel() {
        return Optional.ofNullable(model);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code model} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Model”</i>
     * 
     * @param model
     *            new value of {@code model} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code model} field changed
     */
    public ComanagementEligibleDevice withModel(String model) {
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = changedFields.add("model");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagementEligibleDevice");
        _x.model = model;
        return _x;
    }

    /**
     * <i>“OSDescription”</i>
     * 
     * @return property osDescription
     */
    @Property(name="osDescription")
    @JsonIgnore
    public Optional<String> getOsDescription() {
        return Optional.ofNullable(osDescription);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osDescription}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“OSDescription”</i>
     * 
     * @param osDescription
     *            new value of {@code osDescription} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osDescription} field changed
     */
    public ComanagementEligibleDevice withOsDescription(String osDescription) {
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = changedFields.add("osDescription");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagementEligibleDevice");
        _x.osDescription = osDescription;
        return _x;
    }

    /**
     * <i>“EntitySource”</i>
     * 
     * @return property entitySource
     */
    @Property(name="entitySource")
    @JsonIgnore
    public Optional<Integer> getEntitySource() {
        return Optional.ofNullable(entitySource);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code entitySource}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“EntitySource”</i>
     * 
     * @param entitySource
     *            new value of {@code entitySource} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code entitySource} field changed
     */
    public ComanagementEligibleDevice withEntitySource(Integer entitySource) {
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = changedFields.add("entitySource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagementEligibleDevice");
        _x.entitySource = entitySource;
        return _x;
    }

    /**
     * <i>“UserId”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“UserId”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public ComanagementEligibleDevice withUserId(String userId) {
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagementEligibleDevice");
        _x.userId = userId;
        return _x;
    }

    /**
     * <i>“UPN”</i>
     * 
     * @return property upn
     */
    @Property(name="upn")
    @JsonIgnore
    public Optional<String> getUpn() {
        return Optional.ofNullable(upn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code upn} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“UPN”</i>
     * 
     * @param upn
     *            new value of {@code upn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code upn} field changed
     */
    public ComanagementEligibleDevice withUpn(String upn) {
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = changedFields.add("upn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagementEligibleDevice");
        _x.upn = upn;
        return _x;
    }

    /**
     * <i>“UserEmail”</i>
     * 
     * @return property userEmail
     */
    @Property(name="userEmail")
    @JsonIgnore
    public Optional<String> getUserEmail() {
        return Optional.ofNullable(userEmail);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userEmail} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“UserEmail”</i>
     * 
     * @param userEmail
     *            new value of {@code userEmail} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userEmail} field changed
     */
    public ComanagementEligibleDevice withUserEmail(String userEmail) {
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = changedFields.add("userEmail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagementEligibleDevice");
        _x.userEmail = userEmail;
        return _x;
    }

    /**
     * <i>“UserName”</i>
     * 
     * @return property userName
     */
    @Property(name="userName")
    @JsonIgnore
    public Optional<String> getUserName() {
        return Optional.ofNullable(userName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“UserName”</i>
     * 
     * @param userName
     *            new value of {@code userName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userName} field changed
     */
    public ComanagementEligibleDevice withUserName(String userName) {
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = changedFields.add("userName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagementEligibleDevice");
        _x.userName = userName;
        return _x;
    }

    /**
     * <i>“ComanagementEligibleStatus”</i>
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<ComanagementEligibleType> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“ComanagementEligibleStatus”</i>
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public ComanagementEligibleDevice withStatus(ComanagementEligibleType status) {
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagementEligibleDevice");
        _x.status = status;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ComanagementEligibleDevice patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ComanagementEligibleDevice put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ComanagementEligibleDevice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ComanagementEligibleDevice _copy() {
        ComanagementEligibleDevice _x = new ComanagementEligibleDevice();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.deviceName = deviceName;
        _x.deviceType = deviceType;
        _x.clientRegistrationStatus = clientRegistrationStatus;
        _x.ownerType = ownerType;
        _x.managementAgents = managementAgents;
        _x.managementState = managementState;
        _x.referenceId = referenceId;
        _x.mdmStatus = mdmStatus;
        _x.osVersion = osVersion;
        _x.serialNumber = serialNumber;
        _x.manufacturer = manufacturer;
        _x.model = model;
        _x.osDescription = osDescription;
        _x.entitySource = entitySource;
        _x.userId = userId;
        _x.upn = upn;
        _x.userEmail = userEmail;
        _x.userName = userName;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ComanagementEligibleDevice[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("deviceType=");
        b.append(this.deviceType);
        b.append(", ");
        b.append("clientRegistrationStatus=");
        b.append(this.clientRegistrationStatus);
        b.append(", ");
        b.append("ownerType=");
        b.append(this.ownerType);
        b.append(", ");
        b.append("managementAgents=");
        b.append(this.managementAgents);
        b.append(", ");
        b.append("managementState=");
        b.append(this.managementState);
        b.append(", ");
        b.append("referenceId=");
        b.append(this.referenceId);
        b.append(", ");
        b.append("mdmStatus=");
        b.append(this.mdmStatus);
        b.append(", ");
        b.append("osVersion=");
        b.append(this.osVersion);
        b.append(", ");
        b.append("serialNumber=");
        b.append(this.serialNumber);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append(", ");
        b.append("osDescription=");
        b.append(this.osDescription);
        b.append(", ");
        b.append("entitySource=");
        b.append(this.entitySource);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("upn=");
        b.append(this.upn);
        b.append(", ");
        b.append("userEmail=");
        b.append(this.userEmail);
        b.append(", ");
        b.append("userName=");
        b.append(this.userName);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
