package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.BooleanColumn;
import odata.msgraph.client.beta.complex.CalculatedColumn;
import odata.msgraph.client.beta.complex.ChoiceColumn;
import odata.msgraph.client.beta.complex.CurrencyColumn;
import odata.msgraph.client.beta.complex.DateTimeColumn;
import odata.msgraph.client.beta.complex.DefaultColumnValue;
import odata.msgraph.client.beta.complex.GeolocationColumn;
import odata.msgraph.client.beta.complex.LookupColumn;
import odata.msgraph.client.beta.complex.NumberColumn;
import odata.msgraph.client.beta.complex.PersonOrGroupColumn;
import odata.msgraph.client.beta.complex.TextColumn;

@JsonPropertyOrder({
    "@odata.type", 
    "boolean", 
    "calculated", 
    "choice", 
    "columnGroup", 
    "currency", 
    "dateTime", 
    "defaultValue", 
    "description", 
    "displayName", 
    "enforceUniqueValues", 
    "geolocation", 
    "hidden", 
    "indexed", 
    "lookup", 
    "name", 
    "number", 
    "personOrGroup", 
    "readOnly", 
    "required", 
    "text"})
@JsonInclude(Include.NON_NULL)
public class ColumnDefinition extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.columnDefinition";
    }

    @JsonProperty("boolean")
    protected BooleanColumn boolean_;

    @JsonProperty("calculated")
    protected CalculatedColumn calculated;

    @JsonProperty("choice")
    protected ChoiceColumn choice;

    @JsonProperty("columnGroup")
    protected String columnGroup;

    @JsonProperty("currency")
    protected CurrencyColumn currency;

    @JsonProperty("dateTime")
    protected DateTimeColumn dateTime;

    @JsonProperty("defaultValue")
    protected DefaultColumnValue defaultValue;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("enforceUniqueValues")
    protected Boolean enforceUniqueValues;

    @JsonProperty("geolocation")
    protected GeolocationColumn geolocation;

    @JsonProperty("hidden")
    protected Boolean hidden;

    @JsonProperty("indexed")
    protected Boolean indexed;

    @JsonProperty("lookup")
    protected LookupColumn lookup;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("number")
    protected NumberColumn number;

    @JsonProperty("personOrGroup")
    protected PersonOrGroupColumn personOrGroup;

    @JsonProperty("readOnly")
    protected Boolean readOnly;

    @JsonProperty("required")
    protected Boolean required;

    @JsonProperty("text")
    protected TextColumn text;

    protected ColumnDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderColumnDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private BooleanColumn boolean_;
        private CalculatedColumn calculated;
        private ChoiceColumn choice;
        private String columnGroup;
        private CurrencyColumn currency;
        private DateTimeColumn dateTime;
        private DefaultColumnValue defaultValue;
        private String description;
        private String displayName;
        private Boolean enforceUniqueValues;
        private GeolocationColumn geolocation;
        private Boolean hidden;
        private Boolean indexed;
        private LookupColumn lookup;
        private String name;
        private NumberColumn number;
        private PersonOrGroupColumn personOrGroup;
        private Boolean readOnly;
        private Boolean required;
        private TextColumn text;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder boolean_(BooleanColumn boolean_) {
            this.boolean_ = boolean_;
            this.changedFields = changedFields.add("boolean");
            return this;
        }

        public Builder calculated(CalculatedColumn calculated) {
            this.calculated = calculated;
            this.changedFields = changedFields.add("calculated");
            return this;
        }

        public Builder choice(ChoiceColumn choice) {
            this.choice = choice;
            this.changedFields = changedFields.add("choice");
            return this;
        }

        public Builder columnGroup(String columnGroup) {
            this.columnGroup = columnGroup;
            this.changedFields = changedFields.add("columnGroup");
            return this;
        }

        public Builder currency(CurrencyColumn currency) {
            this.currency = currency;
            this.changedFields = changedFields.add("currency");
            return this;
        }

        public Builder dateTime(DateTimeColumn dateTime) {
            this.dateTime = dateTime;
            this.changedFields = changedFields.add("dateTime");
            return this;
        }

        public Builder defaultValue(DefaultColumnValue defaultValue) {
            this.defaultValue = defaultValue;
            this.changedFields = changedFields.add("defaultValue");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder enforceUniqueValues(Boolean enforceUniqueValues) {
            this.enforceUniqueValues = enforceUniqueValues;
            this.changedFields = changedFields.add("enforceUniqueValues");
            return this;
        }

        public Builder geolocation(GeolocationColumn geolocation) {
            this.geolocation = geolocation;
            this.changedFields = changedFields.add("geolocation");
            return this;
        }

        public Builder hidden(Boolean hidden) {
            this.hidden = hidden;
            this.changedFields = changedFields.add("hidden");
            return this;
        }

        public Builder indexed(Boolean indexed) {
            this.indexed = indexed;
            this.changedFields = changedFields.add("indexed");
            return this;
        }

        public Builder lookup(LookupColumn lookup) {
            this.lookup = lookup;
            this.changedFields = changedFields.add("lookup");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder number(NumberColumn number) {
            this.number = number;
            this.changedFields = changedFields.add("number");
            return this;
        }

        public Builder personOrGroup(PersonOrGroupColumn personOrGroup) {
            this.personOrGroup = personOrGroup;
            this.changedFields = changedFields.add("personOrGroup");
            return this;
        }

        public Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            this.changedFields = changedFields.add("readOnly");
            return this;
        }

        public Builder required(Boolean required) {
            this.required = required;
            this.changedFields = changedFields.add("required");
            return this;
        }

        public Builder text(TextColumn text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        public ColumnDefinition build() {
            ColumnDefinition _x = new ColumnDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.columnDefinition";
            _x.id = id;
            _x.boolean_ = boolean_;
            _x.calculated = calculated;
            _x.choice = choice;
            _x.columnGroup = columnGroup;
            _x.currency = currency;
            _x.dateTime = dateTime;
            _x.defaultValue = defaultValue;
            _x.description = description;
            _x.displayName = displayName;
            _x.enforceUniqueValues = enforceUniqueValues;
            _x.geolocation = geolocation;
            _x.hidden = hidden;
            _x.indexed = indexed;
            _x.lookup = lookup;
            _x.name = name;
            _x.number = number;
            _x.personOrGroup = personOrGroup;
            _x.readOnly = readOnly;
            _x.required = required;
            _x.text = text;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="boolean")
    @JsonIgnore
    public Optional<BooleanColumn> getBoolean() {
        return Optional.ofNullable(boolean_);
    }

    public ColumnDefinition withBoolean(BooleanColumn boolean_) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("boolean");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.boolean_ = boolean_;
        return _x;
    }

    @Property(name="calculated")
    @JsonIgnore
    public Optional<CalculatedColumn> getCalculated() {
        return Optional.ofNullable(calculated);
    }

    public ColumnDefinition withCalculated(CalculatedColumn calculated) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("calculated");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.calculated = calculated;
        return _x;
    }

    @Property(name="choice")
    @JsonIgnore
    public Optional<ChoiceColumn> getChoice() {
        return Optional.ofNullable(choice);
    }

    public ColumnDefinition withChoice(ChoiceColumn choice) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("choice");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.choice = choice;
        return _x;
    }

    @Property(name="columnGroup")
    @JsonIgnore
    public Optional<String> getColumnGroup() {
        return Optional.ofNullable(columnGroup);
    }

    public ColumnDefinition withColumnGroup(String columnGroup) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("columnGroup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.columnGroup = columnGroup;
        return _x;
    }

    @Property(name="currency")
    @JsonIgnore
    public Optional<CurrencyColumn> getCurrency() {
        return Optional.ofNullable(currency);
    }

    public ColumnDefinition withCurrency(CurrencyColumn currency) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("currency");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.currency = currency;
        return _x;
    }

    @Property(name="dateTime")
    @JsonIgnore
    public Optional<DateTimeColumn> getDateTime() {
        return Optional.ofNullable(dateTime);
    }

    public ColumnDefinition withDateTime(DateTimeColumn dateTime) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("dateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.dateTime = dateTime;
        return _x;
    }

    @Property(name="defaultValue")
    @JsonIgnore
    public Optional<DefaultColumnValue> getDefaultValue() {
        return Optional.ofNullable(defaultValue);
    }

    public ColumnDefinition withDefaultValue(DefaultColumnValue defaultValue) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("defaultValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.defaultValue = defaultValue;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ColumnDefinition withDescription(String description) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ColumnDefinition withDisplayName(String displayName) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="enforceUniqueValues")
    @JsonIgnore
    public Optional<Boolean> getEnforceUniqueValues() {
        return Optional.ofNullable(enforceUniqueValues);
    }

    public ColumnDefinition withEnforceUniqueValues(Boolean enforceUniqueValues) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("enforceUniqueValues");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.enforceUniqueValues = enforceUniqueValues;
        return _x;
    }

    @Property(name="geolocation")
    @JsonIgnore
    public Optional<GeolocationColumn> getGeolocation() {
        return Optional.ofNullable(geolocation);
    }

    public ColumnDefinition withGeolocation(GeolocationColumn geolocation) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("geolocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.geolocation = geolocation;
        return _x;
    }

    @Property(name="hidden")
    @JsonIgnore
    public Optional<Boolean> getHidden() {
        return Optional.ofNullable(hidden);
    }

    public ColumnDefinition withHidden(Boolean hidden) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("hidden");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.hidden = hidden;
        return _x;
    }

    @Property(name="indexed")
    @JsonIgnore
    public Optional<Boolean> getIndexed() {
        return Optional.ofNullable(indexed);
    }

    public ColumnDefinition withIndexed(Boolean indexed) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("indexed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.indexed = indexed;
        return _x;
    }

    @Property(name="lookup")
    @JsonIgnore
    public Optional<LookupColumn> getLookup() {
        return Optional.ofNullable(lookup);
    }

    public ColumnDefinition withLookup(LookupColumn lookup) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("lookup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.lookup = lookup;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public ColumnDefinition withName(String name) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.name = name;
        return _x;
    }

    @Property(name="number")
    @JsonIgnore
    public Optional<NumberColumn> getNumber() {
        return Optional.ofNullable(number);
    }

    public ColumnDefinition withNumber(NumberColumn number) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("number");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.number = number;
        return _x;
    }

    @Property(name="personOrGroup")
    @JsonIgnore
    public Optional<PersonOrGroupColumn> getPersonOrGroup() {
        return Optional.ofNullable(personOrGroup);
    }

    public ColumnDefinition withPersonOrGroup(PersonOrGroupColumn personOrGroup) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("personOrGroup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.personOrGroup = personOrGroup;
        return _x;
    }

    @Property(name="readOnly")
    @JsonIgnore
    public Optional<Boolean> getReadOnly() {
        return Optional.ofNullable(readOnly);
    }

    public ColumnDefinition withReadOnly(Boolean readOnly) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("readOnly");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.readOnly = readOnly;
        return _x;
    }

    @Property(name="required")
    @JsonIgnore
    public Optional<Boolean> getRequired() {
        return Optional.ofNullable(required);
    }

    public ColumnDefinition withRequired(Boolean required) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("required");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.required = required;
        return _x;
    }

    @Property(name="text")
    @JsonIgnore
    public Optional<TextColumn> getText() {
        return Optional.ofNullable(text);
    }

    public ColumnDefinition withText(TextColumn text) {
        ColumnDefinition _x = _copy();
        _x.changedFields = changedFields.add("text");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnDefinition");
        _x.text = text;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ColumnDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ColumnDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ColumnDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ColumnDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ColumnDefinition _copy() {
        ColumnDefinition _x = new ColumnDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.boolean_ = boolean_;
        _x.calculated = calculated;
        _x.choice = choice;
        _x.columnGroup = columnGroup;
        _x.currency = currency;
        _x.dateTime = dateTime;
        _x.defaultValue = defaultValue;
        _x.description = description;
        _x.displayName = displayName;
        _x.enforceUniqueValues = enforceUniqueValues;
        _x.geolocation = geolocation;
        _x.hidden = hidden;
        _x.indexed = indexed;
        _x.lookup = lookup;
        _x.name = name;
        _x.number = number;
        _x.personOrGroup = personOrGroup;
        _x.readOnly = readOnly;
        _x.required = required;
        _x.text = text;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ColumnDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("boolean=");
        b.append(this.boolean_);
        b.append(", ");
        b.append("calculated=");
        b.append(this.calculated);
        b.append(", ");
        b.append("choice=");
        b.append(this.choice);
        b.append(", ");
        b.append("columnGroup=");
        b.append(this.columnGroup);
        b.append(", ");
        b.append("currency=");
        b.append(this.currency);
        b.append(", ");
        b.append("dateTime=");
        b.append(this.dateTime);
        b.append(", ");
        b.append("defaultValue=");
        b.append(this.defaultValue);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("enforceUniqueValues=");
        b.append(this.enforceUniqueValues);
        b.append(", ");
        b.append("geolocation=");
        b.append(this.geolocation);
        b.append(", ");
        b.append("hidden=");
        b.append(this.hidden);
        b.append(", ");
        b.append("indexed=");
        b.append(this.indexed);
        b.append(", ");
        b.append("lookup=");
        b.append(this.lookup);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("number=");
        b.append(this.number);
        b.append(", ");
        b.append("personOrGroup=");
        b.append(this.personOrGroup);
        b.append(", ");
        b.append("readOnly=");
        b.append(this.readOnly);
        b.append(", ");
        b.append("required=");
        b.append(this.required);
        b.append(", ");
        b.append("text=");
        b.append(this.text);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
