package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.callRecords.entity.collection.request.CallRecordCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CallCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnlineMeetingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PresenceCollectionRequest;

@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class CloudCommunications extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudCommunications";
    }

    protected CloudCommunications() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCloudCommunications() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public CloudCommunications build() {
            CloudCommunications _x = new CloudCommunications();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.cloudCommunications";
            _x.id = id;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @NavigationProperty(name="calls")
    @JsonIgnore
    public CallCollectionRequest getCalls() {
        return new CallCollectionRequest(
                        contextPath.addSegment("calls"));
    }

    @NavigationProperty(name="callRecords")
    @JsonIgnore
    public CallRecordCollectionRequest getCallRecords() {
        return new CallRecordCollectionRequest(
                        contextPath.addSegment("callRecords"));
    }

    @NavigationProperty(name="onlineMeetings")
    @JsonIgnore
    public OnlineMeetingCollectionRequest getOnlineMeetings() {
        return new OnlineMeetingCollectionRequest(
                        contextPath.addSegment("onlineMeetings"));
    }

    @NavigationProperty(name="presences")
    @JsonIgnore
    public PresenceCollectionRequest getPresences() {
        return new PresenceCollectionRequest(
                        contextPath.addSegment("presences"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudCommunications patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CloudCommunications _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudCommunications put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CloudCommunications _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CloudCommunications _copy() {
        CloudCommunications _x = new CloudCommunications();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        return _x;
    }

    @Action(name = "getPresencesByUserId")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Presence> getPresencesByUserId(List<String> ids) {
        Preconditions.checkNotNull(ids, "ids cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ids", "Collection(Edm.String)", Checks.checkIsAscii(ids))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPresencesByUserId"), Presence.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudCommunications[");
        b.append("id=");
        b.append(this.id);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
