package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.SecurityVendorInformation;
import odata.msgraph.client.beta.enums.ApplicationPermissionsRequired;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SortRestrictions</b>
 * <p>
 * Sortable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "azureSubscriptionId", 
    "azureTenantId", 
    "createdDateTime", 
    "deploymentPackageUrl", 
    "destinationServiceName", 
    "isSigned", 
    "lastModifiedDateTime", 
    "manifest", 
    "name", 
    "permissionsRequired", 
    "platform", 
    "policyName", 
    "publisher", 
    "riskScore", 
    "tags", 
    "type", 
    "vendorInformation"})
@JsonInclude(Include.NON_NULL)
public class CloudAppSecurityProfile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudAppSecurityProfile";
    }

    @JsonProperty("azureSubscriptionId")
    protected String azureSubscriptionId;

    @JsonProperty("azureTenantId")
    protected String azureTenantId;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("deploymentPackageUrl")
    protected String deploymentPackageUrl;

    @JsonProperty("destinationServiceName")
    protected String destinationServiceName;

    @JsonProperty("isSigned")
    protected Boolean isSigned;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("manifest")
    protected String manifest;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("permissionsRequired")
    protected ApplicationPermissionsRequired permissionsRequired;

    @JsonProperty("platform")
    protected String platform;

    @JsonProperty("policyName")
    protected String policyName;

    @JsonProperty("publisher")
    protected String publisher;

    @JsonProperty("riskScore")
    protected String riskScore;

    @JsonProperty("tags")
    protected List<String> tags;

    @JsonProperty("tags@nextLink")
    protected String tagsNextLink;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("vendorInformation")
    protected SecurityVendorInformation vendorInformation;

    protected CloudAppSecurityProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCloudAppSecurityProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String azureSubscriptionId;
        private String azureTenantId;
        private OffsetDateTime createdDateTime;
        private String deploymentPackageUrl;
        private String destinationServiceName;
        private Boolean isSigned;
        private OffsetDateTime lastModifiedDateTime;
        private String manifest;
        private String name;
        private ApplicationPermissionsRequired permissionsRequired;
        private String platform;
        private String policyName;
        private String publisher;
        private String riskScore;
        private List<String> tags;
        private String tagsNextLink;
        private String type;
        private SecurityVendorInformation vendorInformation;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder azureSubscriptionId(String azureSubscriptionId) {
            this.azureSubscriptionId = azureSubscriptionId;
            this.changedFields = changedFields.add("azureSubscriptionId");
            return this;
        }

        public Builder azureTenantId(String azureTenantId) {
            this.azureTenantId = azureTenantId;
            this.changedFields = changedFields.add("azureTenantId");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder deploymentPackageUrl(String deploymentPackageUrl) {
            this.deploymentPackageUrl = deploymentPackageUrl;
            this.changedFields = changedFields.add("deploymentPackageUrl");
            return this;
        }

        public Builder destinationServiceName(String destinationServiceName) {
            this.destinationServiceName = destinationServiceName;
            this.changedFields = changedFields.add("destinationServiceName");
            return this;
        }

        public Builder isSigned(Boolean isSigned) {
            this.isSigned = isSigned;
            this.changedFields = changedFields.add("isSigned");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder manifest(String manifest) {
            this.manifest = manifest;
            this.changedFields = changedFields.add("manifest");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder permissionsRequired(ApplicationPermissionsRequired permissionsRequired) {
            this.permissionsRequired = permissionsRequired;
            this.changedFields = changedFields.add("permissionsRequired");
            return this;
        }

        public Builder platform(String platform) {
            this.platform = platform;
            this.changedFields = changedFields.add("platform");
            return this;
        }

        public Builder policyName(String policyName) {
            this.policyName = policyName;
            this.changedFields = changedFields.add("policyName");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder riskScore(String riskScore) {
            this.riskScore = riskScore;
            this.changedFields = changedFields.add("riskScore");
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder tags(String... tags) {
            return tags(Arrays.asList(tags));
        }

        public Builder tagsNextLink(String tagsNextLink) {
            this.tagsNextLink = tagsNextLink;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder vendorInformation(SecurityVendorInformation vendorInformation) {
            this.vendorInformation = vendorInformation;
            this.changedFields = changedFields.add("vendorInformation");
            return this;
        }

        public CloudAppSecurityProfile build() {
            CloudAppSecurityProfile _x = new CloudAppSecurityProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.cloudAppSecurityProfile";
            _x.id = id;
            _x.azureSubscriptionId = azureSubscriptionId;
            _x.azureTenantId = azureTenantId;
            _x.createdDateTime = createdDateTime;
            _x.deploymentPackageUrl = deploymentPackageUrl;
            _x.destinationServiceName = destinationServiceName;
            _x.isSigned = isSigned;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.manifest = manifest;
            _x.name = name;
            _x.permissionsRequired = permissionsRequired;
            _x.platform = platform;
            _x.policyName = policyName;
            _x.publisher = publisher;
            _x.riskScore = riskScore;
            _x.tags = tags;
            _x.tagsNextLink = tagsNextLink;
            _x.type = type;
            _x.vendorInformation = vendorInformation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="azureSubscriptionId")
    @JsonIgnore
    public Optional<String> getAzureSubscriptionId() {
        return Optional.ofNullable(azureSubscriptionId);
    }

    public CloudAppSecurityProfile withAzureSubscriptionId(String azureSubscriptionId) {
        CloudAppSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("azureSubscriptionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecurityProfile");
        _x.azureSubscriptionId = azureSubscriptionId;
        return _x;
    }

    @Property(name="azureTenantId")
    @JsonIgnore
    public Optional<String> getAzureTenantId() {
        return Optional.ofNullable(azureTenantId);
    }

    public CloudAppSecurityProfile withAzureTenantId(String azureTenantId) {
        CloudAppSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("azureTenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecurityProfile");
        _x.azureTenantId = azureTenantId;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public CloudAppSecurityProfile withCreatedDateTime(OffsetDateTime createdDateTime) {
        CloudAppSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecurityProfile");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="deploymentPackageUrl")
    @JsonIgnore
    public Optional<String> getDeploymentPackageUrl() {
        return Optional.ofNullable(deploymentPackageUrl);
    }

    public CloudAppSecurityProfile withDeploymentPackageUrl(String deploymentPackageUrl) {
        CloudAppSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("deploymentPackageUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecurityProfile");
        _x.deploymentPackageUrl = deploymentPackageUrl;
        return _x;
    }

    @Property(name="destinationServiceName")
    @JsonIgnore
    public Optional<String> getDestinationServiceName() {
        return Optional.ofNullable(destinationServiceName);
    }

    public CloudAppSecurityProfile withDestinationServiceName(String destinationServiceName) {
        CloudAppSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("destinationServiceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecurityProfile");
        _x.destinationServiceName = destinationServiceName;
        return _x;
    }

    @Property(name="isSigned")
    @JsonIgnore
    public Optional<Boolean> getIsSigned() {
        return Optional.ofNullable(isSigned);
    }

    public CloudAppSecurityProfile withIsSigned(Boolean isSigned) {
        CloudAppSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("isSigned");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecurityProfile");
        _x.isSigned = isSigned;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public CloudAppSecurityProfile withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        CloudAppSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecurityProfile");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="manifest")
    @JsonIgnore
    public Optional<String> getManifest() {
        return Optional.ofNullable(manifest);
    }

    public CloudAppSecurityProfile withManifest(String manifest) {
        CloudAppSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("manifest");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecurityProfile");
        _x.manifest = manifest;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public CloudAppSecurityProfile withName(String name) {
        CloudAppSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecurityProfile");
        _x.name = name;
        return _x;
    }

    @Property(name="permissionsRequired")
    @JsonIgnore
    public Optional<ApplicationPermissionsRequired> getPermissionsRequired() {
        return Optional.ofNullable(permissionsRequired);
    }

    public CloudAppSecurityProfile withPermissionsRequired(ApplicationPermissionsRequired permissionsRequired) {
        CloudAppSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("permissionsRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecurityProfile");
        _x.permissionsRequired = permissionsRequired;
        return _x;
    }

    @Property(name="platform")
    @JsonIgnore
    public Optional<String> getPlatform() {
        return Optional.ofNullable(platform);
    }

    public CloudAppSecurityProfile withPlatform(String platform) {
        CloudAppSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("platform");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecurityProfile");
        _x.platform = platform;
        return _x;
    }

    @Property(name="policyName")
    @JsonIgnore
    public Optional<String> getPolicyName() {
        return Optional.ofNullable(policyName);
    }

    public CloudAppSecurityProfile withPolicyName(String policyName) {
        CloudAppSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("policyName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecurityProfile");
        _x.policyName = policyName;
        return _x;
    }

    @Property(name="publisher")
    @JsonIgnore
    public Optional<String> getPublisher() {
        return Optional.ofNullable(publisher);
    }

    public CloudAppSecurityProfile withPublisher(String publisher) {
        CloudAppSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("publisher");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecurityProfile");
        _x.publisher = publisher;
        return _x;
    }

    @Property(name="riskScore")
    @JsonIgnore
    public Optional<String> getRiskScore() {
        return Optional.ofNullable(riskScore);
    }

    public CloudAppSecurityProfile withRiskScore(String riskScore) {
        CloudAppSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("riskScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecurityProfile");
        _x.riskScore = riskScore;
        return _x;
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags() {
        return new CollectionPage<String>(contextPath, String.class, tags, Optional.ofNullable(tagsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, tags, Optional.ofNullable(tagsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public CloudAppSecurityProfile withType(String type) {
        CloudAppSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecurityProfile");
        _x.type = type;
        return _x;
    }

    @Property(name="vendorInformation")
    @JsonIgnore
    public Optional<SecurityVendorInformation> getVendorInformation() {
        return Optional.ofNullable(vendorInformation);
    }

    public CloudAppSecurityProfile withVendorInformation(SecurityVendorInformation vendorInformation) {
        CloudAppSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("vendorInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecurityProfile");
        _x.vendorInformation = vendorInformation;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudAppSecurityProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CloudAppSecurityProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudAppSecurityProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CloudAppSecurityProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CloudAppSecurityProfile _copy() {
        CloudAppSecurityProfile _x = new CloudAppSecurityProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.azureSubscriptionId = azureSubscriptionId;
        _x.azureTenantId = azureTenantId;
        _x.createdDateTime = createdDateTime;
        _x.deploymentPackageUrl = deploymentPackageUrl;
        _x.destinationServiceName = destinationServiceName;
        _x.isSigned = isSigned;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.manifest = manifest;
        _x.name = name;
        _x.permissionsRequired = permissionsRequired;
        _x.platform = platform;
        _x.policyName = policyName;
        _x.publisher = publisher;
        _x.riskScore = riskScore;
        _x.tags = tags;
        _x.type = type;
        _x.vendorInformation = vendorInformation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudAppSecurityProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("azureSubscriptionId=");
        b.append(this.azureSubscriptionId);
        b.append(", ");
        b.append("azureTenantId=");
        b.append(this.azureTenantId);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("deploymentPackageUrl=");
        b.append(this.deploymentPackageUrl);
        b.append(", ");
        b.append("destinationServiceName=");
        b.append(this.destinationServiceName);
        b.append(", ");
        b.append("isSigned=");
        b.append(this.isSigned);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("manifest=");
        b.append(this.manifest);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("permissionsRequired=");
        b.append(this.permissionsRequired);
        b.append(", ");
        b.append("platform=");
        b.append(this.platform);
        b.append(", ");
        b.append("policyName=");
        b.append(this.policyName);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("riskScore=");
        b.append(this.riskScore);
        b.append(", ");
        b.append("tags=");
        b.append(this.tags);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("vendorInformation=");
        b.append(this.vendorInformation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
