package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.complex.TeamworkActivityTopic;
import odata.msgraph.client.beta.complex.TeamworkNotificationRecipient;
import odata.msgraph.client.beta.entity.collection.request.ChatMessageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConversationMemberCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamsAppInstallationCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "topic", 
    "createdDateTime", 
    "lastUpdatedDateTime"})
@JsonInclude(Include.NON_NULL)
public class Chat extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.chat";
    }

    @JsonProperty("topic")
    protected String topic;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("lastUpdatedDateTime")
    protected OffsetDateTime lastUpdatedDateTime;

    protected Chat() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderChat() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String topic;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastUpdatedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder topic(String topic) {
            this.topic = topic;
            this.changedFields = changedFields.add("topic");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        public Chat build() {
            Chat _x = new Chat();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.chat";
            _x.id = id;
            _x.topic = topic;
            _x.createdDateTime = createdDateTime;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="topic")
    @JsonIgnore
    public Optional<String> getTopic() {
        return Optional.ofNullable(topic);
    }

    public Chat withTopic(String topic) {
        Chat _x = _copy();
        _x.changedFields = changedFields.add("topic");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chat");
        _x.topic = topic;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Chat withCreatedDateTime(OffsetDateTime createdDateTime) {
        Chat _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chat");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="lastUpdatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdatedDateTime() {
        return Optional.ofNullable(lastUpdatedDateTime);
    }

    public Chat withLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        Chat _x = _copy();
        _x.changedFields = changedFields.add("lastUpdatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chat");
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        return _x;
    }

    @NavigationProperty(name="members")
    @JsonIgnore
    public ConversationMemberCollectionRequest getMembers() {
        return new ConversationMemberCollectionRequest(
                        contextPath.addSegment("members"));
    }

    @NavigationProperty(name="messages")
    @JsonIgnore
    public ChatMessageCollectionRequest getMessages() {
        return new ChatMessageCollectionRequest(
                        contextPath.addSegment("messages"));
    }

    @NavigationProperty(name="installedApps")
    @JsonIgnore
    public TeamsAppInstallationCollectionRequest getInstalledApps() {
        return new TeamsAppInstallationCollectionRequest(
                        contextPath.addSegment("installedApps"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Chat patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Chat _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Chat put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Chat _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Chat _copy() {
        Chat _x = new Chat();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.topic = topic;
        _x.createdDateTime = createdDateTime;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        return _x;
    }

    @Action(name = "sendActivityNotification")
    @JsonIgnore
    public ActionRequestNoReturn sendActivityNotification(TeamworkActivityTopic topic, String activityType, Long chainId, ItemBody previewText, List<KeyValuePair> templateParameters, TeamworkNotificationRecipient recipient) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("topic", "microsoft.graph.teamworkActivityTopic", topic)
            .put("activityType", "Edm.String", Checks.checkIsAscii(activityType))
            .put("chainId", "Edm.Int64", chainId)
            .put("previewText", "microsoft.graph.itemBody", previewText)
            .put("templateParameters", "Collection(microsoft.graph.keyValuePair)", templateParameters)
            .put("recipient", "microsoft.graph.teamworkNotificationRecipient", recipient)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendActivityNotification"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Chat[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("topic=");
        b.append(this.topic);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
