package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.ChannelModerationSettings;
import odata.msgraph.client.beta.entity.collection.request.ChatMessageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConversationMemberCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamsTabCollectionRequest;
import odata.msgraph.client.beta.entity.request.DriveItemRequest;
import odata.msgraph.client.beta.enums.ChannelMembershipType;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "description", 
    "isFavoriteByDefault", 
    "email", 
    "webUrl", 
    "membershipType", 
    "moderationSettings"})
@JsonInclude(Include.NON_NULL)
public class Channel extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.channel";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("isFavoriteByDefault")
    protected Boolean isFavoriteByDefault;

    @JsonProperty("email")
    protected String email;

    @JsonProperty("webUrl")
    protected String webUrl;

    @JsonProperty("membershipType")
    protected ChannelMembershipType membershipType;

    @JsonProperty("moderationSettings")
    protected ChannelModerationSettings moderationSettings;

    protected Channel() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderChannel() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private Boolean isFavoriteByDefault;
        private String email;
        private String webUrl;
        private ChannelMembershipType membershipType;
        private ChannelModerationSettings moderationSettings;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder isFavoriteByDefault(Boolean isFavoriteByDefault) {
            this.isFavoriteByDefault = isFavoriteByDefault;
            this.changedFields = changedFields.add("isFavoriteByDefault");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.changedFields = changedFields.add("email");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public Builder membershipType(ChannelMembershipType membershipType) {
            this.membershipType = membershipType;
            this.changedFields = changedFields.add("membershipType");
            return this;
        }

        public Builder moderationSettings(ChannelModerationSettings moderationSettings) {
            this.moderationSettings = moderationSettings;
            this.changedFields = changedFields.add("moderationSettings");
            return this;
        }

        public Channel build() {
            Channel _x = new Channel();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.channel";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.isFavoriteByDefault = isFavoriteByDefault;
            _x.email = email;
            _x.webUrl = webUrl;
            _x.membershipType = membershipType;
            _x.moderationSettings = moderationSettings;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Channel withDisplayName(String displayName) {
        Channel _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channel");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Channel withDescription(String description) {
        Channel _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channel");
        _x.description = description;
        return _x;
    }

    @Property(name="isFavoriteByDefault")
    @JsonIgnore
    public Optional<Boolean> getIsFavoriteByDefault() {
        return Optional.ofNullable(isFavoriteByDefault);
    }

    public Channel withIsFavoriteByDefault(Boolean isFavoriteByDefault) {
        Channel _x = _copy();
        _x.changedFields = changedFields.add("isFavoriteByDefault");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channel");
        _x.isFavoriteByDefault = isFavoriteByDefault;
        return _x;
    }

    @Property(name="email")
    @JsonIgnore
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public Channel withEmail(String email) {
        Channel _x = _copy();
        _x.changedFields = changedFields.add("email");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channel");
        _x.email = email;
        return _x;
    }

    @Property(name="webUrl")
    @JsonIgnore
    public Optional<String> getWebUrl() {
        return Optional.ofNullable(webUrl);
    }

    public Channel withWebUrl(String webUrl) {
        Channel _x = _copy();
        _x.changedFields = changedFields.add("webUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channel");
        _x.webUrl = webUrl;
        return _x;
    }

    @Property(name="membershipType")
    @JsonIgnore
    public Optional<ChannelMembershipType> getMembershipType() {
        return Optional.ofNullable(membershipType);
    }

    public Channel withMembershipType(ChannelMembershipType membershipType) {
        Channel _x = _copy();
        _x.changedFields = changedFields.add("membershipType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channel");
        _x.membershipType = membershipType;
        return _x;
    }

    @Property(name="moderationSettings")
    @JsonIgnore
    public Optional<ChannelModerationSettings> getModerationSettings() {
        return Optional.ofNullable(moderationSettings);
    }

    public Channel withModerationSettings(ChannelModerationSettings moderationSettings) {
        Channel _x = _copy();
        _x.changedFields = changedFields.add("moderationSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channel");
        _x.moderationSettings = moderationSettings;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @return navigational property messages
     */
    @NavigationProperty(name="messages")
    @JsonIgnore
    public ChatMessageCollectionRequest getMessages() {
        return new ChatMessageCollectionRequest(
                        contextPath.addSegment("messages"));
    }

    @NavigationProperty(name="tabs")
    @JsonIgnore
    public TeamsTabCollectionRequest getTabs() {
        return new TeamsTabCollectionRequest(
                        contextPath.addSegment("tabs"));
    }

    @NavigationProperty(name="members")
    @JsonIgnore
    public ConversationMemberCollectionRequest getMembers() {
        return new ConversationMemberCollectionRequest(
                        contextPath.addSegment("members"));
    }

    @NavigationProperty(name="filesFolder")
    @JsonIgnore
    public DriveItemRequest getFilesFolder() {
        return new DriveItemRequest(contextPath.addSegment("filesFolder"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Channel patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Channel _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Channel put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Channel _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Channel _copy() {
        Channel _x = new Channel();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.isFavoriteByDefault = isFavoriteByDefault;
        _x.email = email;
        _x.webUrl = webUrl;
        _x.membershipType = membershipType;
        _x.moderationSettings = moderationSettings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Channel[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("isFavoriteByDefault=");
        b.append(this.isFavoriteByDefault);
        b.append(", ");
        b.append("email=");
        b.append(this.email);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append(", ");
        b.append("membershipType=");
        b.append(this.membershipType);
        b.append(", ");
        b.append("moderationSettings=");
        b.append(this.moderationSettings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
