package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.Duration;
import java.time.LocalDate;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AnalyticsActivityType;

@JsonPropertyOrder({
    "@odata.type", 
    "afterHours"})
@JsonInclude(Include.NON_NULL)
public class CallActivityStatistics extends ActivityStatistics implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callActivityStatistics";
    }

    @JsonProperty("afterHours")
    protected Duration afterHours;

    protected CallActivityStatistics() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCallActivityStatistics() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AnalyticsActivityType activity;
        private LocalDate startDate;
        private LocalDate endDate;
        private String timeZoneUsed;
        private Duration duration;
        private Duration afterHours;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder activity(AnalyticsActivityType activity) {
            this.activity = activity;
            this.changedFields = changedFields.add("activity");
            return this;
        }

        public Builder startDate(LocalDate startDate) {
            this.startDate = startDate;
            this.changedFields = changedFields.add("startDate");
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            this.endDate = endDate;
            this.changedFields = changedFields.add("endDate");
            return this;
        }

        public Builder timeZoneUsed(String timeZoneUsed) {
            this.timeZoneUsed = timeZoneUsed;
            this.changedFields = changedFields.add("timeZoneUsed");
            return this;
        }

        public Builder duration(Duration duration) {
            this.duration = duration;
            this.changedFields = changedFields.add("duration");
            return this;
        }

        public Builder afterHours(Duration afterHours) {
            this.afterHours = afterHours;
            this.changedFields = changedFields.add("afterHours");
            return this;
        }

        public CallActivityStatistics build() {
            CallActivityStatistics _x = new CallActivityStatistics();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.callActivityStatistics";
            _x.id = id;
            _x.activity = activity;
            _x.startDate = startDate;
            _x.endDate = endDate;
            _x.timeZoneUsed = timeZoneUsed;
            _x.duration = duration;
            _x.afterHours = afterHours;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="afterHours")
    @JsonIgnore
    public Optional<Duration> getAfterHours() {
        return Optional.ofNullable(afterHours);
    }

    public CallActivityStatistics withAfterHours(Duration afterHours) {
        CallActivityStatistics _x = _copy();
        _x.changedFields = changedFields.add("afterHours");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callActivityStatistics");
        _x.afterHours = afterHours;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CallActivityStatistics patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CallActivityStatistics _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CallActivityStatistics put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CallActivityStatistics _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CallActivityStatistics _copy() {
        CallActivityStatistics _x = new CallActivityStatistics();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.activity = activity;
        _x.startDate = startDate;
        _x.endDate = endDate;
        _x.timeZoneUsed = timeZoneUsed;
        _x.duration = duration;
        _x.afterHours = afterHours;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CallActivityStatistics[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activity=");
        b.append(this.activity);
        b.append(", ");
        b.append("startDate=");
        b.append(this.startDate);
        b.append(", ");
        b.append("endDate=");
        b.append(this.endDate);
        b.append(", ");
        b.append("timeZoneUsed=");
        b.append(this.timeZoneUsed);
        b.append(", ");
        b.append("duration=");
        b.append(this.duration);
        b.append(", ");
        b.append("afterHours=");
        b.append(this.afterHours);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
