package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CallMediaState;
import odata.msgraph.client.beta.complex.CallOptions;
import odata.msgraph.client.beta.complex.CallRoute;
import odata.msgraph.client.beta.complex.ChatInfo;
import odata.msgraph.client.beta.complex.IncomingContext;
import odata.msgraph.client.beta.complex.InvitationParticipantInfo;
import odata.msgraph.client.beta.complex.MediaConfig;
import odata.msgraph.client.beta.complex.MeetingCapability;
import odata.msgraph.client.beta.complex.MeetingInfo;
import odata.msgraph.client.beta.complex.ParticipantInfo;
import odata.msgraph.client.beta.complex.Prompt;
import odata.msgraph.client.beta.complex.ResultInfo;
import odata.msgraph.client.beta.complex.ToneInfo;
import odata.msgraph.client.beta.entity.collection.request.AudioRoutingGroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CommsOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ParticipantCollectionRequest;
import odata.msgraph.client.beta.enums.CallDirection;
import odata.msgraph.client.beta.enums.CallDisposition;
import odata.msgraph.client.beta.enums.CallState;
import odata.msgraph.client.beta.enums.Modality;
import odata.msgraph.client.beta.enums.RecordingStatus;
import odata.msgraph.client.beta.enums.RejectReason;
import odata.msgraph.client.beta.enums.RoutingPolicy;
import odata.msgraph.client.beta.enums.ScreenSharingRole;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "state", 
    "mediaState", 
    "resultInfo", 
    "terminationReason", 
    "direction", 
    "ringingTimeoutInSeconds", 
    "subject", 
    "callbackUri", 
    "callRoutes", 
    "source", 
    "targets", 
    "answeredBy", 
    "requestedModalities", 
    "activeModalities", 
    "mediaConfig", 
    "chatInfo", 
    "callOptions", 
    "meetingInfo", 
    "meetingCapability", 
    "routingPolicies", 
    "tenantId", 
    "myParticipantId", 
    "toneInfo", 
    "callChainId", 
    "incomingContext"})
@JsonInclude(Include.NON_NULL)
public class Call extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.call";
    }

    @JsonProperty("state")
    protected CallState state;

    @JsonProperty("mediaState")
    protected CallMediaState mediaState;

    @JsonProperty("resultInfo")
    protected ResultInfo resultInfo;

    @JsonProperty("terminationReason")
    protected String terminationReason;

    @JsonProperty("direction")
    protected CallDirection direction;

    @JsonProperty("ringingTimeoutInSeconds")
    protected Integer ringingTimeoutInSeconds;

    @JsonProperty("subject")
    protected String subject;

    @JsonProperty("callbackUri")
    protected String callbackUri;

    @JsonProperty("callRoutes")
    protected List<CallRoute> callRoutes;

    @JsonProperty("callRoutes@nextLink")
    protected String callRoutesNextLink;

    @JsonProperty("source")
    protected ParticipantInfo source;

    @JsonProperty("targets")
    protected List<InvitationParticipantInfo> targets;

    @JsonProperty("targets@nextLink")
    protected String targetsNextLink;

    @JsonProperty("answeredBy")
    protected ParticipantInfo answeredBy;

    @JsonProperty("requestedModalities")
    protected List<Modality> requestedModalities;

    @JsonProperty("requestedModalities@nextLink")
    protected String requestedModalitiesNextLink;

    @JsonProperty("activeModalities")
    protected List<Modality> activeModalities;

    @JsonProperty("activeModalities@nextLink")
    protected String activeModalitiesNextLink;

    @JsonProperty("mediaConfig")
    protected MediaConfig mediaConfig;

    @JsonProperty("chatInfo")
    protected ChatInfo chatInfo;

    @JsonProperty("callOptions")
    protected CallOptions callOptions;

    @JsonProperty("meetingInfo")
    protected MeetingInfo meetingInfo;

    @JsonProperty("meetingCapability")
    protected MeetingCapability meetingCapability;

    @JsonProperty("routingPolicies")
    protected List<RoutingPolicy> routingPolicies;

    @JsonProperty("routingPolicies@nextLink")
    protected String routingPoliciesNextLink;

    @JsonProperty("tenantId")
    protected String tenantId;

    @JsonProperty("myParticipantId")
    protected String myParticipantId;

    @JsonProperty("toneInfo")
    protected ToneInfo toneInfo;

    @JsonProperty("callChainId")
    protected String callChainId;

    @JsonProperty("incomingContext")
    protected IncomingContext incomingContext;

    protected Call() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCall() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private CallState state;
        private CallMediaState mediaState;
        private ResultInfo resultInfo;
        private String terminationReason;
        private CallDirection direction;
        private Integer ringingTimeoutInSeconds;
        private String subject;
        private String callbackUri;
        private List<CallRoute> callRoutes;
        private String callRoutesNextLink;
        private ParticipantInfo source;
        private List<InvitationParticipantInfo> targets;
        private String targetsNextLink;
        private ParticipantInfo answeredBy;
        private List<Modality> requestedModalities;
        private String requestedModalitiesNextLink;
        private List<Modality> activeModalities;
        private String activeModalitiesNextLink;
        private MediaConfig mediaConfig;
        private ChatInfo chatInfo;
        private CallOptions callOptions;
        private MeetingInfo meetingInfo;
        private MeetingCapability meetingCapability;
        private List<RoutingPolicy> routingPolicies;
        private String routingPoliciesNextLink;
        private String tenantId;
        private String myParticipantId;
        private ToneInfo toneInfo;
        private String callChainId;
        private IncomingContext incomingContext;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder state(CallState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder mediaState(CallMediaState mediaState) {
            this.mediaState = mediaState;
            this.changedFields = changedFields.add("mediaState");
            return this;
        }

        public Builder resultInfo(ResultInfo resultInfo) {
            this.resultInfo = resultInfo;
            this.changedFields = changedFields.add("resultInfo");
            return this;
        }

        public Builder terminationReason(String terminationReason) {
            this.terminationReason = terminationReason;
            this.changedFields = changedFields.add("terminationReason");
            return this;
        }

        public Builder direction(CallDirection direction) {
            this.direction = direction;
            this.changedFields = changedFields.add("direction");
            return this;
        }

        public Builder ringingTimeoutInSeconds(Integer ringingTimeoutInSeconds) {
            this.ringingTimeoutInSeconds = ringingTimeoutInSeconds;
            this.changedFields = changedFields.add("ringingTimeoutInSeconds");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        public Builder callbackUri(String callbackUri) {
            this.callbackUri = callbackUri;
            this.changedFields = changedFields.add("callbackUri");
            return this;
        }

        public Builder callRoutes(List<CallRoute> callRoutes) {
            this.callRoutes = callRoutes;
            this.changedFields = changedFields.add("callRoutes");
            return this;
        }

        public Builder callRoutes(CallRoute... callRoutes) {
            return callRoutes(Arrays.asList(callRoutes));
        }

        public Builder callRoutesNextLink(String callRoutesNextLink) {
            this.callRoutesNextLink = callRoutesNextLink;
            this.changedFields = changedFields.add("callRoutes");
            return this;
        }

        public Builder source(ParticipantInfo source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder targets(List<InvitationParticipantInfo> targets) {
            this.targets = targets;
            this.changedFields = changedFields.add("targets");
            return this;
        }

        public Builder targets(InvitationParticipantInfo... targets) {
            return targets(Arrays.asList(targets));
        }

        public Builder targetsNextLink(String targetsNextLink) {
            this.targetsNextLink = targetsNextLink;
            this.changedFields = changedFields.add("targets");
            return this;
        }

        public Builder answeredBy(ParticipantInfo answeredBy) {
            this.answeredBy = answeredBy;
            this.changedFields = changedFields.add("answeredBy");
            return this;
        }

        public Builder requestedModalities(List<Modality> requestedModalities) {
            this.requestedModalities = requestedModalities;
            this.changedFields = changedFields.add("requestedModalities");
            return this;
        }

        public Builder requestedModalities(Modality... requestedModalities) {
            return requestedModalities(Arrays.asList(requestedModalities));
        }

        public Builder requestedModalitiesNextLink(String requestedModalitiesNextLink) {
            this.requestedModalitiesNextLink = requestedModalitiesNextLink;
            this.changedFields = changedFields.add("requestedModalities");
            return this;
        }

        public Builder activeModalities(List<Modality> activeModalities) {
            this.activeModalities = activeModalities;
            this.changedFields = changedFields.add("activeModalities");
            return this;
        }

        public Builder activeModalities(Modality... activeModalities) {
            return activeModalities(Arrays.asList(activeModalities));
        }

        public Builder activeModalitiesNextLink(String activeModalitiesNextLink) {
            this.activeModalitiesNextLink = activeModalitiesNextLink;
            this.changedFields = changedFields.add("activeModalities");
            return this;
        }

        public Builder mediaConfig(MediaConfig mediaConfig) {
            this.mediaConfig = mediaConfig;
            this.changedFields = changedFields.add("mediaConfig");
            return this;
        }

        public Builder chatInfo(ChatInfo chatInfo) {
            this.chatInfo = chatInfo;
            this.changedFields = changedFields.add("chatInfo");
            return this;
        }

        public Builder callOptions(CallOptions callOptions) {
            this.callOptions = callOptions;
            this.changedFields = changedFields.add("callOptions");
            return this;
        }

        public Builder meetingInfo(MeetingInfo meetingInfo) {
            this.meetingInfo = meetingInfo;
            this.changedFields = changedFields.add("meetingInfo");
            return this;
        }

        public Builder meetingCapability(MeetingCapability meetingCapability) {
            this.meetingCapability = meetingCapability;
            this.changedFields = changedFields.add("meetingCapability");
            return this;
        }

        public Builder routingPolicies(List<RoutingPolicy> routingPolicies) {
            this.routingPolicies = routingPolicies;
            this.changedFields = changedFields.add("routingPolicies");
            return this;
        }

        public Builder routingPolicies(RoutingPolicy... routingPolicies) {
            return routingPolicies(Arrays.asList(routingPolicies));
        }

        public Builder routingPoliciesNextLink(String routingPoliciesNextLink) {
            this.routingPoliciesNextLink = routingPoliciesNextLink;
            this.changedFields = changedFields.add("routingPolicies");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public Builder myParticipantId(String myParticipantId) {
            this.myParticipantId = myParticipantId;
            this.changedFields = changedFields.add("myParticipantId");
            return this;
        }

        public Builder toneInfo(ToneInfo toneInfo) {
            this.toneInfo = toneInfo;
            this.changedFields = changedFields.add("toneInfo");
            return this;
        }

        public Builder callChainId(String callChainId) {
            this.callChainId = callChainId;
            this.changedFields = changedFields.add("callChainId");
            return this;
        }

        public Builder incomingContext(IncomingContext incomingContext) {
            this.incomingContext = incomingContext;
            this.changedFields = changedFields.add("incomingContext");
            return this;
        }

        public Call build() {
            Call _x = new Call();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.call";
            _x.id = id;
            _x.state = state;
            _x.mediaState = mediaState;
            _x.resultInfo = resultInfo;
            _x.terminationReason = terminationReason;
            _x.direction = direction;
            _x.ringingTimeoutInSeconds = ringingTimeoutInSeconds;
            _x.subject = subject;
            _x.callbackUri = callbackUri;
            _x.callRoutes = callRoutes;
            _x.callRoutesNextLink = callRoutesNextLink;
            _x.source = source;
            _x.targets = targets;
            _x.targetsNextLink = targetsNextLink;
            _x.answeredBy = answeredBy;
            _x.requestedModalities = requestedModalities;
            _x.requestedModalitiesNextLink = requestedModalitiesNextLink;
            _x.activeModalities = activeModalities;
            _x.activeModalitiesNextLink = activeModalitiesNextLink;
            _x.mediaConfig = mediaConfig;
            _x.chatInfo = chatInfo;
            _x.callOptions = callOptions;
            _x.meetingInfo = meetingInfo;
            _x.meetingCapability = meetingCapability;
            _x.routingPolicies = routingPolicies;
            _x.routingPoliciesNextLink = routingPoliciesNextLink;
            _x.tenantId = tenantId;
            _x.myParticipantId = myParticipantId;
            _x.toneInfo = toneInfo;
            _x.callChainId = callChainId;
            _x.incomingContext = incomingContext;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<CallState> getState() {
        return Optional.ofNullable(state);
    }

    public Call withState(CallState state) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.state = state;
        return _x;
    }

    @Property(name="mediaState")
    @JsonIgnore
    public Optional<CallMediaState> getMediaState() {
        return Optional.ofNullable(mediaState);
    }

    public Call withMediaState(CallMediaState mediaState) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("mediaState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.mediaState = mediaState;
        return _x;
    }

    @Property(name="resultInfo")
    @JsonIgnore
    public Optional<ResultInfo> getResultInfo() {
        return Optional.ofNullable(resultInfo);
    }

    public Call withResultInfo(ResultInfo resultInfo) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("resultInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.resultInfo = resultInfo;
        return _x;
    }

    @Property(name="terminationReason")
    @JsonIgnore
    public Optional<String> getTerminationReason() {
        return Optional.ofNullable(terminationReason);
    }

    public Call withTerminationReason(String terminationReason) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("terminationReason");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.terminationReason = terminationReason;
        return _x;
    }

    @Property(name="direction")
    @JsonIgnore
    public Optional<CallDirection> getDirection() {
        return Optional.ofNullable(direction);
    }

    public Call withDirection(CallDirection direction) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("direction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.direction = direction;
        return _x;
    }

    @Property(name="ringingTimeoutInSeconds")
    @JsonIgnore
    public Optional<Integer> getRingingTimeoutInSeconds() {
        return Optional.ofNullable(ringingTimeoutInSeconds);
    }

    public Call withRingingTimeoutInSeconds(Integer ringingTimeoutInSeconds) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("ringingTimeoutInSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.ringingTimeoutInSeconds = ringingTimeoutInSeconds;
        return _x;
    }

    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    public Call withSubject(String subject) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("subject");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.subject = subject;
        return _x;
    }

    @Property(name="callbackUri")
    @JsonIgnore
    public Optional<String> getCallbackUri() {
        return Optional.ofNullable(callbackUri);
    }

    public Call withCallbackUri(String callbackUri) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("callbackUri");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.callbackUri = callbackUri;
        return _x;
    }

    @Property(name="callRoutes")
    @JsonIgnore
    public CollectionPage<CallRoute> getCallRoutes() {
        return new CollectionPage<CallRoute>(contextPath, CallRoute.class, callRoutes, Optional.ofNullable(callRoutesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="callRoutes")
    @JsonIgnore
    public CollectionPage<CallRoute> getCallRoutes(HttpRequestOptions options) {
        return new CollectionPage<CallRoute>(contextPath, CallRoute.class, callRoutes, Optional.ofNullable(callRoutesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="source")
    @JsonIgnore
    public Optional<ParticipantInfo> getSource() {
        return Optional.ofNullable(source);
    }

    public Call withSource(ParticipantInfo source) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("source");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.source = source;
        return _x;
    }

    @Property(name="targets")
    @JsonIgnore
    public CollectionPage<InvitationParticipantInfo> getTargets() {
        return new CollectionPage<InvitationParticipantInfo>(contextPath, InvitationParticipantInfo.class, targets, Optional.ofNullable(targetsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="targets")
    @JsonIgnore
    public CollectionPage<InvitationParticipantInfo> getTargets(HttpRequestOptions options) {
        return new CollectionPage<InvitationParticipantInfo>(contextPath, InvitationParticipantInfo.class, targets, Optional.ofNullable(targetsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="answeredBy")
    @JsonIgnore
    public Optional<ParticipantInfo> getAnsweredBy() {
        return Optional.ofNullable(answeredBy);
    }

    public Call withAnsweredBy(ParticipantInfo answeredBy) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("answeredBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.answeredBy = answeredBy;
        return _x;
    }

    @Property(name="requestedModalities")
    @JsonIgnore
    public CollectionPage<Modality> getRequestedModalities() {
        return new CollectionPage<Modality>(contextPath, Modality.class, requestedModalities, Optional.ofNullable(requestedModalitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="requestedModalities")
    @JsonIgnore
    public CollectionPage<Modality> getRequestedModalities(HttpRequestOptions options) {
        return new CollectionPage<Modality>(contextPath, Modality.class, requestedModalities, Optional.ofNullable(requestedModalitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="activeModalities")
    @JsonIgnore
    public CollectionPage<Modality> getActiveModalities() {
        return new CollectionPage<Modality>(contextPath, Modality.class, activeModalities, Optional.ofNullable(activeModalitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="activeModalities")
    @JsonIgnore
    public CollectionPage<Modality> getActiveModalities(HttpRequestOptions options) {
        return new CollectionPage<Modality>(contextPath, Modality.class, activeModalities, Optional.ofNullable(activeModalitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="mediaConfig")
    @JsonIgnore
    public Optional<MediaConfig> getMediaConfig() {
        return Optional.ofNullable(mediaConfig);
    }

    public Call withMediaConfig(MediaConfig mediaConfig) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("mediaConfig");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.mediaConfig = mediaConfig;
        return _x;
    }

    @Property(name="chatInfo")
    @JsonIgnore
    public Optional<ChatInfo> getChatInfo() {
        return Optional.ofNullable(chatInfo);
    }

    public Call withChatInfo(ChatInfo chatInfo) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("chatInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.chatInfo = chatInfo;
        return _x;
    }

    @Property(name="callOptions")
    @JsonIgnore
    public Optional<CallOptions> getCallOptions() {
        return Optional.ofNullable(callOptions);
    }

    public Call withCallOptions(CallOptions callOptions) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("callOptions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.callOptions = callOptions;
        return _x;
    }

    @Property(name="meetingInfo")
    @JsonIgnore
    public Optional<MeetingInfo> getMeetingInfo() {
        return Optional.ofNullable(meetingInfo);
    }

    public Call withMeetingInfo(MeetingInfo meetingInfo) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("meetingInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.meetingInfo = meetingInfo;
        return _x;
    }

    @Property(name="meetingCapability")
    @JsonIgnore
    public Optional<MeetingCapability> getMeetingCapability() {
        return Optional.ofNullable(meetingCapability);
    }

    public Call withMeetingCapability(MeetingCapability meetingCapability) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("meetingCapability");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.meetingCapability = meetingCapability;
        return _x;
    }

    @Property(name="routingPolicies")
    @JsonIgnore
    public CollectionPage<RoutingPolicy> getRoutingPolicies() {
        return new CollectionPage<RoutingPolicy>(contextPath, RoutingPolicy.class, routingPolicies, Optional.ofNullable(routingPoliciesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="routingPolicies")
    @JsonIgnore
    public CollectionPage<RoutingPolicy> getRoutingPolicies(HttpRequestOptions options) {
        return new CollectionPage<RoutingPolicy>(contextPath, RoutingPolicy.class, routingPolicies, Optional.ofNullable(routingPoliciesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public Call withTenantId(String tenantId) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.tenantId = tenantId;
        return _x;
    }

    @Property(name="myParticipantId")
    @JsonIgnore
    public Optional<String> getMyParticipantId() {
        return Optional.ofNullable(myParticipantId);
    }

    public Call withMyParticipantId(String myParticipantId) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("myParticipantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.myParticipantId = myParticipantId;
        return _x;
    }

    @Property(name="toneInfo")
    @JsonIgnore
    public Optional<ToneInfo> getToneInfo() {
        return Optional.ofNullable(toneInfo);
    }

    public Call withToneInfo(ToneInfo toneInfo) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("toneInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.toneInfo = toneInfo;
        return _x;
    }

    @Property(name="callChainId")
    @JsonIgnore
    public Optional<String> getCallChainId() {
        return Optional.ofNullable(callChainId);
    }

    public Call withCallChainId(String callChainId) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("callChainId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.callChainId = callChainId;
        return _x;
    }

    @Property(name="incomingContext")
    @JsonIgnore
    public Optional<IncomingContext> getIncomingContext() {
        return Optional.ofNullable(incomingContext);
    }

    public Call withIncomingContext(IncomingContext incomingContext) {
        Call _x = _copy();
        _x.changedFields = changedFields.add("incomingContext");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.call");
        _x.incomingContext = incomingContext;
        return _x;
    }

    @NavigationProperty(name="participants")
    @JsonIgnore
    public ParticipantCollectionRequest getParticipants() {
        return new ParticipantCollectionRequest(
                        contextPath.addSegment("participants"));
    }

    @NavigationProperty(name="audioRoutingGroups")
    @JsonIgnore
    public AudioRoutingGroupCollectionRequest getAudioRoutingGroups() {
        return new AudioRoutingGroupCollectionRequest(
                        contextPath.addSegment("audioRoutingGroups"));
    }

    @NavigationProperty(name="operations")
    @JsonIgnore
    public CommsOperationCollectionRequest getOperations() {
        return new CommsOperationCollectionRequest(
                        contextPath.addSegment("operations"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Call patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Call _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Call put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Call _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Call _copy() {
        Call _x = new Call();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.state = state;
        _x.mediaState = mediaState;
        _x.resultInfo = resultInfo;
        _x.terminationReason = terminationReason;
        _x.direction = direction;
        _x.ringingTimeoutInSeconds = ringingTimeoutInSeconds;
        _x.subject = subject;
        _x.callbackUri = callbackUri;
        _x.callRoutes = callRoutes;
        _x.source = source;
        _x.targets = targets;
        _x.answeredBy = answeredBy;
        _x.requestedModalities = requestedModalities;
        _x.activeModalities = activeModalities;
        _x.mediaConfig = mediaConfig;
        _x.chatInfo = chatInfo;
        _x.callOptions = callOptions;
        _x.meetingInfo = meetingInfo;
        _x.meetingCapability = meetingCapability;
        _x.routingPolicies = routingPolicies;
        _x.tenantId = tenantId;
        _x.myParticipantId = myParticipantId;
        _x.toneInfo = toneInfo;
        _x.callChainId = callChainId;
        _x.incomingContext = incomingContext;
        return _x;
    }

    @Action(name = "answer")
    @JsonIgnore
    public ActionRequestNoReturn answer(String callbackUri, MediaConfig mediaConfig, List<Modality> acceptedModalities) {
        Preconditions.checkNotNull(callbackUri, "callbackUri cannot be null");
        Preconditions.checkNotNull(mediaConfig, "mediaConfig cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("callbackUri", "Edm.String", Checks.checkIsAscii(callbackUri))
            .put("mediaConfig", "microsoft.graph.mediaConfig", mediaConfig)
            .put("acceptedModalities", "Collection(microsoft.graph.modality)", acceptedModalities)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.answer"), _parameters);
    }

    @Action(name = "cancelMediaProcessing")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CancelMediaProcessingOperation> cancelMediaProcessing(String clientContext) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CancelMediaProcessingOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancelMediaProcessing"), CancelMediaProcessingOperation.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "changeScreenSharingRole")
    @JsonIgnore
    public ActionRequestNoReturn changeScreenSharingRole(ScreenSharingRole role) {
        Preconditions.checkNotNull(role, "role cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("role", "microsoft.graph.screenSharingRole", role)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.changeScreenSharingRole"), _parameters);
    }

    @Action(name = "keepAlive")
    @JsonIgnore
    public ActionRequestNoReturn keepAlive() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.keepAlive"), _parameters);
    }

    @Action(name = "mute")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<MuteParticipantOperation> mute(String clientContext) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<MuteParticipantOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.mute"), MuteParticipantOperation.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "playPrompt")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PlayPromptOperation> playPrompt(List<Prompt> prompts, Boolean loop, String clientContext) {
        Preconditions.checkNotNull(prompts, "prompts cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("prompts", "Collection(microsoft.graph.prompt)", prompts)
            .put("loop", "Edm.Boolean", loop)
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PlayPromptOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.playPrompt"), PlayPromptOperation.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "record")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RecordOperation> record(List<Prompt> prompts, Boolean bargeInAllowed, Integer initialSilenceTimeoutInSeconds, Integer maxSilenceTimeoutInSeconds, Integer maxRecordDurationInSeconds, Boolean playBeep, Boolean streamWhileRecording, List<String> stopTones, String clientContext) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("prompts", "Collection(microsoft.graph.prompt)", prompts)
            .put("bargeInAllowed", "Edm.Boolean", bargeInAllowed)
            .put("initialSilenceTimeoutInSeconds", "Edm.Int32", initialSilenceTimeoutInSeconds)
            .put("maxSilenceTimeoutInSeconds", "Edm.Int32", maxSilenceTimeoutInSeconds)
            .put("maxRecordDurationInSeconds", "Edm.Int32", maxRecordDurationInSeconds)
            .put("playBeep", "Edm.Boolean", playBeep)
            .put("streamWhileRecording", "Edm.Boolean", streamWhileRecording)
            .put("stopTones", "Collection(Edm.String)", Checks.checkIsAscii(stopTones))
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<RecordOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.record"), RecordOperation.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "recordResponse")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RecordOperation> recordResponse(List<Prompt> prompts, Boolean bargeInAllowed, Integer initialSilenceTimeoutInSeconds, Integer maxSilenceTimeoutInSeconds, Integer maxRecordDurationInSeconds, Boolean playBeep, Boolean streamWhileRecording, List<String> stopTones, String clientContext) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("prompts", "Collection(microsoft.graph.prompt)", prompts)
            .put("bargeInAllowed", "Edm.Boolean", bargeInAllowed)
            .put("initialSilenceTimeoutInSeconds", "Edm.Int32", initialSilenceTimeoutInSeconds)
            .put("maxSilenceTimeoutInSeconds", "Edm.Int32", maxSilenceTimeoutInSeconds)
            .put("maxRecordDurationInSeconds", "Edm.Int32", maxRecordDurationInSeconds)
            .put("playBeep", "Edm.Boolean", playBeep)
            .put("streamWhileRecording", "Edm.Boolean", streamWhileRecording)
            .put("stopTones", "Collection(Edm.String)", Checks.checkIsAscii(stopTones))
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<RecordOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.recordResponse"), RecordOperation.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "redirect")
    @JsonIgnore
    public ActionRequestNoReturn redirect(List<InvitationParticipantInfo> targets, CallDisposition targetDisposition, Integer timeout, Boolean maskCallee, Boolean maskCaller, String callbackUri) {
        Preconditions.checkNotNull(targets, "targets cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("targets", "Collection(microsoft.graph.invitationParticipantInfo)", targets)
            .put("targetDisposition", "microsoft.graph.callDisposition", targetDisposition)
            .put("timeout", "Edm.Int32", timeout)
            .put("maskCallee", "Edm.Boolean", maskCallee)
            .put("maskCaller", "Edm.Boolean", maskCaller)
            .put("callbackUri", "Edm.String", Checks.checkIsAscii(callbackUri))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.redirect"), _parameters);
    }

    @Action(name = "reject")
    @JsonIgnore
    public ActionRequestNoReturn reject(RejectReason reason, String callbackUri) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("reason", "microsoft.graph.rejectReason", reason)
            .put("callbackUri", "Edm.String", Checks.checkIsAscii(callbackUri))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reject"), _parameters);
    }

    @Action(name = "subscribeToTone")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<SubscribeToToneOperation> subscribeToTone(String clientContext) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<SubscribeToToneOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.subscribeToTone"), SubscribeToToneOperation.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "transfer")
    @JsonIgnore
    public ActionRequestNoReturn transfer(InvitationParticipantInfo transferTarget) {
        Preconditions.checkNotNull(transferTarget, "transferTarget cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("transferTarget", "microsoft.graph.invitationParticipantInfo", transferTarget)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.transfer"), _parameters);
    }

    @Action(name = "unmute")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<UnmuteParticipantOperation> unmute(String clientContext) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<UnmuteParticipantOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unmute"), UnmuteParticipantOperation.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "updateRecordingStatus")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<UpdateRecordingStatusOperation> updateRecordingStatus(RecordingStatus status, String clientContext) {
        Preconditions.checkNotNull(status, "status cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("status", "microsoft.graph.recordingStatus", status)
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<UpdateRecordingStatusOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateRecordingStatus"), UpdateRecordingStatusOperation.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Call[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("mediaState=");
        b.append(this.mediaState);
        b.append(", ");
        b.append("resultInfo=");
        b.append(this.resultInfo);
        b.append(", ");
        b.append("terminationReason=");
        b.append(this.terminationReason);
        b.append(", ");
        b.append("direction=");
        b.append(this.direction);
        b.append(", ");
        b.append("ringingTimeoutInSeconds=");
        b.append(this.ringingTimeoutInSeconds);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("callbackUri=");
        b.append(this.callbackUri);
        b.append(", ");
        b.append("callRoutes=");
        b.append(this.callRoutes);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("targets=");
        b.append(this.targets);
        b.append(", ");
        b.append("answeredBy=");
        b.append(this.answeredBy);
        b.append(", ");
        b.append("requestedModalities=");
        b.append(this.requestedModalities);
        b.append(", ");
        b.append("activeModalities=");
        b.append(this.activeModalities);
        b.append(", ");
        b.append("mediaConfig=");
        b.append(this.mediaConfig);
        b.append(", ");
        b.append("chatInfo=");
        b.append(this.chatInfo);
        b.append(", ");
        b.append("callOptions=");
        b.append(this.callOptions);
        b.append(", ");
        b.append("meetingInfo=");
        b.append(this.meetingInfo);
        b.append(", ");
        b.append("meetingCapability=");
        b.append(this.meetingCapability);
        b.append(", ");
        b.append("routingPolicies=");
        b.append(this.routingPolicies);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append(", ");
        b.append("myParticipantId=");
        b.append(this.myParticipantId);
        b.append(", ");
        b.append("toneInfo=");
        b.append(this.toneInfo);
        b.append(", ");
        b.append("callChainId=");
        b.append(this.callChainId);
        b.append(", ");
        b.append("incomingContext=");
        b.append(this.incomingContext);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
