package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CalendarSharingMessageAction;
import odata.msgraph.client.beta.complex.FollowupFlag;
import odata.msgraph.client.beta.complex.InternetMessageHeader;
import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.complex.MentionsPreview;
import odata.msgraph.client.beta.complex.Recipient;
import odata.msgraph.client.beta.enums.Importance;
import odata.msgraph.client.beta.enums.InferenceClassificationType;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "canAccept", 
    "suggestedCalendarName", 
    "sharingMessageAction", 
    "sharingMessageActions"})
@JsonInclude(Include.NON_NULL)
public class CalendarSharingMessage extends Message implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.calendarSharingMessage";
    }

    @JsonProperty("canAccept")
    protected Boolean canAccept;

    @JsonProperty("suggestedCalendarName")
    protected String suggestedCalendarName;

    @JsonProperty("sharingMessageAction")
    protected CalendarSharingMessageAction sharingMessageAction;

    @JsonProperty("sharingMessageActions")
    protected List<CalendarSharingMessageAction> sharingMessageActions;

    @JsonProperty("sharingMessageActions@nextLink")
    protected String sharingMessageActionsNextLink;

    protected CalendarSharingMessage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCalendarSharingMessage() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private String changeKey;
        private List<String> categories;
        private String categoriesNextLink;
        private OffsetDateTime receivedDateTime;
        private OffsetDateTime sentDateTime;
        private Boolean hasAttachments;
        private String internetMessageId;
        private List<InternetMessageHeader> internetMessageHeaders;
        private String internetMessageHeadersNextLink;
        private String subject;
        private ItemBody body;
        private String bodyPreview;
        private Importance importance;
        private String parentFolderId;
        private Recipient sender;
        private Recipient from;
        private List<Recipient> toRecipients;
        private String toRecipientsNextLink;
        private List<Recipient> ccRecipients;
        private String ccRecipientsNextLink;
        private List<Recipient> bccRecipients;
        private String bccRecipientsNextLink;
        private List<Recipient> replyTo;
        private String replyToNextLink;
        private String conversationId;
        private byte[] conversationIndex;
        private ItemBody uniqueBody;
        private Boolean isDeliveryReceiptRequested;
        private Boolean isReadReceiptRequested;
        private Boolean isRead;
        private Boolean isDraft;
        private String webLink;
        private MentionsPreview mentionsPreview;
        private InferenceClassificationType inferenceClassification;
        private List<String> unsubscribeData;
        private String unsubscribeDataNextLink;
        private Boolean unsubscribeEnabled;
        private FollowupFlag flag;
        private Boolean canAccept;
        private String suggestedCalendarName;
        private CalendarSharingMessageAction sharingMessageAction;
        private List<CalendarSharingMessageAction> sharingMessageActions;
        private String sharingMessageActionsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder changeKey(String changeKey) {
            this.changeKey = changeKey;
            this.changedFields = changedFields.add("changeKey");
            return this;
        }

        public Builder categories(List<String> categories) {
            this.categories = categories;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder categories(String... categories) {
            return categories(Arrays.asList(categories));
        }

        public Builder categoriesNextLink(String categoriesNextLink) {
            this.categoriesNextLink = categoriesNextLink;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder receivedDateTime(OffsetDateTime receivedDateTime) {
            this.receivedDateTime = receivedDateTime;
            this.changedFields = changedFields.add("receivedDateTime");
            return this;
        }

        public Builder sentDateTime(OffsetDateTime sentDateTime) {
            this.sentDateTime = sentDateTime;
            this.changedFields = changedFields.add("sentDateTime");
            return this;
        }

        public Builder hasAttachments(Boolean hasAttachments) {
            this.hasAttachments = hasAttachments;
            this.changedFields = changedFields.add("hasAttachments");
            return this;
        }

        public Builder internetMessageId(String internetMessageId) {
            this.internetMessageId = internetMessageId;
            this.changedFields = changedFields.add("internetMessageId");
            return this;
        }

        public Builder internetMessageHeaders(List<InternetMessageHeader> internetMessageHeaders) {
            this.internetMessageHeaders = internetMessageHeaders;
            this.changedFields = changedFields.add("internetMessageHeaders");
            return this;
        }

        public Builder internetMessageHeaders(InternetMessageHeader... internetMessageHeaders) {
            return internetMessageHeaders(Arrays.asList(internetMessageHeaders));
        }

        public Builder internetMessageHeadersNextLink(String internetMessageHeadersNextLink) {
            this.internetMessageHeadersNextLink = internetMessageHeadersNextLink;
            this.changedFields = changedFields.add("internetMessageHeaders");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        public Builder body(ItemBody body) {
            this.body = body;
            this.changedFields = changedFields.add("body");
            return this;
        }

        public Builder bodyPreview(String bodyPreview) {
            this.bodyPreview = bodyPreview;
            this.changedFields = changedFields.add("bodyPreview");
            return this;
        }

        public Builder importance(Importance importance) {
            this.importance = importance;
            this.changedFields = changedFields.add("importance");
            return this;
        }

        public Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            this.changedFields = changedFields.add("parentFolderId");
            return this;
        }

        public Builder sender(Recipient sender) {
            this.sender = sender;
            this.changedFields = changedFields.add("sender");
            return this;
        }

        public Builder from(Recipient from) {
            this.from = from;
            this.changedFields = changedFields.add("from");
            return this;
        }

        public Builder toRecipients(List<Recipient> toRecipients) {
            this.toRecipients = toRecipients;
            this.changedFields = changedFields.add("toRecipients");
            return this;
        }

        public Builder toRecipients(Recipient... toRecipients) {
            return toRecipients(Arrays.asList(toRecipients));
        }

        public Builder toRecipientsNextLink(String toRecipientsNextLink) {
            this.toRecipientsNextLink = toRecipientsNextLink;
            this.changedFields = changedFields.add("toRecipients");
            return this;
        }

        public Builder ccRecipients(List<Recipient> ccRecipients) {
            this.ccRecipients = ccRecipients;
            this.changedFields = changedFields.add("ccRecipients");
            return this;
        }

        public Builder ccRecipients(Recipient... ccRecipients) {
            return ccRecipients(Arrays.asList(ccRecipients));
        }

        public Builder ccRecipientsNextLink(String ccRecipientsNextLink) {
            this.ccRecipientsNextLink = ccRecipientsNextLink;
            this.changedFields = changedFields.add("ccRecipients");
            return this;
        }

        public Builder bccRecipients(List<Recipient> bccRecipients) {
            this.bccRecipients = bccRecipients;
            this.changedFields = changedFields.add("bccRecipients");
            return this;
        }

        public Builder bccRecipients(Recipient... bccRecipients) {
            return bccRecipients(Arrays.asList(bccRecipients));
        }

        public Builder bccRecipientsNextLink(String bccRecipientsNextLink) {
            this.bccRecipientsNextLink = bccRecipientsNextLink;
            this.changedFields = changedFields.add("bccRecipients");
            return this;
        }

        public Builder replyTo(List<Recipient> replyTo) {
            this.replyTo = replyTo;
            this.changedFields = changedFields.add("replyTo");
            return this;
        }

        public Builder replyTo(Recipient... replyTo) {
            return replyTo(Arrays.asList(replyTo));
        }

        public Builder replyToNextLink(String replyToNextLink) {
            this.replyToNextLink = replyToNextLink;
            this.changedFields = changedFields.add("replyTo");
            return this;
        }

        public Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            this.changedFields = changedFields.add("conversationId");
            return this;
        }

        public Builder conversationIndex(byte[] conversationIndex) {
            this.conversationIndex = conversationIndex;
            this.changedFields = changedFields.add("conversationIndex");
            return this;
        }

        public Builder uniqueBody(ItemBody uniqueBody) {
            this.uniqueBody = uniqueBody;
            this.changedFields = changedFields.add("uniqueBody");
            return this;
        }

        public Builder isDeliveryReceiptRequested(Boolean isDeliveryReceiptRequested) {
            this.isDeliveryReceiptRequested = isDeliveryReceiptRequested;
            this.changedFields = changedFields.add("isDeliveryReceiptRequested");
            return this;
        }

        public Builder isReadReceiptRequested(Boolean isReadReceiptRequested) {
            this.isReadReceiptRequested = isReadReceiptRequested;
            this.changedFields = changedFields.add("isReadReceiptRequested");
            return this;
        }

        public Builder isRead(Boolean isRead) {
            this.isRead = isRead;
            this.changedFields = changedFields.add("isRead");
            return this;
        }

        public Builder isDraft(Boolean isDraft) {
            this.isDraft = isDraft;
            this.changedFields = changedFields.add("isDraft");
            return this;
        }

        public Builder webLink(String webLink) {
            this.webLink = webLink;
            this.changedFields = changedFields.add("webLink");
            return this;
        }

        public Builder mentionsPreview(MentionsPreview mentionsPreview) {
            this.mentionsPreview = mentionsPreview;
            this.changedFields = changedFields.add("mentionsPreview");
            return this;
        }

        public Builder inferenceClassification(InferenceClassificationType inferenceClassification) {
            this.inferenceClassification = inferenceClassification;
            this.changedFields = changedFields.add("inferenceClassification");
            return this;
        }

        public Builder unsubscribeData(List<String> unsubscribeData) {
            this.unsubscribeData = unsubscribeData;
            this.changedFields = changedFields.add("unsubscribeData");
            return this;
        }

        public Builder unsubscribeData(String... unsubscribeData) {
            return unsubscribeData(Arrays.asList(unsubscribeData));
        }

        public Builder unsubscribeDataNextLink(String unsubscribeDataNextLink) {
            this.unsubscribeDataNextLink = unsubscribeDataNextLink;
            this.changedFields = changedFields.add("unsubscribeData");
            return this;
        }

        public Builder unsubscribeEnabled(Boolean unsubscribeEnabled) {
            this.unsubscribeEnabled = unsubscribeEnabled;
            this.changedFields = changedFields.add("unsubscribeEnabled");
            return this;
        }

        public Builder flag(FollowupFlag flag) {
            this.flag = flag;
            this.changedFields = changedFields.add("flag");
            return this;
        }

        public Builder canAccept(Boolean canAccept) {
            this.canAccept = canAccept;
            this.changedFields = changedFields.add("canAccept");
            return this;
        }

        public Builder suggestedCalendarName(String suggestedCalendarName) {
            this.suggestedCalendarName = suggestedCalendarName;
            this.changedFields = changedFields.add("suggestedCalendarName");
            return this;
        }

        public Builder sharingMessageAction(CalendarSharingMessageAction sharingMessageAction) {
            this.sharingMessageAction = sharingMessageAction;
            this.changedFields = changedFields.add("sharingMessageAction");
            return this;
        }

        public Builder sharingMessageActions(List<CalendarSharingMessageAction> sharingMessageActions) {
            this.sharingMessageActions = sharingMessageActions;
            this.changedFields = changedFields.add("sharingMessageActions");
            return this;
        }

        public Builder sharingMessageActions(CalendarSharingMessageAction... sharingMessageActions) {
            return sharingMessageActions(Arrays.asList(sharingMessageActions));
        }

        public Builder sharingMessageActionsNextLink(String sharingMessageActionsNextLink) {
            this.sharingMessageActionsNextLink = sharingMessageActionsNextLink;
            this.changedFields = changedFields.add("sharingMessageActions");
            return this;
        }

        public CalendarSharingMessage build() {
            CalendarSharingMessage _x = new CalendarSharingMessage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.calendarSharingMessage";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.changeKey = changeKey;
            _x.categories = categories;
            _x.categoriesNextLink = categoriesNextLink;
            _x.receivedDateTime = receivedDateTime;
            _x.sentDateTime = sentDateTime;
            _x.hasAttachments = hasAttachments;
            _x.internetMessageId = internetMessageId;
            _x.internetMessageHeaders = internetMessageHeaders;
            _x.internetMessageHeadersNextLink = internetMessageHeadersNextLink;
            _x.subject = subject;
            _x.body = body;
            _x.bodyPreview = bodyPreview;
            _x.importance = importance;
            _x.parentFolderId = parentFolderId;
            _x.sender = sender;
            _x.from = from;
            _x.toRecipients = toRecipients;
            _x.toRecipientsNextLink = toRecipientsNextLink;
            _x.ccRecipients = ccRecipients;
            _x.ccRecipientsNextLink = ccRecipientsNextLink;
            _x.bccRecipients = bccRecipients;
            _x.bccRecipientsNextLink = bccRecipientsNextLink;
            _x.replyTo = replyTo;
            _x.replyToNextLink = replyToNextLink;
            _x.conversationId = conversationId;
            _x.conversationIndex = conversationIndex;
            _x.uniqueBody = uniqueBody;
            _x.isDeliveryReceiptRequested = isDeliveryReceiptRequested;
            _x.isReadReceiptRequested = isReadReceiptRequested;
            _x.isRead = isRead;
            _x.isDraft = isDraft;
            _x.webLink = webLink;
            _x.mentionsPreview = mentionsPreview;
            _x.inferenceClassification = inferenceClassification;
            _x.unsubscribeData = unsubscribeData;
            _x.unsubscribeDataNextLink = unsubscribeDataNextLink;
            _x.unsubscribeEnabled = unsubscribeEnabled;
            _x.flag = flag;
            _x.canAccept = canAccept;
            _x.suggestedCalendarName = suggestedCalendarName;
            _x.sharingMessageAction = sharingMessageAction;
            _x.sharingMessageActions = sharingMessageActions;
            _x.sharingMessageActionsNextLink = sharingMessageActionsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="canAccept")
    @JsonIgnore
    public Optional<Boolean> getCanAccept() {
        return Optional.ofNullable(canAccept);
    }

    public CalendarSharingMessage withCanAccept(Boolean canAccept) {
        CalendarSharingMessage _x = _copy();
        _x.changedFields = changedFields.add("canAccept");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendarSharingMessage");
        _x.canAccept = canAccept;
        return _x;
    }

    @Property(name="suggestedCalendarName")
    @JsonIgnore
    public Optional<String> getSuggestedCalendarName() {
        return Optional.ofNullable(suggestedCalendarName);
    }

    public CalendarSharingMessage withSuggestedCalendarName(String suggestedCalendarName) {
        CalendarSharingMessage _x = _copy();
        _x.changedFields = changedFields.add("suggestedCalendarName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendarSharingMessage");
        _x.suggestedCalendarName = suggestedCalendarName;
        return _x;
    }

    @Property(name="sharingMessageAction")
    @JsonIgnore
    public Optional<CalendarSharingMessageAction> getSharingMessageAction() {
        return Optional.ofNullable(sharingMessageAction);
    }

    public CalendarSharingMessage withSharingMessageAction(CalendarSharingMessageAction sharingMessageAction) {
        CalendarSharingMessage _x = _copy();
        _x.changedFields = changedFields.add("sharingMessageAction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendarSharingMessage");
        _x.sharingMessageAction = sharingMessageAction;
        return _x;
    }

    @Property(name="sharingMessageActions")
    @JsonIgnore
    public CollectionPage<CalendarSharingMessageAction> getSharingMessageActions() {
        return new CollectionPage<CalendarSharingMessageAction>(contextPath, CalendarSharingMessageAction.class, sharingMessageActions, Optional.ofNullable(sharingMessageActionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="sharingMessageActions")
    @JsonIgnore
    public CollectionPage<CalendarSharingMessageAction> getSharingMessageActions(HttpRequestOptions options) {
        return new CollectionPage<CalendarSharingMessageAction>(contextPath, CalendarSharingMessageAction.class, sharingMessageActions, Optional.ofNullable(sharingMessageActionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CalendarSharingMessage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CalendarSharingMessage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CalendarSharingMessage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CalendarSharingMessage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CalendarSharingMessage _copy() {
        CalendarSharingMessage _x = new CalendarSharingMessage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.changeKey = changeKey;
        _x.categories = categories;
        _x.receivedDateTime = receivedDateTime;
        _x.sentDateTime = sentDateTime;
        _x.hasAttachments = hasAttachments;
        _x.internetMessageId = internetMessageId;
        _x.internetMessageHeaders = internetMessageHeaders;
        _x.subject = subject;
        _x.body = body;
        _x.bodyPreview = bodyPreview;
        _x.importance = importance;
        _x.parentFolderId = parentFolderId;
        _x.sender = sender;
        _x.from = from;
        _x.toRecipients = toRecipients;
        _x.ccRecipients = ccRecipients;
        _x.bccRecipients = bccRecipients;
        _x.replyTo = replyTo;
        _x.conversationId = conversationId;
        _x.conversationIndex = conversationIndex;
        _x.uniqueBody = uniqueBody;
        _x.isDeliveryReceiptRequested = isDeliveryReceiptRequested;
        _x.isReadReceiptRequested = isReadReceiptRequested;
        _x.isRead = isRead;
        _x.isDraft = isDraft;
        _x.webLink = webLink;
        _x.mentionsPreview = mentionsPreview;
        _x.inferenceClassification = inferenceClassification;
        _x.unsubscribeData = unsubscribeData;
        _x.unsubscribeEnabled = unsubscribeEnabled;
        _x.flag = flag;
        _x.canAccept = canAccept;
        _x.suggestedCalendarName = suggestedCalendarName;
        _x.sharingMessageAction = sharingMessageAction;
        _x.sharingMessageActions = sharingMessageActions;
        return _x;
    }

    @Action(name = "accept")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Calendar> accept() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<Calendar>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.accept"), Calendar.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CalendarSharingMessage[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("changeKey=");
        b.append(this.changeKey);
        b.append(", ");
        b.append("categories=");
        b.append(this.categories);
        b.append(", ");
        b.append("receivedDateTime=");
        b.append(this.receivedDateTime);
        b.append(", ");
        b.append("sentDateTime=");
        b.append(this.sentDateTime);
        b.append(", ");
        b.append("hasAttachments=");
        b.append(this.hasAttachments);
        b.append(", ");
        b.append("internetMessageId=");
        b.append(this.internetMessageId);
        b.append(", ");
        b.append("internetMessageHeaders=");
        b.append(this.internetMessageHeaders);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("body=");
        b.append(this.body);
        b.append(", ");
        b.append("bodyPreview=");
        b.append(this.bodyPreview);
        b.append(", ");
        b.append("importance=");
        b.append(this.importance);
        b.append(", ");
        b.append("parentFolderId=");
        b.append(this.parentFolderId);
        b.append(", ");
        b.append("sender=");
        b.append(this.sender);
        b.append(", ");
        b.append("from=");
        b.append(this.from);
        b.append(", ");
        b.append("toRecipients=");
        b.append(this.toRecipients);
        b.append(", ");
        b.append("ccRecipients=");
        b.append(this.ccRecipients);
        b.append(", ");
        b.append("bccRecipients=");
        b.append(this.bccRecipients);
        b.append(", ");
        b.append("replyTo=");
        b.append(this.replyTo);
        b.append(", ");
        b.append("conversationId=");
        b.append(this.conversationId);
        b.append(", ");
        b.append("conversationIndex=");
        b.append(this.conversationIndex);
        b.append(", ");
        b.append("uniqueBody=");
        b.append(this.uniqueBody);
        b.append(", ");
        b.append("isDeliveryReceiptRequested=");
        b.append(this.isDeliveryReceiptRequested);
        b.append(", ");
        b.append("isReadReceiptRequested=");
        b.append(this.isReadReceiptRequested);
        b.append(", ");
        b.append("isRead=");
        b.append(this.isRead);
        b.append(", ");
        b.append("isDraft=");
        b.append(this.isDraft);
        b.append(", ");
        b.append("webLink=");
        b.append(this.webLink);
        b.append(", ");
        b.append("mentionsPreview=");
        b.append(this.mentionsPreview);
        b.append(", ");
        b.append("inferenceClassification=");
        b.append(this.inferenceClassification);
        b.append(", ");
        b.append("unsubscribeData=");
        b.append(this.unsubscribeData);
        b.append(", ");
        b.append("unsubscribeEnabled=");
        b.append(this.unsubscribeEnabled);
        b.append(", ");
        b.append("flag=");
        b.append(this.flag);
        b.append(", ");
        b.append("canAccept=");
        b.append(this.canAccept);
        b.append(", ");
        b.append("suggestedCalendarName=");
        b.append(this.suggestedCalendarName);
        b.append(", ");
        b.append("sharingMessageAction=");
        b.append(this.sharingMessageAction);
        b.append(", ");
        b.append("sharingMessageActions=");
        b.append(this.sharingMessageActions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
