package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.EmailAddress;
import odata.msgraph.client.beta.enums.CalendarRoleType;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "emailAddress", 
    "isRemovable", 
    "isInsideOrganization", 
    "role", 
    "allowedRoles"})
@JsonInclude(Include.NON_NULL)
public class CalendarPermission extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.calendarPermission";
    }

    @JsonProperty("emailAddress")
    protected EmailAddress emailAddress;

    @JsonProperty("isRemovable")
    protected Boolean isRemovable;

    @JsonProperty("isInsideOrganization")
    protected Boolean isInsideOrganization;

    @JsonProperty("role")
    protected CalendarRoleType role;

    @JsonProperty("allowedRoles")
    protected List<CalendarRoleType> allowedRoles;

    @JsonProperty("allowedRoles@nextLink")
    protected String allowedRolesNextLink;

    protected CalendarPermission() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCalendarPermission() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private EmailAddress emailAddress;
        private Boolean isRemovable;
        private Boolean isInsideOrganization;
        private CalendarRoleType role;
        private List<CalendarRoleType> allowedRoles;
        private String allowedRolesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder emailAddress(EmailAddress emailAddress) {
            this.emailAddress = emailAddress;
            this.changedFields = changedFields.add("emailAddress");
            return this;
        }

        public Builder isRemovable(Boolean isRemovable) {
            this.isRemovable = isRemovable;
            this.changedFields = changedFields.add("isRemovable");
            return this;
        }

        public Builder isInsideOrganization(Boolean isInsideOrganization) {
            this.isInsideOrganization = isInsideOrganization;
            this.changedFields = changedFields.add("isInsideOrganization");
            return this;
        }

        public Builder role(CalendarRoleType role) {
            this.role = role;
            this.changedFields = changedFields.add("role");
            return this;
        }

        public Builder allowedRoles(List<CalendarRoleType> allowedRoles) {
            this.allowedRoles = allowedRoles;
            this.changedFields = changedFields.add("allowedRoles");
            return this;
        }

        public Builder allowedRoles(CalendarRoleType... allowedRoles) {
            return allowedRoles(Arrays.asList(allowedRoles));
        }

        public Builder allowedRolesNextLink(String allowedRolesNextLink) {
            this.allowedRolesNextLink = allowedRolesNextLink;
            this.changedFields = changedFields.add("allowedRoles");
            return this;
        }

        public CalendarPermission build() {
            CalendarPermission _x = new CalendarPermission();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.calendarPermission";
            _x.id = id;
            _x.emailAddress = emailAddress;
            _x.isRemovable = isRemovable;
            _x.isInsideOrganization = isInsideOrganization;
            _x.role = role;
            _x.allowedRoles = allowedRoles;
            _x.allowedRolesNextLink = allowedRolesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="emailAddress")
    @JsonIgnore
    public Optional<EmailAddress> getEmailAddress() {
        return Optional.ofNullable(emailAddress);
    }

    public CalendarPermission withEmailAddress(EmailAddress emailAddress) {
        CalendarPermission _x = _copy();
        _x.changedFields = changedFields.add("emailAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendarPermission");
        _x.emailAddress = emailAddress;
        return _x;
    }

    @Property(name="isRemovable")
    @JsonIgnore
    public Optional<Boolean> getIsRemovable() {
        return Optional.ofNullable(isRemovable);
    }

    public CalendarPermission withIsRemovable(Boolean isRemovable) {
        CalendarPermission _x = _copy();
        _x.changedFields = changedFields.add("isRemovable");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendarPermission");
        _x.isRemovable = isRemovable;
        return _x;
    }

    @Property(name="isInsideOrganization")
    @JsonIgnore
    public Optional<Boolean> getIsInsideOrganization() {
        return Optional.ofNullable(isInsideOrganization);
    }

    public CalendarPermission withIsInsideOrganization(Boolean isInsideOrganization) {
        CalendarPermission _x = _copy();
        _x.changedFields = changedFields.add("isInsideOrganization");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendarPermission");
        _x.isInsideOrganization = isInsideOrganization;
        return _x;
    }

    @Property(name="role")
    @JsonIgnore
    public Optional<CalendarRoleType> getRole() {
        return Optional.ofNullable(role);
    }

    public CalendarPermission withRole(CalendarRoleType role) {
        CalendarPermission _x = _copy();
        _x.changedFields = changedFields.add("role");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendarPermission");
        _x.role = role;
        return _x;
    }

    @Property(name="allowedRoles")
    @JsonIgnore
    public CollectionPage<CalendarRoleType> getAllowedRoles() {
        return new CollectionPage<CalendarRoleType>(contextPath, CalendarRoleType.class, allowedRoles, Optional.ofNullable(allowedRolesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="allowedRoles")
    @JsonIgnore
    public CollectionPage<CalendarRoleType> getAllowedRoles(HttpRequestOptions options) {
        return new CollectionPage<CalendarRoleType>(contextPath, CalendarRoleType.class, allowedRoles, Optional.ofNullable(allowedRolesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CalendarPermission patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CalendarPermission _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CalendarPermission put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CalendarPermission _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CalendarPermission _copy() {
        CalendarPermission _x = new CalendarPermission();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.emailAddress = emailAddress;
        _x.isRemovable = isRemovable;
        _x.isInsideOrganization = isInsideOrganization;
        _x.role = role;
        _x.allowedRoles = allowedRoles;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CalendarPermission[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("emailAddress=");
        b.append(this.emailAddress);
        b.append(", ");
        b.append("isRemovable=");
        b.append(this.isRemovable);
        b.append(", ");
        b.append("isInsideOrganization=");
        b.append(this.isInsideOrganization);
        b.append(", ");
        b.append("role=");
        b.append(this.role);
        b.append(", ");
        b.append("allowedRoles=");
        b.append(this.allowedRoles);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
