package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.CalendarCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "classId", 
    "changeKey"})
@JsonInclude(Include.NON_NULL)
public class CalendarGroup extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.calendarGroup";
    }

    @JsonProperty("name")
    protected String name;

    @JsonProperty("classId")
    protected String classId;

    @JsonProperty("changeKey")
    protected String changeKey;

    protected CalendarGroup() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCalendarGroup() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String name;
        private String classId;
        private String changeKey;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder classId(String classId) {
            this.classId = classId;
            this.changedFields = changedFields.add("classId");
            return this;
        }

        public Builder changeKey(String changeKey) {
            this.changeKey = changeKey;
            this.changedFields = changedFields.add("changeKey");
            return this;
        }

        public CalendarGroup build() {
            CalendarGroup _x = new CalendarGroup();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.calendarGroup";
            _x.id = id;
            _x.name = name;
            _x.classId = classId;
            _x.changeKey = changeKey;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public CalendarGroup withName(String name) {
        CalendarGroup _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendarGroup");
        _x.name = name;
        return _x;
    }

    @Property(name="classId")
    @JsonIgnore
    public Optional<String> getClassId() {
        return Optional.ofNullable(classId);
    }

    public CalendarGroup withClassId(String classId) {
        CalendarGroup _x = _copy();
        _x.changedFields = changedFields.add("classId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendarGroup");
        _x.classId = classId;
        return _x;
    }

    @Property(name="changeKey")
    @JsonIgnore
    public Optional<String> getChangeKey() {
        return Optional.ofNullable(changeKey);
    }

    public CalendarGroup withChangeKey(String changeKey) {
        CalendarGroup _x = _copy();
        _x.changedFields = changedFields.add("changeKey");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendarGroup");
        _x.changeKey = changeKey;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * 
     * @return navigational property calendars
     */
    @NavigationProperty(name="calendars")
    @JsonIgnore
    public CalendarCollectionRequest getCalendars() {
        return new CalendarCollectionRequest(
                        contextPath.addSegment("calendars"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CalendarGroup patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CalendarGroup _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CalendarGroup put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CalendarGroup _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CalendarGroup _copy() {
        CalendarGroup _x = new CalendarGroup();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.name = name;
        _x.classId = classId;
        _x.changeKey = changeKey;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CalendarGroup[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("classId=");
        b.append(this.classId);
        b.append(", ");
        b.append("changeKey=");
        b.append(this.changeKey);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
