package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DateTimeTimeZone;
import odata.msgraph.client.beta.complex.EmailAddress;
import odata.msgraph.client.beta.complex.ScheduleInformation;
import odata.msgraph.client.beta.entity.collection.request.CalendarPermissionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.enums.CalendarColor;
import odata.msgraph.client.beta.enums.CalendarRoleType;
import odata.msgraph.client.beta.enums.OnlineMeetingProviderType;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "color", 
    "hexColor", 
    "isDefaultCalendar", 
    "changeKey", 
    "canShare", 
    "canViewPrivateItems", 
    "isShared", 
    "isSharedWithMe", 
    "canEdit", 
    "owner", 
    "calendarGroupId", 
    "allowedOnlineMeetingProviders", 
    "defaultOnlineMeetingProvider", 
    "isTallyingResponses", 
    "isRemovable"})
@JsonInclude(Include.NON_NULL)
public class Calendar extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.calendar";
    }

    @JsonProperty("name")
    protected String name;

    @JsonProperty("color")
    protected CalendarColor color;

    @JsonProperty("hexColor")
    protected String hexColor;

    @JsonProperty("isDefaultCalendar")
    protected Boolean isDefaultCalendar;

    @JsonProperty("changeKey")
    protected String changeKey;

    @JsonProperty("canShare")
    protected Boolean canShare;

    @JsonProperty("canViewPrivateItems")
    protected Boolean canViewPrivateItems;

    @JsonProperty("isShared")
    protected Boolean isShared;

    @JsonProperty("isSharedWithMe")
    protected Boolean isSharedWithMe;

    @JsonProperty("canEdit")
    protected Boolean canEdit;

    @JsonProperty("owner")
    protected EmailAddress owner;

    @JsonProperty("calendarGroupId")
    protected String calendarGroupId;

    @JsonProperty("allowedOnlineMeetingProviders")
    protected List<OnlineMeetingProviderType> allowedOnlineMeetingProviders;

    @JsonProperty("allowedOnlineMeetingProviders@nextLink")
    protected String allowedOnlineMeetingProvidersNextLink;

    @JsonProperty("defaultOnlineMeetingProvider")
    protected OnlineMeetingProviderType defaultOnlineMeetingProvider;

    @JsonProperty("isTallyingResponses")
    protected Boolean isTallyingResponses;

    @JsonProperty("isRemovable")
    protected Boolean isRemovable;

    protected Calendar() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCalendar() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String name;
        private CalendarColor color;
        private String hexColor;
        private Boolean isDefaultCalendar;
        private String changeKey;
        private Boolean canShare;
        private Boolean canViewPrivateItems;
        private Boolean isShared;
        private Boolean isSharedWithMe;
        private Boolean canEdit;
        private EmailAddress owner;
        private String calendarGroupId;
        private List<OnlineMeetingProviderType> allowedOnlineMeetingProviders;
        private String allowedOnlineMeetingProvidersNextLink;
        private OnlineMeetingProviderType defaultOnlineMeetingProvider;
        private Boolean isTallyingResponses;
        private Boolean isRemovable;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder color(CalendarColor color) {
            this.color = color;
            this.changedFields = changedFields.add("color");
            return this;
        }

        public Builder hexColor(String hexColor) {
            this.hexColor = hexColor;
            this.changedFields = changedFields.add("hexColor");
            return this;
        }

        public Builder isDefaultCalendar(Boolean isDefaultCalendar) {
            this.isDefaultCalendar = isDefaultCalendar;
            this.changedFields = changedFields.add("isDefaultCalendar");
            return this;
        }

        public Builder changeKey(String changeKey) {
            this.changeKey = changeKey;
            this.changedFields = changedFields.add("changeKey");
            return this;
        }

        public Builder canShare(Boolean canShare) {
            this.canShare = canShare;
            this.changedFields = changedFields.add("canShare");
            return this;
        }

        public Builder canViewPrivateItems(Boolean canViewPrivateItems) {
            this.canViewPrivateItems = canViewPrivateItems;
            this.changedFields = changedFields.add("canViewPrivateItems");
            return this;
        }

        public Builder isShared(Boolean isShared) {
            this.isShared = isShared;
            this.changedFields = changedFields.add("isShared");
            return this;
        }

        public Builder isSharedWithMe(Boolean isSharedWithMe) {
            this.isSharedWithMe = isSharedWithMe;
            this.changedFields = changedFields.add("isSharedWithMe");
            return this;
        }

        public Builder canEdit(Boolean canEdit) {
            this.canEdit = canEdit;
            this.changedFields = changedFields.add("canEdit");
            return this;
        }

        public Builder owner(EmailAddress owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder calendarGroupId(String calendarGroupId) {
            this.calendarGroupId = calendarGroupId;
            this.changedFields = changedFields.add("calendarGroupId");
            return this;
        }

        public Builder allowedOnlineMeetingProviders(List<OnlineMeetingProviderType> allowedOnlineMeetingProviders) {
            this.allowedOnlineMeetingProviders = allowedOnlineMeetingProviders;
            this.changedFields = changedFields.add("allowedOnlineMeetingProviders");
            return this;
        }

        public Builder allowedOnlineMeetingProviders(OnlineMeetingProviderType... allowedOnlineMeetingProviders) {
            return allowedOnlineMeetingProviders(Arrays.asList(allowedOnlineMeetingProviders));
        }

        public Builder allowedOnlineMeetingProvidersNextLink(String allowedOnlineMeetingProvidersNextLink) {
            this.allowedOnlineMeetingProvidersNextLink = allowedOnlineMeetingProvidersNextLink;
            this.changedFields = changedFields.add("allowedOnlineMeetingProviders");
            return this;
        }

        public Builder defaultOnlineMeetingProvider(OnlineMeetingProviderType defaultOnlineMeetingProvider) {
            this.defaultOnlineMeetingProvider = defaultOnlineMeetingProvider;
            this.changedFields = changedFields.add("defaultOnlineMeetingProvider");
            return this;
        }

        public Builder isTallyingResponses(Boolean isTallyingResponses) {
            this.isTallyingResponses = isTallyingResponses;
            this.changedFields = changedFields.add("isTallyingResponses");
            return this;
        }

        public Builder isRemovable(Boolean isRemovable) {
            this.isRemovable = isRemovable;
            this.changedFields = changedFields.add("isRemovable");
            return this;
        }

        public Calendar build() {
            Calendar _x = new Calendar();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.calendar";
            _x.id = id;
            _x.name = name;
            _x.color = color;
            _x.hexColor = hexColor;
            _x.isDefaultCalendar = isDefaultCalendar;
            _x.changeKey = changeKey;
            _x.canShare = canShare;
            _x.canViewPrivateItems = canViewPrivateItems;
            _x.isShared = isShared;
            _x.isSharedWithMe = isSharedWithMe;
            _x.canEdit = canEdit;
            _x.owner = owner;
            _x.calendarGroupId = calendarGroupId;
            _x.allowedOnlineMeetingProviders = allowedOnlineMeetingProviders;
            _x.allowedOnlineMeetingProvidersNextLink = allowedOnlineMeetingProvidersNextLink;
            _x.defaultOnlineMeetingProvider = defaultOnlineMeetingProvider;
            _x.isTallyingResponses = isTallyingResponses;
            _x.isRemovable = isRemovable;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Calendar withName(String name) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendar");
        _x.name = name;
        return _x;
    }

    @Property(name="color")
    @JsonIgnore
    public Optional<CalendarColor> getColor() {
        return Optional.ofNullable(color);
    }

    public Calendar withColor(CalendarColor color) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("color");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendar");
        _x.color = color;
        return _x;
    }

    @Property(name="hexColor")
    @JsonIgnore
    public Optional<String> getHexColor() {
        return Optional.ofNullable(hexColor);
    }

    public Calendar withHexColor(String hexColor) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("hexColor");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendar");
        _x.hexColor = hexColor;
        return _x;
    }

    @Property(name="isDefaultCalendar")
    @JsonIgnore
    public Optional<Boolean> getIsDefaultCalendar() {
        return Optional.ofNullable(isDefaultCalendar);
    }

    public Calendar withIsDefaultCalendar(Boolean isDefaultCalendar) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("isDefaultCalendar");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendar");
        _x.isDefaultCalendar = isDefaultCalendar;
        return _x;
    }

    @Property(name="changeKey")
    @JsonIgnore
    public Optional<String> getChangeKey() {
        return Optional.ofNullable(changeKey);
    }

    public Calendar withChangeKey(String changeKey) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("changeKey");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendar");
        _x.changeKey = changeKey;
        return _x;
    }

    @Property(name="canShare")
    @JsonIgnore
    public Optional<Boolean> getCanShare() {
        return Optional.ofNullable(canShare);
    }

    public Calendar withCanShare(Boolean canShare) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("canShare");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendar");
        _x.canShare = canShare;
        return _x;
    }

    @Property(name="canViewPrivateItems")
    @JsonIgnore
    public Optional<Boolean> getCanViewPrivateItems() {
        return Optional.ofNullable(canViewPrivateItems);
    }

    public Calendar withCanViewPrivateItems(Boolean canViewPrivateItems) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("canViewPrivateItems");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendar");
        _x.canViewPrivateItems = canViewPrivateItems;
        return _x;
    }

    @Property(name="isShared")
    @JsonIgnore
    public Optional<Boolean> getIsShared() {
        return Optional.ofNullable(isShared);
    }

    public Calendar withIsShared(Boolean isShared) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("isShared");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendar");
        _x.isShared = isShared;
        return _x;
    }

    @Property(name="isSharedWithMe")
    @JsonIgnore
    public Optional<Boolean> getIsSharedWithMe() {
        return Optional.ofNullable(isSharedWithMe);
    }

    public Calendar withIsSharedWithMe(Boolean isSharedWithMe) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("isSharedWithMe");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendar");
        _x.isSharedWithMe = isSharedWithMe;
        return _x;
    }

    @Property(name="canEdit")
    @JsonIgnore
    public Optional<Boolean> getCanEdit() {
        return Optional.ofNullable(canEdit);
    }

    public Calendar withCanEdit(Boolean canEdit) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("canEdit");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendar");
        _x.canEdit = canEdit;
        return _x;
    }

    @Property(name="owner")
    @JsonIgnore
    public Optional<EmailAddress> getOwner() {
        return Optional.ofNullable(owner);
    }

    public Calendar withOwner(EmailAddress owner) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("owner");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendar");
        _x.owner = owner;
        return _x;
    }

    @Property(name="calendarGroupId")
    @JsonIgnore
    public Optional<String> getCalendarGroupId() {
        return Optional.ofNullable(calendarGroupId);
    }

    public Calendar withCalendarGroupId(String calendarGroupId) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("calendarGroupId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendar");
        _x.calendarGroupId = calendarGroupId;
        return _x;
    }

    @Property(name="allowedOnlineMeetingProviders")
    @JsonIgnore
    public CollectionPage<OnlineMeetingProviderType> getAllowedOnlineMeetingProviders() {
        return new CollectionPage<OnlineMeetingProviderType>(contextPath, OnlineMeetingProviderType.class, allowedOnlineMeetingProviders, Optional.ofNullable(allowedOnlineMeetingProvidersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="allowedOnlineMeetingProviders")
    @JsonIgnore
    public CollectionPage<OnlineMeetingProviderType> getAllowedOnlineMeetingProviders(HttpRequestOptions options) {
        return new CollectionPage<OnlineMeetingProviderType>(contextPath, OnlineMeetingProviderType.class, allowedOnlineMeetingProviders, Optional.ofNullable(allowedOnlineMeetingProvidersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="defaultOnlineMeetingProvider")
    @JsonIgnore
    public Optional<OnlineMeetingProviderType> getDefaultOnlineMeetingProvider() {
        return Optional.ofNullable(defaultOnlineMeetingProvider);
    }

    public Calendar withDefaultOnlineMeetingProvider(OnlineMeetingProviderType defaultOnlineMeetingProvider) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("defaultOnlineMeetingProvider");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendar");
        _x.defaultOnlineMeetingProvider = defaultOnlineMeetingProvider;
        return _x;
    }

    @Property(name="isTallyingResponses")
    @JsonIgnore
    public Optional<Boolean> getIsTallyingResponses() {
        return Optional.ofNullable(isTallyingResponses);
    }

    public Calendar withIsTallyingResponses(Boolean isTallyingResponses) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("isTallyingResponses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendar");
        _x.isTallyingResponses = isTallyingResponses;
        return _x;
    }

    @Property(name="isRemovable")
    @JsonIgnore
    public Optional<Boolean> getIsRemovable() {
        return Optional.ofNullable(isRemovable);
    }

    public Calendar withIsRemovable(Boolean isRemovable) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("isRemovable");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendar");
        _x.isRemovable = isRemovable;
        return _x;
    }

    @NavigationProperty(name="singleValueExtendedProperties")
    @JsonIgnore
    public SingleValueLegacyExtendedPropertyCollectionRequest getSingleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"));
    }

    @NavigationProperty(name="multiValueExtendedProperties")
    @JsonIgnore
    public MultiValueLegacyExtendedPropertyCollectionRequest getMultiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property calendarPermissions
     */
    @NavigationProperty(name="calendarPermissions")
    @JsonIgnore
    public CalendarPermissionCollectionRequest getCalendarPermissions() {
        return new CalendarPermissionCollectionRequest(
                        contextPath.addSegment("calendarPermissions"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * 
     * @return navigational property events
     */
    @NavigationProperty(name="events")
    @JsonIgnore
    public EventCollectionRequest getEvents() {
        return new EventCollectionRequest(
                        contextPath.addSegment("events"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * 
     * @return navigational property calendarView
     */
    @NavigationProperty(name="calendarView")
    @JsonIgnore
    public EventCollectionRequest getCalendarView() {
        return new EventCollectionRequest(
                        contextPath.addSegment("calendarView"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Calendar patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Calendar _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Calendar put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Calendar _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Calendar _copy() {
        Calendar _x = new Calendar();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.name = name;
        _x.color = color;
        _x.hexColor = hexColor;
        _x.isDefaultCalendar = isDefaultCalendar;
        _x.changeKey = changeKey;
        _x.canShare = canShare;
        _x.canViewPrivateItems = canViewPrivateItems;
        _x.isShared = isShared;
        _x.isSharedWithMe = isSharedWithMe;
        _x.canEdit = canEdit;
        _x.owner = owner;
        _x.calendarGroupId = calendarGroupId;
        _x.allowedOnlineMeetingProviders = allowedOnlineMeetingProviders;
        _x.defaultOnlineMeetingProvider = defaultOnlineMeetingProvider;
        _x.isTallyingResponses = isTallyingResponses;
        _x.isRemovable = isRemovable;
        return _x;
    }

    @Action(name = "getSchedule")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ScheduleInformation> getSchedule(List<String> schedules, DateTimeTimeZone endTime, DateTimeTimeZone startTime, Integer availabilityViewInterval) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Schedules", "Collection(Edm.String)", Checks.checkIsAscii(schedules))
            .put("EndTime", "microsoft.graph.dateTimeTimeZone", endTime)
            .put("StartTime", "microsoft.graph.dateTimeTimeZone", startTime)
            .put("AvailabilityViewInterval", "Edm.Int32", availabilityViewInterval)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSchedule"), ScheduleInformation.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "allowedCalendarSharingRoles")
    @JsonIgnore
    public CollectionPageNonEntityRequest<CalendarRoleType> allowedCalendarSharingRoles(String user) {
        Preconditions.checkNotNull(user, "user cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("User", "Edm.String", Checks.checkIsAscii(user))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.allowedCalendarSharingRoles"), CalendarRoleType.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Calendar[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("color=");
        b.append(this.color);
        b.append(", ");
        b.append("hexColor=");
        b.append(this.hexColor);
        b.append(", ");
        b.append("isDefaultCalendar=");
        b.append(this.isDefaultCalendar);
        b.append(", ");
        b.append("changeKey=");
        b.append(this.changeKey);
        b.append(", ");
        b.append("canShare=");
        b.append(this.canShare);
        b.append(", ");
        b.append("canViewPrivateItems=");
        b.append(this.canViewPrivateItems);
        b.append(", ");
        b.append("isShared=");
        b.append(this.isShared);
        b.append(", ");
        b.append("isSharedWithMe=");
        b.append(this.isSharedWithMe);
        b.append(", ");
        b.append("canEdit=");
        b.append(this.canEdit);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("calendarGroupId=");
        b.append(this.calendarGroupId);
        b.append(", ");
        b.append("allowedOnlineMeetingProviders=");
        b.append(this.allowedOnlineMeetingProviders);
        b.append(", ");
        b.append("defaultOnlineMeetingProvider=");
        b.append(this.defaultOnlineMeetingProvider);
        b.append(", ");
        b.append("isTallyingResponses=");
        b.append(this.isTallyingResponses);
        b.append(", ");
        b.append("isRemovable=");
        b.append(this.isRemovable);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
