package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.BookingReminder;
import odata.msgraph.client.beta.complex.BookingSchedulingPolicy;
import odata.msgraph.client.beta.complex.Location;
import odata.msgraph.client.beta.enums.BookingPriceType;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Represents a particular service offered by a booking business.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "defaultDuration", 
    "defaultLocation", 
    "defaultPrice", 
    "defaultPriceType", 
    "defaultReminders", 
    "description", 
    "isHiddenFromCustomers", 
    "notes", 
    "preBuffer", 
    "postBuffer", 
    "schedulingPolicy", 
    "staffMemberIds"})
@JsonInclude(Include.NON_NULL)
public class BookingService extends BookingNamedEntity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bookingService";
    }

    @JsonProperty("defaultDuration")
    protected Duration defaultDuration;

    @JsonProperty("defaultLocation")
    protected Location defaultLocation;

    @JsonProperty("defaultPrice")
    protected Double defaultPrice;

    @JsonProperty("defaultPriceType")
    protected BookingPriceType defaultPriceType;

    @JsonProperty("defaultReminders")
    protected List<BookingReminder> defaultReminders;

    @JsonProperty("defaultReminders@nextLink")
    protected String defaultRemindersNextLink;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("isHiddenFromCustomers")
    protected Boolean isHiddenFromCustomers;

    @JsonProperty("notes")
    protected String notes;

    @JsonProperty("preBuffer")
    protected Duration preBuffer;

    @JsonProperty("postBuffer")
    protected Duration postBuffer;

    @JsonProperty("schedulingPolicy")
    protected BookingSchedulingPolicy schedulingPolicy;

    @JsonProperty("staffMemberIds")
    protected List<String> staffMemberIds;

    @JsonProperty("staffMemberIds@nextLink")
    protected String staffMemberIdsNextLink;

    protected BookingService() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderBookingService() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private Duration defaultDuration;
        private Location defaultLocation;
        private Double defaultPrice;
        private BookingPriceType defaultPriceType;
        private List<BookingReminder> defaultReminders;
        private String defaultRemindersNextLink;
        private String description;
        private Boolean isHiddenFromCustomers;
        private String notes;
        private Duration preBuffer;
        private Duration postBuffer;
        private BookingSchedulingPolicy schedulingPolicy;
        private List<String> staffMemberIds;
        private String staffMemberIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder defaultDuration(Duration defaultDuration) {
            this.defaultDuration = defaultDuration;
            this.changedFields = changedFields.add("defaultDuration");
            return this;
        }

        public Builder defaultLocation(Location defaultLocation) {
            this.defaultLocation = defaultLocation;
            this.changedFields = changedFields.add("defaultLocation");
            return this;
        }

        public Builder defaultPrice(Double defaultPrice) {
            this.defaultPrice = defaultPrice;
            this.changedFields = changedFields.add("defaultPrice");
            return this;
        }

        public Builder defaultPriceType(BookingPriceType defaultPriceType) {
            this.defaultPriceType = defaultPriceType;
            this.changedFields = changedFields.add("defaultPriceType");
            return this;
        }

        /**
         * <i>“The value of this property is only available when reading an individual booking
         * service by id.”</i>
         * 
         * @param defaultReminders
         *            value of {@code defaultReminders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultReminders(List<BookingReminder> defaultReminders) {
            this.defaultReminders = defaultReminders;
            this.changedFields = changedFields.add("defaultReminders");
            return this;
        }

        /**
         * <i>“The value of this property is only available when reading an individual booking
         * service by id.”</i>
         * 
         * @param defaultReminders
         *            value of {@code defaultReminders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultReminders(BookingReminder... defaultReminders) {
            return defaultReminders(Arrays.asList(defaultReminders));
        }

        /**
         * <i>“The value of this property is only available when reading an individual booking
         * service by id.”</i>
         * 
         * @param defaultRemindersNextLink
         *            value of {@code defaultReminders@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultRemindersNextLink(String defaultRemindersNextLink) {
            this.defaultRemindersNextLink = defaultRemindersNextLink;
            this.changedFields = changedFields.add("defaultReminders");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder isHiddenFromCustomers(Boolean isHiddenFromCustomers) {
            this.isHiddenFromCustomers = isHiddenFromCustomers;
            this.changedFields = changedFields.add("isHiddenFromCustomers");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder preBuffer(Duration preBuffer) {
            this.preBuffer = preBuffer;
            this.changedFields = changedFields.add("preBuffer");
            return this;
        }

        public Builder postBuffer(Duration postBuffer) {
            this.postBuffer = postBuffer;
            this.changedFields = changedFields.add("postBuffer");
            return this;
        }

        public Builder schedulingPolicy(BookingSchedulingPolicy schedulingPolicy) {
            this.schedulingPolicy = schedulingPolicy;
            this.changedFields = changedFields.add("schedulingPolicy");
            return this;
        }

        public Builder staffMemberIds(List<String> staffMemberIds) {
            this.staffMemberIds = staffMemberIds;
            this.changedFields = changedFields.add("staffMemberIds");
            return this;
        }

        public Builder staffMemberIds(String... staffMemberIds) {
            return staffMemberIds(Arrays.asList(staffMemberIds));
        }

        public Builder staffMemberIdsNextLink(String staffMemberIdsNextLink) {
            this.staffMemberIdsNextLink = staffMemberIdsNextLink;
            this.changedFields = changedFields.add("staffMemberIds");
            return this;
        }

        public BookingService build() {
            BookingService _x = new BookingService();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.bookingService";
            _x.id = id;
            _x.displayName = displayName;
            _x.defaultDuration = defaultDuration;
            _x.defaultLocation = defaultLocation;
            _x.defaultPrice = defaultPrice;
            _x.defaultPriceType = defaultPriceType;
            _x.defaultReminders = defaultReminders;
            _x.defaultRemindersNextLink = defaultRemindersNextLink;
            _x.description = description;
            _x.isHiddenFromCustomers = isHiddenFromCustomers;
            _x.notes = notes;
            _x.preBuffer = preBuffer;
            _x.postBuffer = postBuffer;
            _x.schedulingPolicy = schedulingPolicy;
            _x.staffMemberIds = staffMemberIds;
            _x.staffMemberIdsNextLink = staffMemberIdsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="defaultDuration")
    @JsonIgnore
    public Optional<Duration> getDefaultDuration() {
        return Optional.ofNullable(defaultDuration);
    }

    public BookingService withDefaultDuration(Duration defaultDuration) {
        BookingService _x = _copy();
        _x.changedFields = changedFields.add("defaultDuration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingService");
        _x.defaultDuration = defaultDuration;
        return _x;
    }

    @Property(name="defaultLocation")
    @JsonIgnore
    public Optional<Location> getDefaultLocation() {
        return Optional.ofNullable(defaultLocation);
    }

    public BookingService withDefaultLocation(Location defaultLocation) {
        BookingService _x = _copy();
        _x.changedFields = changedFields.add("defaultLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingService");
        _x.defaultLocation = defaultLocation;
        return _x;
    }

    @Property(name="defaultPrice")
    @JsonIgnore
    public Optional<Double> getDefaultPrice() {
        return Optional.ofNullable(defaultPrice);
    }

    public BookingService withDefaultPrice(Double defaultPrice) {
        BookingService _x = _copy();
        _x.changedFields = changedFields.add("defaultPrice");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingService");
        _x.defaultPrice = defaultPrice;
        return _x;
    }

    @Property(name="defaultPriceType")
    @JsonIgnore
    public Optional<BookingPriceType> getDefaultPriceType() {
        return Optional.ofNullable(defaultPriceType);
    }

    public BookingService withDefaultPriceType(BookingPriceType defaultPriceType) {
        BookingService _x = _copy();
        _x.changedFields = changedFields.add("defaultPriceType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingService");
        _x.defaultPriceType = defaultPriceType;
        return _x;
    }

    /**
     * <i>“The value of this property is only available when reading an individual booking
     * service by id.”</i>
     * 
     * @return property defaultReminders
     */
    @Property(name="defaultReminders")
    @JsonIgnore
    public CollectionPage<BookingReminder> getDefaultReminders() {
        return new CollectionPage<BookingReminder>(contextPath, BookingReminder.class, defaultReminders, Optional.ofNullable(defaultRemindersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The value of this property is only available when reading an individual booking
     * service by id.”</i>
     * 
     * @return property defaultReminders
     */
    @Property(name="defaultReminders")
    @JsonIgnore
    public CollectionPage<BookingReminder> getDefaultReminders(HttpRequestOptions options) {
        return new CollectionPage<BookingReminder>(contextPath, BookingReminder.class, defaultReminders, Optional.ofNullable(defaultRemindersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public BookingService withDescription(String description) {
        BookingService _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingService");
        _x.description = description;
        return _x;
    }

    @Property(name="isHiddenFromCustomers")
    @JsonIgnore
    public Optional<Boolean> getIsHiddenFromCustomers() {
        return Optional.ofNullable(isHiddenFromCustomers);
    }

    public BookingService withIsHiddenFromCustomers(Boolean isHiddenFromCustomers) {
        BookingService _x = _copy();
        _x.changedFields = changedFields.add("isHiddenFromCustomers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingService");
        _x.isHiddenFromCustomers = isHiddenFromCustomers;
        return _x;
    }

    @Property(name="notes")
    @JsonIgnore
    public Optional<String> getNotes() {
        return Optional.ofNullable(notes);
    }

    public BookingService withNotes(String notes) {
        BookingService _x = _copy();
        _x.changedFields = changedFields.add("notes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingService");
        _x.notes = notes;
        return _x;
    }

    @Property(name="preBuffer")
    @JsonIgnore
    public Optional<Duration> getPreBuffer() {
        return Optional.ofNullable(preBuffer);
    }

    public BookingService withPreBuffer(Duration preBuffer) {
        BookingService _x = _copy();
        _x.changedFields = changedFields.add("preBuffer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingService");
        _x.preBuffer = preBuffer;
        return _x;
    }

    @Property(name="postBuffer")
    @JsonIgnore
    public Optional<Duration> getPostBuffer() {
        return Optional.ofNullable(postBuffer);
    }

    public BookingService withPostBuffer(Duration postBuffer) {
        BookingService _x = _copy();
        _x.changedFields = changedFields.add("postBuffer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingService");
        _x.postBuffer = postBuffer;
        return _x;
    }

    @Property(name="schedulingPolicy")
    @JsonIgnore
    public Optional<BookingSchedulingPolicy> getSchedulingPolicy() {
        return Optional.ofNullable(schedulingPolicy);
    }

    public BookingService withSchedulingPolicy(BookingSchedulingPolicy schedulingPolicy) {
        BookingService _x = _copy();
        _x.changedFields = changedFields.add("schedulingPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingService");
        _x.schedulingPolicy = schedulingPolicy;
        return _x;
    }

    @Property(name="staffMemberIds")
    @JsonIgnore
    public CollectionPage<String> getStaffMemberIds() {
        return new CollectionPage<String>(contextPath, String.class, staffMemberIds, Optional.ofNullable(staffMemberIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="staffMemberIds")
    @JsonIgnore
    public CollectionPage<String> getStaffMemberIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, staffMemberIds, Optional.ofNullable(staffMemberIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BookingService patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        BookingService _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BookingService put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        BookingService _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private BookingService _copy() {
        BookingService _x = new BookingService();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.defaultDuration = defaultDuration;
        _x.defaultLocation = defaultLocation;
        _x.defaultPrice = defaultPrice;
        _x.defaultPriceType = defaultPriceType;
        _x.defaultReminders = defaultReminders;
        _x.description = description;
        _x.isHiddenFromCustomers = isHiddenFromCustomers;
        _x.notes = notes;
        _x.preBuffer = preBuffer;
        _x.postBuffer = postBuffer;
        _x.schedulingPolicy = schedulingPolicy;
        _x.staffMemberIds = staffMemberIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BookingService[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("defaultDuration=");
        b.append(this.defaultDuration);
        b.append(", ");
        b.append("defaultLocation=");
        b.append(this.defaultLocation);
        b.append(", ");
        b.append("defaultPrice=");
        b.append(this.defaultPrice);
        b.append(", ");
        b.append("defaultPriceType=");
        b.append(this.defaultPriceType);
        b.append(", ");
        b.append("defaultReminders=");
        b.append(this.defaultReminders);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("isHiddenFromCustomers=");
        b.append(this.isHiddenFromCustomers);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("preBuffer=");
        b.append(this.preBuffer);
        b.append(", ");
        b.append("postBuffer=");
        b.append(this.postBuffer);
        b.append(", ");
        b.append("schedulingPolicy=");
        b.append(this.schedulingPolicy);
        b.append(", ");
        b.append("staffMemberIds=");
        b.append(this.staffMemberIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
