package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import odata.msgraph.client.beta.entity.collection.request.BitlockerRecoveryKeyCollectionRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
 * <p>
 * Expandable = true
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class Bitlocker extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bitlocker";
    }

    protected Bitlocker() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderBitlocker() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Bitlocker build() {
            Bitlocker _x = new Bitlocker();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.bitlocker";
            _x.id = id;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @NavigationProperty(name="recoveryKeys")
    @JsonIgnore
    public BitlockerRecoveryKeyCollectionRequest getRecoveryKeys() {
        return new BitlockerRecoveryKeyCollectionRequest(
                        contextPath.addSegment("recoveryKeys"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Bitlocker patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Bitlocker _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Bitlocker put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Bitlocker _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Bitlocker _copy() {
        Bitlocker _x = new Bitlocker();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Bitlocker[");
        b.append("id=");
        b.append(this.id);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
