package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;

import odata.msgraph.client.beta.complex.OutOfBoxExperienceSettings;
import odata.msgraph.client.beta.complex.WindowsEnrollmentStatusScreenSettings;
import odata.msgraph.client.beta.enums.WindowsAutopilotDeviceType;


/**
 * <i>“Windows Autopilot Deployment Profile”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class AzureADWindowsAutopilotDeploymentProfile extends WindowsAutopilotDeploymentProfile implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.azureADWindowsAutopilotDeploymentProfile";
    }

    protected AzureADWindowsAutopilotDeploymentProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAzureADWindowsAutopilotDeploymentProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private String language;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private OutOfBoxExperienceSettings outOfBoxExperienceSettings;
        private WindowsEnrollmentStatusScreenSettings enrollmentStatusScreenSettings;
        private Boolean extractHardwareHash;
        private String deviceNameTemplate;
        private WindowsAutopilotDeviceType deviceType;
        private Boolean enableWhiteGlove;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            this.changedFields = changedFields.add("language");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder outOfBoxExperienceSettings(OutOfBoxExperienceSettings outOfBoxExperienceSettings) {
            this.outOfBoxExperienceSettings = outOfBoxExperienceSettings;
            this.changedFields = changedFields.add("outOfBoxExperienceSettings");
            return this;
        }

        public Builder enrollmentStatusScreenSettings(WindowsEnrollmentStatusScreenSettings enrollmentStatusScreenSettings) {
            this.enrollmentStatusScreenSettings = enrollmentStatusScreenSettings;
            this.changedFields = changedFields.add("enrollmentStatusScreenSettings");
            return this;
        }

        public Builder extractHardwareHash(Boolean extractHardwareHash) {
            this.extractHardwareHash = extractHardwareHash;
            this.changedFields = changedFields.add("extractHardwareHash");
            return this;
        }

        public Builder deviceNameTemplate(String deviceNameTemplate) {
            this.deviceNameTemplate = deviceNameTemplate;
            this.changedFields = changedFields.add("deviceNameTemplate");
            return this;
        }

        public Builder deviceType(WindowsAutopilotDeviceType deviceType) {
            this.deviceType = deviceType;
            this.changedFields = changedFields.add("deviceType");
            return this;
        }

        public Builder enableWhiteGlove(Boolean enableWhiteGlove) {
            this.enableWhiteGlove = enableWhiteGlove;
            this.changedFields = changedFields.add("enableWhiteGlove");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public AzureADWindowsAutopilotDeploymentProfile build() {
            AzureADWindowsAutopilotDeploymentProfile _x = new AzureADWindowsAutopilotDeploymentProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.azureADWindowsAutopilotDeploymentProfile";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.language = language;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.outOfBoxExperienceSettings = outOfBoxExperienceSettings;
            _x.enrollmentStatusScreenSettings = enrollmentStatusScreenSettings;
            _x.extractHardwareHash = extractHardwareHash;
            _x.deviceNameTemplate = deviceNameTemplate;
            _x.deviceType = deviceType;
            _x.enableWhiteGlove = enableWhiteGlove;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AzureADWindowsAutopilotDeploymentProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AzureADWindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AzureADWindowsAutopilotDeploymentProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AzureADWindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AzureADWindowsAutopilotDeploymentProfile _copy() {
        AzureADWindowsAutopilotDeploymentProfile _x = new AzureADWindowsAutopilotDeploymentProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.language = language;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.outOfBoxExperienceSettings = outOfBoxExperienceSettings;
        _x.enrollmentStatusScreenSettings = enrollmentStatusScreenSettings;
        _x.extractHardwareHash = extractHardwareHash;
        _x.deviceNameTemplate = deviceNameTemplate;
        _x.deviceType = deviceType;
        _x.enableWhiteGlove = enableWhiteGlove;
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AzureADWindowsAutopilotDeploymentProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("language=");
        b.append(this.language);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("outOfBoxExperienceSettings=");
        b.append(this.outOfBoxExperienceSettings);
        b.append(", ");
        b.append("enrollmentStatusScreenSettings=");
        b.append(this.enrollmentStatusScreenSettings);
        b.append(", ");
        b.append("extractHardwareHash=");
        b.append(this.extractHardwareHash);
        b.append(", ");
        b.append("deviceNameTemplate=");
        b.append(this.deviceNameTemplate);
        b.append(", ");
        b.append("deviceType=");
        b.append(this.deviceType);
        b.append(", ");
        b.append("enableWhiteGlove=");
        b.append(this.enableWhiteGlove);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
