package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 */@JsonPropertyOrder({
    "@odata.type", 
    "snapshotDateTime", 
    "featureName", 
    "usage"})
@JsonInclude(Include.NON_NULL)
public class AzureADFeatureUsage extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.azureADFeatureUsage";
    }

    @JsonProperty("snapshotDateTime")
    protected OffsetDateTime snapshotDateTime;

    @JsonProperty("featureName")
    protected String featureName;

    @JsonProperty("usage")
    protected Integer usage;

    protected AzureADFeatureUsage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAzureADFeatureUsage() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime snapshotDateTime;
        private String featureName;
        private Integer usage;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder snapshotDateTime(OffsetDateTime snapshotDateTime) {
            this.snapshotDateTime = snapshotDateTime;
            this.changedFields = changedFields.add("snapshotDateTime");
            return this;
        }

        public Builder featureName(String featureName) {
            this.featureName = featureName;
            this.changedFields = changedFields.add("featureName");
            return this;
        }

        public Builder usage(Integer usage) {
            this.usage = usage;
            this.changedFields = changedFields.add("usage");
            return this;
        }

        public AzureADFeatureUsage build() {
            AzureADFeatureUsage _x = new AzureADFeatureUsage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.azureADFeatureUsage";
            _x.id = id;
            _x.snapshotDateTime = snapshotDateTime;
            _x.featureName = featureName;
            _x.usage = usage;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="snapshotDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getSnapshotDateTime() {
        return Optional.ofNullable(snapshotDateTime);
    }

    public AzureADFeatureUsage withSnapshotDateTime(OffsetDateTime snapshotDateTime) {
        AzureADFeatureUsage _x = _copy();
        _x.changedFields = changedFields.add("snapshotDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.azureADFeatureUsage");
        _x.snapshotDateTime = snapshotDateTime;
        return _x;
    }

    @Property(name="featureName")
    @JsonIgnore
    public Optional<String> getFeatureName() {
        return Optional.ofNullable(featureName);
    }

    public AzureADFeatureUsage withFeatureName(String featureName) {
        AzureADFeatureUsage _x = _copy();
        _x.changedFields = changedFields.add("featureName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.azureADFeatureUsage");
        _x.featureName = featureName;
        return _x;
    }

    @Property(name="usage")
    @JsonIgnore
    public Optional<Integer> getUsage() {
        return Optional.ofNullable(usage);
    }

    public AzureADFeatureUsage withUsage(Integer usage) {
        AzureADFeatureUsage _x = _copy();
        _x.changedFields = changedFields.add("usage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.azureADFeatureUsage");
        _x.usage = usage;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AzureADFeatureUsage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AzureADFeatureUsage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AzureADFeatureUsage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AzureADFeatureUsage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AzureADFeatureUsage _copy() {
        AzureADFeatureUsage _x = new AzureADFeatureUsage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.snapshotDateTime = snapshotDateTime;
        _x.featureName = featureName;
        _x.usage = usage;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AzureADFeatureUsage[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("snapshotDateTime=");
        b.append(this.snapshotDateTime);
        b.append(", ");
        b.append("featureName=");
        b.append(this.featureName);
        b.append(", ");
        b.append("usage=");
        b.append(this.usage);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
